"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.struct_pb2
import google.protobuf.timestamp_pb2
import google.protobuf.wrappers_pb2
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class _Versioning:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _VersioningEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_Versioning.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    VERSIONING_UNSPECIFIED: _Versioning.ValueType  # 0
    VERSIONING_DISABLED: _Versioning.ValueType  # 1
    """The bucket is unversioned, i.e. versioning has never been enabled for the bucket, including at its creation.
    Objects that are stored in the bucket have a version ID of `null`.

    To enable versioning, change status to `VERSIONING_ENABLED` via a [BucketService.Update] request. Note that this
    action is irreversible, and a bucket with versioning enabled can never return to `VERSIONING_DISABLED` state.
    """
    VERSIONING_ENABLED: _Versioning.ValueType  # 2
    """Bucket versioning is enabled, i.e. all new objects are versioned and given a unique version ID, and objects that
    already existed at the time versioning was enabled will be versioned and given a unique version ID when modified
    by future requests.

    To suspend versioning, change status to `VERSIONING_SUSPENDED` via a [BucketService.Update] request. You cannot
    disable versioning altogether for a bucket that already had it enabled; objects that had version IDs will keep
    them.
    """
    VERSIONING_SUSPENDED: _Versioning.ValueType  # 3
    """Bucket versioning is suspended, i.e. new objects are not versioned, but objects that already existed at the time
    versioning was suspended are still versioned and keep their version IDs.

    To resume versioning, change status to `VERSIONING_ENABLED` via a [BucketService.Update] request.
    """

class Versioning(_Versioning, metaclass=_VersioningEnumTypeWrapper): ...

VERSIONING_UNSPECIFIED: Versioning.ValueType  # 0
VERSIONING_DISABLED: Versioning.ValueType  # 1
"""The bucket is unversioned, i.e. versioning has never been enabled for the bucket, including at its creation.
Objects that are stored in the bucket have a version ID of `null`.

To enable versioning, change status to `VERSIONING_ENABLED` via a [BucketService.Update] request. Note that this
action is irreversible, and a bucket with versioning enabled can never return to `VERSIONING_DISABLED` state.
"""
VERSIONING_ENABLED: Versioning.ValueType  # 2
"""Bucket versioning is enabled, i.e. all new objects are versioned and given a unique version ID, and objects that
already existed at the time versioning was enabled will be versioned and given a unique version ID when modified
by future requests.

To suspend versioning, change status to `VERSIONING_SUSPENDED` via a [BucketService.Update] request. You cannot
disable versioning altogether for a bucket that already had it enabled; objects that had version IDs will keep
them.
"""
VERSIONING_SUSPENDED: Versioning.ValueType  # 3
"""Bucket versioning is suspended, i.e. new objects are not versioned, but objects that already existed at the time
versioning was suspended are still versioned and keep their version IDs.

To resume versioning, change status to `VERSIONING_ENABLED` via a [BucketService.Update] request.
"""
global___Versioning = Versioning

@typing.final
class Bucket(google.protobuf.message.Message):
    """A bucket resource.
    For details about the concept, see [documentation](/docs/storage/concepts/bucket).
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    FOLDER_ID_FIELD_NUMBER: builtins.int
    ANONYMOUS_ACCESS_FLAGS_FIELD_NUMBER: builtins.int
    DEFAULT_STORAGE_CLASS_FIELD_NUMBER: builtins.int
    VERSIONING_FIELD_NUMBER: builtins.int
    MAX_SIZE_FIELD_NUMBER: builtins.int
    POLICY_FIELD_NUMBER: builtins.int
    ACL_FIELD_NUMBER: builtins.int
    CREATED_AT_FIELD_NUMBER: builtins.int
    CORS_FIELD_NUMBER: builtins.int
    WEBSITE_SETTINGS_FIELD_NUMBER: builtins.int
    LIFECYCLE_RULES_FIELD_NUMBER: builtins.int
    TAGS_FIELD_NUMBER: builtins.int
    OBJECT_LOCK_FIELD_NUMBER: builtins.int
    ENCRYPTION_FIELD_NUMBER: builtins.int
    ALLOWED_PRIVATE_ENDPOINTS_FIELD_NUMBER: builtins.int
    RESOURCE_ID_FIELD_NUMBER: builtins.int
    id: builtins.str
    """ID of the bucket. Always equal to [name], which has priority."""
    name: builtins.str
    """Name of the bucket.

    The name is unique within the platform. For naming limitations and rules, see
    [documentation](/docs/storage/concepts/bucket#naming).
    """
    folder_id: builtins.str
    """ID of the folder that the bucket belongs to."""
    default_storage_class: builtins.str
    """Default storage class for objects in the bucket. Supported classes are standard storage (`STANDARD`), cold storage
    (`COLD`, `STANDARD_IA`, `NEARLINE` all synonyms), and ice storage (`ICE` and `GLACIER` are synonyms).
    For details, see [documentation](/docs/storage/concepts/storage-class).
    """
    versioning: global___Versioning.ValueType
    """Bucket versioning status.
    For details, see [documentation](/docs/storage/concepts/versioning).
    """
    max_size: builtins.int
    """Maximum size of the bucket, in bytes.
    For details, see [documentation](/docs/storage/operations/buckets/limit-max-volume).
    """
    resource_id: builtins.str
    """ID of the Yandex.Cloud entity that owns the bucket."""
    @property
    def anonymous_access_flags(self) -> global___AnonymousAccessFlags:
        """Flags for configuring public (anonymous) access to the bucket's content and settings.
        For details, see [documentation](/docs/storage/concepts/bucket#bucket-access).
        """

    @property
    def policy(self) -> google.protobuf.struct_pb2.Struct:
        """Bucket policies that set permissions for actions with the bucket, its objects, and groups of objects.
        For details, see [documentation](/docs/storage/concepts/policy).
        """

    @property
    def acl(self) -> global___ACL:
        """Access control list (ACL) of the bucket.
        For details, see [documentation](/docs/storage/concepts/acl).
        """

    @property
    def created_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Creation timestamp."""

    @property
    def cors(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___CorsRule]:
        """List of rules for cross-domain requests to objects in the bucket (cross-origin resource sharing, CORS).
        For details, see [documentation](/docs/storage/concepts/cors).
        """

    @property
    def website_settings(self) -> global___WebsiteSettings:
        """Configuration for hosting a static website in the bucket.
        For details, see [documentation](/docs/storage/concepts/hosting).
        """

    @property
    def lifecycle_rules(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___LifecycleRule]:
        """List of object lifecycle rules for the bucket.
        For details, see [documentation](/docs/storage/concepts/lifecycles).
        """

    @property
    def tags(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Tag]:
        """List of tags for the bucket.
        For details, see [documentation](/docs/resource-manager/concepts/labels).
        """

    @property
    def object_lock(self) -> global___ObjectLock:
        """Configuration for object lock on the bucket.
        For details about the concept, see [documentation](/docs/storage/concepts/object-lock).
        """

    @property
    def encryption(self) -> global___Encryption:
        """Configuration for bucket's encryption
        For details, see [documentation](/docs/storage/concepts/encryption)
        """

    @property
    def allowed_private_endpoints(self) -> global___BucketAllowedPrivateEndpoints:
        """Bucket allowed private endpoints."""

    def __init__(
        self,
        *,
        id: builtins.str = ...,
        name: builtins.str = ...,
        folder_id: builtins.str = ...,
        anonymous_access_flags: global___AnonymousAccessFlags | None = ...,
        default_storage_class: builtins.str = ...,
        versioning: global___Versioning.ValueType = ...,
        max_size: builtins.int = ...,
        policy: google.protobuf.struct_pb2.Struct | None = ...,
        acl: global___ACL | None = ...,
        created_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        cors: collections.abc.Iterable[global___CorsRule] | None = ...,
        website_settings: global___WebsiteSettings | None = ...,
        lifecycle_rules: collections.abc.Iterable[global___LifecycleRule] | None = ...,
        tags: collections.abc.Iterable[global___Tag] | None = ...,
        object_lock: global___ObjectLock | None = ...,
        encryption: global___Encryption | None = ...,
        allowed_private_endpoints: global___BucketAllowedPrivateEndpoints | None = ...,
        resource_id: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["acl", b"acl", "allowed_private_endpoints", b"allowed_private_endpoints", "anonymous_access_flags", b"anonymous_access_flags", "created_at", b"created_at", "encryption", b"encryption", "object_lock", b"object_lock", "policy", b"policy", "website_settings", b"website_settings"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["acl", b"acl", "allowed_private_endpoints", b"allowed_private_endpoints", "anonymous_access_flags", b"anonymous_access_flags", "cors", b"cors", "created_at", b"created_at", "default_storage_class", b"default_storage_class", "encryption", b"encryption", "folder_id", b"folder_id", "id", b"id", "lifecycle_rules", b"lifecycle_rules", "max_size", b"max_size", "name", b"name", "object_lock", b"object_lock", "policy", b"policy", "resource_id", b"resource_id", "tags", b"tags", "versioning", b"versioning", "website_settings", b"website_settings"]) -> None: ...

global___Bucket = Bucket

@typing.final
class Tag(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    KEY_FIELD_NUMBER: builtins.int
    VALUE_FIELD_NUMBER: builtins.int
    key: builtins.str
    """Key of the bucket tag."""
    value: builtins.str
    """Value of the bucket tag."""
    def __init__(
        self,
        *,
        key: builtins.str = ...,
        value: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

global___Tag = Tag

@typing.final
class ACL(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class Grant(google.protobuf.message.Message):
        """A grant resource, used to specify the permission granted and the grantee."""

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        class _Permission:
            ValueType = typing.NewType("ValueType", builtins.int)
            V: typing_extensions.TypeAlias = ValueType

        class _PermissionEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[ACL.Grant._Permission.ValueType], builtins.type):
            DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
            PERMISSION_UNSPECIFIED: ACL.Grant._Permission.ValueType  # 0
            PERMISSION_FULL_CONTROL: ACL.Grant._Permission.ValueType  # 1
            """Allows grantee the `PERMISSION_WRITE`, `PERMISSION_WRITE_ACP`, `PERMISSION_READ`, and `PERMISSION_READ_ACP`
            on the bucket.

            Maps to `x-amz-grant-full-control` header for [bucketPutAcl](/docs/storage/s3/api-ref/acl/bucketput) method of
            Amazon S3-compatible HTTP API.
            """
            PERMISSION_WRITE: ACL.Grant._Permission.ValueType  # 2
            """Allows grantee to create new objects in the bucket. For the bucket and object owners of existing objects, also
            allows deletions and overwrites of those objects.

            Maps to `x-amz-grant-write` header for [bucketPutAcl](/docs/storage/s3/api-ref/acl/bucketput) method of Amazon
            S3-compatible HTTP API.
            """
            PERMISSION_WRITE_ACP: ACL.Grant._Permission.ValueType  # 3
            """Allows grantee to write the ACL for the bucket.

            Maps to `x-amz-grant-write-acp` header for [bucketPutAcl](/docs/storage/s3/api-ref/acl/bucketput) method of
            Amazon S3-compatible HTTP API.
            """
            PERMISSION_READ: ACL.Grant._Permission.ValueType  # 4
            """Allows grantee to list the objects in the bucket.

            Maps to `x-amz-grant-read` header for [bucketPutAcl](/docs/storage/s3/api-ref/acl/bucketput) method of Amazon
            S3-compatible HTTP API.
            """
            PERMISSION_READ_ACP: ACL.Grant._Permission.ValueType  # 5
            """Allows grantee to read the bucket ACL

            Maps to `x-amz-grant-read-acp` header for [bucketPutAcl](/docs/storage/s3/api-ref/acl/bucketput) method of
            Amazon S3-compatible HTTP API.
            """

        class Permission(_Permission, metaclass=_PermissionEnumTypeWrapper): ...
        PERMISSION_UNSPECIFIED: ACL.Grant.Permission.ValueType  # 0
        PERMISSION_FULL_CONTROL: ACL.Grant.Permission.ValueType  # 1
        """Allows grantee the `PERMISSION_WRITE`, `PERMISSION_WRITE_ACP`, `PERMISSION_READ`, and `PERMISSION_READ_ACP`
        on the bucket.

        Maps to `x-amz-grant-full-control` header for [bucketPutAcl](/docs/storage/s3/api-ref/acl/bucketput) method of
        Amazon S3-compatible HTTP API.
        """
        PERMISSION_WRITE: ACL.Grant.Permission.ValueType  # 2
        """Allows grantee to create new objects in the bucket. For the bucket and object owners of existing objects, also
        allows deletions and overwrites of those objects.

        Maps to `x-amz-grant-write` header for [bucketPutAcl](/docs/storage/s3/api-ref/acl/bucketput) method of Amazon
        S3-compatible HTTP API.
        """
        PERMISSION_WRITE_ACP: ACL.Grant.Permission.ValueType  # 3
        """Allows grantee to write the ACL for the bucket.

        Maps to `x-amz-grant-write-acp` header for [bucketPutAcl](/docs/storage/s3/api-ref/acl/bucketput) method of
        Amazon S3-compatible HTTP API.
        """
        PERMISSION_READ: ACL.Grant.Permission.ValueType  # 4
        """Allows grantee to list the objects in the bucket.

        Maps to `x-amz-grant-read` header for [bucketPutAcl](/docs/storage/s3/api-ref/acl/bucketput) method of Amazon
        S3-compatible HTTP API.
        """
        PERMISSION_READ_ACP: ACL.Grant.Permission.ValueType  # 5
        """Allows grantee to read the bucket ACL

        Maps to `x-amz-grant-read-acp` header for [bucketPutAcl](/docs/storage/s3/api-ref/acl/bucketput) method of
        Amazon S3-compatible HTTP API.
        """

        class _GrantType:
            ValueType = typing.NewType("ValueType", builtins.int)
            V: typing_extensions.TypeAlias = ValueType

        class _GrantTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[ACL.Grant._GrantType.ValueType], builtins.type):
            DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
            GRANT_TYPE_UNSPECIFIED: ACL.Grant._GrantType.ValueType  # 0
            GRANT_TYPE_ACCOUNT: ACL.Grant._GrantType.ValueType  # 1
            """A grantee is an [account on the platform](/docs/iam/concepts/#accounts).

            For this grantee type, you need to specify the user ID in [Bucket.acl.grants.grantee_id] field. To get user ID, see
            [instruction](/docs/iam/operations/users/get).

            Maps to using `id="*"` value for `x-amz-grant-*` header ([bucketPutAcl](/docs/storage/s3/api-ref/acl/bucketput)
            method of Amazon S3-compatible HTTP API).
            """
            GRANT_TYPE_ALL_AUTHENTICATED_USERS: ACL.Grant._GrantType.ValueType  # 2
            """Grantees are all authenticated users, both from your clouds and other users' clouds. Access
            permission to this group allows any account on the platform to access the resource via a signed (authenticated)
            request.

            Maps to using `uri="http://acs.amazonaws.com/groups/global/AuthenticatedUsers"` value for `x-amz-grant-*`
            header ([bucketPutAcl](/docs/storage/s3/api-ref/acl/bucketput) method of Amazon S3-compatible HTTP API).
            """
            GRANT_TYPE_ALL_USERS: ACL.Grant._GrantType.ValueType  # 3
            """Grantees are all internet users. Access permission to this group allows anyone in the world access to the
            resource via signed (authenticated) or unsigned (anonymous) requests.

            Maps to using `uri="http://acs.amazonaws.com/groups/global/AllUsers"` value for `x-amz-grant-*` header
            ([bucketPutAcl](/docs/storage/s3/api-ref/acl/bucketput) method of Amazon S3-compatible HTTP API).
            """

        class GrantType(_GrantType, metaclass=_GrantTypeEnumTypeWrapper): ...
        GRANT_TYPE_UNSPECIFIED: ACL.Grant.GrantType.ValueType  # 0
        GRANT_TYPE_ACCOUNT: ACL.Grant.GrantType.ValueType  # 1
        """A grantee is an [account on the platform](/docs/iam/concepts/#accounts).

        For this grantee type, you need to specify the user ID in [Bucket.acl.grants.grantee_id] field. To get user ID, see
        [instruction](/docs/iam/operations/users/get).

        Maps to using `id="*"` value for `x-amz-grant-*` header ([bucketPutAcl](/docs/storage/s3/api-ref/acl/bucketput)
        method of Amazon S3-compatible HTTP API).
        """
        GRANT_TYPE_ALL_AUTHENTICATED_USERS: ACL.Grant.GrantType.ValueType  # 2
        """Grantees are all authenticated users, both from your clouds and other users' clouds. Access
        permission to this group allows any account on the platform to access the resource via a signed (authenticated)
        request.

        Maps to using `uri="http://acs.amazonaws.com/groups/global/AuthenticatedUsers"` value for `x-amz-grant-*`
        header ([bucketPutAcl](/docs/storage/s3/api-ref/acl/bucketput) method of Amazon S3-compatible HTTP API).
        """
        GRANT_TYPE_ALL_USERS: ACL.Grant.GrantType.ValueType  # 3
        """Grantees are all internet users. Access permission to this group allows anyone in the world access to the
        resource via signed (authenticated) or unsigned (anonymous) requests.

        Maps to using `uri="http://acs.amazonaws.com/groups/global/AllUsers"` value for `x-amz-grant-*` header
        ([bucketPutAcl](/docs/storage/s3/api-ref/acl/bucketput) method of Amazon S3-compatible HTTP API).
        """

        PERMISSION_FIELD_NUMBER: builtins.int
        GRANT_TYPE_FIELD_NUMBER: builtins.int
        GRANTEE_ID_FIELD_NUMBER: builtins.int
        permission: global___ACL.Grant.Permission.ValueType
        """Permission granted by the grant."""
        grant_type: global___ACL.Grant.GrantType.ValueType
        """The grantee type for the grant."""
        grantee_id: builtins.str
        """ID of the account who is a grantee. Required when the [grant_type] is `GRANT_TYPE_ACCOUNT`."""
        def __init__(
            self,
            *,
            permission: global___ACL.Grant.Permission.ValueType = ...,
            grant_type: global___ACL.Grant.GrantType.ValueType = ...,
            grantee_id: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["grant_type", b"grant_type", "grantee_id", b"grantee_id", "permission", b"permission"]) -> None: ...

    GRANTS_FIELD_NUMBER: builtins.int
    @property
    def grants(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ACL.Grant]:
        """List of permissions granted and the grantees."""

    def __init__(
        self,
        *,
        grants: collections.abc.Iterable[global___ACL.Grant] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["grants", b"grants"]) -> None: ...

global___ACL = ACL

@typing.final
class AnonymousAccessFlags(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    READ_FIELD_NUMBER: builtins.int
    LIST_FIELD_NUMBER: builtins.int
    CONFIG_READ_FIELD_NUMBER: builtins.int
    @property
    def read(self) -> google.protobuf.wrappers_pb2.BoolValue:
        """Specifies whether public (anonymous) access to read objects in the bucket is enabled."""

    @property
    def list(self) -> google.protobuf.wrappers_pb2.BoolValue:
        """Specifies whether public (anonymous) access to the list of objects in the bucket is enabled."""

    @property
    def config_read(self) -> google.protobuf.wrappers_pb2.BoolValue:
        """Specifies whether public (anonymous) access to read [CORS](/docs/storage/concepts/cors),
        [static website hosting](/docs/storage/concepts/hosting), and
        [object lifecycles](/docs/storage/concepts/lifecycles) settings of the bucket is enabled.
        """

    def __init__(
        self,
        *,
        read: google.protobuf.wrappers_pb2.BoolValue | None = ...,
        list: google.protobuf.wrappers_pb2.BoolValue | None = ...,
        config_read: google.protobuf.wrappers_pb2.BoolValue | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["config_read", b"config_read", "list", b"list", "read", b"read"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["config_read", b"config_read", "list", b"list", "read", b"read"]) -> None: ...

global___AnonymousAccessFlags = AnonymousAccessFlags

@typing.final
class CorsRule(google.protobuf.message.Message):
    """A CORS rule resource.
    For details about the concept, see [documentation](/docs/storage/concepts/cors).
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Method:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _MethodEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[CorsRule._Method.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        METHOD_UNSPECIFIED: CorsRule._Method.ValueType  # 0
        METHOD_GET: CorsRule._Method.ValueType  # 1
        """HTTP `GET` method."""
        METHOD_HEAD: CorsRule._Method.ValueType  # 2
        """HTTP `HEAD` method."""
        METHOD_POST: CorsRule._Method.ValueType  # 3
        """HTTP `POST` method."""
        METHOD_PUT: CorsRule._Method.ValueType  # 4
        """HTTP `PUT` method."""
        METHOD_DELETE: CorsRule._Method.ValueType  # 5
        """HTTP `DELETE` method."""

    class Method(_Method, metaclass=_MethodEnumTypeWrapper):
        """List of HTTP methods that are allowed by the CORS rule.

        When a client sends a CORS-preflight `options` request with the `Access-Control-Request-Method` header (see
        S3-compatible API reference](/docs/storage/s3/api-ref/object/options)), the specified method is checked against the
        list of the allowed methods. If there is a match, all the allowed methods are listed in the
        `Access-Control-Allow-Methods` header of the response.
        """

    METHOD_UNSPECIFIED: CorsRule.Method.ValueType  # 0
    METHOD_GET: CorsRule.Method.ValueType  # 1
    """HTTP `GET` method."""
    METHOD_HEAD: CorsRule.Method.ValueType  # 2
    """HTTP `HEAD` method."""
    METHOD_POST: CorsRule.Method.ValueType  # 3
    """HTTP `POST` method."""
    METHOD_PUT: CorsRule.Method.ValueType  # 4
    """HTTP `PUT` method."""
    METHOD_DELETE: CorsRule.Method.ValueType  # 5
    """HTTP `DELETE` method."""

    ID_FIELD_NUMBER: builtins.int
    ALLOWED_METHODS_FIELD_NUMBER: builtins.int
    ALLOWED_HEADERS_FIELD_NUMBER: builtins.int
    ALLOWED_ORIGINS_FIELD_NUMBER: builtins.int
    EXPOSE_HEADERS_FIELD_NUMBER: builtins.int
    MAX_AGE_SECONDS_FIELD_NUMBER: builtins.int
    id: builtins.str
    """ID of the CORS rule."""
    @property
    def allowed_methods(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[global___CorsRule.Method.ValueType]:
        """List of HTTP methods allowed by the CORS rule.

        When a client sends a CORS-preflight `options` request with the `Access-Control-Request-Method` header (see
        [S3-compatible API reference](/docs/storage/s3/api-ref/object/options)), the specified method is checked against
        the list of the allowed methods. If there is a match, all the allowed methods are listed in the
        `Access-Control-Allow-Methods` header of the response.
        """

    @property
    def allowed_headers(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """List of HTTP headers allowed by the CORS rule.

        When a client sends a CORS-preflight `options` request with the `Access-Control-Request-Headers` header (see
        [S3-compatible API reference](/docs/storage/s3/api-ref/object/options)), the specified headers are checked against
        the list of the allowed headers. If there is a match, the specified headers that are allowed are listed in the
        `Access-Control-Allow-Headers` header of the response.

        Each string in the list can contain at most one `*` wildcard character that matches 0 or more characters.
        For example, `x-amz-*` value will allow all Amazon S3-compatible headers.
        """

    @property
    def allowed_origins(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """List of request origins allowed by the CORS rule.

        Each string in the list can contain at most one `*` wildcard character that matches 0 or more characters.
        For example, `http://*.example.com` value will allow requests originating from all subdomains of `example.com`.
        """

    @property
    def expose_headers(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """List of headers contained in responses to CORS requests that can be accessed by applications."""

    @property
    def max_age_seconds(self) -> google.protobuf.wrappers_pb2.Int64Value:
        """Time in seconds that a client can cache the response to a CORS-preflight request as identified by the
        object requested, the HTTP method, and the origin.
        """

    def __init__(
        self,
        *,
        id: builtins.str = ...,
        allowed_methods: collections.abc.Iterable[global___CorsRule.Method.ValueType] | None = ...,
        allowed_headers: collections.abc.Iterable[builtins.str] | None = ...,
        allowed_origins: collections.abc.Iterable[builtins.str] | None = ...,
        expose_headers: collections.abc.Iterable[builtins.str] | None = ...,
        max_age_seconds: google.protobuf.wrappers_pb2.Int64Value | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["max_age_seconds", b"max_age_seconds"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["allowed_headers", b"allowed_headers", "allowed_methods", b"allowed_methods", "allowed_origins", b"allowed_origins", "expose_headers", b"expose_headers", "id", b"id", "max_age_seconds", b"max_age_seconds"]) -> None: ...

global___CorsRule = CorsRule

@typing.final
class WebsiteSettings(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Protocol:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _ProtocolEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[WebsiteSettings._Protocol.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        PROTOCOL_UNSPECIFIED: WebsiteSettings._Protocol.ValueType  # 0
        PROTOCOL_HTTP: WebsiteSettings._Protocol.ValueType  # 1
        """`http` scheme."""
        PROTOCOL_HTTPS: WebsiteSettings._Protocol.ValueType  # 2
        """`https` scheme."""

    class Protocol(_Protocol, metaclass=_ProtocolEnumTypeWrapper): ...
    PROTOCOL_UNSPECIFIED: WebsiteSettings.Protocol.ValueType  # 0
    PROTOCOL_HTTP: WebsiteSettings.Protocol.ValueType  # 1
    """`http` scheme."""
    PROTOCOL_HTTPS: WebsiteSettings.Protocol.ValueType  # 2
    """`https` scheme."""

    @typing.final
    class Scheme(google.protobuf.message.Message):
        """A configuration resource for redirecting all requests sent to the website."""

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        PROTOCOL_FIELD_NUMBER: builtins.int
        HOSTNAME_FIELD_NUMBER: builtins.int
        protocol: global___WebsiteSettings.Protocol.ValueType
        """Scheme of the redirect URI."""
        hostname: builtins.str
        """Hostname of the redirect URI."""
        def __init__(
            self,
            *,
            protocol: global___WebsiteSettings.Protocol.ValueType = ...,
            hostname: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["hostname", b"hostname", "protocol", b"protocol"]) -> None: ...

    @typing.final
    class Condition(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        HTTP_ERROR_CODE_RETURNED_EQUALS_FIELD_NUMBER: builtins.int
        KEY_PREFIX_EQUALS_FIELD_NUMBER: builtins.int
        http_error_code_returned_equals: builtins.str
        """HTTP status code (number only) that must match for the redirect to apply."""
        key_prefix_equals: builtins.str
        """Prefix of the object key from which requests are redirected."""
        def __init__(
            self,
            *,
            http_error_code_returned_equals: builtins.str = ...,
            key_prefix_equals: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["http_error_code_returned_equals", b"http_error_code_returned_equals", "key_prefix_equals", b"key_prefix_equals"]) -> None: ...

    @typing.final
    class Redirect(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        HOSTNAME_FIELD_NUMBER: builtins.int
        HTTP_REDIRECT_CODE_FIELD_NUMBER: builtins.int
        PROTOCOL_FIELD_NUMBER: builtins.int
        REPLACE_KEY_PREFIX_WITH_FIELD_NUMBER: builtins.int
        REPLACE_KEY_WITH_FIELD_NUMBER: builtins.int
        hostname: builtins.str
        """Hostname of the redirect URI."""
        http_redirect_code: builtins.str
        """HTTP status code of the redirect response.

        Default value: `"301"`.
        """
        protocol: global___WebsiteSettings.Protocol.ValueType
        """Scheme of the redirect URI."""
        replace_key_prefix_with: builtins.str
        """Substitution for the prefix of the object key specified in [Condition.key_prefix_equals].

        At most one of [replace_key_prefix_with] and [replace_key_with] can be specified.
        """
        replace_key_with: builtins.str
        """New object key.

        At most one of [replace_key_with] and [replace_key_prefix_with] can be specified.
        """
        def __init__(
            self,
            *,
            hostname: builtins.str = ...,
            http_redirect_code: builtins.str = ...,
            protocol: global___WebsiteSettings.Protocol.ValueType = ...,
            replace_key_prefix_with: builtins.str = ...,
            replace_key_with: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["hostname", b"hostname", "http_redirect_code", b"http_redirect_code", "protocol", b"protocol", "replace_key_prefix_with", b"replace_key_prefix_with", "replace_key_with", b"replace_key_with"]) -> None: ...

    @typing.final
    class RoutingRule(google.protobuf.message.Message):
        """List of redirect rules."""

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        CONDITION_FIELD_NUMBER: builtins.int
        REDIRECT_FIELD_NUMBER: builtins.int
        @property
        def condition(self) -> global___WebsiteSettings.Condition:
            """Redirect condition."""

        @property
        def redirect(self) -> global___WebsiteSettings.Redirect:
            """Redirect instructions."""

        def __init__(
            self,
            *,
            condition: global___WebsiteSettings.Condition | None = ...,
            redirect: global___WebsiteSettings.Redirect | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["condition", b"condition", "redirect", b"redirect"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["condition", b"condition", "redirect", b"redirect"]) -> None: ...

    INDEX_FIELD_NUMBER: builtins.int
    ERROR_FIELD_NUMBER: builtins.int
    REDIRECT_ALL_REQUESTS_FIELD_NUMBER: builtins.int
    ROUTING_RULES_FIELD_NUMBER: builtins.int
    index: builtins.str
    """Key of the index page object that is returned when a response is made to the root of the website.

    Either [index] or [redirect_all_requests] must be specified in order for the bucket to host a static website.

    If specified, the index page object must be located in the root of the bucket.
    """
    error: builtins.str
    """Key of the error page object that is returned when an error occurs."""
    @property
    def redirect_all_requests(self) -> global___WebsiteSettings.Scheme:
        """Configuration for redirecting all requests sent to the website.

        Either [redirect_all_requests] or [index] must be specified in order for the bucket to host a static website.
        If [redirect_all_requests] is specified, it must be the only field in [Bucket.website_settings].
        """

    @property
    def routing_rules(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___WebsiteSettings.RoutingRule]:
        """List of redirect rules."""

    def __init__(
        self,
        *,
        index: builtins.str = ...,
        error: builtins.str = ...,
        redirect_all_requests: global___WebsiteSettings.Scheme | None = ...,
        routing_rules: collections.abc.Iterable[global___WebsiteSettings.RoutingRule] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["redirect_all_requests", b"redirect_all_requests"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["error", b"error", "index", b"index", "redirect_all_requests", b"redirect_all_requests", "routing_rules", b"routing_rules"]) -> None: ...

global___WebsiteSettings = WebsiteSettings

@typing.final
class LifecycleRule(google.protobuf.message.Message):
    """An object lifecycle rule resource for the bucket.
    For details about the concept, see [documentation](/docs/storage/concepts/lifecycles).
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class AfterDays(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        DAYS_AFTER_EXPIRATION_FIELD_NUMBER: builtins.int
        @property
        def days_after_expiration(self) -> google.protobuf.wrappers_pb2.Int64Value:
            """Time period, in number of days from the start of the multipart upload, after which the incomplete upload is
            aborted.
            """

        def __init__(
            self,
            *,
            days_after_expiration: google.protobuf.wrappers_pb2.Int64Value | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["days_after_expiration", b"days_after_expiration"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["days_after_expiration", b"days_after_expiration"]) -> None: ...

    @typing.final
    class NoncurrentDeleteMarkers(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        NONCURRENT_DAYS_FIELD_NUMBER: builtins.int
        @property
        def noncurrent_days(self) -> google.protobuf.wrappers_pb2.Int64Value:
            """Time period, in number of days since the version of a delete marker was classified as non-current, after which
            the delete marker expires.
            """

        def __init__(
            self,
            *,
            noncurrent_days: google.protobuf.wrappers_pb2.Int64Value | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["noncurrent_days", b"noncurrent_days"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["noncurrent_days", b"noncurrent_days"]) -> None: ...

    @typing.final
    class NoncurrentExpiration(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        NONCURRENT_DAYS_FIELD_NUMBER: builtins.int
        @property
        def noncurrent_days(self) -> google.protobuf.wrappers_pb2.Int64Value:
            """Time period, in number of days since the version of an object was classified as non-current, after which the
            version expires.
            """

        def __init__(
            self,
            *,
            noncurrent_days: google.protobuf.wrappers_pb2.Int64Value | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["noncurrent_days", b"noncurrent_days"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["noncurrent_days", b"noncurrent_days"]) -> None: ...

    @typing.final
    class NoncurrentTransition(google.protobuf.message.Message):
        """List of transition rules for non-current versions of objects in a bucket with versioning enabled
        ([Bucket.versioning] is `VERSIONING_ENABLED`) or suspended (`VERSIONING_SUSPENDED`).

        At transition, the non-current version of the object is transitioned to the specified storage class.
        """

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        NONCURRENT_DAYS_FIELD_NUMBER: builtins.int
        STORAGE_CLASS_FIELD_NUMBER: builtins.int
        storage_class: builtins.str
        """Storage class to which a non-current version of an object is transitioned from standard storage.

        The only supported class is cold storage (`COLD`, `STANDARD_IA`, `NEARLINE` all synonyms). Transitions from cold
        to standard storage and transitions to or from ice storage are not allowed.
        """
        @property
        def noncurrent_days(self) -> google.protobuf.wrappers_pb2.Int64Value:
            """Time period, in number of days since the version of an object was classified as non-current, after which the
            version is transitioned.
            """

        def __init__(
            self,
            *,
            noncurrent_days: google.protobuf.wrappers_pb2.Int64Value | None = ...,
            storage_class: builtins.str = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["noncurrent_days", b"noncurrent_days"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["noncurrent_days", b"noncurrent_days", "storage_class", b"storage_class"]) -> None: ...

    @typing.final
    class Transition(google.protobuf.message.Message):
        """List of transition rules.

        The transition of an object is described as follows.

        For the unversioned bucket ([Bucket.versioning] is `VERSIONING_DISABLED`), the object is transitioned to the
        specified storage class.

        For the bucket with versioning enabled ([Bucket.versioning] is `VERSIONING_ENABLED`) or suspended
        (`VERSIONING_SUSPENDED`), the current version of the object is transitioned to the specified storage class.
        """

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        DATE_FIELD_NUMBER: builtins.int
        DAYS_FIELD_NUMBER: builtins.int
        STORAGE_CLASS_FIELD_NUMBER: builtins.int
        storage_class: builtins.str
        """Storage class to which an object is transitioned from standard storage.

        The only supported class is cold storage (`COLD`, `STANDARD_IA`, `NEARLINE` all synonyms). Transitions from cold
        to standard storage and transitions to or from ice storage are not allowed.
        """
        @property
        def date(self) -> google.protobuf.timestamp_pb2.Timestamp:
            """Specific date of object transition.

            The rule continues to apply even after the date has passed, i.e. any new objects created in the bucket are
            transitioned immediately.

            At most one of [date] and [days] fields can be specified.
            """

        @property
        def days(self) -> google.protobuf.wrappers_pb2.Int64Value:
            """Time period, in number of days from the creation or modification of the object, after which an object is
            transitioned.

            At most one of [days] and [date] fields can be specified.
            """

        def __init__(
            self,
            *,
            date: google.protobuf.timestamp_pb2.Timestamp | None = ...,
            days: google.protobuf.wrappers_pb2.Int64Value | None = ...,
            storage_class: builtins.str = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["date", b"date", "days", b"days"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["date", b"date", "days", b"days", "storage_class", b"storage_class"]) -> None: ...

    @typing.final
    class Expiration(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        DATE_FIELD_NUMBER: builtins.int
        DAYS_FIELD_NUMBER: builtins.int
        EXPIRED_OBJECT_DELETE_MARKER_FIELD_NUMBER: builtins.int
        @property
        def date(self) -> google.protobuf.timestamp_pb2.Timestamp:
            """Specific date of object expiration.

            The rule continues to apply even after the date has passed, i.e. any new objects created in the bucket expire
            immediately.

            Exactly one of [date], [days], and [expired_object_delete_marker] fields can be specified.
            """

        @property
        def days(self) -> google.protobuf.wrappers_pb2.Int64Value:
            """Time period, in number of days from the creation or modification of the object, after which an object expires.

            Exactly one of [days], [date], and [expired_object_delete_marker] fields can be specified.
            """

        @property
        def expired_object_delete_marker(self) -> google.protobuf.wrappers_pb2.BoolValue:
            """Indicates whether a delete marker of an object with no non-current versions (referred to as an expired object
            delete marker) is removed at the object's expiration.

            Exactly one of [expired_object_delete_marker], [date], and [days] fields can be specified.
            """

        def __init__(
            self,
            *,
            date: google.protobuf.timestamp_pb2.Timestamp | None = ...,
            days: google.protobuf.wrappers_pb2.Int64Value | None = ...,
            expired_object_delete_marker: google.protobuf.wrappers_pb2.BoolValue | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["date", b"date", "days", b"days", "expired_object_delete_marker", b"expired_object_delete_marker"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["date", b"date", "days", b"days", "expired_object_delete_marker", b"expired_object_delete_marker"]) -> None: ...

    @typing.final
    class RuleFilter(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        @typing.final
        class And(google.protobuf.message.Message):
            DESCRIPTOR: google.protobuf.descriptor.Descriptor

            PREFIX_FIELD_NUMBER: builtins.int
            OBJECT_SIZE_GREATER_THAN_FIELD_NUMBER: builtins.int
            OBJECT_SIZE_LESS_THAN_FIELD_NUMBER: builtins.int
            TAG_FIELD_NUMBER: builtins.int
            prefix: builtins.str
            @property
            def object_size_greater_than(self) -> google.protobuf.wrappers_pb2.Int64Value: ...
            @property
            def object_size_less_than(self) -> google.protobuf.wrappers_pb2.Int64Value: ...
            @property
            def tag(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Tag]: ...
            def __init__(
                self,
                *,
                prefix: builtins.str = ...,
                object_size_greater_than: google.protobuf.wrappers_pb2.Int64Value | None = ...,
                object_size_less_than: google.protobuf.wrappers_pb2.Int64Value | None = ...,
                tag: collections.abc.Iterable[global___Tag] | None = ...,
            ) -> None: ...
            def HasField(self, field_name: typing.Literal["object_size_greater_than", b"object_size_greater_than", "object_size_less_than", b"object_size_less_than"]) -> builtins.bool: ...
            def ClearField(self, field_name: typing.Literal["object_size_greater_than", b"object_size_greater_than", "object_size_less_than", b"object_size_less_than", "prefix", b"prefix", "tag", b"tag"]) -> None: ...

        PREFIX_FIELD_NUMBER: builtins.int
        OBJECT_SIZE_GREATER_THAN_FIELD_NUMBER: builtins.int
        OBJECT_SIZE_LESS_THAN_FIELD_NUMBER: builtins.int
        TAG_FIELD_NUMBER: builtins.int
        AND_OPERATOR_FIELD_NUMBER: builtins.int
        prefix: builtins.str
        """Key prefix that the object must have in order for the rule to apply."""
        @property
        def object_size_greater_than(self) -> google.protobuf.wrappers_pb2.Int64Value:
            """Size that the object must be greater."""

        @property
        def object_size_less_than(self) -> google.protobuf.wrappers_pb2.Int64Value:
            """Size that the object must be less t."""

        @property
        def tag(self) -> global___Tag:
            """Tags that the object's tag set must have for the rule to apply."""

        @property
        def and_operator(self) -> global___LifecycleRule.RuleFilter.And:
            """Apply a logical AND to all of the predicates configured inside the And operator."""

        def __init__(
            self,
            *,
            prefix: builtins.str = ...,
            object_size_greater_than: google.protobuf.wrappers_pb2.Int64Value | None = ...,
            object_size_less_than: google.protobuf.wrappers_pb2.Int64Value | None = ...,
            tag: global___Tag | None = ...,
            and_operator: global___LifecycleRule.RuleFilter.And | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["and_operator", b"and_operator", "object_size_greater_than", b"object_size_greater_than", "object_size_less_than", b"object_size_less_than", "tag", b"tag"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["and_operator", b"and_operator", "object_size_greater_than", b"object_size_greater_than", "object_size_less_than", b"object_size_less_than", "prefix", b"prefix", "tag", b"tag"]) -> None: ...

    ID_FIELD_NUMBER: builtins.int
    ENABLED_FIELD_NUMBER: builtins.int
    FILTER_FIELD_NUMBER: builtins.int
    EXPIRATION_FIELD_NUMBER: builtins.int
    TRANSITIONS_FIELD_NUMBER: builtins.int
    ABORT_INCOMPLETE_MULTIPART_UPLOAD_FIELD_NUMBER: builtins.int
    NONCURRENT_EXPIRATION_FIELD_NUMBER: builtins.int
    NONCURRENT_TRANSITIONS_FIELD_NUMBER: builtins.int
    NONCURRENT_DELETE_MARKERS_FIELD_NUMBER: builtins.int
    enabled: builtins.bool
    """Indicates whether the rule is in effect."""
    @property
    def id(self) -> google.protobuf.wrappers_pb2.StringValue:
        """ID of the rule. Provided by the client or generated at creation time."""

    @property
    def filter(self) -> global___LifecycleRule.RuleFilter:
        """Filter that identifies the objects to which the rule applies.

        If not specified, the rule applies to all objects in the bucket.
        """

    @property
    def expiration(self) -> global___LifecycleRule.Expiration:
        """Expiration rule.

        The expiration of an object is described as follows.

        For the unversioned bucket ([Bucket.versioning] is `VERSIONING_DISABLED`), the object is deleted and cannot be
        recovered.

        For the bucket with versioning enabled ([Bucket.versioning] is `VERSIONING_ENABLED`), the current version of the
        object (if it exists and is not a delete marker) is retained as a non-current version, and a delete marker becomes
        the current version of the object.

        For the bucket with versioning suspended ([Bucket.versioning] is `VERSIONING_SUSPENDED`), the current version of
        the object is retained as a non-current version if it is not a delete marker, or is removed otherwise, and a
        delete marker becomes the current version of the object.
        """

    @property
    def transitions(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___LifecycleRule.Transition]:
        """List of transition rules.

        The transition of an object is described as follows.

        For the unversioned bucket ([Bucket.versioning] is `VERSIONING_DISABLED`), the object is transitioned to the
        specified storage class.

        For the bucket with versioning enabled ([Bucket.versioning] is `VERSIONING_ENABLED`) or suspended
        (`VERSIONING_SUSPENDED`), the current version of the object is transitioned to the specified storage class.
        """

    @property
    def abort_incomplete_multipart_upload(self) -> global___LifecycleRule.AfterDays:
        """Configuration for aborting incomplete [multipart uploads](/docs/storage/concepts/multipart)."""

    @property
    def noncurrent_expiration(self) -> global___LifecycleRule.NoncurrentExpiration:
        """Expiration rule for non-current versions of objects in a bucket with versioning enabled ([Bucket.versioning] is
        `VERSIONING_ENABLED`) or suspended (`VERSIONING_SUSPENDED`).

        At expiration, the non-current version of the object is deleted and cannot be recovered.
        """

    @property
    def noncurrent_transitions(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___LifecycleRule.NoncurrentTransition]:
        """List of transition rules for non-current versions of objects in a bucket with versioning enabled
        ([Bucket.versioning] is `VERSIONING_ENABLED`) or suspended (`VERSIONING_SUSPENDED`).

        At transition, the non-current version of the object is transitioned to the specified storage class.
        """

    @property
    def noncurrent_delete_markers(self) -> global___LifecycleRule.NoncurrentDeleteMarkers:
        """Expiration rule for non-current delete markers of an objects in a bucket with versioning
        enabled ([Bucket.versioning] is `VERSIONING_ENABLED`) or suspended (`VERSIONING_SUSPENDED`).
        Works in the same way as noncurrent_expiration rule, but only for delete markers.

        At expiration, the non-current delete marker of the object is deleted and cannot be recovered.
        """

    def __init__(
        self,
        *,
        id: google.protobuf.wrappers_pb2.StringValue | None = ...,
        enabled: builtins.bool = ...,
        filter: global___LifecycleRule.RuleFilter | None = ...,
        expiration: global___LifecycleRule.Expiration | None = ...,
        transitions: collections.abc.Iterable[global___LifecycleRule.Transition] | None = ...,
        abort_incomplete_multipart_upload: global___LifecycleRule.AfterDays | None = ...,
        noncurrent_expiration: global___LifecycleRule.NoncurrentExpiration | None = ...,
        noncurrent_transitions: collections.abc.Iterable[global___LifecycleRule.NoncurrentTransition] | None = ...,
        noncurrent_delete_markers: global___LifecycleRule.NoncurrentDeleteMarkers | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["abort_incomplete_multipart_upload", b"abort_incomplete_multipart_upload", "expiration", b"expiration", "filter", b"filter", "id", b"id", "noncurrent_delete_markers", b"noncurrent_delete_markers", "noncurrent_expiration", b"noncurrent_expiration"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["abort_incomplete_multipart_upload", b"abort_incomplete_multipart_upload", "enabled", b"enabled", "expiration", b"expiration", "filter", b"filter", "id", b"id", "noncurrent_delete_markers", b"noncurrent_delete_markers", "noncurrent_expiration", b"noncurrent_expiration", "noncurrent_transitions", b"noncurrent_transitions", "transitions", b"transitions"]) -> None: ...

global___LifecycleRule = LifecycleRule

@typing.final
class Counters(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SIMPLE_OBJECT_SIZE_FIELD_NUMBER: builtins.int
    SIMPLE_OBJECT_COUNT_FIELD_NUMBER: builtins.int
    OBJECTS_PARTS_SIZE_FIELD_NUMBER: builtins.int
    OBJECTS_PARTS_COUNT_FIELD_NUMBER: builtins.int
    MULTIPART_OBJECTS_SIZE_FIELD_NUMBER: builtins.int
    MULTIPART_OBJECTS_COUNT_FIELD_NUMBER: builtins.int
    ACTIVE_MULTIPART_COUNT_FIELD_NUMBER: builtins.int
    simple_object_size: builtins.int
    """Total size of objects uploaded in single operation, in bytes."""
    simple_object_count: builtins.int
    """Number of objects uploaded in single operation."""
    objects_parts_size: builtins.int
    """Total size of uploaded parts in incomplete multipart uploads, in bytes."""
    objects_parts_count: builtins.int
    """Number of uploaded parts in incomplete multipart uploads."""
    multipart_objects_size: builtins.int
    """Total size of objects uploaded in multiple parts, in bytes."""
    multipart_objects_count: builtins.int
    """Number of objects uploaded in multiple parts."""
    active_multipart_count: builtins.int
    """Number of incomplete multipart uploads."""
    def __init__(
        self,
        *,
        simple_object_size: builtins.int = ...,
        simple_object_count: builtins.int = ...,
        objects_parts_size: builtins.int = ...,
        objects_parts_count: builtins.int = ...,
        multipart_objects_size: builtins.int = ...,
        multipart_objects_count: builtins.int = ...,
        active_multipart_count: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["active_multipart_count", b"active_multipart_count", "multipart_objects_count", b"multipart_objects_count", "multipart_objects_size", b"multipart_objects_size", "objects_parts_count", b"objects_parts_count", "objects_parts_size", b"objects_parts_size", "simple_object_count", b"simple_object_count", "simple_object_size", b"simple_object_size"]) -> None: ...

global___Counters = Counters

@typing.final
class OptionalSizeByClass(google.protobuf.message.Message):
    """A resource for size of available space in a bucket for a storage class."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    STORAGE_CLASS_FIELD_NUMBER: builtins.int
    CLASS_SIZE_FIELD_NUMBER: builtins.int
    storage_class: builtins.str
    """Storage class. Supported classes are standard storage (`STANDARD`), cold storage (`COLD`, `STANDARD_IA`, `NEARLINE`
    all synonyms), and ice storage (`ICE` and `GLACIER` are synonyms).
    For details, see [documentation](/docs/storage/concepts/storage-class).
    """
    @property
    def class_size(self) -> google.protobuf.wrappers_pb2.Int64Value:
        """Size of available space in the bucket for the storage class."""

    def __init__(
        self,
        *,
        storage_class: builtins.str = ...,
        class_size: google.protobuf.wrappers_pb2.Int64Value | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["class_size", b"class_size"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["class_size", b"class_size", "storage_class", b"storage_class"]) -> None: ...

global___OptionalSizeByClass = OptionalSizeByClass

@typing.final
class SizeByClass(google.protobuf.message.Message):
    """A resource for size of used space in a bucket for a storage class."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    STORAGE_CLASS_FIELD_NUMBER: builtins.int
    CLASS_SIZE_FIELD_NUMBER: builtins.int
    storage_class: builtins.str
    """Storage class. Supported classes are standard storage (`STANDARD`), cold storage (`COLD`, `STANDARD_IA`, `NEARLINE`
    all synonyms), and ice storage (`ICE` and `GLACIER` are synonyms).
    For details, see [documentation](/docs/storage/concepts/storage-class).
    """
    class_size: builtins.int
    """Size of used space in the bucket for the storage class."""
    def __init__(
        self,
        *,
        storage_class: builtins.str = ...,
        class_size: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["class_size", b"class_size", "storage_class", b"storage_class"]) -> None: ...

global___SizeByClass = SizeByClass

@typing.final
class CountersByClass(google.protobuf.message.Message):
    """A resource for object-related statistics for a storage class by type of upload (simple vs. multipart)."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    STORAGE_CLASS_FIELD_NUMBER: builtins.int
    COUNTERS_FIELD_NUMBER: builtins.int
    storage_class: builtins.str
    """Storage class. Supported classes are standard storage (`STANDARD`), cold storage (`COLD`, `STANDARD_IA`, `NEARLINE`
    all synonyms), and ice storage (`ice` and `GLACIER` are synonyms).
    For details, see [documentation](/docs/storage/concepts/storage-class).
    """
    @property
    def counters(self) -> global___Counters:
        """Object-related statistics for the storage class by type of upload."""

    def __init__(
        self,
        *,
        storage_class: builtins.str = ...,
        counters: global___Counters | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["counters", b"counters"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["counters", b"counters", "storage_class", b"storage_class"]) -> None: ...

global___CountersByClass = CountersByClass

@typing.final
class BucketStats(google.protobuf.message.Message):
    """A bucket statistics resource."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    MAX_SIZE_FIELD_NUMBER: builtins.int
    USED_SIZE_FIELD_NUMBER: builtins.int
    STORAGE_CLASS_MAX_SIZES_FIELD_NUMBER: builtins.int
    STORAGE_CLASS_USED_SIZES_FIELD_NUMBER: builtins.int
    STORAGE_CLASS_COUNTERS_FIELD_NUMBER: builtins.int
    DEFAULT_STORAGE_CLASS_FIELD_NUMBER: builtins.int
    ANONYMOUS_ACCESS_FLAGS_FIELD_NUMBER: builtins.int
    CREATED_AT_FIELD_NUMBER: builtins.int
    UPDATED_AT_FIELD_NUMBER: builtins.int
    name: builtins.str
    """Name of the bucket."""
    used_size: builtins.int
    """Size of used space in the bucket, in bytes."""
    @property
    def max_size(self) -> google.protobuf.wrappers_pb2.Int64Value:
        """Maximum size of the bucket, in bytes."""

    @property
    def storage_class_max_sizes(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___OptionalSizeByClass]:
        """Size of available space in the bucket by storage class, in bytes."""

    @property
    def storage_class_used_sizes(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___SizeByClass]:
        """Size of used space in the bucket by storage class, in bytes."""

    @property
    def storage_class_counters(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___CountersByClass]:
        """Object-related statistics by storage class and type of upload (simple vs. multipart), in bytes."""

    @property
    def default_storage_class(self) -> google.protobuf.wrappers_pb2.StringValue:
        """Default storage class for objects in the bucket. Supported classes are standard storage (`STANDARD`), cold storage
        (`COLD`, `STANDARD_IA`, `NEARLINE` all synonyms), and ice storage (`ICE` and `GLACIER` are synonyms).
        For details, see [documentation](/docs/storage/concepts/storage-class).
        """

    @property
    def anonymous_access_flags(self) -> global___AnonymousAccessFlags:
        """Flags for configuring public (anonymous) access to the bucket's content and settings.
        For details, see [documentation](/docs/storage/concepts/bucket#bucket-access).
        """

    @property
    def created_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Bucket creation timestamp."""

    @property
    def updated_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Bucket latest update timestamp."""

    def __init__(
        self,
        *,
        name: builtins.str = ...,
        max_size: google.protobuf.wrappers_pb2.Int64Value | None = ...,
        used_size: builtins.int = ...,
        storage_class_max_sizes: collections.abc.Iterable[global___OptionalSizeByClass] | None = ...,
        storage_class_used_sizes: collections.abc.Iterable[global___SizeByClass] | None = ...,
        storage_class_counters: collections.abc.Iterable[global___CountersByClass] | None = ...,
        default_storage_class: google.protobuf.wrappers_pb2.StringValue | None = ...,
        anonymous_access_flags: global___AnonymousAccessFlags | None = ...,
        created_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        updated_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["anonymous_access_flags", b"anonymous_access_flags", "created_at", b"created_at", "default_storage_class", b"default_storage_class", "max_size", b"max_size", "updated_at", b"updated_at"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["anonymous_access_flags", b"anonymous_access_flags", "created_at", b"created_at", "default_storage_class", b"default_storage_class", "max_size", b"max_size", "name", b"name", "storage_class_counters", b"storage_class_counters", "storage_class_max_sizes", b"storage_class_max_sizes", "storage_class_used_sizes", b"storage_class_used_sizes", "updated_at", b"updated_at", "used_size", b"used_size"]) -> None: ...

global___BucketStats = BucketStats

@typing.final
class HTTPSConfig(google.protobuf.message.Message):
    """A resource for HTTPS configuration of a bucket."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _SourceType:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _SourceTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[HTTPSConfig._SourceType.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        SOURCE_TYPE_UNSPECIFIED: HTTPSConfig._SourceType.ValueType  # 0
        SOURCE_TYPE_SELF_MANAGED: HTTPSConfig._SourceType.ValueType  # 1
        """Your certificate, uploaded directly."""
        SOURCE_TYPE_MANAGED_BY_CERTIFICATE_MANAGER: HTTPSConfig._SourceType.ValueType  # 2
        """Certificate managed by Certificate Manager."""

    class SourceType(_SourceType, metaclass=_SourceTypeEnumTypeWrapper):
        """A resource for type of TLS certificate source."""

    SOURCE_TYPE_UNSPECIFIED: HTTPSConfig.SourceType.ValueType  # 0
    SOURCE_TYPE_SELF_MANAGED: HTTPSConfig.SourceType.ValueType  # 1
    """Your certificate, uploaded directly."""
    SOURCE_TYPE_MANAGED_BY_CERTIFICATE_MANAGER: HTTPSConfig.SourceType.ValueType  # 2
    """Certificate managed by Certificate Manager."""

    NAME_FIELD_NUMBER: builtins.int
    SOURCE_TYPE_FIELD_NUMBER: builtins.int
    ISSUER_FIELD_NUMBER: builtins.int
    SUBJECT_FIELD_NUMBER: builtins.int
    DNS_NAMES_FIELD_NUMBER: builtins.int
    NOT_BEFORE_FIELD_NUMBER: builtins.int
    NOT_AFTER_FIELD_NUMBER: builtins.int
    CERTIFICATE_ID_FIELD_NUMBER: builtins.int
    name: builtins.str
    """Name of the bucket."""
    source_type: global___HTTPSConfig.SourceType.ValueType
    """Type of TLS certificate source."""
    certificate_id: builtins.str
    """ID of the TLS certificate in Certificate Manager.

    To get information about the certificate from Certificate Manager, make a
    [yandex.cloud.certificatemanager.v1.CertificateService.Get] request.
    """
    @property
    def issuer(self) -> google.protobuf.wrappers_pb2.StringValue:
        """Issuer of the TLS certificate."""

    @property
    def subject(self) -> google.protobuf.wrappers_pb2.StringValue:
        """Subject of the TLS certificate."""

    @property
    def dns_names(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """List of DNS names of the TLS certificate (Subject Alternative Name field)."""

    @property
    def not_before(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Start of the TLS certificate validity period (Not Before field)."""

    @property
    def not_after(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """End of the TLS certificate validity period (Not After field)"""

    def __init__(
        self,
        *,
        name: builtins.str = ...,
        source_type: global___HTTPSConfig.SourceType.ValueType = ...,
        issuer: google.protobuf.wrappers_pb2.StringValue | None = ...,
        subject: google.protobuf.wrappers_pb2.StringValue | None = ...,
        dns_names: collections.abc.Iterable[builtins.str] | None = ...,
        not_before: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        not_after: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        certificate_id: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["issuer", b"issuer", "not_after", b"not_after", "not_before", b"not_before", "subject", b"subject"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["certificate_id", b"certificate_id", "dns_names", b"dns_names", "issuer", b"issuer", "name", b"name", "not_after", b"not_after", "not_before", b"not_before", "source_type", b"source_type", "subject", b"subject"]) -> None: ...

global___HTTPSConfig = HTTPSConfig

@typing.final
class ObjectLock(google.protobuf.message.Message):
    """A resource for Object Lock configuration of a bucket.
    For details about the concept, see [documentation](/docs/storage/concepts/object-lock).
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _ObjectLockStatus:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _ObjectLockStatusEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[ObjectLock._ObjectLockStatus.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        OBJECT_LOCK_STATUS_UNSPECIFIED: ObjectLock._ObjectLockStatus.ValueType  # 0
        OBJECT_LOCK_STATUS_DISABLED: ObjectLock._ObjectLockStatus.ValueType  # 1
        OBJECT_LOCK_STATUS_ENABLED: ObjectLock._ObjectLockStatus.ValueType  # 2

    class ObjectLockStatus(_ObjectLockStatus, metaclass=_ObjectLockStatusEnumTypeWrapper):
        """Activity status of the object lock settings on the bucket"""

    OBJECT_LOCK_STATUS_UNSPECIFIED: ObjectLock.ObjectLockStatus.ValueType  # 0
    OBJECT_LOCK_STATUS_DISABLED: ObjectLock.ObjectLockStatus.ValueType  # 1
    OBJECT_LOCK_STATUS_ENABLED: ObjectLock.ObjectLockStatus.ValueType  # 2

    @typing.final
    class DefaultRetention(google.protobuf.message.Message):
        """Default lock configuration for added objects"""

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        class _Mode:
            ValueType = typing.NewType("ValueType", builtins.int)
            V: typing_extensions.TypeAlias = ValueType

        class _ModeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[ObjectLock.DefaultRetention._Mode.ValueType], builtins.type):
            DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
            MODE_UNSPECIFIED: ObjectLock.DefaultRetention._Mode.ValueType  # 0
            MODE_GOVERNANCE: ObjectLock.DefaultRetention._Mode.ValueType  # 1
            MODE_COMPLIANCE: ObjectLock.DefaultRetention._Mode.ValueType  # 2

        class Mode(_Mode, metaclass=_ModeEnumTypeWrapper):
            """Lock type"""

        MODE_UNSPECIFIED: ObjectLock.DefaultRetention.Mode.ValueType  # 0
        MODE_GOVERNANCE: ObjectLock.DefaultRetention.Mode.ValueType  # 1
        MODE_COMPLIANCE: ObjectLock.DefaultRetention.Mode.ValueType  # 2

        MODE_FIELD_NUMBER: builtins.int
        DAYS_FIELD_NUMBER: builtins.int
        YEARS_FIELD_NUMBER: builtins.int
        mode: global___ObjectLock.DefaultRetention.Mode.ValueType
        days: builtins.int
        """Number of days for locking"""
        years: builtins.int
        """Number of years for locking"""
        def __init__(
            self,
            *,
            mode: global___ObjectLock.DefaultRetention.Mode.ValueType = ...,
            days: builtins.int = ...,
            years: builtins.int = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["days", b"days", "period", b"period", "years", b"years"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["days", b"days", "mode", b"mode", "period", b"period", "years", b"years"]) -> None: ...
        def WhichOneof(self, oneof_group: typing.Literal["period", b"period"]) -> typing.Literal["days", "years"] | None: ...

    STATUS_FIELD_NUMBER: builtins.int
    DEFAULT_RETENTION_FIELD_NUMBER: builtins.int
    status: global___ObjectLock.ObjectLockStatus.ValueType
    @property
    def default_retention(self) -> global___ObjectLock.DefaultRetention: ...
    def __init__(
        self,
        *,
        status: global___ObjectLock.ObjectLockStatus.ValueType = ...,
        default_retention: global___ObjectLock.DefaultRetention | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["default_retention", b"default_retention"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["default_retention", b"default_retention", "status", b"status"]) -> None: ...

global___ObjectLock = ObjectLock

@typing.final
class Encryption(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class EncryptionRule(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KMS_MASTER_KEY_ID_FIELD_NUMBER: builtins.int
        SSE_ALGORITHM_FIELD_NUMBER: builtins.int
        kms_master_key_id: builtins.str
        sse_algorithm: builtins.str
        def __init__(
            self,
            *,
            kms_master_key_id: builtins.str = ...,
            sse_algorithm: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["kms_master_key_id", b"kms_master_key_id", "sse_algorithm", b"sse_algorithm"]) -> None: ...

    RULES_FIELD_NUMBER: builtins.int
    @property
    def rules(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Encryption.EncryptionRule]: ...
    def __init__(
        self,
        *,
        rules: collections.abc.Iterable[global___Encryption.EncryptionRule] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["rules", b"rules"]) -> None: ...

global___Encryption = Encryption

@typing.final
class BucketAllowedPrivateEndpoints(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ENABLED_FIELD_NUMBER: builtins.int
    PRIVATE_ENDPOINTS_FIELD_NUMBER: builtins.int
    enabled: builtins.bool
    """if true, private endpoints white list check is enabled
    even if private_endpoints list is empty
    """
    @property
    def private_endpoints(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """white list of private endpoints bucket accessible from"""

    def __init__(
        self,
        *,
        enabled: builtins.bool = ...,
        private_endpoints: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["enabled", b"enabled", "private_endpoints", b"private_endpoints"]) -> None: ...

global___BucketAllowedPrivateEndpoints = BucketAllowedPrivateEndpoints
