"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import abc
import collections.abc
import grpc
import grpc.aio
import typing
import yandex.cloud.access.access_pb2
import yandex.cloud.operation.operation_pb2
import yandex.cloud.storage.v1.bucket_pb2
import yandex.cloud.storage.v1.bucket_service_pb2

_T = typing.TypeVar("_T")

class _MaybeAsyncIterator(collections.abc.AsyncIterator[_T], collections.abc.Iterator[_T], metaclass=abc.ABCMeta): ...

class _ServicerContext(grpc.ServicerContext, grpc.aio.ServicerContext):  # type: ignore[misc, type-arg]
    ...

class BucketServiceStub:
    """A set of methods for managing buckets."""

    def __init__(self, channel: typing.Union[grpc.Channel, grpc.aio.Channel]) -> None: ...
    List: grpc.UnaryUnaryMultiCallable[
        yandex.cloud.storage.v1.bucket_service_pb2.ListBucketsRequest,
        yandex.cloud.storage.v1.bucket_service_pb2.ListBucketsResponse,
    ]
    """Retrieves the list of buckets in the specified folder.

    The following fields will not be returned for buckets in the list: [Bucket.policy], [Bucket.acl], [Bucket.cors],
    [Bucket.website_settings], [Bucket.lifecycle_rules], [Bucket.tags].
    """

    Get: grpc.UnaryUnaryMultiCallable[
        yandex.cloud.storage.v1.bucket_service_pb2.GetBucketRequest,
        yandex.cloud.storage.v1.bucket_pb2.Bucket,
    ]
    """Returns the specified bucket.

    To get the list of all available buckets, make a [List] request.
    """

    Create: grpc.UnaryUnaryMultiCallable[
        yandex.cloud.storage.v1.bucket_service_pb2.CreateBucketRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Creates a bucket in the specified folder."""

    Update: grpc.UnaryUnaryMultiCallable[
        yandex.cloud.storage.v1.bucket_service_pb2.UpdateBucketRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Updates the specified bucket.

    In most cases, `storage.editor` role (see [documentation](/docs/storage/security/#storage-editor)) should be enough
    to update a bucket, subject to its [policy](/docs/storage/concepts/policy).
    """

    Delete: grpc.UnaryUnaryMultiCallable[
        yandex.cloud.storage.v1.bucket_service_pb2.DeleteBucketRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Deletes the specified bucket."""

    GetStats: grpc.UnaryUnaryMultiCallable[
        yandex.cloud.storage.v1.bucket_service_pb2.GetBucketStatsRequest,
        yandex.cloud.storage.v1.bucket_pb2.BucketStats,
    ]
    """Returns the statistics for the specified bucket."""

    GetHTTPSConfig: grpc.UnaryUnaryMultiCallable[
        yandex.cloud.storage.v1.bucket_service_pb2.GetBucketHTTPSConfigRequest,
        yandex.cloud.storage.v1.bucket_pb2.HTTPSConfig,
    ]
    """Returns the HTTPS configuration for the specified bucket."""

    SetHTTPSConfig: grpc.UnaryUnaryMultiCallable[
        yandex.cloud.storage.v1.bucket_service_pb2.SetBucketHTTPSConfigRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Updates the HTTPS configuration for the specified bucket.

    The updated configuration could take up to 30 minutes to apply to the bucket.
    """

    DeleteHTTPSConfig: grpc.UnaryUnaryMultiCallable[
        yandex.cloud.storage.v1.bucket_service_pb2.DeleteBucketHTTPSConfigRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Deletes the HTTPS configuration for the specified bucket."""

    SetAccessBindings: grpc.UnaryUnaryMultiCallable[
        yandex.cloud.access.access_pb2.SetAccessBindingsRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]

    UpdateAccessBindings: grpc.UnaryUnaryMultiCallable[
        yandex.cloud.access.access_pb2.UpdateAccessBindingsRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]

    ListAccessBindings: grpc.UnaryUnaryMultiCallable[
        yandex.cloud.access.access_pb2.ListAccessBindingsRequest,
        yandex.cloud.access.access_pb2.ListAccessBindingsResponse,
    ]

class BucketServiceAsyncStub:
    """A set of methods for managing buckets."""

    List: grpc.aio.UnaryUnaryMultiCallable[
        yandex.cloud.storage.v1.bucket_service_pb2.ListBucketsRequest,
        yandex.cloud.storage.v1.bucket_service_pb2.ListBucketsResponse,
    ]
    """Retrieves the list of buckets in the specified folder.

    The following fields will not be returned for buckets in the list: [Bucket.policy], [Bucket.acl], [Bucket.cors],
    [Bucket.website_settings], [Bucket.lifecycle_rules], [Bucket.tags].
    """

    Get: grpc.aio.UnaryUnaryMultiCallable[
        yandex.cloud.storage.v1.bucket_service_pb2.GetBucketRequest,
        yandex.cloud.storage.v1.bucket_pb2.Bucket,
    ]
    """Returns the specified bucket.

    To get the list of all available buckets, make a [List] request.
    """

    Create: grpc.aio.UnaryUnaryMultiCallable[
        yandex.cloud.storage.v1.bucket_service_pb2.CreateBucketRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Creates a bucket in the specified folder."""

    Update: grpc.aio.UnaryUnaryMultiCallable[
        yandex.cloud.storage.v1.bucket_service_pb2.UpdateBucketRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Updates the specified bucket.

    In most cases, `storage.editor` role (see [documentation](/docs/storage/security/#storage-editor)) should be enough
    to update a bucket, subject to its [policy](/docs/storage/concepts/policy).
    """

    Delete: grpc.aio.UnaryUnaryMultiCallable[
        yandex.cloud.storage.v1.bucket_service_pb2.DeleteBucketRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Deletes the specified bucket."""

    GetStats: grpc.aio.UnaryUnaryMultiCallable[
        yandex.cloud.storage.v1.bucket_service_pb2.GetBucketStatsRequest,
        yandex.cloud.storage.v1.bucket_pb2.BucketStats,
    ]
    """Returns the statistics for the specified bucket."""

    GetHTTPSConfig: grpc.aio.UnaryUnaryMultiCallable[
        yandex.cloud.storage.v1.bucket_service_pb2.GetBucketHTTPSConfigRequest,
        yandex.cloud.storage.v1.bucket_pb2.HTTPSConfig,
    ]
    """Returns the HTTPS configuration for the specified bucket."""

    SetHTTPSConfig: grpc.aio.UnaryUnaryMultiCallable[
        yandex.cloud.storage.v1.bucket_service_pb2.SetBucketHTTPSConfigRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Updates the HTTPS configuration for the specified bucket.

    The updated configuration could take up to 30 minutes to apply to the bucket.
    """

    DeleteHTTPSConfig: grpc.aio.UnaryUnaryMultiCallable[
        yandex.cloud.storage.v1.bucket_service_pb2.DeleteBucketHTTPSConfigRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Deletes the HTTPS configuration for the specified bucket."""

    SetAccessBindings: grpc.aio.UnaryUnaryMultiCallable[
        yandex.cloud.access.access_pb2.SetAccessBindingsRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]

    UpdateAccessBindings: grpc.aio.UnaryUnaryMultiCallable[
        yandex.cloud.access.access_pb2.UpdateAccessBindingsRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]

    ListAccessBindings: grpc.aio.UnaryUnaryMultiCallable[
        yandex.cloud.access.access_pb2.ListAccessBindingsRequest,
        yandex.cloud.access.access_pb2.ListAccessBindingsResponse,
    ]

class BucketServiceServicer(metaclass=abc.ABCMeta):
    """A set of methods for managing buckets."""

    @abc.abstractmethod
    def List(
        self,
        request: yandex.cloud.storage.v1.bucket_service_pb2.ListBucketsRequest,
        context: _ServicerContext,
    ) -> typing.Union[yandex.cloud.storage.v1.bucket_service_pb2.ListBucketsResponse, collections.abc.Awaitable[yandex.cloud.storage.v1.bucket_service_pb2.ListBucketsResponse]]:
        """Retrieves the list of buckets in the specified folder.

        The following fields will not be returned for buckets in the list: [Bucket.policy], [Bucket.acl], [Bucket.cors],
        [Bucket.website_settings], [Bucket.lifecycle_rules], [Bucket.tags].
        """

    @abc.abstractmethod
    def Get(
        self,
        request: yandex.cloud.storage.v1.bucket_service_pb2.GetBucketRequest,
        context: _ServicerContext,
    ) -> typing.Union[yandex.cloud.storage.v1.bucket_pb2.Bucket, collections.abc.Awaitable[yandex.cloud.storage.v1.bucket_pb2.Bucket]]:
        """Returns the specified bucket.

        To get the list of all available buckets, make a [List] request.
        """

    @abc.abstractmethod
    def Create(
        self,
        request: yandex.cloud.storage.v1.bucket_service_pb2.CreateBucketRequest,
        context: _ServicerContext,
    ) -> typing.Union[yandex.cloud.operation.operation_pb2.Operation, collections.abc.Awaitable[yandex.cloud.operation.operation_pb2.Operation]]:
        """Creates a bucket in the specified folder."""

    @abc.abstractmethod
    def Update(
        self,
        request: yandex.cloud.storage.v1.bucket_service_pb2.UpdateBucketRequest,
        context: _ServicerContext,
    ) -> typing.Union[yandex.cloud.operation.operation_pb2.Operation, collections.abc.Awaitable[yandex.cloud.operation.operation_pb2.Operation]]:
        """Updates the specified bucket.

        In most cases, `storage.editor` role (see [documentation](/docs/storage/security/#storage-editor)) should be enough
        to update a bucket, subject to its [policy](/docs/storage/concepts/policy).
        """

    @abc.abstractmethod
    def Delete(
        self,
        request: yandex.cloud.storage.v1.bucket_service_pb2.DeleteBucketRequest,
        context: _ServicerContext,
    ) -> typing.Union[yandex.cloud.operation.operation_pb2.Operation, collections.abc.Awaitable[yandex.cloud.operation.operation_pb2.Operation]]:
        """Deletes the specified bucket."""

    @abc.abstractmethod
    def GetStats(
        self,
        request: yandex.cloud.storage.v1.bucket_service_pb2.GetBucketStatsRequest,
        context: _ServicerContext,
    ) -> typing.Union[yandex.cloud.storage.v1.bucket_pb2.BucketStats, collections.abc.Awaitable[yandex.cloud.storage.v1.bucket_pb2.BucketStats]]:
        """Returns the statistics for the specified bucket."""

    @abc.abstractmethod
    def GetHTTPSConfig(
        self,
        request: yandex.cloud.storage.v1.bucket_service_pb2.GetBucketHTTPSConfigRequest,
        context: _ServicerContext,
    ) -> typing.Union[yandex.cloud.storage.v1.bucket_pb2.HTTPSConfig, collections.abc.Awaitable[yandex.cloud.storage.v1.bucket_pb2.HTTPSConfig]]:
        """Returns the HTTPS configuration for the specified bucket."""

    @abc.abstractmethod
    def SetHTTPSConfig(
        self,
        request: yandex.cloud.storage.v1.bucket_service_pb2.SetBucketHTTPSConfigRequest,
        context: _ServicerContext,
    ) -> typing.Union[yandex.cloud.operation.operation_pb2.Operation, collections.abc.Awaitable[yandex.cloud.operation.operation_pb2.Operation]]:
        """Updates the HTTPS configuration for the specified bucket.

        The updated configuration could take up to 30 minutes to apply to the bucket.
        """

    @abc.abstractmethod
    def DeleteHTTPSConfig(
        self,
        request: yandex.cloud.storage.v1.bucket_service_pb2.DeleteBucketHTTPSConfigRequest,
        context: _ServicerContext,
    ) -> typing.Union[yandex.cloud.operation.operation_pb2.Operation, collections.abc.Awaitable[yandex.cloud.operation.operation_pb2.Operation]]:
        """Deletes the HTTPS configuration for the specified bucket."""

    @abc.abstractmethod
    def SetAccessBindings(
        self,
        request: yandex.cloud.access.access_pb2.SetAccessBindingsRequest,
        context: _ServicerContext,
    ) -> typing.Union[yandex.cloud.operation.operation_pb2.Operation, collections.abc.Awaitable[yandex.cloud.operation.operation_pb2.Operation]]: ...

    @abc.abstractmethod
    def UpdateAccessBindings(
        self,
        request: yandex.cloud.access.access_pb2.UpdateAccessBindingsRequest,
        context: _ServicerContext,
    ) -> typing.Union[yandex.cloud.operation.operation_pb2.Operation, collections.abc.Awaitable[yandex.cloud.operation.operation_pb2.Operation]]: ...

    @abc.abstractmethod
    def ListAccessBindings(
        self,
        request: yandex.cloud.access.access_pb2.ListAccessBindingsRequest,
        context: _ServicerContext,
    ) -> typing.Union[yandex.cloud.access.access_pb2.ListAccessBindingsResponse, collections.abc.Awaitable[yandex.cloud.access.access_pb2.ListAccessBindingsResponse]]: ...

def add_BucketServiceServicer_to_server(servicer: BucketServiceServicer, server: typing.Union[grpc.Server, grpc.aio.Server]) -> None: ...
