"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.message
import google.protobuf.timestamp_pb2
import typing

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class S3APIGetObjectResponse(google.protobuf.message.Message):
    """Represents a response of the get object request to S3."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class MetadataEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    ETAG_FIELD_NUMBER: builtins.int
    REQUEST_ID_FIELD_NUMBER: builtins.int
    ACCEPT_RANGES_FIELD_NUMBER: builtins.int
    CACHE_CONTROL_FIELD_NUMBER: builtins.int
    CONTENT_DISPOSITION_FIELD_NUMBER: builtins.int
    CONTENT_ENCODING_FIELD_NUMBER: builtins.int
    CONTENT_LANGUAGE_FIELD_NUMBER: builtins.int
    CONTENT_LENGTH_FIELD_NUMBER: builtins.int
    CONTENT_RANGE_FIELD_NUMBER: builtins.int
    CONTENT_TYPE_FIELD_NUMBER: builtins.int
    VERSION_ID_FIELD_NUMBER: builtins.int
    EXPIRES_AT_FIELD_NUMBER: builtins.int
    LAST_MODIFIED_AT_FIELD_NUMBER: builtins.int
    METADATA_FIELD_NUMBER: builtins.int
    STORAGE_CLASS_FIELD_NUMBER: builtins.int
    SERVER_SIDE_ENCRYPTION_FIELD_NUMBER: builtins.int
    SSE_KMS_KEY_ID_FIELD_NUMBER: builtins.int
    OBJECT_LOCK_MODE_FIELD_NUMBER: builtins.int
    OBJECT_LOCK_RETAIN_UNTIL_DATE_FIELD_NUMBER: builtins.int
    OBJECT_LOCK_LEGAL_HOLD_STATUS_FIELD_NUMBER: builtins.int
    etag: builtins.str
    """MD5 hash of the object."""
    request_id: builtins.str
    """Unique request ID."""
    accept_ranges: builtins.str
    """Indicates that a range of bytes was specified in the request."""
    cache_control: builtins.str
    """Specifies caching behavior along the request/reply chain."""
    content_disposition: builtins.str
    """Specifies presentational information for the object."""
    content_encoding: builtins.str
    """Indicates what content encodings have been applied to the object."""
    content_language: builtins.str
    """The language the content is in."""
    content_length: builtins.int
    """Size of the body in bytes."""
    content_range: builtins.str
    """The portion of the object returned in the response."""
    content_type: builtins.str
    """A standard MIME type describing the format of the object data."""
    version_id: builtins.str
    """Version ID of the object."""
    storage_class: builtins.str
    """Provides storage class information of the object."""
    server_side_encryption: builtins.str
    """Encryption algorithm used to encrypt the object."""
    sse_kms_key_id: builtins.str
    """ID of the key KMS."""
    object_lock_mode: builtins.str
    """Type of retention put on the object."""
    object_lock_legal_hold_status: builtins.str
    """Type of legal hold put on the object"""
    @property
    def expires_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """The date and time at which the object is no longer cacheable."""

    @property
    def last_modified_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Date and time when the object was last modified."""

    @property
    def metadata(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Object user-defined metadata."""

    @property
    def object_lock_retain_until_date(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Date and time until which the object is retained"""

    def __init__(
        self,
        *,
        etag: builtins.str = ...,
        request_id: builtins.str = ...,
        accept_ranges: builtins.str = ...,
        cache_control: builtins.str = ...,
        content_disposition: builtins.str = ...,
        content_encoding: builtins.str = ...,
        content_language: builtins.str = ...,
        content_length: builtins.int = ...,
        content_range: builtins.str = ...,
        content_type: builtins.str = ...,
        version_id: builtins.str = ...,
        expires_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        last_modified_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        metadata: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        storage_class: builtins.str = ...,
        server_side_encryption: builtins.str = ...,
        sse_kms_key_id: builtins.str = ...,
        object_lock_mode: builtins.str = ...,
        object_lock_retain_until_date: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        object_lock_legal_hold_status: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["expires_at", b"expires_at", "last_modified_at", b"last_modified_at", "object_lock_retain_until_date", b"object_lock_retain_until_date"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["accept_ranges", b"accept_ranges", "cache_control", b"cache_control", "content_disposition", b"content_disposition", "content_encoding", b"content_encoding", "content_language", b"content_language", "content_length", b"content_length", "content_range", b"content_range", "content_type", b"content_type", "etag", b"etag", "expires_at", b"expires_at", "last_modified_at", b"last_modified_at", "metadata", b"metadata", "object_lock_legal_hold_status", b"object_lock_legal_hold_status", "object_lock_mode", b"object_lock_mode", "object_lock_retain_until_date", b"object_lock_retain_until_date", "request_id", b"request_id", "server_side_encryption", b"server_side_encryption", "sse_kms_key_id", b"sse_kms_key_id", "storage_class", b"storage_class", "version_id", b"version_id"]) -> None: ...

global___S3APIGetObjectResponse = S3APIGetObjectResponse

@typing.final
class S3APIPutObjectResponse(google.protobuf.message.Message):
    """Represents a response of the put object request to S3."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ETAG_FIELD_NUMBER: builtins.int
    REQUEST_ID_FIELD_NUMBER: builtins.int
    VERSION_ID_FIELD_NUMBER: builtins.int
    etag: builtins.str
    """MD5 hash of the object."""
    request_id: builtins.str
    """Unique request ID."""
    version_id: builtins.str
    """Version ID of the object."""
    def __init__(
        self,
        *,
        etag: builtins.str = ...,
        request_id: builtins.str = ...,
        version_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["etag", b"etag", "request_id", b"request_id", "version_id", b"version_id"]) -> None: ...

global___S3APIPutObjectResponse = S3APIPutObjectResponse

@typing.final
class S3APIDeleteObjectResponse(google.protobuf.message.Message):
    """Represents a response of the delete object request to S3."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    REQUEST_ID_FIELD_NUMBER: builtins.int
    VERSION_ID_FIELD_NUMBER: builtins.int
    request_id: builtins.str
    """Unique request ID."""
    version_id: builtins.str
    """Version ID of the object."""
    def __init__(
        self,
        *,
        request_id: builtins.str = ...,
        version_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["request_id", b"request_id", "version_id", b"version_id"]) -> None: ...

global___S3APIDeleteObjectResponse = S3APIDeleteObjectResponse

@typing.final
class CopyObjectResult(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ETAG_FIELD_NUMBER: builtins.int
    LAST_MODIFIED_AT_FIELD_NUMBER: builtins.int
    etag: builtins.str
    """Returns the ETag of the new object."""
    @property
    def last_modified_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Creation date of the object."""

    def __init__(
        self,
        *,
        etag: builtins.str = ...,
        last_modified_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["last_modified_at", b"last_modified_at"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["etag", b"etag", "last_modified_at", b"last_modified_at"]) -> None: ...

global___CopyObjectResult = CopyObjectResult

@typing.final
class S3APICopyObjectResponse(google.protobuf.message.Message):
    """Represents a response of the copy object request to S3."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    COPY_OBJECT_RESULT_FIELD_NUMBER: builtins.int
    REQUEST_ID_FIELD_NUMBER: builtins.int
    COPY_SOURCE_VERSION_ID_FIELD_NUMBER: builtins.int
    VERSION_ID_FIELD_NUMBER: builtins.int
    request_id: builtins.str
    """Unique request ID."""
    copy_source_version_id: builtins.str
    """Version ID of the source object that was copied."""
    version_id: builtins.str
    """Version ID of the newly created copy."""
    @property
    def copy_object_result(self) -> global___CopyObjectResult:
        """Container for all response elements."""

    def __init__(
        self,
        *,
        copy_object_result: global___CopyObjectResult | None = ...,
        request_id: builtins.str = ...,
        copy_source_version_id: builtins.str = ...,
        version_id: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["copy_object_result", b"copy_object_result"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["copy_object_result", b"copy_object_result", "copy_source_version_id", b"copy_source_version_id", "request_id", b"request_id", "version_id", b"version_id"]) -> None: ...

global___S3APICopyObjectResponse = S3APICopyObjectResponse

@typing.final
class SuccessfullyDeletedObject(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    KEY_FIELD_NUMBER: builtins.int
    VERSION_ID_FIELD_NUMBER: builtins.int
    DELETE_MARKER_FIELD_NUMBER: builtins.int
    DELETE_MARKER_VERSION_ID_FIELD_NUMBER: builtins.int
    key: builtins.str
    """The name of the deleted object."""
    version_id: builtins.str
    """The version ID of the deleted object."""
    delete_marker: builtins.bool
    """Specifies whether the versioned object that was permanently deleted was (true) or was not (false) a delete marker."""
    delete_marker_version_id: builtins.str
    """The version ID of the delete marker created as a result of the DELETE operation."""
    def __init__(
        self,
        *,
        key: builtins.str = ...,
        version_id: builtins.str = ...,
        delete_marker: builtins.bool = ...,
        delete_marker_version_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["delete_marker", b"delete_marker", "delete_marker_version_id", b"delete_marker_version_id", "key", b"key", "version_id", b"version_id"]) -> None: ...

global___SuccessfullyDeletedObject = SuccessfullyDeletedObject

@typing.final
class DeleteObjectError(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    KEY_FIELD_NUMBER: builtins.int
    VERSION_ID_FIELD_NUMBER: builtins.int
    CODE_FIELD_NUMBER: builtins.int
    MSG_FIELD_NUMBER: builtins.int
    key: builtins.str
    """The error key."""
    version_id: builtins.str
    """The version ID of the error."""
    code: builtins.str
    """The error code is a string that uniquely identifies an error condition."""
    msg: builtins.str
    """The error message contains a generic description of the error condition in English."""
    def __init__(
        self,
        *,
        key: builtins.str = ...,
        version_id: builtins.str = ...,
        code: builtins.str = ...,
        msg: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["code", b"code", "key", b"key", "msg", b"msg", "version_id", b"version_id"]) -> None: ...

global___DeleteObjectError = DeleteObjectError

@typing.final
class S3APIDeleteObjectsResponse(google.protobuf.message.Message):
    """Represents a response of the delete objects request to S3."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DELETED_FIELD_NUMBER: builtins.int
    ERRORS_FIELD_NUMBER: builtins.int
    REQUEST_ID_FIELD_NUMBER: builtins.int
    request_id: builtins.str
    """Unique request ID."""
    @property
    def deleted(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___SuccessfullyDeletedObject]:
        """List of successfully deleted objects"""

    @property
    def errors(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___DeleteObjectError]:
        """List of objects that attempted to be deleted but encountered an error"""

    def __init__(
        self,
        *,
        deleted: collections.abc.Iterable[global___SuccessfullyDeletedObject] | None = ...,
        errors: collections.abc.Iterable[global___DeleteObjectError] | None = ...,
        request_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["deleted", b"deleted", "errors", b"errors", "request_id", b"request_id"]) -> None: ...

global___S3APIDeleteObjectsResponse = S3APIDeleteObjectsResponse

@typing.final
class S3APIPutObjectRetentionResponse(google.protobuf.message.Message):
    """Represents a response of the put object retention request to S3."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    REQUEST_ID_FIELD_NUMBER: builtins.int
    request_id: builtins.str
    """Unique request ID."""
    def __init__(
        self,
        *,
        request_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["request_id", b"request_id"]) -> None: ...

global___S3APIPutObjectRetentionResponse = S3APIPutObjectRetentionResponse

@typing.final
class ObjectLockRetention(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MODE_FIELD_NUMBER: builtins.int
    RETAIN_UNTIL_DATE_FIELD_NUMBER: builtins.int
    mode: builtins.str
    """Indicates the Retention mode for the specified object."""
    @property
    def retain_until_date(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """The date on which this object lock retention will expire."""

    def __init__(
        self,
        *,
        mode: builtins.str = ...,
        retain_until_date: google.protobuf.timestamp_pb2.Timestamp | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["retain_until_date", b"retain_until_date"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["mode", b"mode", "retain_until_date", b"retain_until_date"]) -> None: ...

global___ObjectLockRetention = ObjectLockRetention

@typing.final
class S3APIGetObjectRetentionResponse(google.protobuf.message.Message):
    """Represents a response of the get object retention request to S3."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    REQUEST_ID_FIELD_NUMBER: builtins.int
    RETENTION_FIELD_NUMBER: builtins.int
    request_id: builtins.str
    """Unique request ID."""
    @property
    def retention(self) -> global___ObjectLockRetention:
        """An object retention settings."""

    def __init__(
        self,
        *,
        request_id: builtins.str = ...,
        retention: global___ObjectLockRetention | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["retention", b"retention"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["request_id", b"request_id", "retention", b"retention"]) -> None: ...

global___S3APIGetObjectRetentionResponse = S3APIGetObjectRetentionResponse

@typing.final
class S3APIPutObjectLegalHoldResponse(google.protobuf.message.Message):
    """Represents a response of the put object retention request to S3."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    REQUEST_ID_FIELD_NUMBER: builtins.int
    request_id: builtins.str
    """Unique request ID."""
    def __init__(
        self,
        *,
        request_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["request_id", b"request_id"]) -> None: ...

global___S3APIPutObjectLegalHoldResponse = S3APIPutObjectLegalHoldResponse

@typing.final
class ObjectLockLegalHold(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    STATUS_FIELD_NUMBER: builtins.int
    status: builtins.str
    """Indicates whether the specified object has a legal hold in place."""
    def __init__(
        self,
        *,
        status: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["status", b"status"]) -> None: ...

global___ObjectLockLegalHold = ObjectLockLegalHold

@typing.final
class S3APIGetObjectLegalHoldResponse(google.protobuf.message.Message):
    """Represents a response of the get object legal hold request to S3."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    REQUEST_ID_FIELD_NUMBER: builtins.int
    LEGAL_HOLD_FIELD_NUMBER: builtins.int
    request_id: builtins.str
    """Unique request ID."""
    @property
    def legal_hold(self) -> global___ObjectLockLegalHold:
        """The current legal hold status for the specified object."""

    def __init__(
        self,
        *,
        request_id: builtins.str = ...,
        legal_hold: global___ObjectLockLegalHold | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["legal_hold", b"legal_hold"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["legal_hold", b"legal_hold", "request_id", b"request_id"]) -> None: ...

global___S3APIGetObjectLegalHoldResponse = S3APIGetObjectLegalHoldResponse

@typing.final
class S3APIPutObjectTaggingResponse(google.protobuf.message.Message):
    """Represents a response of put object tagging request to S3."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    REQUEST_ID_FIELD_NUMBER: builtins.int
    VERSION_ID_FIELD_NUMBER: builtins.int
    request_id: builtins.str
    """Unique request ID."""
    version_id: builtins.str
    """The versionId of the object the tag-set was added to."""
    def __init__(
        self,
        *,
        request_id: builtins.str = ...,
        version_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["request_id", b"request_id", "version_id", b"version_id"]) -> None: ...

global___S3APIPutObjectTaggingResponse = S3APIPutObjectTaggingResponse

@typing.final
class ObjectTag(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    KEY_FIELD_NUMBER: builtins.int
    VALUE_FIELD_NUMBER: builtins.int
    key: builtins.str
    """Key of the object tag."""
    value: builtins.str
    """Value of the object tag."""
    def __init__(
        self,
        *,
        key: builtins.str = ...,
        value: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

global___ObjectTag = ObjectTag

@typing.final
class S3APIGetObjectTaggingResponse(google.protobuf.message.Message):
    """Represents a response of get object tagging request to S3."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    REQUEST_ID_FIELD_NUMBER: builtins.int
    VERSION_ID_FIELD_NUMBER: builtins.int
    TAG_SET_FIELD_NUMBER: builtins.int
    request_id: builtins.str
    """Unique request ID."""
    version_id: builtins.str
    """The versionId of the object for which you got the tagging information."""
    @property
    def tag_set(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ObjectTag]:
        """Contains the tag set."""

    def __init__(
        self,
        *,
        request_id: builtins.str = ...,
        version_id: builtins.str = ...,
        tag_set: collections.abc.Iterable[global___ObjectTag] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["request_id", b"request_id", "tag_set", b"tag_set", "version_id", b"version_id"]) -> None: ...

global___S3APIGetObjectTaggingResponse = S3APIGetObjectTaggingResponse

@typing.final
class S3APIDeleteObjectTaggingResponse(google.protobuf.message.Message):
    """Represents a response of delete object tagging request to S3."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    REQUEST_ID_FIELD_NUMBER: builtins.int
    VERSION_ID_FIELD_NUMBER: builtins.int
    request_id: builtins.str
    """Unique request ID."""
    version_id: builtins.str
    """The versionId of the object the tag-set was removed from."""
    def __init__(
        self,
        *,
        request_id: builtins.str = ...,
        version_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["request_id", b"request_id", "version_id", b"version_id"]) -> None: ...

global___S3APIDeleteObjectTaggingResponse = S3APIDeleteObjectTaggingResponse

@typing.final
class S3APIStartMultipartUploadResponse(google.protobuf.message.Message):
    """Represents a response of start multipart upload request to S3."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    REQUEST_ID_FIELD_NUMBER: builtins.int
    BUCKET_FIELD_NUMBER: builtins.int
    KEY_FIELD_NUMBER: builtins.int
    UPLOAD_ID_FIELD_NUMBER: builtins.int
    request_id: builtins.str
    """Unique request ID."""
    bucket: builtins.str
    """The name of the bucket in which the initiated multipart upload was initiated."""
    key: builtins.str
    """Object key for which the multipart upload was initiated."""
    upload_id: builtins.str
    """The ID of the initiated multipart upload."""
    def __init__(
        self,
        *,
        request_id: builtins.str = ...,
        bucket: builtins.str = ...,
        key: builtins.str = ...,
        upload_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["bucket", b"bucket", "key", b"key", "request_id", b"request_id", "upload_id", b"upload_id"]) -> None: ...

global___S3APIStartMultipartUploadResponse = S3APIStartMultipartUploadResponse

@typing.final
class S3APIUploadPartResponse(google.protobuf.message.Message):
    """Represents a response of upload part request to S3."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    REQUEST_ID_FIELD_NUMBER: builtins.int
    ETAG_FIELD_NUMBER: builtins.int
    request_id: builtins.str
    """Unique request ID."""
    etag: builtins.str
    """MD5 hash of the object."""
    def __init__(
        self,
        *,
        request_id: builtins.str = ...,
        etag: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["etag", b"etag", "request_id", b"request_id"]) -> None: ...

global___S3APIUploadPartResponse = S3APIUploadPartResponse

@typing.final
class S3APIListPartsResponse(google.protobuf.message.Message):
    """Represents a response of list parts request to S3."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    BUCKET_FIELD_NUMBER: builtins.int
    KEY_FIELD_NUMBER: builtins.int
    UPLOAD_ID_FIELD_NUMBER: builtins.int
    PART_NUMBER_MARKER_FIELD_NUMBER: builtins.int
    NEXT_PART_NUMBER_MARKER_FIELD_NUMBER: builtins.int
    MAX_PARTS_FIELD_NUMBER: builtins.int
    IS_TRUNCATED_FIELD_NUMBER: builtins.int
    PARTS_FIELD_NUMBER: builtins.int
    INITIATOR_FIELD_NUMBER: builtins.int
    OWNER_FIELD_NUMBER: builtins.int
    STORAGE_CLASS_FIELD_NUMBER: builtins.int
    REQUEST_ID_FIELD_NUMBER: builtins.int
    bucket: builtins.str
    """The name of the bucket to which the multipart upload was initiated."""
    key: builtins.str
    """Object key for which the multipart upload was initiated."""
    upload_id: builtins.str
    """Upload ID identifying the multipart upload whose parts are being listed."""
    part_number_marker: builtins.str
    """When a list is truncated, this element specifies the last part in the list, as
    well as the value to use for the part-number-marker request parameter in a
    subsequent request.
    """
    next_part_number_marker: builtins.str
    """When a list is truncated, this element specifies the last part in the list, as
    well as the value to use for the part-number-marker request parameter in a
    subsequent request.
    """
    max_parts: builtins.int
    """Maximum number of parts that were allowed in the response."""
    is_truncated: builtins.bool
    """Indicates whether the returned list of parts is truncated."""
    storage_class: builtins.str
    """Class of storage used to store the uploaded object."""
    request_id: builtins.str
    """Unique request ID."""
    @property
    def parts(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___S3APIPart]:
        """Container for elements related to a particular part."""

    @property
    def initiator(self) -> global___S3APIOwner:
        """Container element that identifies who initiated the multipart upload."""

    @property
    def owner(self) -> global___S3APIOwner:
        """Container element that identifies who initiated the multipart upload."""

    def __init__(
        self,
        *,
        bucket: builtins.str = ...,
        key: builtins.str = ...,
        upload_id: builtins.str = ...,
        part_number_marker: builtins.str = ...,
        next_part_number_marker: builtins.str = ...,
        max_parts: builtins.int = ...,
        is_truncated: builtins.bool = ...,
        parts: collections.abc.Iterable[global___S3APIPart] | None = ...,
        initiator: global___S3APIOwner | None = ...,
        owner: global___S3APIOwner | None = ...,
        storage_class: builtins.str = ...,
        request_id: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["initiator", b"initiator", "owner", b"owner"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["bucket", b"bucket", "initiator", b"initiator", "is_truncated", b"is_truncated", "key", b"key", "max_parts", b"max_parts", "next_part_number_marker", b"next_part_number_marker", "owner", b"owner", "part_number_marker", b"part_number_marker", "parts", b"parts", "request_id", b"request_id", "storage_class", b"storage_class", "upload_id", b"upload_id"]) -> None: ...

global___S3APIListPartsResponse = S3APIListPartsResponse

@typing.final
class S3APIPart(google.protobuf.message.Message):
    """Container for elements related to a part."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PART_NUMBER_FIELD_NUMBER: builtins.int
    LAST_MODIFIED_AT_FIELD_NUMBER: builtins.int
    SIZE_FIELD_NUMBER: builtins.int
    ETAG_FIELD_NUMBER: builtins.int
    part_number: builtins.int
    """Part number identifying the part. This is a positive integer between 1 and
    10,000.
    """
    size: builtins.int
    """Size in bytes of the uploaded part data."""
    etag: builtins.str
    """Entity tag returned when the part was uploaded."""
    @property
    def last_modified_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Date and time at which the part was uploaded."""

    def __init__(
        self,
        *,
        part_number: builtins.int = ...,
        last_modified_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        size: builtins.int = ...,
        etag: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["last_modified_at", b"last_modified_at"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["etag", b"etag", "last_modified_at", b"last_modified_at", "part_number", b"part_number", "size", b"size"]) -> None: ...

global___S3APIPart = S3APIPart

@typing.final
class S3APIAbortMultipartUploadResponse(google.protobuf.message.Message):
    """Represents a response of abort multipart upload request to S3."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    REQUEST_ID_FIELD_NUMBER: builtins.int
    request_id: builtins.str
    """Unique request ID."""
    def __init__(
        self,
        *,
        request_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["request_id", b"request_id"]) -> None: ...

global___S3APIAbortMultipartUploadResponse = S3APIAbortMultipartUploadResponse

@typing.final
class S3APICompleteMultipartUploadResponse(google.protobuf.message.Message):
    """Represents a response of complete multipart upload request to S3."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    REQUEST_ID_FIELD_NUMBER: builtins.int
    BUCKET_FIELD_NUMBER: builtins.int
    KEY_FIELD_NUMBER: builtins.int
    ETAG_FIELD_NUMBER: builtins.int
    LOCATION_FIELD_NUMBER: builtins.int
    VERSION_ID_FIELD_NUMBER: builtins.int
    request_id: builtins.str
    """Unique request ID."""
    bucket: builtins.str
    """The name of the bucket that contains the newly created object."""
    key: builtins.str
    """The object key of the newly created object."""
    etag: builtins.str
    """Entity tag that identifies the newly created object's data."""
    location: builtins.str
    """The URI that identifies the newly created object."""
    version_id: builtins.str
    """Version ID of the newly created object, in case the bucket has versioning
    turned on.
    """
    def __init__(
        self,
        *,
        request_id: builtins.str = ...,
        bucket: builtins.str = ...,
        key: builtins.str = ...,
        etag: builtins.str = ...,
        location: builtins.str = ...,
        version_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["bucket", b"bucket", "etag", b"etag", "key", b"key", "location", b"location", "request_id", b"request_id", "version_id", b"version_id"]) -> None: ...

global___S3APICompleteMultipartUploadResponse = S3APICompleteMultipartUploadResponse

@typing.final
class S3APIListMultipartUploadsResponse(google.protobuf.message.Message):
    """Represents a response of list multipart uploads request to S3."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    BUCKET_FIELD_NUMBER: builtins.int
    KEY_MARKER_FIELD_NUMBER: builtins.int
    UPLOAD_ID_MARKER_FIELD_NUMBER: builtins.int
    NEXT_KEY_MARKER_FIELD_NUMBER: builtins.int
    NEXT_UPLOAD_ID_MARKER_FIELD_NUMBER: builtins.int
    DELIMITER_FIELD_NUMBER: builtins.int
    PREFIX_FIELD_NUMBER: builtins.int
    MAX_UPLOADS_FIELD_NUMBER: builtins.int
    IS_TRUNCATED_FIELD_NUMBER: builtins.int
    UPLOADS_FIELD_NUMBER: builtins.int
    COMMON_PREFIXES_FIELD_NUMBER: builtins.int
    REQUEST_ID_FIELD_NUMBER: builtins.int
    bucket: builtins.str
    """The name of the bucket to which the multipart upload was initiated."""
    key_marker: builtins.str
    """The key at or after which the listing began."""
    upload_id_marker: builtins.str
    """Upload ID after which listing began."""
    next_key_marker: builtins.str
    """When a list is truncated, this element specifies the value that should be used
    for the key-marker request parameter in a subsequent request.
    """
    next_upload_id_marker: builtins.str
    """When a list is truncated, this element specifies the value that should be used
    for the upload-id-marker request parameter in a subsequent request.
    """
    delimiter: builtins.str
    """Contains the delimiter you specified in the request."""
    prefix: builtins.str
    """When a prefix is provided in the request, this field contains the specified
    prefix.
    """
    max_uploads: builtins.int
    """Maximum number of multipart uploads that could have been included in the
    response.
    """
    is_truncated: builtins.bool
    """Indicates whether the returned list of multipart uploads is truncated."""
    request_id: builtins.str
    """Unique request ID."""
    @property
    def uploads(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___S3APIMultipartUpload]:
        """Container for elements related to a particular multipart upload."""

    @property
    def common_prefixes(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """If you specify a delimiter in the request, then the result returns each
        distinct key prefix containing the delimiter in a CommonPrefixes element.
        """

    def __init__(
        self,
        *,
        bucket: builtins.str = ...,
        key_marker: builtins.str = ...,
        upload_id_marker: builtins.str = ...,
        next_key_marker: builtins.str = ...,
        next_upload_id_marker: builtins.str = ...,
        delimiter: builtins.str = ...,
        prefix: builtins.str = ...,
        max_uploads: builtins.int = ...,
        is_truncated: builtins.bool = ...,
        uploads: collections.abc.Iterable[global___S3APIMultipartUpload] | None = ...,
        common_prefixes: collections.abc.Iterable[builtins.str] | None = ...,
        request_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["bucket", b"bucket", "common_prefixes", b"common_prefixes", "delimiter", b"delimiter", "is_truncated", b"is_truncated", "key_marker", b"key_marker", "max_uploads", b"max_uploads", "next_key_marker", b"next_key_marker", "next_upload_id_marker", b"next_upload_id_marker", "prefix", b"prefix", "request_id", b"request_id", "upload_id_marker", b"upload_id_marker", "uploads", b"uploads"]) -> None: ...

global___S3APIListMultipartUploadsResponse = S3APIListMultipartUploadsResponse

@typing.final
class S3APIMultipartUpload(google.protobuf.message.Message):
    """Container for the MultipartUpload for the S3 object."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    KEY_FIELD_NUMBER: builtins.int
    UPLOAD_ID_FIELD_NUMBER: builtins.int
    INITIATOR_FIELD_NUMBER: builtins.int
    OWNER_FIELD_NUMBER: builtins.int
    STORAGE_CLASS_FIELD_NUMBER: builtins.int
    INITIATED_AT_FIELD_NUMBER: builtins.int
    key: builtins.str
    """Key of the object for which the multipart upload was initiated."""
    upload_id: builtins.str
    """Upload ID that identifies the multipart upload."""
    storage_class: builtins.str
    """The class of storage used to store the object."""
    @property
    def initiator(self) -> global___S3APIOwner:
        """Identifies who initiated the multipart upload."""

    @property
    def owner(self) -> global___S3APIOwner:
        """Specifies the owner of the object that is part of the multipart upload."""

    @property
    def initiated_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Date and time at which the multipart upload was initiated."""

    def __init__(
        self,
        *,
        key: builtins.str = ...,
        upload_id: builtins.str = ...,
        initiator: global___S3APIOwner | None = ...,
        owner: global___S3APIOwner | None = ...,
        storage_class: builtins.str = ...,
        initiated_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["initiated_at", b"initiated_at", "initiator", b"initiator", "owner", b"owner"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["initiated_at", b"initiated_at", "initiator", b"initiator", "key", b"key", "owner", b"owner", "storage_class", b"storage_class", "upload_id", b"upload_id"]) -> None: ...

global___S3APIMultipartUpload = S3APIMultipartUpload

@typing.final
class S3APIOwner(google.protobuf.message.Message):
    """Container for the owner/initiator display name and ID."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    DISPLAY_NAME_FIELD_NUMBER: builtins.int
    id: builtins.str
    """Container for the ID of the owner/initiator."""
    display_name: builtins.str
    """Container for the display name of the owner/initiator."""
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        display_name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["display_name", b"display_name", "id", b"id"]) -> None: ...

global___S3APIOwner = S3APIOwner

@typing.final
class S3APIUploadPartCopyResponse(google.protobuf.message.Message):
    """Response message for UploadPartCopy operation"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ETAG_FIELD_NUMBER: builtins.int
    LAST_MODIFIED_AT_FIELD_NUMBER: builtins.int
    REQUEST_ID_FIELD_NUMBER: builtins.int
    etag: builtins.str
    """Entity tag of the object."""
    request_id: builtins.str
    """Unique request ID."""
    @property
    def last_modified_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Date and time at which the object was uploaded."""

    def __init__(
        self,
        *,
        etag: builtins.str = ...,
        last_modified_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        request_id: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["last_modified_at", b"last_modified_at"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["etag", b"etag", "last_modified_at", b"last_modified_at", "request_id", b"request_id"]) -> None: ...

global___S3APIUploadPartCopyResponse = S3APIUploadPartCopyResponse

@typing.final
class S3APIListObjectsV2Response(google.protobuf.message.Message):
    """Represents a response of list objects v2 request to S3."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    IS_TRUNCATED_FIELD_NUMBER: builtins.int
    CONTENTS_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    PREFIX_FIELD_NUMBER: builtins.int
    DELIMITER_FIELD_NUMBER: builtins.int
    MAX_KEYS_FIELD_NUMBER: builtins.int
    COMMON_PREFIXES_FIELD_NUMBER: builtins.int
    KEY_COUNT_FIELD_NUMBER: builtins.int
    CONTINUATION_TOKEN_FIELD_NUMBER: builtins.int
    NEXT_CONTINUATION_TOKEN_FIELD_NUMBER: builtins.int
    START_AFTER_FIELD_NUMBER: builtins.int
    REQUEST_ID_FIELD_NUMBER: builtins.int
    is_truncated: builtins.bool
    """A flag that indicates whether S3 returned all of the results that satisfied the search criteria."""
    name: builtins.str
    """The bucket name."""
    prefix: builtins.str
    """Keys that begin with the indicated prefix."""
    delimiter: builtins.str
    """Causes keys that contain the same string between the prefix and the first occurrence of the delimiter to be rolled up into a single result element in the CommonPrefixes collection."""
    max_keys: builtins.int
    """The maximum number of keys returned in the response body."""
    key_count: builtins.int
    """The number of keys returned with this request."""
    continuation_token: builtins.str
    """Indicates where in the bucket listing begins. This is only returned if a continuation token was used in the request."""
    next_continuation_token: builtins.str
    """If the response is truncated, S3 returns this continuation token, which you can use in the next request to fetch the next set of keys."""
    start_after: builtins.str
    """StartAfter is where you want S3 to start listing from. This is only returned if a start-after was used in the request."""
    request_id: builtins.str
    """Unique request ID."""
    @property
    def contents(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___S3APIObject]:
        """Metadata about each object returned."""

    @property
    def common_prefixes(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___S3APICommonPrefix]:
        """All of the keys rolled up into a common prefix count as a single return when calculating the number of returns."""

    def __init__(
        self,
        *,
        is_truncated: builtins.bool = ...,
        contents: collections.abc.Iterable[global___S3APIObject] | None = ...,
        name: builtins.str = ...,
        prefix: builtins.str = ...,
        delimiter: builtins.str = ...,
        max_keys: builtins.int = ...,
        common_prefixes: collections.abc.Iterable[global___S3APICommonPrefix] | None = ...,
        key_count: builtins.int = ...,
        continuation_token: builtins.str = ...,
        next_continuation_token: builtins.str = ...,
        start_after: builtins.str = ...,
        request_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["common_prefixes", b"common_prefixes", "contents", b"contents", "continuation_token", b"continuation_token", "delimiter", b"delimiter", "is_truncated", b"is_truncated", "key_count", b"key_count", "max_keys", b"max_keys", "name", b"name", "next_continuation_token", b"next_continuation_token", "prefix", b"prefix", "request_id", b"request_id", "start_after", b"start_after"]) -> None: ...

global___S3APIListObjectsV2Response = S3APIListObjectsV2Response

@typing.final
class S3APIObject(google.protobuf.message.Message):
    """Container for object metadata."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    KEY_FIELD_NUMBER: builtins.int
    LAST_MODIFIED_FIELD_NUMBER: builtins.int
    ETAG_FIELD_NUMBER: builtins.int
    SIZE_FIELD_NUMBER: builtins.int
    OWNER_FIELD_NUMBER: builtins.int
    STORAGE_CLASS_FIELD_NUMBER: builtins.int
    key: builtins.str
    """The object key."""
    etag: builtins.str
    """The entity tag is a hash of the object."""
    size: builtins.int
    """Size in bytes of the object."""
    storage_class: builtins.str
    """The class of storage used to store the object."""
    @property
    def last_modified(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Date and time the object was last modified."""

    @property
    def owner(self) -> global___S3APIOwner:
        """The owner of the object."""

    def __init__(
        self,
        *,
        key: builtins.str = ...,
        last_modified: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        etag: builtins.str = ...,
        size: builtins.int = ...,
        owner: global___S3APIOwner | None = ...,
        storage_class: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["last_modified", b"last_modified", "owner", b"owner"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["etag", b"etag", "key", b"key", "last_modified", b"last_modified", "owner", b"owner", "size", b"size", "storage_class", b"storage_class"]) -> None: ...

global___S3APIObject = S3APIObject

@typing.final
class S3APICommonPrefix(google.protobuf.message.Message):
    """Container for common prefix information."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PREFIX_FIELD_NUMBER: builtins.int
    prefix: builtins.str
    """Container for the specified common prefix."""
    def __init__(
        self,
        *,
        prefix: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["prefix", b"prefix"]) -> None: ...

global___S3APICommonPrefix = S3APICommonPrefix

@typing.final
class S3APIGetAclResponse(google.protobuf.message.Message):
    """Represents a response of the get bucket acl or get object acl requests to S3."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class Owner(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        ID_FIELD_NUMBER: builtins.int
        DISPLAY_NAME_FIELD_NUMBER: builtins.int
        id: builtins.str
        display_name: builtins.str
        def __init__(
            self,
            *,
            id: builtins.str = ...,
            display_name: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["display_name", b"display_name", "id", b"id"]) -> None: ...

    @typing.final
    class Grant(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        @typing.final
        class Grantee(google.protobuf.message.Message):
            DESCRIPTOR: google.protobuf.descriptor.Descriptor

            ID_FIELD_NUMBER: builtins.int
            TYPE_FIELD_NUMBER: builtins.int
            URI_FIELD_NUMBER: builtins.int
            DISPLAY_NAME_FIELD_NUMBER: builtins.int
            EMAIL_ADDRESS_FIELD_NUMBER: builtins.int
            id: builtins.str
            type: builtins.str
            uri: builtins.str
            display_name: builtins.str
            email_address: builtins.str
            def __init__(
                self,
                *,
                id: builtins.str = ...,
                type: builtins.str = ...,
                uri: builtins.str = ...,
                display_name: builtins.str = ...,
                email_address: builtins.str = ...,
            ) -> None: ...
            def ClearField(self, field_name: typing.Literal["display_name", b"display_name", "email_address", b"email_address", "id", b"id", "type", b"type", "uri", b"uri"]) -> None: ...

        GRANTEE_FIELD_NUMBER: builtins.int
        PERMISSION_FIELD_NUMBER: builtins.int
        permission: builtins.str
        @property
        def grantee(self) -> global___S3APIGetAclResponse.Grant.Grantee: ...
        def __init__(
            self,
            *,
            grantee: global___S3APIGetAclResponse.Grant.Grantee | None = ...,
            permission: builtins.str = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["grantee", b"grantee"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["grantee", b"grantee", "permission", b"permission"]) -> None: ...

    REQUEST_ID_FIELD_NUMBER: builtins.int
    OWNER_FIELD_NUMBER: builtins.int
    GRANTS_FIELD_NUMBER: builtins.int
    request_id: builtins.str
    @property
    def owner(self) -> global___S3APIGetAclResponse.Owner: ...
    @property
    def grants(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___S3APIGetAclResponse.Grant]: ...
    def __init__(
        self,
        *,
        request_id: builtins.str = ...,
        owner: global___S3APIGetAclResponse.Owner | None = ...,
        grants: collections.abc.Iterable[global___S3APIGetAclResponse.Grant] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["owner", b"owner"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["grants", b"grants", "owner", b"owner", "request_id", b"request_id"]) -> None: ...

global___S3APIGetAclResponse = S3APIGetAclResponse

@typing.final
class S3APIPutAclResponse(google.protobuf.message.Message):
    """Represents a response of the put bucket acl or put object acl requests to S3."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    REQUEST_ID_FIELD_NUMBER: builtins.int
    request_id: builtins.str
    """Unique request ID."""
    def __init__(
        self,
        *,
        request_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["request_id", b"request_id"]) -> None: ...

global___S3APIPutAclResponse = S3APIPutAclResponse
