"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class AccessControlConfig(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CATALOGS_FIELD_NUMBER: builtins.int
    SCHEMAS_FIELD_NUMBER: builtins.int
    TABLES_FIELD_NUMBER: builtins.int
    FUNCTIONS_FIELD_NUMBER: builtins.int
    PROCEDURES_FIELD_NUMBER: builtins.int
    QUERIES_FIELD_NUMBER: builtins.int
    SYSTEM_SESSION_PROPERTIES_FIELD_NUMBER: builtins.int
    CATALOG_SESSION_PROPERTIES_FIELD_NUMBER: builtins.int
    @property
    def catalogs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___CatalogAccessRule]:
        """Catalog access control rules."""

    @property
    def schemas(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___SchemaAccessRule]:
        """Schema access control rules."""

    @property
    def tables(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___TableAccessRule]:
        """Table access control rules."""

    @property
    def functions(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___FunctionAccessRule]:
        """Function access control rules."""

    @property
    def procedures(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ProcedureAccessRule]:
        """Procedures access control rules."""

    @property
    def queries(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___QueryAccessRule]:
        """Queries access control rules."""

    @property
    def system_session_properties(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___SystemSessionPropertyAccessRule]:
        """System session property access control rules."""

    @property
    def catalog_session_properties(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___CatalogSessionPropertyAccessRule]:
        """Catalog session property access control rules."""

    def __init__(
        self,
        *,
        catalogs: collections.abc.Iterable[global___CatalogAccessRule] | None = ...,
        schemas: collections.abc.Iterable[global___SchemaAccessRule] | None = ...,
        tables: collections.abc.Iterable[global___TableAccessRule] | None = ...,
        functions: collections.abc.Iterable[global___FunctionAccessRule] | None = ...,
        procedures: collections.abc.Iterable[global___ProcedureAccessRule] | None = ...,
        queries: collections.abc.Iterable[global___QueryAccessRule] | None = ...,
        system_session_properties: collections.abc.Iterable[global___SystemSessionPropertyAccessRule] | None = ...,
        catalog_session_properties: collections.abc.Iterable[global___CatalogSessionPropertyAccessRule] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["catalog_session_properties", b"catalog_session_properties", "catalogs", b"catalogs", "functions", b"functions", "procedures", b"procedures", "queries", b"queries", "schemas", b"schemas", "system_session_properties", b"system_session_properties", "tables", b"tables"]) -> None: ...

global___AccessControlConfig = AccessControlConfig

@typing.final
class CatalogAccessRuleMatcher(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class CatalogIds(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        ANY_FIELD_NUMBER: builtins.int
        @property
        def any(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]: ...
        def __init__(
            self,
            *,
            any: collections.abc.Iterable[builtins.str] | None = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["any", b"any"]) -> None: ...

    @typing.final
    class CatalogNames(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        ANY_FIELD_NUMBER: builtins.int
        @property
        def any(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]: ...
        def __init__(
            self,
            *,
            any: collections.abc.Iterable[builtins.str] | None = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["any", b"any"]) -> None: ...

    NAME_REGEXP_FIELD_NUMBER: builtins.int
    IDS_FIELD_NUMBER: builtins.int
    NAMES_FIELD_NUMBER: builtins.int
    name_regexp: builtins.str
    """Catalog name regexp the rule is applied to."""
    @property
    def ids(self) -> global___CatalogAccessRuleMatcher.CatalogIds:
        """Catalog IDs rule is applied to."""

    @property
    def names(self) -> global___CatalogAccessRuleMatcher.CatalogNames:
        """Catalog names rule is applied to."""

    def __init__(
        self,
        *,
        name_regexp: builtins.str = ...,
        ids: global___CatalogAccessRuleMatcher.CatalogIds | None = ...,
        names: global___CatalogAccessRuleMatcher.CatalogNames | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["ids", b"ids", "match_by", b"match_by", "name_regexp", b"name_regexp", "names", b"names"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["ids", b"ids", "match_by", b"match_by", "name_regexp", b"name_regexp", "names", b"names"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["match_by", b"match_by"]) -> typing.Literal["name_regexp", "ids", "names"] | None: ...

global___CatalogAccessRuleMatcher = CatalogAccessRuleMatcher

@typing.final
class SchemaAccessRuleMatcher(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class SchemaNames(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        ANY_FIELD_NUMBER: builtins.int
        @property
        def any(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]: ...
        def __init__(
            self,
            *,
            any: collections.abc.Iterable[builtins.str] | None = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["any", b"any"]) -> None: ...

    NAME_REGEXP_FIELD_NUMBER: builtins.int
    NAMES_FIELD_NUMBER: builtins.int
    name_regexp: builtins.str
    """Schema name regexp the rule is applied to."""
    @property
    def names(self) -> global___SchemaAccessRuleMatcher.SchemaNames:
        """Schema names the rule is applied to."""

    def __init__(
        self,
        *,
        name_regexp: builtins.str = ...,
        names: global___SchemaAccessRuleMatcher.SchemaNames | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["match_by", b"match_by", "name_regexp", b"name_regexp", "names", b"names"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["match_by", b"match_by", "name_regexp", b"name_regexp", "names", b"names"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["match_by", b"match_by"]) -> typing.Literal["name_regexp", "names"] | None: ...

global___SchemaAccessRuleMatcher = SchemaAccessRuleMatcher

@typing.final
class TableAccessRuleMatcher(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class TableNames(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        ANY_FIELD_NUMBER: builtins.int
        @property
        def any(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]: ...
        def __init__(
            self,
            *,
            any: collections.abc.Iterable[builtins.str] | None = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["any", b"any"]) -> None: ...

    NAME_REGEXP_FIELD_NUMBER: builtins.int
    NAMES_FIELD_NUMBER: builtins.int
    name_regexp: builtins.str
    """Table name regexp the rule is applied to."""
    @property
    def names(self) -> global___TableAccessRuleMatcher.TableNames:
        """Table names the rule is applied to."""

    def __init__(
        self,
        *,
        name_regexp: builtins.str = ...,
        names: global___TableAccessRuleMatcher.TableNames | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["match_by", b"match_by", "name_regexp", b"name_regexp", "names", b"names"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["match_by", b"match_by", "name_regexp", b"name_regexp", "names", b"names"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["match_by", b"match_by"]) -> typing.Literal["name_regexp", "names"] | None: ...

global___TableAccessRuleMatcher = TableAccessRuleMatcher

@typing.final
class FunctionAccessRuleMatcher(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class FunctionNames(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        ANY_FIELD_NUMBER: builtins.int
        @property
        def any(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]: ...
        def __init__(
            self,
            *,
            any: collections.abc.Iterable[builtins.str] | None = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["any", b"any"]) -> None: ...

    NAME_REGEXP_FIELD_NUMBER: builtins.int
    NAMES_FIELD_NUMBER: builtins.int
    name_regexp: builtins.str
    """Function name regexp the rule is applied to."""
    @property
    def names(self) -> global___FunctionAccessRuleMatcher.FunctionNames:
        """Function names the rule is applied to."""

    def __init__(
        self,
        *,
        name_regexp: builtins.str = ...,
        names: global___FunctionAccessRuleMatcher.FunctionNames | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["match_by", b"match_by", "name_regexp", b"name_regexp", "names", b"names"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["match_by", b"match_by", "name_regexp", b"name_regexp", "names", b"names"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["match_by", b"match_by"]) -> typing.Literal["name_regexp", "names"] | None: ...

global___FunctionAccessRuleMatcher = FunctionAccessRuleMatcher

@typing.final
class ProcedureAccessRuleMatcher(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class ProcedureNames(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        ANY_FIELD_NUMBER: builtins.int
        @property
        def any(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]: ...
        def __init__(
            self,
            *,
            any: collections.abc.Iterable[builtins.str] | None = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["any", b"any"]) -> None: ...

    NAME_REGEXP_FIELD_NUMBER: builtins.int
    NAMES_FIELD_NUMBER: builtins.int
    name_regexp: builtins.str
    """Procedure name regexp the rule is applied to."""
    @property
    def names(self) -> global___ProcedureAccessRuleMatcher.ProcedureNames:
        """Procedure names the rule is applied to."""

    def __init__(
        self,
        *,
        name_regexp: builtins.str = ...,
        names: global___ProcedureAccessRuleMatcher.ProcedureNames | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["match_by", b"match_by", "name_regexp", b"name_regexp", "names", b"names"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["match_by", b"match_by", "name_regexp", b"name_regexp", "names", b"names"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["match_by", b"match_by"]) -> typing.Literal["name_regexp", "names"] | None: ...

global___ProcedureAccessRuleMatcher = ProcedureAccessRuleMatcher

@typing.final
class PropertyAccessRuleMatcher(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class PropertyNames(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        ANY_FIELD_NUMBER: builtins.int
        @property
        def any(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]: ...
        def __init__(
            self,
            *,
            any: collections.abc.Iterable[builtins.str] | None = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["any", b"any"]) -> None: ...

    NAME_REGEXP_FIELD_NUMBER: builtins.int
    NAMES_FIELD_NUMBER: builtins.int
    name_regexp: builtins.str
    """Property name regexp the rule is applied to."""
    @property
    def names(self) -> global___PropertyAccessRuleMatcher.PropertyNames:
        """Property names the rule is applied to."""

    def __init__(
        self,
        *,
        name_regexp: builtins.str = ...,
        names: global___PropertyAccessRuleMatcher.PropertyNames | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["match_by", b"match_by", "name_regexp", b"name_regexp", "names", b"names"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["match_by", b"match_by", "name_regexp", b"name_regexp", "names", b"names"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["match_by", b"match_by"]) -> typing.Literal["name_regexp", "names"] | None: ...

global___PropertyAccessRuleMatcher = PropertyAccessRuleMatcher

@typing.final
class CatalogAccessRule(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Permission:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _PermissionEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[CatalogAccessRule._Permission.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        PERMISSION_UNSPECIFIED: CatalogAccessRule._Permission.ValueType  # 0
        NONE: CatalogAccessRule._Permission.ValueType  # 1
        """Denies all operations on the catalog entities."""
        ALL: CatalogAccessRule._Permission.ValueType  # 2
        """Allows all operations on catalog entities."""
        READ_ONLY: CatalogAccessRule._Permission.ValueType  # 3
        """Allows only read operations on catalog entities."""

    class Permission(_Permission, metaclass=_PermissionEnumTypeWrapper): ...
    PERMISSION_UNSPECIFIED: CatalogAccessRule.Permission.ValueType  # 0
    NONE: CatalogAccessRule.Permission.ValueType  # 1
    """Denies all operations on the catalog entities."""
    ALL: CatalogAccessRule.Permission.ValueType  # 2
    """Allows all operations on catalog entities."""
    READ_ONLY: CatalogAccessRule.Permission.ValueType  # 3
    """Allows only read operations on catalog entities."""

    USERS_FIELD_NUMBER: builtins.int
    GROUPS_FIELD_NUMBER: builtins.int
    CATALOG_FIELD_NUMBER: builtins.int
    PERMISSION_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    permission: global___CatalogAccessRule.Permission.ValueType
    """Permission granted by the rule."""
    description: builtins.str
    """Rule description."""
    @property
    def users(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """IAM user IDs the rule is applied to."""

    @property
    def groups(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """IAM group IDs the rule is applied to."""

    @property
    def catalog(self) -> global___CatalogAccessRuleMatcher:
        """Catalog matcher specifying what catalogs the rule is applied to."""

    def __init__(
        self,
        *,
        users: collections.abc.Iterable[builtins.str] | None = ...,
        groups: collections.abc.Iterable[builtins.str] | None = ...,
        catalog: global___CatalogAccessRuleMatcher | None = ...,
        permission: global___CatalogAccessRule.Permission.ValueType = ...,
        description: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["catalog", b"catalog"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["catalog", b"catalog", "description", b"description", "groups", b"groups", "permission", b"permission", "users", b"users"]) -> None: ...

global___CatalogAccessRule = CatalogAccessRule

@typing.final
class SchemaAccessRule(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Owner:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _OwnerEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[SchemaAccessRule._Owner.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        OWNER_UNSPECIFIED: SchemaAccessRule._Owner.ValueType  # 0
        NO: SchemaAccessRule._Owner.ValueType  # 1
        """User is not considered an owner of the schema."""
        YES: SchemaAccessRule._Owner.ValueType  # 2
        """User is considered an owner of the schema."""

    class Owner(_Owner, metaclass=_OwnerEnumTypeWrapper): ...
    OWNER_UNSPECIFIED: SchemaAccessRule.Owner.ValueType  # 0
    NO: SchemaAccessRule.Owner.ValueType  # 1
    """User is not considered an owner of the schema."""
    YES: SchemaAccessRule.Owner.ValueType  # 2
    """User is considered an owner of the schema."""

    USERS_FIELD_NUMBER: builtins.int
    GROUPS_FIELD_NUMBER: builtins.int
    CATALOG_FIELD_NUMBER: builtins.int
    SCHEMA_FIELD_NUMBER: builtins.int
    OWNER_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    owner: global___SchemaAccessRule.Owner.ValueType
    """Ownership granted by the rule."""
    description: builtins.str
    """Rule description."""
    @property
    def users(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """IAM user IDs the rule is applied to."""

    @property
    def groups(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """IAM group IDs the rule is applied to."""

    @property
    def catalog(self) -> global___CatalogAccessRuleMatcher:
        """Catalog matcher specifying what catalogs the rule is applied to."""

    @property
    def schema(self) -> global___SchemaAccessRuleMatcher:
        """Schema matcher specifying what schemas the rule is applied to."""

    def __init__(
        self,
        *,
        users: collections.abc.Iterable[builtins.str] | None = ...,
        groups: collections.abc.Iterable[builtins.str] | None = ...,
        catalog: global___CatalogAccessRuleMatcher | None = ...,
        schema: global___SchemaAccessRuleMatcher | None = ...,
        owner: global___SchemaAccessRule.Owner.ValueType = ...,
        description: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["catalog", b"catalog", "schema", b"schema"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["catalog", b"catalog", "description", b"description", "groups", b"groups", "owner", b"owner", "schema", b"schema", "users", b"users"]) -> None: ...

global___SchemaAccessRule = SchemaAccessRule

@typing.final
class TableAccessRule(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Privilege:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _PrivilegeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[TableAccessRule._Privilege.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        PRIVILEGE_UNSPECIFIED: TableAccessRule._Privilege.ValueType  # 0
        SELECT: TableAccessRule._Privilege.ValueType  # 1
        """Allows SELECT statements on the table."""
        INSERT: TableAccessRule._Privilege.ValueType  # 2
        """Allows INSERT statements on the table."""
        DELETE: TableAccessRule._Privilege.ValueType  # 3
        """Allows DELETE statements on the table."""
        UPDATE: TableAccessRule._Privilege.ValueType  # 4
        """Allows UPDATE statements on the table."""
        OWNERSHIP: TableAccessRule._Privilege.ValueType  # 5
        """Allows CREATE, DROP, COMMENT ON and ALTER statements on the table."""
        GRANT_SELECT: TableAccessRule._Privilege.ValueType  # 6
        """Allows SELECT statements on the table while creating view."""

    class Privilege(_Privilege, metaclass=_PrivilegeEnumTypeWrapper): ...
    PRIVILEGE_UNSPECIFIED: TableAccessRule.Privilege.ValueType  # 0
    SELECT: TableAccessRule.Privilege.ValueType  # 1
    """Allows SELECT statements on the table."""
    INSERT: TableAccessRule.Privilege.ValueType  # 2
    """Allows INSERT statements on the table."""
    DELETE: TableAccessRule.Privilege.ValueType  # 3
    """Allows DELETE statements on the table."""
    UPDATE: TableAccessRule.Privilege.ValueType  # 4
    """Allows UPDATE statements on the table."""
    OWNERSHIP: TableAccessRule.Privilege.ValueType  # 5
    """Allows CREATE, DROP, COMMENT ON and ALTER statements on the table."""
    GRANT_SELECT: TableAccessRule.Privilege.ValueType  # 6
    """Allows SELECT statements on the table while creating view."""

    @typing.final
    class Column(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        class _AccessMode:
            ValueType = typing.NewType("ValueType", builtins.int)
            V: typing_extensions.TypeAlias = ValueType

        class _AccessModeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[TableAccessRule.Column._AccessMode.ValueType], builtins.type):
            DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
            ACCESS_MODE_UNSPECIFIED: TableAccessRule.Column._AccessMode.ValueType  # 0
            NONE: TableAccessRule.Column._AccessMode.ValueType  # 1
            """Access to column is denied."""
            ALL: TableAccessRule.Column._AccessMode.ValueType  # 2
            """Access to column is allowed."""

        class AccessMode(_AccessMode, metaclass=_AccessModeEnumTypeWrapper): ...
        ACCESS_MODE_UNSPECIFIED: TableAccessRule.Column.AccessMode.ValueType  # 0
        NONE: TableAccessRule.Column.AccessMode.ValueType  # 1
        """Access to column is denied."""
        ALL: TableAccessRule.Column.AccessMode.ValueType  # 2
        """Access to column is allowed."""

        NAME_FIELD_NUMBER: builtins.int
        ACCESS_FIELD_NUMBER: builtins.int
        MASK_FIELD_NUMBER: builtins.int
        name: builtins.str
        """Column name."""
        access: global___TableAccessRule.Column.AccessMode.ValueType
        """Column access mode."""
        mask: builtins.str
        """SQL expression mask to evaluate instead of original column values.
        Mask should have the same type as original column.
        """
        def __init__(
            self,
            *,
            name: builtins.str = ...,
            access: global___TableAccessRule.Column.AccessMode.ValueType = ...,
            mask: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["access", b"access", "mask", b"mask", "name", b"name"]) -> None: ...

    USERS_FIELD_NUMBER: builtins.int
    GROUPS_FIELD_NUMBER: builtins.int
    CATALOG_FIELD_NUMBER: builtins.int
    SCHEMA_FIELD_NUMBER: builtins.int
    TABLE_FIELD_NUMBER: builtins.int
    PRIVILEGES_FIELD_NUMBER: builtins.int
    COLUMNS_FIELD_NUMBER: builtins.int
    FILTER_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    filter: builtins.str
    """Boolean SQL expression to filter table rows for particular user."""
    description: builtins.str
    """Rule description."""
    @property
    def users(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """IAM user IDs the rule is applied to."""

    @property
    def groups(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """IAM group IDs the rule is applied to."""

    @property
    def catalog(self) -> global___CatalogAccessRuleMatcher:
        """Catalog matcher specifying what catalogs the rule is applied to."""

    @property
    def schema(self) -> global___SchemaAccessRuleMatcher:
        """Schema matcher specifying what schemas the rule is applied to."""

    @property
    def table(self) -> global___TableAccessRuleMatcher:
        """Table matcher specifying what tables the rule is applied to."""

    @property
    def privileges(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[global___TableAccessRule.Privilege.ValueType]:
        """Permission granted by the rule."""

    @property
    def columns(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___TableAccessRule.Column]:
        """Column rules."""

    def __init__(
        self,
        *,
        users: collections.abc.Iterable[builtins.str] | None = ...,
        groups: collections.abc.Iterable[builtins.str] | None = ...,
        catalog: global___CatalogAccessRuleMatcher | None = ...,
        schema: global___SchemaAccessRuleMatcher | None = ...,
        table: global___TableAccessRuleMatcher | None = ...,
        privileges: collections.abc.Iterable[global___TableAccessRule.Privilege.ValueType] | None = ...,
        columns: collections.abc.Iterable[global___TableAccessRule.Column] | None = ...,
        filter: builtins.str = ...,
        description: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["catalog", b"catalog", "schema", b"schema", "table", b"table"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["catalog", b"catalog", "columns", b"columns", "description", b"description", "filter", b"filter", "groups", b"groups", "privileges", b"privileges", "schema", b"schema", "table", b"table", "users", b"users"]) -> None: ...

global___TableAccessRule = TableAccessRule

@typing.final
class FunctionAccessRule(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Privilege:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _PrivilegeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[FunctionAccessRule._Privilege.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        PRIVILEGE_UNSPECIFIED: FunctionAccessRule._Privilege.ValueType  # 0
        EXECUTE: FunctionAccessRule._Privilege.ValueType  # 1
        """Allows to execute the function."""
        GRANT_EXECUTE: FunctionAccessRule._Privilege.ValueType  # 2
        """Allows to use the function while view creation."""
        OWNERSHIP: FunctionAccessRule._Privilege.ValueType  # 3
        """Allows to CREATE and DROP the function."""

    class Privilege(_Privilege, metaclass=_PrivilegeEnumTypeWrapper): ...
    PRIVILEGE_UNSPECIFIED: FunctionAccessRule.Privilege.ValueType  # 0
    EXECUTE: FunctionAccessRule.Privilege.ValueType  # 1
    """Allows to execute the function."""
    GRANT_EXECUTE: FunctionAccessRule.Privilege.ValueType  # 2
    """Allows to use the function while view creation."""
    OWNERSHIP: FunctionAccessRule.Privilege.ValueType  # 3
    """Allows to CREATE and DROP the function."""

    USERS_FIELD_NUMBER: builtins.int
    GROUPS_FIELD_NUMBER: builtins.int
    CATALOG_FIELD_NUMBER: builtins.int
    SCHEMA_FIELD_NUMBER: builtins.int
    FUNCTION_FIELD_NUMBER: builtins.int
    PRIVILEGES_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    description: builtins.str
    """Rule description."""
    @property
    def users(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """IAM user IDs the rule is applied to."""

    @property
    def groups(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """IAM group IDs the rule is applied to."""

    @property
    def catalog(self) -> global___CatalogAccessRuleMatcher:
        """Catalog matcher specifying what catalogs the rule is applied to."""

    @property
    def schema(self) -> global___SchemaAccessRuleMatcher:
        """Schema matcher specifying what schema the rule is applied to."""

    @property
    def function(self) -> global___FunctionAccessRuleMatcher:
        """Function matcher specifying what functions the rule is applied to."""

    @property
    def privileges(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[global___FunctionAccessRule.Privilege.ValueType]:
        """Privileges granted by the rule."""

    def __init__(
        self,
        *,
        users: collections.abc.Iterable[builtins.str] | None = ...,
        groups: collections.abc.Iterable[builtins.str] | None = ...,
        catalog: global___CatalogAccessRuleMatcher | None = ...,
        schema: global___SchemaAccessRuleMatcher | None = ...,
        function: global___FunctionAccessRuleMatcher | None = ...,
        privileges: collections.abc.Iterable[global___FunctionAccessRule.Privilege.ValueType] | None = ...,
        description: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["catalog", b"catalog", "function", b"function", "schema", b"schema"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["catalog", b"catalog", "description", b"description", "function", b"function", "groups", b"groups", "privileges", b"privileges", "schema", b"schema", "users", b"users"]) -> None: ...

global___FunctionAccessRule = FunctionAccessRule

@typing.final
class ProcedureAccessRule(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Privilege:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _PrivilegeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[ProcedureAccessRule._Privilege.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        PRIVILEGE_UNSPECIFIED: ProcedureAccessRule._Privilege.ValueType  # 0
        EXECUTE: ProcedureAccessRule._Privilege.ValueType  # 1
        """Allows to execute the procedure."""

    class Privilege(_Privilege, metaclass=_PrivilegeEnumTypeWrapper): ...
    PRIVILEGE_UNSPECIFIED: ProcedureAccessRule.Privilege.ValueType  # 0
    EXECUTE: ProcedureAccessRule.Privilege.ValueType  # 1
    """Allows to execute the procedure."""

    USERS_FIELD_NUMBER: builtins.int
    GROUPS_FIELD_NUMBER: builtins.int
    CATALOG_FIELD_NUMBER: builtins.int
    SCHEMA_FIELD_NUMBER: builtins.int
    PROCEDURE_FIELD_NUMBER: builtins.int
    PRIVILEGES_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    description: builtins.str
    """Rule description."""
    @property
    def users(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """IAM user IDs the rule is applied to."""

    @property
    def groups(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """IAM group IDs the rule is applied to."""

    @property
    def catalog(self) -> global___CatalogAccessRuleMatcher:
        """Catalog matcher specifying what catalogs the rule is applied to."""

    @property
    def schema(self) -> global___SchemaAccessRuleMatcher:
        """Schema matcher specifying what schema the rule is applied to."""

    @property
    def procedure(self) -> global___ProcedureAccessRuleMatcher:
        """Procedure matcher specifying what functions the rule is applied to."""

    @property
    def privileges(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[global___ProcedureAccessRule.Privilege.ValueType]:
        """Privileges granted by the rule."""

    def __init__(
        self,
        *,
        users: collections.abc.Iterable[builtins.str] | None = ...,
        groups: collections.abc.Iterable[builtins.str] | None = ...,
        catalog: global___CatalogAccessRuleMatcher | None = ...,
        schema: global___SchemaAccessRuleMatcher | None = ...,
        procedure: global___ProcedureAccessRuleMatcher | None = ...,
        privileges: collections.abc.Iterable[global___ProcedureAccessRule.Privilege.ValueType] | None = ...,
        description: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["catalog", b"catalog", "procedure", b"procedure", "schema", b"schema"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["catalog", b"catalog", "description", b"description", "groups", b"groups", "privileges", b"privileges", "procedure", b"procedure", "schema", b"schema", "users", b"users"]) -> None: ...

global___ProcedureAccessRule = ProcedureAccessRule

@typing.final
class QueryAccessRule(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Privilege:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _PrivilegeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[QueryAccessRule._Privilege.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        PRIVILEGE_UNSPECIFIED: QueryAccessRule._Privilege.ValueType  # 0
        VIEW: QueryAccessRule._Privilege.ValueType  # 1
        """Allows to view the query."""
        EXECUTE: QueryAccessRule._Privilege.ValueType  # 2
        """Allows to execute the query."""
        KILL: QueryAccessRule._Privilege.ValueType  # 3
        """Allows to kill the query."""

    class Privilege(_Privilege, metaclass=_PrivilegeEnumTypeWrapper): ...
    PRIVILEGE_UNSPECIFIED: QueryAccessRule.Privilege.ValueType  # 0
    VIEW: QueryAccessRule.Privilege.ValueType  # 1
    """Allows to view the query."""
    EXECUTE: QueryAccessRule.Privilege.ValueType  # 2
    """Allows to execute the query."""
    KILL: QueryAccessRule.Privilege.ValueType  # 3
    """Allows to kill the query."""

    USERS_FIELD_NUMBER: builtins.int
    GROUPS_FIELD_NUMBER: builtins.int
    QUERY_OWNERS_FIELD_NUMBER: builtins.int
    PRIVILEGES_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    description: builtins.str
    """Rule description."""
    @property
    def users(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """IAM user IDs the rule is applied to."""

    @property
    def groups(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """IAM group IDs the rule is applied to."""

    @property
    def query_owners(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Owners of queries the rule is applied to.
        Cannot be combined with EXECUTE privilege.
        """

    @property
    def privileges(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[global___QueryAccessRule.Privilege.ValueType]:
        """Privileges granted by the user."""

    def __init__(
        self,
        *,
        users: collections.abc.Iterable[builtins.str] | None = ...,
        groups: collections.abc.Iterable[builtins.str] | None = ...,
        query_owners: collections.abc.Iterable[builtins.str] | None = ...,
        privileges: collections.abc.Iterable[global___QueryAccessRule.Privilege.ValueType] | None = ...,
        description: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["description", b"description", "groups", b"groups", "privileges", b"privileges", "query_owners", b"query_owners", "users", b"users"]) -> None: ...

global___QueryAccessRule = QueryAccessRule

@typing.final
class SystemSessionPropertyAccessRule(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Allow:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _AllowEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[SystemSessionPropertyAccessRule._Allow.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        ALLOW_UNSPECIFIED: SystemSessionPropertyAccessRule._Allow.ValueType  # 0
        NO: SystemSessionPropertyAccessRule._Allow.ValueType  # 1
        """Denies setting the system session property."""
        YES: SystemSessionPropertyAccessRule._Allow.ValueType  # 2
        """Allows to set the system session property."""

    class Allow(_Allow, metaclass=_AllowEnumTypeWrapper): ...
    ALLOW_UNSPECIFIED: SystemSessionPropertyAccessRule.Allow.ValueType  # 0
    NO: SystemSessionPropertyAccessRule.Allow.ValueType  # 1
    """Denies setting the system session property."""
    YES: SystemSessionPropertyAccessRule.Allow.ValueType  # 2
    """Allows to set the system session property."""

    USERS_FIELD_NUMBER: builtins.int
    GROUPS_FIELD_NUMBER: builtins.int
    PROPERTY_FIELD_NUMBER: builtins.int
    ALLOW_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    allow: global___SystemSessionPropertyAccessRule.Allow.ValueType
    """Whether the rule allows setting the property."""
    description: builtins.str
    """Rule description."""
    @property
    def users(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """IAM user IDs the rule is applied to."""

    @property
    def groups(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """IAM group IDs the rule is applied to."""

    @property
    def property(self) -> global___PropertyAccessRuleMatcher:
        """Property matcher specifying what properties the rule is applied to."""

    def __init__(
        self,
        *,
        users: collections.abc.Iterable[builtins.str] | None = ...,
        groups: collections.abc.Iterable[builtins.str] | None = ...,
        property: global___PropertyAccessRuleMatcher | None = ...,
        allow: global___SystemSessionPropertyAccessRule.Allow.ValueType = ...,
        description: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["property", b"property"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["allow", b"allow", "description", b"description", "groups", b"groups", "property", b"property", "users", b"users"]) -> None: ...

global___SystemSessionPropertyAccessRule = SystemSessionPropertyAccessRule

@typing.final
class CatalogSessionPropertyAccessRule(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Allow:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _AllowEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[CatalogSessionPropertyAccessRule._Allow.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        ALLOW_UNSPECIFIED: CatalogSessionPropertyAccessRule._Allow.ValueType  # 0
        NO: CatalogSessionPropertyAccessRule._Allow.ValueType  # 1
        """Denies setting the catalog session property."""
        YES: CatalogSessionPropertyAccessRule._Allow.ValueType  # 2
        """Allows to set the catalog session property."""

    class Allow(_Allow, metaclass=_AllowEnumTypeWrapper): ...
    ALLOW_UNSPECIFIED: CatalogSessionPropertyAccessRule.Allow.ValueType  # 0
    NO: CatalogSessionPropertyAccessRule.Allow.ValueType  # 1
    """Denies setting the catalog session property."""
    YES: CatalogSessionPropertyAccessRule.Allow.ValueType  # 2
    """Allows to set the catalog session property."""

    USERS_FIELD_NUMBER: builtins.int
    GROUPS_FIELD_NUMBER: builtins.int
    CATALOG_FIELD_NUMBER: builtins.int
    PROPERTY_FIELD_NUMBER: builtins.int
    ALLOW_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    allow: global___CatalogSessionPropertyAccessRule.Allow.ValueType
    """Whether the rule allows setting the property."""
    description: builtins.str
    """Rule description."""
    @property
    def users(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """IAM user IDs the rule is applied to."""

    @property
    def groups(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """IAM group IDs the rule is applied to."""

    @property
    def catalog(self) -> global___CatalogAccessRuleMatcher:
        """Catalog matcher specifying what catalogs the rule is applied to."""

    @property
    def property(self) -> global___PropertyAccessRuleMatcher:
        """Property matcher specifying what properties the rule is applied to."""

    def __init__(
        self,
        *,
        users: collections.abc.Iterable[builtins.str] | None = ...,
        groups: collections.abc.Iterable[builtins.str] | None = ...,
        catalog: global___CatalogAccessRuleMatcher | None = ...,
        property: global___PropertyAccessRuleMatcher | None = ...,
        allow: global___CatalogSessionPropertyAccessRule.Allow.ValueType = ...,
        description: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["catalog", b"catalog", "property", b"property"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["allow", b"allow", "catalog", b"catalog", "description", b"description", "groups", b"groups", "property", b"property", "users", b"users"]) -> None: ...

global___CatalogSessionPropertyAccessRule = CatalogSessionPropertyAccessRule
