"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.field_mask_pb2
import google.protobuf.internal.containers
import google.protobuf.message
import typing
import yandex.cloud.trino.v1.catalog_pb2

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class GetCatalogRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    CATALOG_ID_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the Trino Cluster resource which contains the requested catalog."""
    catalog_id: builtins.str
    """ID of the Trino Catalog resource."""
    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
        catalog_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["catalog_id", b"catalog_id", "cluster_id", b"cluster_id"]) -> None: ...

global___GetCatalogRequest = GetCatalogRequest

@typing.final
class ListCatalogsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    FILTER_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the cluster to list Trino Catalogs in."""
    page_size: builtins.int
    """The maximum number of results per page to return. If the number of available
    results is larger than [page_size], the service returns a [ListCatalogsResponse.next_page_token]
    that can be used to get the next page of results in subsequent list requests.
    """
    page_token: builtins.str
    """Page token. To get the next page of results, set [page_token] to the [ListCatalogsResponse.next_page_token]
    returned by the previous list request.
    """
    filter: builtins.str
    """A filter expression that filters resources listed in the response.
    The expression must specify:
    1. The field name. Currently you can only use filtering with the [Catalog.name] field.
    2. An `=` operator.
    3. The value in double quotes (`"`). Must be 1-63 characters long and match the regular expression `[a-zA-Z0-9_-]+`.
    """
    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
        page_size: builtins.int = ...,
        page_token: builtins.str = ...,
        filter: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id", "filter", b"filter", "page_size", b"page_size", "page_token", b"page_token"]) -> None: ...

global___ListCatalogsRequest = ListCatalogsRequest

@typing.final
class ListCatalogsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CATALOGS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    next_page_token: builtins.str
    """This token allows you to get the next page of results for list requests. If the number of results
    is larger than [ListCatalogsRequest.page_size], use the [next_page_token] as the value
    for the [ListCatalogsRequest.page_token] parameter in the next list request. Each subsequent
    list request will have its own [next_page_token] to continue paging through the results.
    """
    @property
    def catalogs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.trino.v1.catalog_pb2.Catalog]:
        """List of Trino Catalog resources."""

    def __init__(
        self,
        *,
        catalogs: collections.abc.Iterable[yandex.cloud.trino.v1.catalog_pb2.Catalog] | None = ...,
        next_page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["catalogs", b"catalogs", "next_page_token", b"next_page_token"]) -> None: ...

global___ListCatalogsResponse = ListCatalogsResponse

@typing.final
class CreateCatalogRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    CATALOG_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the Trino Cluster where the catalog should be created."""
    @property
    def catalog(self) -> yandex.cloud.trino.v1.catalog_pb2.CatalogSpec:
        """Specification of the catalog to be created."""

    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
        catalog: yandex.cloud.trino.v1.catalog_pb2.CatalogSpec | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["catalog", b"catalog"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["catalog", b"catalog", "cluster_id", b"cluster_id"]) -> None: ...

global___CreateCatalogRequest = CreateCatalogRequest

@typing.final
class CreateCatalogMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    CATALOG_ID_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the Trino cluster where a catalog is being created."""
    catalog_id: builtins.str
    """ID of the catalog that is being created."""
    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
        catalog_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["catalog_id", b"catalog_id", "cluster_id", b"cluster_id"]) -> None: ...

global___CreateCatalogMetadata = CreateCatalogMetadata

@typing.final
class UpdateCatalogRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    CATALOG_ID_FIELD_NUMBER: builtins.int
    UPDATE_MASK_FIELD_NUMBER: builtins.int
    CATALOG_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the Trino Cluster that contains the catalog to update."""
    catalog_id: builtins.str
    """ID of the catalog to update."""
    @property
    def update_mask(self) -> google.protobuf.field_mask_pb2.FieldMask:
        """Field mask that specifies which fields of the catalog should be updated."""

    @property
    def catalog(self) -> yandex.cloud.trino.v1.catalog_pb2.CatalogUpdateSpec:
        """New values for the specified fields."""

    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
        catalog_id: builtins.str = ...,
        update_mask: google.protobuf.field_mask_pb2.FieldMask | None = ...,
        catalog: yandex.cloud.trino.v1.catalog_pb2.CatalogUpdateSpec | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["catalog", b"catalog", "update_mask", b"update_mask"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["catalog", b"catalog", "catalog_id", b"catalog_id", "cluster_id", b"cluster_id", "update_mask", b"update_mask"]) -> None: ...

global___UpdateCatalogRequest = UpdateCatalogRequest

@typing.final
class UpdateCatalogMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    CATALOG_ID_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the Trino cluster where a catalog is being updated."""
    catalog_id: builtins.str
    """ID of the catalog that is being updated."""
    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
        catalog_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["catalog_id", b"catalog_id", "cluster_id", b"cluster_id"]) -> None: ...

global___UpdateCatalogMetadata = UpdateCatalogMetadata

@typing.final
class DeleteCatalogRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    CATALOG_ID_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the Trino Cluster resource which contains the requested catalog."""
    catalog_id: builtins.str
    """ID of the Trino Catalog resource."""
    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
        catalog_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["catalog_id", b"catalog_id", "cluster_id", b"cluster_id"]) -> None: ...

global___DeleteCatalogRequest = DeleteCatalogRequest

@typing.final
class DeleteCatalogMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    CATALOG_ID_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the Trino cluster where a catalog is being deleted."""
    catalog_id: builtins.str
    """ID of the catalog that is being deleted."""
    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
        catalog_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["catalog_id", b"catalog_id", "cluster_id", b"cluster_id"]) -> None: ...

global___DeleteCatalogMetadata = DeleteCatalogMetadata
