"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class ResourceManagementConfig(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RESOURCE_GROUPS_FIELD_NUMBER: builtins.int
    QUERY_FIELD_NUMBER: builtins.int
    @property
    def resource_groups(self) -> global___ResourceGroupsConfig:
        """Resource groups configuration."""

    @property
    def query(self) -> global___QueryConfig:
        """Query management confiugration."""

    def __init__(
        self,
        *,
        resource_groups: global___ResourceGroupsConfig | None = ...,
        query: global___QueryConfig | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["query", b"query", "resource_groups", b"resource_groups"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["query", b"query", "resource_groups", b"resource_groups"]) -> None: ...

global___ResourceManagementConfig = ResourceManagementConfig

@typing.final
class QueryConfig(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class PropertiesEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    PROPERTIES_FIELD_NUMBER: builtins.int
    @property
    def properties(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Query properties."""

    def __init__(
        self,
        *,
        properties: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["properties", b"properties"]) -> None: ...

global___QueryConfig = QueryConfig

@typing.final
class ResourceGroupsConfig(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ROOT_GROUPS_FIELD_NUMBER: builtins.int
    SELECTORS_FIELD_NUMBER: builtins.int
    CPU_QUOTA_PERIOD_FIELD_NUMBER: builtins.int
    cpu_quota_period: builtins.str
    """Period for CPU quota calculations."""
    @property
    def root_groups(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ResourceGroupConfig]:
        """Root resource groups configuration."""

    @property
    def selectors(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___SelectorRuleConfig]:
        """Selector rules for routing queries to resource groups."""

    def __init__(
        self,
        *,
        root_groups: collections.abc.Iterable[global___ResourceGroupConfig] | None = ...,
        selectors: collections.abc.Iterable[global___SelectorRuleConfig] | None = ...,
        cpu_quota_period: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cpu_quota_period", b"cpu_quota_period", "root_groups", b"root_groups", "selectors", b"selectors"]) -> None: ...

global___ResourceGroupsConfig = ResourceGroupsConfig

@typing.final
class ResourceGroupConfig(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _SchedulingPolicy:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _SchedulingPolicyEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[ResourceGroupConfig._SchedulingPolicy.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        SCHEDULING_POLICY_UNSPECIFIED: ResourceGroupConfig._SchedulingPolicy.ValueType  # 0
        FAIR: ResourceGroupConfig._SchedulingPolicy.ValueType  # 1
        """Queued queries processed first-in-first-out, sub-groups take turns starting queries."""
        WEIGHTED: ResourceGroupConfig._SchedulingPolicy.ValueType  # 2
        """Queries selected stochastically by priority, sub-groups selected by schedulingWeight."""
        WEIGHTED_FAIR: ResourceGroupConfig._SchedulingPolicy.ValueType  # 3
        """Sub-groups selected by schedulingWeight and concurrency relative to their share."""
        QUERY_PRIORITY: ResourceGroupConfig._SchedulingPolicy.ValueType  # 4
        """Queued queries selected strictly by priority."""

    class SchedulingPolicy(_SchedulingPolicy, metaclass=_SchedulingPolicyEnumTypeWrapper): ...
    SCHEDULING_POLICY_UNSPECIFIED: ResourceGroupConfig.SchedulingPolicy.ValueType  # 0
    FAIR: ResourceGroupConfig.SchedulingPolicy.ValueType  # 1
    """Queued queries processed first-in-first-out, sub-groups take turns starting queries."""
    WEIGHTED: ResourceGroupConfig.SchedulingPolicy.ValueType  # 2
    """Queries selected stochastically by priority, sub-groups selected by schedulingWeight."""
    WEIGHTED_FAIR: ResourceGroupConfig.SchedulingPolicy.ValueType  # 3
    """Sub-groups selected by schedulingWeight and concurrency relative to their share."""
    QUERY_PRIORITY: ResourceGroupConfig.SchedulingPolicy.ValueType  # 4
    """Queued queries selected strictly by priority."""

    NAME_FIELD_NUMBER: builtins.int
    MAX_QUEUED_FIELD_NUMBER: builtins.int
    SOFT_CONCURRENCY_LIMIT_FIELD_NUMBER: builtins.int
    HARD_CONCURRENCY_LIMIT_FIELD_NUMBER: builtins.int
    SOFT_MEMORY_LIMIT_FIELD_NUMBER: builtins.int
    SOFT_CPU_LIMIT_FIELD_NUMBER: builtins.int
    HARD_CPU_LIMIT_FIELD_NUMBER: builtins.int
    SCHEDULING_POLICY_FIELD_NUMBER: builtins.int
    SCHEDULING_WEIGHT_FIELD_NUMBER: builtins.int
    SUB_GROUPS_FIELD_NUMBER: builtins.int
    name: builtins.str
    """Resource group name."""
    max_queued: builtins.int
    """Maximum number of queued queries."""
    soft_concurrency_limit: builtins.int
    """Number of concurrently running queries after which new queries only run if peer groups are below soft limits."""
    hard_concurrency_limit: builtins.int
    """Maximum number of queries that can run concurrently."""
    soft_memory_limit: builtins.str
    """Maximum amount of distributed memory this group can use."""
    soft_cpu_limit: builtins.str
    """Maximum CPU time per period this group can use before applying penalty to running queries (requires hard_cpu_limit)."""
    hard_cpu_limit: builtins.str
    """Maximum CPU time per period this group can use."""
    scheduling_policy: global___ResourceGroupConfig.SchedulingPolicy.ValueType
    """Policy for selecting queued queries and sub-group eligibility."""
    scheduling_weight: builtins.int
    """Weight for weighted and weighted_fair scheduling policies."""
    @property
    def sub_groups(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ResourceGroupConfig]:
        """List of sub-groups."""

    def __init__(
        self,
        *,
        name: builtins.str = ...,
        max_queued: builtins.int = ...,
        soft_concurrency_limit: builtins.int = ...,
        hard_concurrency_limit: builtins.int = ...,
        soft_memory_limit: builtins.str = ...,
        soft_cpu_limit: builtins.str = ...,
        hard_cpu_limit: builtins.str = ...,
        scheduling_policy: global___ResourceGroupConfig.SchedulingPolicy.ValueType = ...,
        scheduling_weight: builtins.int = ...,
        sub_groups: collections.abc.Iterable[global___ResourceGroupConfig] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["hard_concurrency_limit", b"hard_concurrency_limit", "hard_cpu_limit", b"hard_cpu_limit", "max_queued", b"max_queued", "name", b"name", "scheduling_policy", b"scheduling_policy", "scheduling_weight", b"scheduling_weight", "soft_concurrency_limit", b"soft_concurrency_limit", "soft_cpu_limit", b"soft_cpu_limit", "soft_memory_limit", b"soft_memory_limit", "sub_groups", b"sub_groups"]) -> None: ...

global___ResourceGroupConfig = ResourceGroupConfig

@typing.final
class SelectorRuleConfig(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _QueryType:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _QueryTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[SelectorRuleConfig._QueryType.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        QUERY_TYPE_UNSPECIFIED: SelectorRuleConfig._QueryType.ValueType  # 0
        SELECT: SelectorRuleConfig._QueryType.ValueType  # 1
        EXPLAIN: SelectorRuleConfig._QueryType.ValueType  # 2
        DESCRIBE: SelectorRuleConfig._QueryType.ValueType  # 3
        INSERT: SelectorRuleConfig._QueryType.ValueType  # 4
        UPDATE: SelectorRuleConfig._QueryType.ValueType  # 5
        MERGE: SelectorRuleConfig._QueryType.ValueType  # 6
        DELETE: SelectorRuleConfig._QueryType.ValueType  # 7
        ANALYZE: SelectorRuleConfig._QueryType.ValueType  # 8
        DATA_DEFINITION: SelectorRuleConfig._QueryType.ValueType  # 9
        ALTER_TABLE_EXECUTE: SelectorRuleConfig._QueryType.ValueType  # 10

    class QueryType(_QueryType, metaclass=_QueryTypeEnumTypeWrapper): ...
    QUERY_TYPE_UNSPECIFIED: SelectorRuleConfig.QueryType.ValueType  # 0
    SELECT: SelectorRuleConfig.QueryType.ValueType  # 1
    EXPLAIN: SelectorRuleConfig.QueryType.ValueType  # 2
    DESCRIBE: SelectorRuleConfig.QueryType.ValueType  # 3
    INSERT: SelectorRuleConfig.QueryType.ValueType  # 4
    UPDATE: SelectorRuleConfig.QueryType.ValueType  # 5
    MERGE: SelectorRuleConfig.QueryType.ValueType  # 6
    DELETE: SelectorRuleConfig.QueryType.ValueType  # 7
    ANALYZE: SelectorRuleConfig.QueryType.ValueType  # 8
    DATA_DEFINITION: SelectorRuleConfig.QueryType.ValueType  # 9
    ALTER_TABLE_EXECUTE: SelectorRuleConfig.QueryType.ValueType  # 10

    USER_FIELD_NUMBER: builtins.int
    USER_GROUP_FIELD_NUMBER: builtins.int
    SOURCE_FIELD_NUMBER: builtins.int
    QUERY_TYPE_FIELD_NUMBER: builtins.int
    CLIENT_TAGS_FIELD_NUMBER: builtins.int
    GROUP_FIELD_NUMBER: builtins.int
    user: builtins.str
    """Regex to match against username."""
    user_group: builtins.str
    """Regex to match against user groups."""
    source: builtins.str
    """Regex to match against query source."""
    query_type: global___SelectorRuleConfig.QueryType.ValueType
    """Type of query to match."""
    group: builtins.str
    """Target resource group name."""
    @property
    def client_tags(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Tags that must all be present in the query's client tags."""

    def __init__(
        self,
        *,
        user: builtins.str = ...,
        user_group: builtins.str = ...,
        source: builtins.str = ...,
        query_type: global___SelectorRuleConfig.QueryType.ValueType = ...,
        client_tags: collections.abc.Iterable[builtins.str] | None = ...,
        group: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["client_tags", b"client_tags", "group", b"group", "query_type", b"query_type", "source", b"source", "user", b"user", "user_group", b"user_group"]) -> None: ...

global___SelectorRuleConfig = SelectorRuleConfig
