"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import google.protobuf.descriptor
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.timestamp_pb2
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class Episode(google.protobuf.message.Message):
    """Entity representing a stream fragment that can be accessed independently.
    Episodes can be linked to either a stream or a line
    and provide a way to reference specific portions of the corresponding content.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _VisibilityStatus:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _VisibilityStatusEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Episode._VisibilityStatus.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        VISIBILITY_STATUS_UNSPECIFIED: Episode._VisibilityStatus.ValueType  # 0
        """The visibility status is not specified."""
        PUBLISHED: Episode._VisibilityStatus.ValueType  # 1
        """The episode is publicly available, subject to its access permission settings."""
        UNPUBLISHED: Episode._VisibilityStatus.ValueType  # 2
        """The episode is available only to administrators."""

    class VisibilityStatus(_VisibilityStatus, metaclass=_VisibilityStatusEnumTypeWrapper):
        """Visibility status of the episode."""

    VISIBILITY_STATUS_UNSPECIFIED: Episode.VisibilityStatus.ValueType  # 0
    """The visibility status is not specified."""
    PUBLISHED: Episode.VisibilityStatus.ValueType  # 1
    """The episode is publicly available, subject to its access permission settings."""
    UNPUBLISHED: Episode.VisibilityStatus.ValueType  # 2
    """The episode is available only to administrators."""

    ID_FIELD_NUMBER: builtins.int
    STREAM_ID_FIELD_NUMBER: builtins.int
    LINE_ID_FIELD_NUMBER: builtins.int
    TITLE_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    THUMBNAIL_ID_FIELD_NUMBER: builtins.int
    START_TIME_FIELD_NUMBER: builtins.int
    FINISH_TIME_FIELD_NUMBER: builtins.int
    DVR_SECONDS_FIELD_NUMBER: builtins.int
    VISIBILITY_STATUS_FIELD_NUMBER: builtins.int
    STYLE_PRESET_ID_FIELD_NUMBER: builtins.int
    PUBLIC_ACCESS_FIELD_NUMBER: builtins.int
    SIGN_URL_ACCESS_FIELD_NUMBER: builtins.int
    CREATED_AT_FIELD_NUMBER: builtins.int
    UPDATED_AT_FIELD_NUMBER: builtins.int
    id: builtins.str
    """Unique identifier of the episode."""
    stream_id: builtins.str
    """Identifier of the stream this episode is linked to.
    Optional, empty if the episode is linked to a line.
    """
    line_id: builtins.str
    """Identifier of the line this episode is linked to.
    Optional, empty if the episode is linked to a stream.
    """
    title: builtins.str
    """Title of the episode displayed in interfaces and players."""
    description: builtins.str
    """Detailed description of the episode content and context."""
    thumbnail_id: builtins.str
    """Identifier of the thumbnail image used to represent the episode visually."""
    dvr_seconds: builtins.int
    """Controls the Digital Video Recording (DVR) functionality for the episode.
    Determines how many seconds of the stream are available for time-shifted viewing.

    Possible values:
     * `0`: Infinite DVR size, the full length of the stream is available for viewing.
     * `>0`: Size of DVR window in seconds, the minimum value is 30s.
    """
    visibility_status: global___Episode.VisibilityStatus.ValueType
    """Current visibility status controlling whether the episode is publicly available."""
    style_preset_id: builtins.str
    """Identifier of the style preset used in the player during episode playback."""
    @property
    def start_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Timestamp marking the beginning of the episode content."""

    @property
    def finish_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Timestamp marking the end of the episode content."""

    @property
    def public_access(self) -> global___EpisodePublicAccessRights:
        """Allows unrestricted public access to the episode via direct link.
        No additional authorization or access control is applied.
        """

    @property
    def sign_url_access(self) -> global___EpisodeSignURLAccessRights:
        """Restricts episode access using URL signatures for secure time-limited access."""

    @property
    def created_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Timestamp when the episode was initially created in the system."""

    @property
    def updated_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Timestamp of the last modification to the episode or its metadata."""

    def __init__(
        self,
        *,
        id: builtins.str = ...,
        stream_id: builtins.str = ...,
        line_id: builtins.str = ...,
        title: builtins.str = ...,
        description: builtins.str = ...,
        thumbnail_id: builtins.str = ...,
        start_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        finish_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        dvr_seconds: builtins.int = ...,
        visibility_status: global___Episode.VisibilityStatus.ValueType = ...,
        style_preset_id: builtins.str = ...,
        public_access: global___EpisodePublicAccessRights | None = ...,
        sign_url_access: global___EpisodeSignURLAccessRights | None = ...,
        created_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        updated_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["access_rights", b"access_rights", "created_at", b"created_at", "finish_time", b"finish_time", "public_access", b"public_access", "sign_url_access", b"sign_url_access", "start_time", b"start_time", "updated_at", b"updated_at"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["access_rights", b"access_rights", "created_at", b"created_at", "description", b"description", "dvr_seconds", b"dvr_seconds", "finish_time", b"finish_time", "id", b"id", "line_id", b"line_id", "public_access", b"public_access", "sign_url_access", b"sign_url_access", "start_time", b"start_time", "stream_id", b"stream_id", "style_preset_id", b"style_preset_id", "thumbnail_id", b"thumbnail_id", "title", b"title", "updated_at", b"updated_at", "visibility_status", b"visibility_status"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["access_rights", b"access_rights"]) -> typing.Literal["public_access", "sign_url_access"] | None: ...

global___Episode = Episode

@typing.final
class EpisodePublicAccessRights(google.protobuf.message.Message):
    """Represents public access rights for an episode.
    When this access type is set, the episode is publicly accessible via direct link.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___EpisodePublicAccessRights = EpisodePublicAccessRights

@typing.final
class EpisodeSignURLAccessRights(google.protobuf.message.Message):
    """Represents access rights controlled by URL signatures.
    When this access type is set, the episode is accessible only via properly signed temporary link.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___EpisodeSignURLAccessRights = EpisodeSignURLAccessRights
