"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.field_mask_pb2
import google.protobuf.internal.containers
import google.protobuf.message
import typing
import yandex.cloud.video.v1.playlist_pb2

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class GetPlaylistRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PLAYLIST_ID_FIELD_NUMBER: builtins.int
    playlist_id: builtins.str
    """ID of the playlist to retrieve."""
    def __init__(
        self,
        *,
        playlist_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["playlist_id", b"playlist_id"]) -> None: ...

global___GetPlaylistRequest = GetPlaylistRequest

@typing.final
class ListPlaylistsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CHANNEL_ID_FIELD_NUMBER: builtins.int
    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    ORDER_BY_FIELD_NUMBER: builtins.int
    FILTER_FIELD_NUMBER: builtins.int
    channel_id: builtins.str
    """ID of the channel containing the playlists to list."""
    page_size: builtins.int
    """The maximum number of playlists to return per page."""
    page_token: builtins.str
    """Page token for retrieving the next page of results.
    This token is obtained from the next_page_token field in the previous ListPlaylistsResponse.
    """
    order_by: builtins.str
    """Specifies the ordering of results.
    Format is "<field> <order>" (e.g., "createdAt desc").
    Default: "id asc".
    Supported fields: ["id", "title", "createdAt", "updatedAt"].
    Both snake_case and camelCase field names are supported.
    """
    filter: builtins.str
    """Filter expression to narrow down the list of returned playlists.
    Expressions consist of terms connected by logical operators.
    Values containing spaces or quotes must be enclosed in quotes (`'` or `"`)
    with inner quotes being backslash-escaped.

    Supported logical operators: ["AND", "OR"].
    Supported comparison operators: ["=", "!=", ":"] where ":" enables substring matching.
    Parentheses can be used to group logical expressions.

    Example: `title:'highlights' AND id='playlist-1'`

    Filterable fields: ["id", "title"].
    Both snake_case and camelCase field names are supported.
    """
    def __init__(
        self,
        *,
        channel_id: builtins.str = ...,
        page_size: builtins.int = ...,
        page_token: builtins.str = ...,
        order_by: builtins.str = ...,
        filter: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["channel_id", b"channel_id", "filter", b"filter", "order_by", b"order_by", "page_size", b"page_size", "page_token", b"page_token"]) -> None: ...

global___ListPlaylistsRequest = ListPlaylistsRequest

@typing.final
class ListPlaylistsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PLAYLISTS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    next_page_token: builtins.str
    """Token for retrieving the next page of results.
    Empty if there are no more results available.
    """
    @property
    def playlists(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.video.v1.playlist_pb2.Playlist]:
        """List of playlists matching the request criteria.
        May be empty if no playlists match the criteria or if the channel has no playlists.
        """

    def __init__(
        self,
        *,
        playlists: collections.abc.Iterable[yandex.cloud.video.v1.playlist_pb2.Playlist] | None = ...,
        next_page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["next_page_token", b"next_page_token", "playlists", b"playlists"]) -> None: ...

global___ListPlaylistsResponse = ListPlaylistsResponse

@typing.final
class CreatePlaylistRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CHANNEL_ID_FIELD_NUMBER: builtins.int
    TITLE_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    ITEMS_FIELD_NUMBER: builtins.int
    STYLE_PRESET_ID_FIELD_NUMBER: builtins.int
    channel_id: builtins.str
    """ID of the channel where the playlist will be created."""
    title: builtins.str
    """Title of the playlist to be displayed in interfaces and players."""
    description: builtins.str
    """Detailed description of the playlist content and context.
    Optional field that can provide additional information about the playlist.
    """
    style_preset_id: builtins.str
    """ID of the style preset to be applied to the playlist player.
    Style presets control the visual appearance of the player.
    """
    @property
    def items(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.video.v1.playlist_pb2.PlaylistItem]:
        """List of items to include in the playlist.
        Each item represents a video or episode to be played in sequence.
        The order of items in this list determines the playback order.
        """

    def __init__(
        self,
        *,
        channel_id: builtins.str = ...,
        title: builtins.str = ...,
        description: builtins.str = ...,
        items: collections.abc.Iterable[yandex.cloud.video.v1.playlist_pb2.PlaylistItem] | None = ...,
        style_preset_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["channel_id", b"channel_id", "description", b"description", "items", b"items", "style_preset_id", b"style_preset_id", "title", b"title"]) -> None: ...

global___CreatePlaylistRequest = CreatePlaylistRequest

@typing.final
class CreatePlaylistMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PLAYLIST_ID_FIELD_NUMBER: builtins.int
    playlist_id: builtins.str
    """ID of the playlist being created."""
    def __init__(
        self,
        *,
        playlist_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["playlist_id", b"playlist_id"]) -> None: ...

global___CreatePlaylistMetadata = CreatePlaylistMetadata

@typing.final
class UpdatePlaylistRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PLAYLIST_ID_FIELD_NUMBER: builtins.int
    FIELD_MASK_FIELD_NUMBER: builtins.int
    TITLE_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    ITEMS_FIELD_NUMBER: builtins.int
    STYLE_PRESET_ID_FIELD_NUMBER: builtins.int
    playlist_id: builtins.str
    """ID of the playlist to update."""
    title: builtins.str
    """New title for the playlist."""
    description: builtins.str
    """New description for the playlist.
    Optional field that can provide additional information about the playlist.
    """
    style_preset_id: builtins.str
    """New ID of the style preset to be applied to the playlist player."""
    @property
    def field_mask(self) -> google.protobuf.field_mask_pb2.FieldMask:
        """Field mask specifying which fields of the playlist should be updated.
        Only fields specified in this mask will be modified;
        all other fields will retain their current values.
        This allows for partial updates.
        """

    @property
    def items(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.video.v1.playlist_pb2.PlaylistItem]:
        """New list of items to include in the playlist.
        This completely replaces the existing items if specified in the field mask.
        The order of items in this list determines the playback order.
        """

    def __init__(
        self,
        *,
        playlist_id: builtins.str = ...,
        field_mask: google.protobuf.field_mask_pb2.FieldMask | None = ...,
        title: builtins.str = ...,
        description: builtins.str = ...,
        items: collections.abc.Iterable[yandex.cloud.video.v1.playlist_pb2.PlaylistItem] | None = ...,
        style_preset_id: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["field_mask", b"field_mask"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["description", b"description", "field_mask", b"field_mask", "items", b"items", "playlist_id", b"playlist_id", "style_preset_id", b"style_preset_id", "title", b"title"]) -> None: ...

global___UpdatePlaylistRequest = UpdatePlaylistRequest

@typing.final
class UpdatePlaylistMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PLAYLIST_ID_FIELD_NUMBER: builtins.int
    playlist_id: builtins.str
    """ID of the playlist being updated."""
    def __init__(
        self,
        *,
        playlist_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["playlist_id", b"playlist_id"]) -> None: ...

global___UpdatePlaylistMetadata = UpdatePlaylistMetadata

@typing.final
class DeletePlaylistRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PLAYLIST_ID_FIELD_NUMBER: builtins.int
    playlist_id: builtins.str
    """ID of the playlist to delete."""
    def __init__(
        self,
        *,
        playlist_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["playlist_id", b"playlist_id"]) -> None: ...

global___DeletePlaylistRequest = DeletePlaylistRequest

@typing.final
class DeletePlaylistMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PLAYLIST_ID_FIELD_NUMBER: builtins.int
    playlist_id: builtins.str
    """ID of the playlist being deleted.
    This identifier can be used to track the playlist deletion operation.
    """
    def __init__(
        self,
        *,
        playlist_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["playlist_id", b"playlist_id"]) -> None: ...

global___DeletePlaylistMetadata = DeletePlaylistMetadata

@typing.final
class BatchDeletePlaylistsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CHANNEL_ID_FIELD_NUMBER: builtins.int
    PLAYLIST_IDS_FIELD_NUMBER: builtins.int
    channel_id: builtins.str
    """ID of the channel containing the playlists to delete."""
    @property
    def playlist_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """List of playlist IDs to delete.
        All playlists must exist in the specified channel.
        """

    def __init__(
        self,
        *,
        channel_id: builtins.str = ...,
        playlist_ids: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["channel_id", b"channel_id", "playlist_ids", b"playlist_ids"]) -> None: ...

global___BatchDeletePlaylistsRequest = BatchDeletePlaylistsRequest

@typing.final
class BatchDeletePlaylistsMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PLAYLIST_IDS_FIELD_NUMBER: builtins.int
    @property
    def playlist_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """List of playlist IDs being deleted.
        This list can be used to track which playlists are included
        in the batch deletion operation.
        """

    def __init__(
        self,
        *,
        playlist_ids: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["playlist_ids", b"playlist_ids"]) -> None: ...

global___BatchDeletePlaylistsMetadata = BatchDeletePlaylistsMetadata

@typing.final
class GetPlaylistPlayerURLRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PLAYLIST_ID_FIELD_NUMBER: builtins.int
    PARAMS_FIELD_NUMBER: builtins.int
    playlist_id: builtins.str
    """ID of the playlist for which to generate a player URL."""
    @property
    def params(self) -> global___PlaylistPlayerParams:
        """Optional player parameters to customize the playback experience.
        These parameters control initial player state such as mute, autoplay, and visibility of interface controls.
        """

    def __init__(
        self,
        *,
        playlist_id: builtins.str = ...,
        params: global___PlaylistPlayerParams | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["params", b"params"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["params", b"params", "playlist_id", b"playlist_id"]) -> None: ...

global___GetPlaylistPlayerURLRequest = GetPlaylistPlayerURLRequest

@typing.final
class PlaylistPlayerParams(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MUTE_FIELD_NUMBER: builtins.int
    AUTOPLAY_FIELD_NUMBER: builtins.int
    HIDDEN_FIELD_NUMBER: builtins.int
    mute: builtins.bool
    """If true, the player will start with audio muted.
    Users can unmute the audio manually after playback starts.
    """
    autoplay: builtins.bool
    """If true, the playlist will start playing automatically when the player loads.
    This may be subject to browser autoplay policies that restrict autoplay with sound.
    """
    hidden: builtins.bool
    """If true, the player interface controls will be hidden initially.
    Users can typically reveal the controls by moving the mouse over the player.
    """
    def __init__(
        self,
        *,
        mute: builtins.bool = ...,
        autoplay: builtins.bool = ...,
        hidden: builtins.bool = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["autoplay", b"autoplay", "hidden", b"hidden", "mute", b"mute"]) -> None: ...

global___PlaylistPlayerParams = PlaylistPlayerParams

@typing.final
class GetPlaylistPlayerURLResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PLAYER_URL_FIELD_NUMBER: builtins.int
    HTML_FIELD_NUMBER: builtins.int
    player_url: builtins.str
    """Direct URL to the playlist player.
    This URL can be used to access the playlist in a web browser
    or shared with users who have appropriate permissions.
    """
    html: builtins.str
    """HTML embed code in iframe format that can be inserted into web pages.
    This code allows the playlist to be embedded directly in third-party websites.
    """
    def __init__(
        self,
        *,
        player_url: builtins.str = ...,
        html: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["html", b"html", "player_url", b"player_url"]) -> None: ...

global___GetPlaylistPlayerURLResponse = GetPlaylistPlayerURLResponse
