"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.field_mask_pb2
import google.protobuf.internal.containers
import google.protobuf.message
import typing
import yandex.cloud.video.v1.stream_line_pb2

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class GetStreamLineRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    STREAM_LINE_ID_FIELD_NUMBER: builtins.int
    stream_line_id: builtins.str
    """ID of the stream line to retrieve."""
    def __init__(
        self,
        *,
        stream_line_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["stream_line_id", b"stream_line_id"]) -> None: ...

global___GetStreamLineRequest = GetStreamLineRequest

@typing.final
class ListStreamLinesRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CHANNEL_ID_FIELD_NUMBER: builtins.int
    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    ORDER_BY_FIELD_NUMBER: builtins.int
    FILTER_FIELD_NUMBER: builtins.int
    channel_id: builtins.str
    """ID of the channel containing the stream lines to list."""
    page_size: builtins.int
    """The maximum number of stream lines to return per page."""
    page_token: builtins.str
    """Page token for retrieving the next page of results.
    This token is obtained from the next_page_token field in the previous ListStreamLinesResponse.
    """
    order_by: builtins.str
    """Specifies the ordering of results.
    Format is "<field> <order>" (e.g., "createdAt desc").
    Default: "id asc".
    Supported fields: ["id", "title", "createdAt", "updatedAt"].
    Both snake_case and camelCase field names are supported.
    """
    filter: builtins.str
    """Filter expression to narrow down the list of returned stream lines.
    Expressions consist of terms connected by logical operators.
    Values containing spaces or quotes must be enclosed in quotes (`'` or `"`)
    with inner quotes being backslash-escaped.

    Supported logical operators: ["AND", "OR"].
    Supported comparison operators: ["=", "!=", ":"] where ":" enables substring matching.
    Parentheses can be used to group logical expressions.

    Example: `title:'main' AND id='line-1'`

    Filterable fields: ["id", "title"].
    Both snake_case and camelCase field names are supported.
    """
    def __init__(
        self,
        *,
        channel_id: builtins.str = ...,
        page_size: builtins.int = ...,
        page_token: builtins.str = ...,
        order_by: builtins.str = ...,
        filter: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["channel_id", b"channel_id", "filter", b"filter", "order_by", b"order_by", "page_size", b"page_size", "page_token", b"page_token"]) -> None: ...

global___ListStreamLinesRequest = ListStreamLinesRequest

@typing.final
class ListStreamLinesResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    STREAM_LINES_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    next_page_token: builtins.str
    """Token for retrieving the next page of results.
    Empty if there are no more results available.
    """
    @property
    def stream_lines(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.video.v1.stream_line_pb2.StreamLine]:
        """List of stream lines matching the request criteria.
        May be empty if no stream lines match the criteria or if the channel has no stream lines.
        """

    def __init__(
        self,
        *,
        stream_lines: collections.abc.Iterable[yandex.cloud.video.v1.stream_line_pb2.StreamLine] | None = ...,
        next_page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["next_page_token", b"next_page_token", "stream_lines", b"stream_lines"]) -> None: ...

global___ListStreamLinesResponse = ListStreamLinesResponse

@typing.final
class BatchGetStreamLinesRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CHANNEL_ID_FIELD_NUMBER: builtins.int
    STREAM_LINE_IDS_FIELD_NUMBER: builtins.int
    channel_id: builtins.str
    """ID of the channel containing the stream lines to retrieve."""
    @property
    def stream_line_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """List of stream line IDs to retrieve."""

    def __init__(
        self,
        *,
        channel_id: builtins.str = ...,
        stream_line_ids: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["channel_id", b"channel_id", "stream_line_ids", b"stream_line_ids"]) -> None: ...

global___BatchGetStreamLinesRequest = BatchGetStreamLinesRequest

@typing.final
class BatchGetStreamLinesResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    STREAM_LINES_FIELD_NUMBER: builtins.int
    @property
    def stream_lines(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.video.v1.stream_line_pb2.StreamLine]:
        """List of stream lines matching the requested IDs."""

    def __init__(
        self,
        *,
        stream_lines: collections.abc.Iterable[yandex.cloud.video.v1.stream_line_pb2.StreamLine] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["stream_lines", b"stream_lines"]) -> None: ...

global___BatchGetStreamLinesResponse = BatchGetStreamLinesResponse

@typing.final
class CreateStreamLineRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class LabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    CHANNEL_ID_FIELD_NUMBER: builtins.int
    TITLE_FIELD_NUMBER: builtins.int
    RTMP_PUSH_FIELD_NUMBER: builtins.int
    RTMP_PULL_FIELD_NUMBER: builtins.int
    MANUAL_LINE_FIELD_NUMBER: builtins.int
    AUTO_LINE_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    channel_id: builtins.str
    """ID of the channel."""
    title: builtins.str
    """Line title."""
    @property
    def rtmp_push(self) -> global___RTMPPushParams:
        """RTMP push input type."""

    @property
    def rtmp_pull(self) -> global___RTMPPullParams:
        """RTMP pull input type."""

    @property
    def manual_line(self) -> global___ManualLineParams:
        """Manual stream control."""

    @property
    def auto_line(self) -> global___AutoLineParams:
        """Automatic stream control."""

    @property
    def labels(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Custom user-defined labels as key:value pairs.
        Maximum 64 labels per stream line.
        Keys must be lowercase alphanumeric strings with optional hyphens/underscores.
        Values can contain alphanumeric characters and various symbols.
        """

    def __init__(
        self,
        *,
        channel_id: builtins.str = ...,
        title: builtins.str = ...,
        rtmp_push: global___RTMPPushParams | None = ...,
        rtmp_pull: global___RTMPPullParams | None = ...,
        manual_line: global___ManualLineParams | None = ...,
        auto_line: global___AutoLineParams | None = ...,
        labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["auto_line", b"auto_line", "input_params", b"input_params", "line_type_params", b"line_type_params", "manual_line", b"manual_line", "rtmp_pull", b"rtmp_pull", "rtmp_push", b"rtmp_push"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["auto_line", b"auto_line", "channel_id", b"channel_id", "input_params", b"input_params", "labels", b"labels", "line_type_params", b"line_type_params", "manual_line", b"manual_line", "rtmp_pull", b"rtmp_pull", "rtmp_push", b"rtmp_push", "title", b"title"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["input_params", b"input_params"]) -> typing.Literal["rtmp_push", "rtmp_pull"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["line_type_params", b"line_type_params"]) -> typing.Literal["manual_line", "auto_line"] | None: ...

global___CreateStreamLineRequest = CreateStreamLineRequest

@typing.final
class CreateStreamLineMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    STREAM_LINE_ID_FIELD_NUMBER: builtins.int
    stream_line_id: builtins.str
    """ID of the stream line."""
    def __init__(
        self,
        *,
        stream_line_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["stream_line_id", b"stream_line_id"]) -> None: ...

global___CreateStreamLineMetadata = CreateStreamLineMetadata

@typing.final
class UpdateStreamLineRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class LabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    STREAM_LINE_ID_FIELD_NUMBER: builtins.int
    FIELD_MASK_FIELD_NUMBER: builtins.int
    TITLE_FIELD_NUMBER: builtins.int
    RTMP_PUSH_FIELD_NUMBER: builtins.int
    RTMP_PULL_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    stream_line_id: builtins.str
    """ID of the line."""
    title: builtins.str
    """Line title."""
    @property
    def field_mask(self) -> google.protobuf.field_mask_pb2.FieldMask:
        """Field mask specifying which fields of the stream line should be updated.
        Only fields specified in this mask will be modified;
        all other fields will retain their current values.
        This allows for partial updates.
        """

    @property
    def rtmp_push(self) -> global___RTMPPushParams:
        """RTMP push input type."""

    @property
    def rtmp_pull(self) -> global___RTMPPullParams:
        """RTMP pull input type."""

    @property
    def labels(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """New custom labels for the stream line as `key:value` pairs.
        Maximum 64 labels per stream line.
        If provided, replaces all existing labels.
        """

    def __init__(
        self,
        *,
        stream_line_id: builtins.str = ...,
        field_mask: google.protobuf.field_mask_pb2.FieldMask | None = ...,
        title: builtins.str = ...,
        rtmp_push: global___RTMPPushParams | None = ...,
        rtmp_pull: global___RTMPPullParams | None = ...,
        labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["field_mask", b"field_mask", "input_params", b"input_params", "rtmp_pull", b"rtmp_pull", "rtmp_push", b"rtmp_push"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["field_mask", b"field_mask", "input_params", b"input_params", "labels", b"labels", "rtmp_pull", b"rtmp_pull", "rtmp_push", b"rtmp_push", "stream_line_id", b"stream_line_id", "title", b"title"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["input_params", b"input_params"]) -> typing.Literal["rtmp_push", "rtmp_pull"] | None: ...

global___UpdateStreamLineRequest = UpdateStreamLineRequest

@typing.final
class UpdateStreamLineMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    STREAM_LINE_ID_FIELD_NUMBER: builtins.int
    stream_line_id: builtins.str
    """ID of the stream line."""
    def __init__(
        self,
        *,
        stream_line_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["stream_line_id", b"stream_line_id"]) -> None: ...

global___UpdateStreamLineMetadata = UpdateStreamLineMetadata

@typing.final
class DeleteStreamLineRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    STREAM_LINE_ID_FIELD_NUMBER: builtins.int
    stream_line_id: builtins.str
    """ID of the stream line to delete."""
    def __init__(
        self,
        *,
        stream_line_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["stream_line_id", b"stream_line_id"]) -> None: ...

global___DeleteStreamLineRequest = DeleteStreamLineRequest

@typing.final
class DeleteStreamLineMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    STREAM_LINE_ID_FIELD_NUMBER: builtins.int
    stream_line_id: builtins.str
    """ID of the stream line.
    This identifier can be used to track the stream line deletion operation.
    """
    def __init__(
        self,
        *,
        stream_line_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["stream_line_id", b"stream_line_id"]) -> None: ...

global___DeleteStreamLineMetadata = DeleteStreamLineMetadata

@typing.final
class BatchDeleteStreamLinesRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CHANNEL_ID_FIELD_NUMBER: builtins.int
    STREAM_LINE_IDS_FIELD_NUMBER: builtins.int
    channel_id: builtins.str
    """ID of the channel containing the stream lines to delete."""
    @property
    def stream_line_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """List of stream line IDs to delete.
        All stream lines must exist in the specified channel.
        """

    def __init__(
        self,
        *,
        channel_id: builtins.str = ...,
        stream_line_ids: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["channel_id", b"channel_id", "stream_line_ids", b"stream_line_ids"]) -> None: ...

global___BatchDeleteStreamLinesRequest = BatchDeleteStreamLinesRequest

@typing.final
class BatchDeleteStreamLinesMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    STREAM_LINE_IDS_FIELD_NUMBER: builtins.int
    @property
    def stream_line_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """List of stream line IDs being deleted.
        This list can be used to track which stream lines are included
        in the batch deletion operation.
        """

    def __init__(
        self,
        *,
        stream_line_ids: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["stream_line_ids", b"stream_line_ids"]) -> None: ...

global___BatchDeleteStreamLinesMetadata = BatchDeleteStreamLinesMetadata

@typing.final
class PerformLineActionRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    STREAM_LINE_ID_FIELD_NUMBER: builtins.int
    ACTIVATE_FIELD_NUMBER: builtins.int
    DEACTIVATE_FIELD_NUMBER: builtins.int
    stream_line_id: builtins.str
    """ID of the stream line on which to perform the action."""
    @property
    def activate(self) -> global___ActivateAction:
        """Activate the stream line, enabling it to receive and process video signals.
        This is typically used for automatic stream lines.
        """

    @property
    def deactivate(self) -> global___DeactivateAction:
        """Deactivate the stream line, disabling it from receiving and processing video signals.
        This is typically used for automatic stream lines.
        """

    def __init__(
        self,
        *,
        stream_line_id: builtins.str = ...,
        activate: global___ActivateAction | None = ...,
        deactivate: global___DeactivateAction | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["action", b"action", "activate", b"activate", "deactivate", b"deactivate"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["action", b"action", "activate", b"activate", "deactivate", b"deactivate", "stream_line_id", b"stream_line_id"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["action", b"action"]) -> typing.Literal["activate", "deactivate"] | None: ...

global___PerformLineActionRequest = PerformLineActionRequest

@typing.final
class PerformLineActionMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    STREAM_LINE_ID_FIELD_NUMBER: builtins.int
    stream_line_id: builtins.str
    """ID of the stream line on which the action is being performed.
    This identifier can be used to track the action operation
    and to verify that the action is being applied to the correct stream line.
    """
    def __init__(
        self,
        *,
        stream_line_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["stream_line_id", b"stream_line_id"]) -> None: ...

global___PerformLineActionMetadata = PerformLineActionMetadata

@typing.final
class RTMPPushParams(google.protobuf.message.Message):
    """Parameters for creating an RTMP push input type stream line."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___RTMPPushParams = RTMPPushParams

@typing.final
class RTMPPullParams(google.protobuf.message.Message):
    """Parameters for creating an RTMP pull input type stream line."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    URL_FIELD_NUMBER: builtins.int
    url: builtins.str
    """The RTMP URL from which to pull the video stream.
    Must be a valid RTMP URL starting with "rtmp://".
    """
    def __init__(
        self,
        *,
        url: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["url", b"url"]) -> None: ...

global___RTMPPullParams = RTMPPullParams

@typing.final
class ManualLineParams(google.protobuf.message.Message):
    """Parameters for manual stream line."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___ManualLineParams = ManualLineParams

@typing.final
class AutoLineParams(google.protobuf.message.Message):
    """Parameters for auto stream line."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___AutoLineParams = AutoLineParams

@typing.final
class ActivateAction(google.protobuf.message.Message):
    """Parameters for the activate action."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___ActivateAction = ActivateAction

@typing.final
class DeactivateAction(google.protobuf.message.Message):
    """Parameters for the deactivate action."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___DeactivateAction = DeactivateAction

@typing.final
class GetStreamKeyRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    STREAM_LINE_ID_FIELD_NUMBER: builtins.int
    stream_line_id: builtins.str
    """ID of the stream line for which to retrieve the stream key.
    The stream line must be a push-type input (RTMP push or SRT push).
    """
    def __init__(
        self,
        *,
        stream_line_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["stream_line_id", b"stream_line_id"]) -> None: ...

global___GetStreamKeyRequest = GetStreamKeyRequest

@typing.final
class UpdateStreamKeyRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    STREAM_LINE_ID_FIELD_NUMBER: builtins.int
    stream_line_id: builtins.str
    """ID of the stream line for which to update the stream key.
    The stream line must be a push-type input (RTMP push or SRT push).
    """
    def __init__(
        self,
        *,
        stream_line_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["stream_line_id", b"stream_line_id"]) -> None: ...

global___UpdateStreamKeyRequest = UpdateStreamKeyRequest

@typing.final
class UpdateStreamKeyMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    STREAM_LINE_ID_FIELD_NUMBER: builtins.int
    stream_line_id: builtins.str
    """ID of the stream line."""
    def __init__(
        self,
        *,
        stream_line_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["stream_line_id", b"stream_line_id"]) -> None: ...

global___UpdateStreamKeyMetadata = UpdateStreamKeyMetadata
