"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import abc
import collections.abc
import grpc
import grpc.aio
import typing
import yandex.cloud.operation.operation_pb2
import yandex.cloud.video.v1.stream_line_pb2
import yandex.cloud.video.v1.stream_line_service_pb2

_T = typing.TypeVar("_T")

class _MaybeAsyncIterator(collections.abc.AsyncIterator[_T], collections.abc.Iterator[_T], metaclass=abc.ABCMeta): ...

class _ServicerContext(grpc.ServicerContext, grpc.aio.ServicerContext):  # type: ignore[misc, type-arg]
    ...

class StreamLineServiceStub:
    """Stream line management service.
    Provides methods for creating, retrieving, updating, and deleting stream lines,
    which define the technical configuration for receiving and processing video signals.
    """

    def __init__(self, channel: typing.Union[grpc.Channel, grpc.aio.Channel]) -> None: ...
    Get: grpc.UnaryUnaryMultiCallable[
        yandex.cloud.video.v1.stream_line_service_pb2.GetStreamLineRequest,
        yandex.cloud.video.v1.stream_line_pb2.StreamLine,
    ]
    """Retrieves detailed information about a specific stream line by its ID.
    Returns all stream line metadata, configuration, and related information.
    """

    List: grpc.UnaryUnaryMultiCallable[
        yandex.cloud.video.v1.stream_line_service_pb2.ListStreamLinesRequest,
        yandex.cloud.video.v1.stream_line_service_pb2.ListStreamLinesResponse,
    ]
    """Lists all stream lines in a specific channel with pagination support.
    Results can be filtered and sorted using the provided parameters.
    """

    BatchGet: grpc.UnaryUnaryMultiCallable[
        yandex.cloud.video.v1.stream_line_service_pb2.BatchGetStreamLinesRequest,
        yandex.cloud.video.v1.stream_line_service_pb2.BatchGetStreamLinesResponse,
    ]
    """Retrieves multiple stream lines by their IDs in a specific channel in a single request.
    This is more efficient than making multiple Get requests when retrieving several stream lines.
    """

    Create: grpc.UnaryUnaryMultiCallable[
        yandex.cloud.video.v1.stream_line_service_pb2.CreateStreamLineRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Creates a new stream line in the specified channel with the provided configuration.
    Stream lines define the technical settings for receiving and processing video signals.
    """

    Update: grpc.UnaryUnaryMultiCallable[
        yandex.cloud.video.v1.stream_line_service_pb2.UpdateStreamLineRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Updates an existing stream line's metadata and configuration.
    Only fields specified in the field_mask will be updated.
    """

    Delete: grpc.UnaryUnaryMultiCallable[
        yandex.cloud.video.v1.stream_line_service_pb2.DeleteStreamLineRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Deletes a specific stream line by its ID."""

    BatchDelete: grpc.UnaryUnaryMultiCallable[
        yandex.cloud.video.v1.stream_line_service_pb2.BatchDeleteStreamLinesRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Deletes multiple stream lines in a specific channel in a single request.
    This is more efficient than making multiple Delete requests when removing several stream lines.
    """

    PerformAction: grpc.UnaryUnaryMultiCallable[
        yandex.cloud.video.v1.stream_line_service_pb2.PerformLineActionRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Performs a specific action on a stream line, such as activation or deactivation.
    Actions change the stream line's state without modifying its configuration.
    """

    GetStreamKey: grpc.UnaryUnaryMultiCallable[
        yandex.cloud.video.v1.stream_line_service_pb2.GetStreamKeyRequest,
        yandex.cloud.video.v1.stream_line_pb2.PushStreamKey,
    ]
    """Retrieves the unique stream key for a push-type stream line.
    This key is used to authenticate when pushing video streams to the platform.
    """

    UpdateStreamKey: grpc.UnaryUnaryMultiCallable[
        yandex.cloud.video.v1.stream_line_service_pb2.UpdateStreamKeyRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Regenerates and updates the stream key for a push-type stream line.
    This is useful for security purposes when the existing key may be compromised.
    """

class StreamLineServiceAsyncStub:
    """Stream line management service.
    Provides methods for creating, retrieving, updating, and deleting stream lines,
    which define the technical configuration for receiving and processing video signals.
    """

    Get: grpc.aio.UnaryUnaryMultiCallable[
        yandex.cloud.video.v1.stream_line_service_pb2.GetStreamLineRequest,
        yandex.cloud.video.v1.stream_line_pb2.StreamLine,
    ]
    """Retrieves detailed information about a specific stream line by its ID.
    Returns all stream line metadata, configuration, and related information.
    """

    List: grpc.aio.UnaryUnaryMultiCallable[
        yandex.cloud.video.v1.stream_line_service_pb2.ListStreamLinesRequest,
        yandex.cloud.video.v1.stream_line_service_pb2.ListStreamLinesResponse,
    ]
    """Lists all stream lines in a specific channel with pagination support.
    Results can be filtered and sorted using the provided parameters.
    """

    BatchGet: grpc.aio.UnaryUnaryMultiCallable[
        yandex.cloud.video.v1.stream_line_service_pb2.BatchGetStreamLinesRequest,
        yandex.cloud.video.v1.stream_line_service_pb2.BatchGetStreamLinesResponse,
    ]
    """Retrieves multiple stream lines by their IDs in a specific channel in a single request.
    This is more efficient than making multiple Get requests when retrieving several stream lines.
    """

    Create: grpc.aio.UnaryUnaryMultiCallable[
        yandex.cloud.video.v1.stream_line_service_pb2.CreateStreamLineRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Creates a new stream line in the specified channel with the provided configuration.
    Stream lines define the technical settings for receiving and processing video signals.
    """

    Update: grpc.aio.UnaryUnaryMultiCallable[
        yandex.cloud.video.v1.stream_line_service_pb2.UpdateStreamLineRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Updates an existing stream line's metadata and configuration.
    Only fields specified in the field_mask will be updated.
    """

    Delete: grpc.aio.UnaryUnaryMultiCallable[
        yandex.cloud.video.v1.stream_line_service_pb2.DeleteStreamLineRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Deletes a specific stream line by its ID."""

    BatchDelete: grpc.aio.UnaryUnaryMultiCallable[
        yandex.cloud.video.v1.stream_line_service_pb2.BatchDeleteStreamLinesRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Deletes multiple stream lines in a specific channel in a single request.
    This is more efficient than making multiple Delete requests when removing several stream lines.
    """

    PerformAction: grpc.aio.UnaryUnaryMultiCallable[
        yandex.cloud.video.v1.stream_line_service_pb2.PerformLineActionRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Performs a specific action on a stream line, such as activation or deactivation.
    Actions change the stream line's state without modifying its configuration.
    """

    GetStreamKey: grpc.aio.UnaryUnaryMultiCallable[
        yandex.cloud.video.v1.stream_line_service_pb2.GetStreamKeyRequest,
        yandex.cloud.video.v1.stream_line_pb2.PushStreamKey,
    ]
    """Retrieves the unique stream key for a push-type stream line.
    This key is used to authenticate when pushing video streams to the platform.
    """

    UpdateStreamKey: grpc.aio.UnaryUnaryMultiCallable[
        yandex.cloud.video.v1.stream_line_service_pb2.UpdateStreamKeyRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Regenerates and updates the stream key for a push-type stream line.
    This is useful for security purposes when the existing key may be compromised.
    """

class StreamLineServiceServicer(metaclass=abc.ABCMeta):
    """Stream line management service.
    Provides methods for creating, retrieving, updating, and deleting stream lines,
    which define the technical configuration for receiving and processing video signals.
    """

    @abc.abstractmethod
    def Get(
        self,
        request: yandex.cloud.video.v1.stream_line_service_pb2.GetStreamLineRequest,
        context: _ServicerContext,
    ) -> typing.Union[yandex.cloud.video.v1.stream_line_pb2.StreamLine, collections.abc.Awaitable[yandex.cloud.video.v1.stream_line_pb2.StreamLine]]:
        """Retrieves detailed information about a specific stream line by its ID.
        Returns all stream line metadata, configuration, and related information.
        """

    @abc.abstractmethod
    def List(
        self,
        request: yandex.cloud.video.v1.stream_line_service_pb2.ListStreamLinesRequest,
        context: _ServicerContext,
    ) -> typing.Union[yandex.cloud.video.v1.stream_line_service_pb2.ListStreamLinesResponse, collections.abc.Awaitable[yandex.cloud.video.v1.stream_line_service_pb2.ListStreamLinesResponse]]:
        """Lists all stream lines in a specific channel with pagination support.
        Results can be filtered and sorted using the provided parameters.
        """

    @abc.abstractmethod
    def BatchGet(
        self,
        request: yandex.cloud.video.v1.stream_line_service_pb2.BatchGetStreamLinesRequest,
        context: _ServicerContext,
    ) -> typing.Union[yandex.cloud.video.v1.stream_line_service_pb2.BatchGetStreamLinesResponse, collections.abc.Awaitable[yandex.cloud.video.v1.stream_line_service_pb2.BatchGetStreamLinesResponse]]:
        """Retrieves multiple stream lines by their IDs in a specific channel in a single request.
        This is more efficient than making multiple Get requests when retrieving several stream lines.
        """

    @abc.abstractmethod
    def Create(
        self,
        request: yandex.cloud.video.v1.stream_line_service_pb2.CreateStreamLineRequest,
        context: _ServicerContext,
    ) -> typing.Union[yandex.cloud.operation.operation_pb2.Operation, collections.abc.Awaitable[yandex.cloud.operation.operation_pb2.Operation]]:
        """Creates a new stream line in the specified channel with the provided configuration.
        Stream lines define the technical settings for receiving and processing video signals.
        """

    @abc.abstractmethod
    def Update(
        self,
        request: yandex.cloud.video.v1.stream_line_service_pb2.UpdateStreamLineRequest,
        context: _ServicerContext,
    ) -> typing.Union[yandex.cloud.operation.operation_pb2.Operation, collections.abc.Awaitable[yandex.cloud.operation.operation_pb2.Operation]]:
        """Updates an existing stream line's metadata and configuration.
        Only fields specified in the field_mask will be updated.
        """

    @abc.abstractmethod
    def Delete(
        self,
        request: yandex.cloud.video.v1.stream_line_service_pb2.DeleteStreamLineRequest,
        context: _ServicerContext,
    ) -> typing.Union[yandex.cloud.operation.operation_pb2.Operation, collections.abc.Awaitable[yandex.cloud.operation.operation_pb2.Operation]]:
        """Deletes a specific stream line by its ID."""

    @abc.abstractmethod
    def BatchDelete(
        self,
        request: yandex.cloud.video.v1.stream_line_service_pb2.BatchDeleteStreamLinesRequest,
        context: _ServicerContext,
    ) -> typing.Union[yandex.cloud.operation.operation_pb2.Operation, collections.abc.Awaitable[yandex.cloud.operation.operation_pb2.Operation]]:
        """Deletes multiple stream lines in a specific channel in a single request.
        This is more efficient than making multiple Delete requests when removing several stream lines.
        """

    @abc.abstractmethod
    def PerformAction(
        self,
        request: yandex.cloud.video.v1.stream_line_service_pb2.PerformLineActionRequest,
        context: _ServicerContext,
    ) -> typing.Union[yandex.cloud.operation.operation_pb2.Operation, collections.abc.Awaitable[yandex.cloud.operation.operation_pb2.Operation]]:
        """Performs a specific action on a stream line, such as activation or deactivation.
        Actions change the stream line's state without modifying its configuration.
        """

    @abc.abstractmethod
    def GetStreamKey(
        self,
        request: yandex.cloud.video.v1.stream_line_service_pb2.GetStreamKeyRequest,
        context: _ServicerContext,
    ) -> typing.Union[yandex.cloud.video.v1.stream_line_pb2.PushStreamKey, collections.abc.Awaitable[yandex.cloud.video.v1.stream_line_pb2.PushStreamKey]]:
        """Retrieves the unique stream key for a push-type stream line.
        This key is used to authenticate when pushing video streams to the platform.
        """

    @abc.abstractmethod
    def UpdateStreamKey(
        self,
        request: yandex.cloud.video.v1.stream_line_service_pb2.UpdateStreamKeyRequest,
        context: _ServicerContext,
    ) -> typing.Union[yandex.cloud.operation.operation_pb2.Operation, collections.abc.Awaitable[yandex.cloud.operation.operation_pb2.Operation]]:
        """Regenerates and updates the stream key for a push-type stream line.
        This is useful for security purposes when the existing key may be compromised.
        """

def add_StreamLineServiceServicer_to_server(servicer: StreamLineServiceServicer, server: typing.Union[grpc.Server, grpc.aio.Server]) -> None: ...
