"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.field_mask_pb2
import google.protobuf.internal.containers
import google.protobuf.message
import google.protobuf.timestamp_pb2
import google.protobuf.wrappers_pb2
import typing
import yandex.cloud.video.v1.stream_pb2

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class GetStreamRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    STREAM_ID_FIELD_NUMBER: builtins.int
    stream_id: builtins.str
    """ID of the stream to retrieve."""
    def __init__(
        self,
        *,
        stream_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["stream_id", b"stream_id"]) -> None: ...

global___GetStreamRequest = GetStreamRequest

@typing.final
class ListStreamsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CHANNEL_ID_FIELD_NUMBER: builtins.int
    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    ORDER_BY_FIELD_NUMBER: builtins.int
    FILTER_FIELD_NUMBER: builtins.int
    channel_id: builtins.str
    """ID of the channel containing the streams to list."""
    page_size: builtins.int
    """The maximum number of streams to return per page."""
    page_token: builtins.str
    """Page token for retrieving the next page of results.
    This token is obtained from the next_page_token field in the previous ListStreamsResponse.
    """
    order_by: builtins.str
    """Specifies the ordering of results.
    Format is "<field> <order>" (e.g., "startTime desc").
    Default: "id asc".
    Supported fields: ["id", "title", "startTime", "finishTime", "createdAt", "updatedAt"].
    Both snake_case and camelCase field names are supported.
    """
    filter: builtins.str
    """Filter expression to narrow down the list of returned streams.
    Expressions consist of terms connected by logical operators.
    Values containing spaces or quotes must be enclosed in quotes (`'` or `"`)
    with inner quotes being backslash-escaped.

    Supported logical operators: ["AND", "OR"].
    Supported comparison operators: ["=", "!=", ":"] where ":" enables substring matching.
    Parentheses can be used to group logical expressions.

    Example: `title:'live' AND (status='READY' OR status='ONAIR')`

    Filterable fields: ["id", "title", "lineId", "status"].
    Both snake_case and camelCase field names are supported.
    """
    def __init__(
        self,
        *,
        channel_id: builtins.str = ...,
        page_size: builtins.int = ...,
        page_token: builtins.str = ...,
        order_by: builtins.str = ...,
        filter: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["channel_id", b"channel_id", "filter", b"filter", "order_by", b"order_by", "page_size", b"page_size", "page_token", b"page_token"]) -> None: ...

global___ListStreamsRequest = ListStreamsRequest

@typing.final
class ListStreamsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    STREAMS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    next_page_token: builtins.str
    """Token for retrieving the next page of results.
    Empty if there are no more results available.
    """
    @property
    def streams(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.video.v1.stream_pb2.Stream]:
        """List of streams matching the request criteria.
        May be empty if no streams match the criteria or if the channel has no streams.
        """

    def __init__(
        self,
        *,
        streams: collections.abc.Iterable[yandex.cloud.video.v1.stream_pb2.Stream] | None = ...,
        next_page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["next_page_token", b"next_page_token", "streams", b"streams"]) -> None: ...

global___ListStreamsResponse = ListStreamsResponse

@typing.final
class BatchGetStreamsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CHANNEL_ID_FIELD_NUMBER: builtins.int
    STREAM_IDS_FIELD_NUMBER: builtins.int
    channel_id: builtins.str
    """ID of the channel containing the streams to retrieve."""
    @property
    def stream_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """List of stream IDs to retrieve."""

    def __init__(
        self,
        *,
        channel_id: builtins.str = ...,
        stream_ids: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["channel_id", b"channel_id", "stream_ids", b"stream_ids"]) -> None: ...

global___BatchGetStreamsRequest = BatchGetStreamsRequest

@typing.final
class BatchGetStreamsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    STREAMS_FIELD_NUMBER: builtins.int
    @property
    def streams(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.video.v1.stream_pb2.Stream]:
        """List of streams matching the requested IDs."""

    def __init__(
        self,
        *,
        streams: collections.abc.Iterable[yandex.cloud.video.v1.stream_pb2.Stream] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["streams", b"streams"]) -> None: ...

global___BatchGetStreamsResponse = BatchGetStreamsResponse

@typing.final
class CreateStreamRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class LabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    CHANNEL_ID_FIELD_NUMBER: builtins.int
    LINE_ID_FIELD_NUMBER: builtins.int
    TITLE_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    THUMBNAIL_ID_FIELD_NUMBER: builtins.int
    AUTO_PUBLISH_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    ON_DEMAND_FIELD_NUMBER: builtins.int
    SCHEDULE_FIELD_NUMBER: builtins.int
    channel_id: builtins.str
    """ID of the channel where the stream will be created."""
    line_id: builtins.str
    """ID of the stream line to which this stream will be linked.
    Stream lines define the technical configuration for streaming.
    """
    title: builtins.str
    """Title of the stream to be displayed in interfaces and players."""
    description: builtins.str
    """Detailed description of the stream content and context.
    Optional field that can provide additional information about the stream.
    """
    thumbnail_id: builtins.str
    """ID of the thumbnail image to be used for the stream."""
    @property
    def auto_publish(self) -> google.protobuf.wrappers_pb2.BoolValue:
        """Controls whether the stream is automatically published when ready.
        When set to true, the stream's status will automatically change from
        READY to ONAIR when the streaming infrastructure is prepared,
        making it available for viewing without manual intervention.
        """

    @property
    def labels(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Custom user-defined labels as `key:value` pairs.
        Maximum 64 labels per stream.
        Keys must be lowercase alphanumeric strings with optional hyphens/underscores.
        Values can contain alphanumeric characters and various symbols.
        """

    @property
    def on_demand(self) -> global___OnDemandParams:
        """On-demand stream that starts immediately when a video signal appears.
        This type of stream has no predetermined start or end time.
        """

    @property
    def schedule(self) -> global___ScheduleParams:
        """Scheduled stream that starts and finishes at specified time.
        This type of stream has predetermined start and end time.
        """

    def __init__(
        self,
        *,
        channel_id: builtins.str = ...,
        line_id: builtins.str = ...,
        title: builtins.str = ...,
        description: builtins.str = ...,
        thumbnail_id: builtins.str = ...,
        auto_publish: google.protobuf.wrappers_pb2.BoolValue | None = ...,
        labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        on_demand: global___OnDemandParams | None = ...,
        schedule: global___ScheduleParams | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["auto_publish", b"auto_publish", "on_demand", b"on_demand", "schedule", b"schedule", "stream_type", b"stream_type"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["auto_publish", b"auto_publish", "channel_id", b"channel_id", "description", b"description", "labels", b"labels", "line_id", b"line_id", "on_demand", b"on_demand", "schedule", b"schedule", "stream_type", b"stream_type", "thumbnail_id", b"thumbnail_id", "title", b"title"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["stream_type", b"stream_type"]) -> typing.Literal["on_demand", "schedule"] | None: ...

global___CreateStreamRequest = CreateStreamRequest

@typing.final
class OnDemandParams(google.protobuf.message.Message):
    """On-demand streams start automatically when a video signal is detected
    and must be manually stopped when no longer needed.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___OnDemandParams = OnDemandParams

@typing.final
class ScheduleParams(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    START_TIME_FIELD_NUMBER: builtins.int
    FINISH_TIME_FIELD_NUMBER: builtins.int
    @property
    def start_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Scheduled time when the stream should automatically start.
        The streaming infrastructure will be prepared at this time
        and will begin accepting the video signal.
        """

    @property
    def finish_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Scheduled time when the stream should automatically finish.
        The streaming infrastructure will be shut down at this time
        and the stream will be marked as FINISHED.
        """

    def __init__(
        self,
        *,
        start_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        finish_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["finish_time", b"finish_time", "start_time", b"start_time"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["finish_time", b"finish_time", "start_time", b"start_time"]) -> None: ...

global___ScheduleParams = ScheduleParams

@typing.final
class CreateStreamMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    STREAM_ID_FIELD_NUMBER: builtins.int
    stream_id: builtins.str
    """ID of the stream being created."""
    def __init__(
        self,
        *,
        stream_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["stream_id", b"stream_id"]) -> None: ...

global___CreateStreamMetadata = CreateStreamMetadata

@typing.final
class UpdateStreamRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class LabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    STREAM_ID_FIELD_NUMBER: builtins.int
    FIELD_MASK_FIELD_NUMBER: builtins.int
    LINE_ID_FIELD_NUMBER: builtins.int
    TITLE_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    THUMBNAIL_ID_FIELD_NUMBER: builtins.int
    AUTO_PUBLISH_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    ON_DEMAND_FIELD_NUMBER: builtins.int
    SCHEDULE_FIELD_NUMBER: builtins.int
    stream_id: builtins.str
    """ID of the stream."""
    line_id: builtins.str
    """DEPRECATED."""
    title: builtins.str
    """Stream title."""
    description: builtins.str
    """Stream description."""
    thumbnail_id: builtins.str
    """ID of the thumbnail."""
    @property
    def field_mask(self) -> google.protobuf.field_mask_pb2.FieldMask:
        """Field mask specifying which fields of the stream should be updated.
        Only fields specified in this mask will be modified;
        all other fields will retain their current values.
        This allows for partial updates.
        """

    @property
    def auto_publish(self) -> google.protobuf.wrappers_pb2.BoolValue:
        """Automatically publish stream when ready.
        Switches status from READY to ONAIR.
        """

    @property
    def labels(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """New custom labels for the stream as `key:value` pairs.
        Maximum 64 labels per stream.
        If provided, replaces all existing labels.
        """

    @property
    def on_demand(self) -> global___OnDemandParams:
        """On demand stream.
        It starts immediately when a signal appears.
        """

    @property
    def schedule(self) -> global___ScheduleParams:
        """Scheduled stream.
        It starts and finishes at specified time.
        """

    def __init__(
        self,
        *,
        stream_id: builtins.str = ...,
        field_mask: google.protobuf.field_mask_pb2.FieldMask | None = ...,
        line_id: builtins.str = ...,
        title: builtins.str = ...,
        description: builtins.str = ...,
        thumbnail_id: builtins.str = ...,
        auto_publish: google.protobuf.wrappers_pb2.BoolValue | None = ...,
        labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        on_demand: global___OnDemandParams | None = ...,
        schedule: global___ScheduleParams | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["auto_publish", b"auto_publish", "field_mask", b"field_mask", "on_demand", b"on_demand", "schedule", b"schedule", "stream_type", b"stream_type"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["auto_publish", b"auto_publish", "description", b"description", "field_mask", b"field_mask", "labels", b"labels", "line_id", b"line_id", "on_demand", b"on_demand", "schedule", b"schedule", "stream_id", b"stream_id", "stream_type", b"stream_type", "thumbnail_id", b"thumbnail_id", "title", b"title"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["stream_type", b"stream_type"]) -> typing.Literal["on_demand", "schedule"] | None: ...

global___UpdateStreamRequest = UpdateStreamRequest

@typing.final
class UpdateStreamMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    STREAM_ID_FIELD_NUMBER: builtins.int
    stream_id: builtins.str
    """ID of the stream."""
    def __init__(
        self,
        *,
        stream_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["stream_id", b"stream_id"]) -> None: ...

global___UpdateStreamMetadata = UpdateStreamMetadata

@typing.final
class DeleteStreamRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    STREAM_ID_FIELD_NUMBER: builtins.int
    stream_id: builtins.str
    """ID of the stream to delete."""
    def __init__(
        self,
        *,
        stream_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["stream_id", b"stream_id"]) -> None: ...

global___DeleteStreamRequest = DeleteStreamRequest

@typing.final
class DeleteStreamMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    STREAM_ID_FIELD_NUMBER: builtins.int
    stream_id: builtins.str
    """ID of the stream.
    This identifier can be used to track the stream deletion operation.
    """
    def __init__(
        self,
        *,
        stream_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["stream_id", b"stream_id"]) -> None: ...

global___DeleteStreamMetadata = DeleteStreamMetadata

@typing.final
class BatchDeleteStreamsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CHANNEL_ID_FIELD_NUMBER: builtins.int
    STREAM_IDS_FIELD_NUMBER: builtins.int
    channel_id: builtins.str
    """ID of the channel containing the streams to delete."""
    @property
    def stream_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """List of stream IDs to delete.
        All streams must exist in the specified channel.
        """

    def __init__(
        self,
        *,
        channel_id: builtins.str = ...,
        stream_ids: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["channel_id", b"channel_id", "stream_ids", b"stream_ids"]) -> None: ...

global___BatchDeleteStreamsRequest = BatchDeleteStreamsRequest

@typing.final
class BatchDeleteStreamsMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    STREAM_IDS_FIELD_NUMBER: builtins.int
    @property
    def stream_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """List of stream IDs being deleted.
        This list can be used to track which streams are included
        in the batch deletion operation.
        """

    def __init__(
        self,
        *,
        stream_ids: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["stream_ids", b"stream_ids"]) -> None: ...

global___BatchDeleteStreamsMetadata = BatchDeleteStreamsMetadata

@typing.final
class PerformStreamActionRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    STREAM_ID_FIELD_NUMBER: builtins.int
    PUBLISH_FIELD_NUMBER: builtins.int
    STOP_FIELD_NUMBER: builtins.int
    stream_id: builtins.str
    """ID of the stream on which to perform the action."""
    @property
    def publish(self) -> global___PublishAction:
        """Publish the stream, changing its status from READY to ONAIR.
        This makes the stream available for watching.
        """

    @property
    def stop(self) -> global___StopAction:
        """Stop the stream, changing its status to FINISHED.
        This terminates the streaming session and releases resources.
        """

    def __init__(
        self,
        *,
        stream_id: builtins.str = ...,
        publish: global___PublishAction | None = ...,
        stop: global___StopAction | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["action", b"action", "publish", b"publish", "stop", b"stop"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["action", b"action", "publish", b"publish", "stop", b"stop", "stream_id", b"stream_id"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["action", b"action"]) -> typing.Literal["publish", "stop"] | None: ...

global___PerformStreamActionRequest = PerformStreamActionRequest

@typing.final
class PublishAction(google.protobuf.message.Message):
    """Parameters for the publish action.
    The action changes the stream's status from READY to ONAIR.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___PublishAction = PublishAction

@typing.final
class StopAction(google.protobuf.message.Message):
    """Parameters for the stop action.
    The action changes the stream's status to FINISHED.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___StopAction = StopAction

@typing.final
class PerformStreamActionMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    STREAM_ID_FIELD_NUMBER: builtins.int
    stream_id: builtins.str
    """ID of the stream on which the action is being performed.
    This identifier can be used to track the action operation
    and to verify that the action is being applied to the correct stream.
    """
    def __init__(
        self,
        *,
        stream_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["stream_id", b"stream_id"]) -> None: ...

global___PerformStreamActionMetadata = PerformStreamActionMetadata
