"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import google.protobuf.descriptor
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.timestamp_pb2
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class Subtitle(google.protobuf.message.Message):
    """Entity representing a subtitle track that can be associated with a video.
    Subtitles provide text versions of the audio content, enabling accessibility
    and multilingual support for video content.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _SubtitleStatus:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _SubtitleStatusEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Subtitle._SubtitleStatus.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        SUBTITLE_STATUS_UNSPECIFIED: Subtitle._SubtitleStatus.ValueType  # 0
        """The subtitle status is not specified."""
        WAIT_UPLOADING: Subtitle._SubtitleStatus.ValueType  # 1
        """The subtitle file upload is in progress, waiting for all bytes to be received."""
        UPLOADED: Subtitle._SubtitleStatus.ValueType  # 2
        """The subtitle file has been fully uploaded and is ready for use."""

    class SubtitleStatus(_SubtitleStatus, metaclass=_SubtitleStatusEnumTypeWrapper):
        """Current processing status of the subtitle."""

    SUBTITLE_STATUS_UNSPECIFIED: Subtitle.SubtitleStatus.ValueType  # 0
    """The subtitle status is not specified."""
    WAIT_UPLOADING: Subtitle.SubtitleStatus.ValueType  # 1
    """The subtitle file upload is in progress, waiting for all bytes to be received."""
    UPLOADED: Subtitle.SubtitleStatus.ValueType  # 2
    """The subtitle file has been fully uploaded and is ready for use."""

    class _SubtitleSourceType:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _SubtitleSourceTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Subtitle._SubtitleSourceType.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        SUBTITLE_SOURCE_TYPE_UNSPECIFIED: Subtitle._SubtitleSourceType.ValueType  # 0
        """The subtitle source type is not specified."""
        MANUAL: Subtitle._SubtitleSourceType.ValueType  # 1
        """The subtitle was manually created and uploaded by a user."""
        GENERATED: Subtitle._SubtitleSourceType.ValueType  # 2
        """The subtitle was automatically generated through speech recognition."""

    class SubtitleSourceType(_SubtitleSourceType, metaclass=_SubtitleSourceTypeEnumTypeWrapper):
        """Source type representing how the subtitle was created or obtained."""

    SUBTITLE_SOURCE_TYPE_UNSPECIFIED: Subtitle.SubtitleSourceType.ValueType  # 0
    """The subtitle source type is not specified."""
    MANUAL: Subtitle.SubtitleSourceType.ValueType  # 1
    """The subtitle was manually created and uploaded by a user."""
    GENERATED: Subtitle.SubtitleSourceType.ValueType  # 2
    """The subtitle was automatically generated through speech recognition."""

    ID_FIELD_NUMBER: builtins.int
    LANGUAGE_FIELD_NUMBER: builtins.int
    LABEL_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    SOURCE_TYPE_FIELD_NUMBER: builtins.int
    FILENAME_FIELD_NUMBER: builtins.int
    CREATED_AT_FIELD_NUMBER: builtins.int
    UPDATED_AT_FIELD_NUMBER: builtins.int
    VIDEO_ID_FIELD_NUMBER: builtins.int
    id: builtins.str
    """Unique identifier of the subtitle track."""
    language: builtins.str
    """Language of the subtitle content according to ISO 639-2/T."""
    label: builtins.str
    """Display label for the subtitle track shown in the video player's subtitle selection menu."""
    status: global___Subtitle.SubtitleStatus.ValueType
    """Current processing status of the subtitle."""
    source_type: global___Subtitle.SubtitleSourceType.ValueType
    """Indicates how the subtitle was created or obtained."""
    filename: builtins.str
    """Original filename of the subtitle file."""
    video_id: builtins.str
    """Identifier of the video this subtitle belongs to."""
    @property
    def created_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Timestamp when the subtitle was initially created in the system."""

    @property
    def updated_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Timestamp of the last modification to the subtitle or its metadata."""

    def __init__(
        self,
        *,
        id: builtins.str = ...,
        language: builtins.str = ...,
        label: builtins.str = ...,
        status: global___Subtitle.SubtitleStatus.ValueType = ...,
        source_type: global___Subtitle.SubtitleSourceType.ValueType = ...,
        filename: builtins.str = ...,
        created_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        updated_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        video_id: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["created_at", b"created_at", "parent_id", b"parent_id", "updated_at", b"updated_at", "video_id", b"video_id"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["created_at", b"created_at", "filename", b"filename", "id", b"id", "label", b"label", "language", b"language", "parent_id", b"parent_id", "source_type", b"source_type", "status", b"status", "updated_at", b"updated_at", "video_id", b"video_id"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["parent_id", b"parent_id"]) -> typing.Literal["video_id"] | None: ...

global___Subtitle = Subtitle
