"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.duration_pb2
import google.protobuf.field_mask_pb2
import google.protobuf.internal.containers
import google.protobuf.message
import google.protobuf.wrappers_pb2
import typing
import yandex.cloud.video.v1.manifest_pb2
import yandex.cloud.video.v1.video_pb2

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class GetVideoRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    VIDEO_ID_FIELD_NUMBER: builtins.int
    video_id: builtins.str
    """ID of the video to retrieve."""
    def __init__(
        self,
        *,
        video_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["video_id", b"video_id"]) -> None: ...

global___GetVideoRequest = GetVideoRequest

@typing.final
class ListVideoRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CHANNEL_ID_FIELD_NUMBER: builtins.int
    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    ORDER_BY_FIELD_NUMBER: builtins.int
    FILTER_FIELD_NUMBER: builtins.int
    channel_id: builtins.str
    """ID of the channel containing the videos to list."""
    page_size: builtins.int
    """The maximum number of videos to return per page."""
    page_token: builtins.str
    """Page token for retrieving the next page of results.
    This token is obtained from the next_page_token field in the previous ListVideoResponse.
    """
    order_by: builtins.str
    """Specifies the ordering of results.
    Format is "<field> <order>" (e.g., "createdAt desc").
    Default: "id asc".
    Supported fields: ["id", "title", "createdAt", "updatedAt"].
    Both snake_case and camelCase field names are supported.
    """
    filter: builtins.str
    """Filter expression to narrow down the list of returned videos.
    Expressions consist of terms connected by logical operators.
    Values containing spaces or quotes must be enclosed in quotes (`'` or `"`)
    with inner quotes being backslash-escaped.

    Supported logical operators: ["AND", "OR"].
    Supported comparison operators: ["=", "!=", ":"] where ":" enables substring matching.
    Parentheses can be used to group logical expressions.

    Example: `title:'sample' AND (status='READY' OR visibilityStatus='PUBLISHED')`

    Filterable fields: ["id", "title", "status", "visibilityStatus"].
    Both snake_case and camelCase field names are supported.
    """
    def __init__(
        self,
        *,
        channel_id: builtins.str = ...,
        page_size: builtins.int = ...,
        page_token: builtins.str = ...,
        order_by: builtins.str = ...,
        filter: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["channel_id", b"channel_id", "filter", b"filter", "order_by", b"order_by", "page_size", b"page_size", "page_token", b"page_token"]) -> None: ...

global___ListVideoRequest = ListVideoRequest

@typing.final
class ListVideoResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    VIDEOS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    next_page_token: builtins.str
    """Token for retrieving the next page of results.
    Empty if there are no more results available.
    """
    @property
    def videos(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.video.v1.video_pb2.Video]:
        """List of videos matching the request criteria.
        May be empty if no videos match the criteria or if the channel is empty.
        """

    def __init__(
        self,
        *,
        videos: collections.abc.Iterable[yandex.cloud.video.v1.video_pb2.Video] | None = ...,
        next_page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["next_page_token", b"next_page_token", "videos", b"videos"]) -> None: ...

global___ListVideoResponse = ListVideoResponse

@typing.final
class BatchGetVideosRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CHANNEL_ID_FIELD_NUMBER: builtins.int
    VIDEO_IDS_FIELD_NUMBER: builtins.int
    channel_id: builtins.str
    """ID of the channel containing the videos to retrieve."""
    @property
    def video_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """List of video IDs to retrieve."""

    def __init__(
        self,
        *,
        channel_id: builtins.str = ...,
        video_ids: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["channel_id", b"channel_id", "video_ids", b"video_ids"]) -> None: ...

global___BatchGetVideosRequest = BatchGetVideosRequest

@typing.final
class BatchGetVideosResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    VIDEOS_FIELD_NUMBER: builtins.int
    @property
    def videos(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.video.v1.video_pb2.Video]:
        """List of videos matching the requested IDs."""

    def __init__(
        self,
        *,
        videos: collections.abc.Iterable[yandex.cloud.video.v1.video_pb2.Video] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["videos", b"videos"]) -> None: ...

global___BatchGetVideosResponse = BatchGetVideosResponse

@typing.final
class CreateVideoRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class LabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    CHANNEL_ID_FIELD_NUMBER: builtins.int
    TITLE_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    THUMBNAIL_ID_FIELD_NUMBER: builtins.int
    AUTO_TRANSCODE_FIELD_NUMBER: builtins.int
    STYLE_PRESET_ID_FIELD_NUMBER: builtins.int
    AUTO_PUBLISH_FIELD_NUMBER: builtins.int
    ENABLE_AD_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    TUSD_FIELD_NUMBER: builtins.int
    PUBLIC_ACCESS_FIELD_NUMBER: builtins.int
    SIGN_URL_ACCESS_FIELD_NUMBER: builtins.int
    channel_id: builtins.str
    """ID of the channel where the video will be created."""
    title: builtins.str
    """Title of the video to be displayed in interfaces and players."""
    description: builtins.str
    """Detailed description of the video content and context.
    Optional field that can provide additional information about the video.
    """
    thumbnail_id: builtins.str
    """ID of the thumbnail image to be used for the video.
    If not provided, a thumbnail may be automatically generated during transcoding.
    """
    auto_transcode: yandex.cloud.video.v1.video_pb2.AutoTranscode.ValueType
    """Controls whether transcoding starts automatically after upload.
    Set to ENABLE to automatically initiate transcoding after upload,
    or DISABLE for manual initiation via the Transcode() method.
    """
    style_preset_id: builtins.str
    """ID of the style preset to apply to the video during processing.
    Style presets define visual appearance settings for the video player.
    """
    @property
    def auto_publish(self) -> google.protobuf.wrappers_pb2.BoolValue:
        """Controls whether the video is automatically published after transcoding.
        When set to true, the video's visibility status will be set to PUBLISHED
        once transcoding is complete, making it available for watching.
        """

    @property
    def enable_ad(self) -> google.protobuf.wrappers_pb2.BoolValue:
        """Controls the ability to display advertisements for this video.
        Default: true
        Set explicitly to false to disable advertisements for this specific video.
        """

    @property
    def labels(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Custom user-defined labels as `key:value` pairs.
        Maximum 64 labels per video.
        Keys must be lowercase alphanumeric strings with optional hyphens/underscores.
        Values can contain alphanumeric characters and various symbols.
        """

    @property
    def tusd(self) -> global___VideoTUSDParams:
        """Upload video using the TUS (Tus Resumable Upload Protocol) protocol.
        This is a push-based upload method where the client pushes data to the server.
        """

    @property
    def public_access(self) -> global___VideoPublicAccessParams:
        """Video is publicly available."""

    @property
    def sign_url_access(self) -> global___VideoSignURLAccessParams:
        """Access to the video is restricted by temporarily signed links."""

    def __init__(
        self,
        *,
        channel_id: builtins.str = ...,
        title: builtins.str = ...,
        description: builtins.str = ...,
        thumbnail_id: builtins.str = ...,
        auto_transcode: yandex.cloud.video.v1.video_pb2.AutoTranscode.ValueType = ...,
        style_preset_id: builtins.str = ...,
        auto_publish: google.protobuf.wrappers_pb2.BoolValue | None = ...,
        enable_ad: google.protobuf.wrappers_pb2.BoolValue | None = ...,
        labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        tusd: global___VideoTUSDParams | None = ...,
        public_access: global___VideoPublicAccessParams | None = ...,
        sign_url_access: global___VideoSignURLAccessParams | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["access_rights", b"access_rights", "auto_publish", b"auto_publish", "enable_ad", b"enable_ad", "public_access", b"public_access", "sign_url_access", b"sign_url_access", "source", b"source", "tusd", b"tusd"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["access_rights", b"access_rights", "auto_publish", b"auto_publish", "auto_transcode", b"auto_transcode", "channel_id", b"channel_id", "description", b"description", "enable_ad", b"enable_ad", "labels", b"labels", "public_access", b"public_access", "sign_url_access", b"sign_url_access", "source", b"source", "style_preset_id", b"style_preset_id", "thumbnail_id", b"thumbnail_id", "title", b"title", "tusd", b"tusd"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["access_rights", b"access_rights"]) -> typing.Literal["public_access", "sign_url_access"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["source", b"source"]) -> typing.Literal["tusd"] | None: ...

global___CreateVideoRequest = CreateVideoRequest

@typing.final
class VideoTUSDParams(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FILE_SIZE_FIELD_NUMBER: builtins.int
    FILE_NAME_FIELD_NUMBER: builtins.int
    file_size: builtins.int
    """Total size of the file to be uploaded, in bytes."""
    file_name: builtins.str
    """Original name of the file being uploaded.
    This is used for reference and does not affect the upload process.
    """
    def __init__(
        self,
        *,
        file_size: builtins.int = ...,
        file_name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["file_name", b"file_name", "file_size", b"file_size"]) -> None: ...

global___VideoTUSDParams = VideoTUSDParams

@typing.final
class VideoPublicAccessParams(google.protobuf.message.Message):
    """Parameters for video public access rights."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___VideoPublicAccessParams = VideoPublicAccessParams

@typing.final
class VideoSignURLAccessParams(google.protobuf.message.Message):
    """Parameters for video access restrictions based on temporary signed links."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___VideoSignURLAccessParams = VideoSignURLAccessParams

@typing.final
class CreateVideoMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    VIDEO_ID_FIELD_NUMBER: builtins.int
    video_id: builtins.str
    """Unique identifier of the video."""
    def __init__(
        self,
        *,
        video_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["video_id", b"video_id"]) -> None: ...

global___CreateVideoMetadata = CreateVideoMetadata

@typing.final
class UpdateVideoRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class LabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    VIDEO_ID_FIELD_NUMBER: builtins.int
    FIELD_MASK_FIELD_NUMBER: builtins.int
    TITLE_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    THUMBNAIL_ID_FIELD_NUMBER: builtins.int
    AUTO_TRANSCODE_FIELD_NUMBER: builtins.int
    STYLE_PRESET_ID_FIELD_NUMBER: builtins.int
    ENABLE_AD_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    PUBLIC_ACCESS_FIELD_NUMBER: builtins.int
    SIGN_URL_ACCESS_FIELD_NUMBER: builtins.int
    video_id: builtins.str
    """ID of the video to update."""
    title: builtins.str
    """New title for the video."""
    description: builtins.str
    """New description for the video."""
    thumbnail_id: builtins.str
    """New thumbnail ID for the video."""
    auto_transcode: yandex.cloud.video.v1.video_pb2.AutoTranscode.ValueType
    """New auto-transcoding setting for the video.
    Controls whether transcoding starts automatically after upload.
    """
    style_preset_id: builtins.str
    """New style preset ID for the video."""
    @property
    def field_mask(self) -> google.protobuf.field_mask_pb2.FieldMask:
        """Field mask specifying which fields of the video should be updated.
        Only fields specified in this mask will be modified;
        all other fields will retain their current values.
        This allows for partial updates.
        """

    @property
    def enable_ad(self) -> google.protobuf.wrappers_pb2.BoolValue:
        """New advertisement setting for the video.
        Set to false to disable advertisements for this specific video.
        """

    @property
    def labels(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """New custom labels for the video as `key:value` pairs.
        Maximum 64 labels per video.
        If provided, replaces all existing labels.
        """

    @property
    def public_access(self) -> global___VideoPublicAccessParams:
        """Makes the video publicly accessible to anyone with the direct link."""

    @property
    def sign_url_access(self) -> global___VideoSignURLAccessParams:
        """Restricts video access using URL signatures for secure time-limited access."""

    def __init__(
        self,
        *,
        video_id: builtins.str = ...,
        field_mask: google.protobuf.field_mask_pb2.FieldMask | None = ...,
        title: builtins.str = ...,
        description: builtins.str = ...,
        thumbnail_id: builtins.str = ...,
        auto_transcode: yandex.cloud.video.v1.video_pb2.AutoTranscode.ValueType = ...,
        style_preset_id: builtins.str = ...,
        enable_ad: google.protobuf.wrappers_pb2.BoolValue | None = ...,
        labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        public_access: global___VideoPublicAccessParams | None = ...,
        sign_url_access: global___VideoSignURLAccessParams | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["access_rights", b"access_rights", "enable_ad", b"enable_ad", "field_mask", b"field_mask", "public_access", b"public_access", "sign_url_access", b"sign_url_access"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["access_rights", b"access_rights", "auto_transcode", b"auto_transcode", "description", b"description", "enable_ad", b"enable_ad", "field_mask", b"field_mask", "labels", b"labels", "public_access", b"public_access", "sign_url_access", b"sign_url_access", "style_preset_id", b"style_preset_id", "thumbnail_id", b"thumbnail_id", "title", b"title", "video_id", b"video_id"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["access_rights", b"access_rights"]) -> typing.Literal["public_access", "sign_url_access"] | None: ...

global___UpdateVideoRequest = UpdateVideoRequest

@typing.final
class UpdateVideoMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    VIDEO_ID_FIELD_NUMBER: builtins.int
    video_id: builtins.str
    """ID of the video."""
    def __init__(
        self,
        *,
        video_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["video_id", b"video_id"]) -> None: ...

global___UpdateVideoMetadata = UpdateVideoMetadata

@typing.final
class TranscodeVideoRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    VIDEO_ID_FIELD_NUMBER: builtins.int
    FIELD_MASK_FIELD_NUMBER: builtins.int
    SUBTITLE_IDS_FIELD_NUMBER: builtins.int
    TRANSLATION_SETTINGS_FIELD_NUMBER: builtins.int
    SUMMARIZATION_SETTINGS_FIELD_NUMBER: builtins.int
    video_id: builtins.str
    """ID of the video to transcode."""
    @property
    def field_mask(self) -> google.protobuf.field_mask_pb2.FieldMask:
        """Field mask specifying which transcoding-specific fields should be updated.
        Only fields specified in this mask will be modified;
        all other fields will retain their current values.
        This allows for partial updates.
        """

    @property
    def subtitle_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """IDs of manually uploaded subtitle files to include in the transcoding process.
        These subtitles will be embedded in the video output.
        """

    @property
    def translation_settings(self) -> global___VideoTranslationSettings:
        """Settings for automatic translation of audio tracks.
        Defines source tracks and target languages for subtitle and audio translation.
        """

    @property
    def summarization_settings(self) -> global___VideoSummarizationSettings:
        """Settings for automatic video content summarization.
        Defines which audio tracks should be processed to generate text summaries.
        """

    def __init__(
        self,
        *,
        video_id: builtins.str = ...,
        field_mask: google.protobuf.field_mask_pb2.FieldMask | None = ...,
        subtitle_ids: collections.abc.Iterable[builtins.str] | None = ...,
        translation_settings: global___VideoTranslationSettings | None = ...,
        summarization_settings: global___VideoSummarizationSettings | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["field_mask", b"field_mask", "summarization_settings", b"summarization_settings", "translation_settings", b"translation_settings"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["field_mask", b"field_mask", "subtitle_ids", b"subtitle_ids", "summarization_settings", b"summarization_settings", "translation_settings", b"translation_settings", "video_id", b"video_id"]) -> None: ...

global___TranscodeVideoRequest = TranscodeVideoRequest

@typing.final
class VideoTranslationSettings(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class TranslationTrack(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        INPUT_TRACK_FIELD_NUMBER: builtins.int
        SUBTITLES_FIELD_NUMBER: builtins.int
        AUDIO_FIELD_NUMBER: builtins.int
        @property
        def input_track(self) -> global___VideoTranslationSettings.InputTrack:
            """Input track settings."""

        @property
        def subtitles(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___VideoTranslationSettings.SubtitleTrack]:
            """Settings for target subtitle tracks."""

        @property
        def audio(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___VideoTranslationSettings.AudioTrack]:
            """Settings for target audio tracks."""

        def __init__(
            self,
            *,
            input_track: global___VideoTranslationSettings.InputTrack | None = ...,
            subtitles: collections.abc.Iterable[global___VideoTranslationSettings.SubtitleTrack] | None = ...,
            audio: collections.abc.Iterable[global___VideoTranslationSettings.AudioTrack] | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["input_track", b"input_track"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["audio", b"audio", "input_track", b"input_track", "subtitles", b"subtitles"]) -> None: ...

    @typing.final
    class InputTrack(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        TRACK_INDEX_FIELD_NUMBER: builtins.int
        SRC_LANG_FIELD_NUMBER: builtins.int
        track_index: builtins.int
        """Input audio track index (one-based)."""
        src_lang: builtins.str
        """Source track language represented as a three-letter code according to ISO 639-2/T.
        Track language will be deduced automatically if not provided.
        In the latter case the deduction accuracy is not guaranteed.
        For better performance please do specify the source track language when possible.
        """
        def __init__(
            self,
            *,
            track_index: builtins.int = ...,
            src_lang: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["src_lang", b"src_lang", "track_index", b"track_index"]) -> None: ...

    @typing.final
    class SubtitleTrack(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        DST_LANG_FIELD_NUMBER: builtins.int
        LABEL_FIELD_NUMBER: builtins.int
        dst_lang: builtins.str
        """Target language represented as a three-letter code according to ISO 639-2/T."""
        label: builtins.str
        """Track label to be displayed on the screen during video playback."""
        def __init__(
            self,
            *,
            dst_lang: builtins.str = ...,
            label: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["dst_lang", b"dst_lang", "label", b"label"]) -> None: ...

    @typing.final
    class AudioTrack(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        DST_LANG_FIELD_NUMBER: builtins.int
        LABEL_FIELD_NUMBER: builtins.int
        dst_lang: builtins.str
        """Target language represented as a three-letter code according to ISO 639-2/T."""
        label: builtins.str
        """Track label to be displayed on the screen during video playback."""
        def __init__(
            self,
            *,
            dst_lang: builtins.str = ...,
            label: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["dst_lang", b"dst_lang", "label", b"label"]) -> None: ...

    TRACKS_FIELD_NUMBER: builtins.int
    @property
    def tracks(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___VideoTranslationSettings.TranslationTrack]:
        """Translation settings for each track."""

    def __init__(
        self,
        *,
        tracks: collections.abc.Iterable[global___VideoTranslationSettings.TranslationTrack] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["tracks", b"tracks"]) -> None: ...

global___VideoTranslationSettings = VideoTranslationSettings

@typing.final
class VideoSummarizationSettings(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class SummarizationTrack(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        INPUT_TRACK_FIELD_NUMBER: builtins.int
        @property
        def input_track(self) -> global___VideoSummarizationSettings.InputTrack:
            """Input track settings."""

        def __init__(
            self,
            *,
            input_track: global___VideoSummarizationSettings.InputTrack | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["input_track", b"input_track"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["input_track", b"input_track"]) -> None: ...

    @typing.final
    class InputTrack(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        TRACK_INDEX_FIELD_NUMBER: builtins.int
        SRC_LANG_FIELD_NUMBER: builtins.int
        track_index: builtins.int
        """Input audio track index (one-based)."""
        src_lang: builtins.str
        """Source track language represented as a three-letter code according to ISO 639-2/T.
        It will be deduced automatically if not provided.
        In the latter case the deduction accuracy is not guaranteed.
        For better performance please do specify the source track language when possible.
        """
        def __init__(
            self,
            *,
            track_index: builtins.int = ...,
            src_lang: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["src_lang", b"src_lang", "track_index", b"track_index"]) -> None: ...

    TRACKS_FIELD_NUMBER: builtins.int
    PROCESS_ALL_TRACKS_FIELD_NUMBER: builtins.int
    process_all_tracks: builtins.bool
    """Summarize all available tracks.
    If enabled, `tracks` parameter is ignored.
    Enables automatic source language deduction for each track
    and thus may lead to performance degradation.
    """
    @property
    def tracks(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___VideoSummarizationSettings.SummarizationTrack]:
        """Summarization settings for each track."""

    def __init__(
        self,
        *,
        tracks: collections.abc.Iterable[global___VideoSummarizationSettings.SummarizationTrack] | None = ...,
        process_all_tracks: builtins.bool = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["process_all_tracks", b"process_all_tracks", "tracks", b"tracks"]) -> None: ...

global___VideoSummarizationSettings = VideoSummarizationSettings

@typing.final
class TranscodeVideoMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    VIDEO_ID_FIELD_NUMBER: builtins.int
    video_id: builtins.str
    """ID of the video."""
    def __init__(
        self,
        *,
        video_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["video_id", b"video_id"]) -> None: ...

global___TranscodeVideoMetadata = TranscodeVideoMetadata

@typing.final
class DeleteVideoRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    VIDEO_ID_FIELD_NUMBER: builtins.int
    video_id: builtins.str
    """ID of the video to delete."""
    def __init__(
        self,
        *,
        video_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["video_id", b"video_id"]) -> None: ...

global___DeleteVideoRequest = DeleteVideoRequest

@typing.final
class DeleteVideoMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    VIDEO_ID_FIELD_NUMBER: builtins.int
    video_id: builtins.str
    """ID of the video.
    This identifier can be used to track the video deletion operation.
    """
    def __init__(
        self,
        *,
        video_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["video_id", b"video_id"]) -> None: ...

global___DeleteVideoMetadata = DeleteVideoMetadata

@typing.final
class BatchDeleteVideosRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CHANNEL_ID_FIELD_NUMBER: builtins.int
    VIDEO_IDS_FIELD_NUMBER: builtins.int
    channel_id: builtins.str
    """ID of the channel containing the videos to delete."""
    @property
    def video_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """List of video IDs to delete."""

    def __init__(
        self,
        *,
        channel_id: builtins.str = ...,
        video_ids: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["channel_id", b"channel_id", "video_ids", b"video_ids"]) -> None: ...

global___BatchDeleteVideosRequest = BatchDeleteVideosRequest

@typing.final
class BatchDeleteVideosMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    VIDEO_IDS_FIELD_NUMBER: builtins.int
    @property
    def video_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """List of video IDs being deleted.
        This list can be used to track which videos are included
        in the batch deletion operation.
        """

    def __init__(
        self,
        *,
        video_ids: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["video_ids", b"video_ids"]) -> None: ...

global___BatchDeleteVideosMetadata = BatchDeleteVideosMetadata

@typing.final
class PerformVideoActionRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    VIDEO_ID_FIELD_NUMBER: builtins.int
    PUBLISH_FIELD_NUMBER: builtins.int
    UNPUBLISH_FIELD_NUMBER: builtins.int
    video_id: builtins.str
    """ID of the video on which to perform the action."""
    @property
    def publish(self) -> global___PublishVideoAction:
        """Publish the video, making it available for watching.
        Changes the video's visibility status to PUBLISHED.
        """

    @property
    def unpublish(self) -> global___UnpublishVideoAction:
        """Unpublish the video, making it unavailable for watching.
        Changes the video's visibility status to UNPUBLISHED.
        """

    def __init__(
        self,
        *,
        video_id: builtins.str = ...,
        publish: global___PublishVideoAction | None = ...,
        unpublish: global___UnpublishVideoAction | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["action", b"action", "publish", b"publish", "unpublish", b"unpublish"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["action", b"action", "publish", b"publish", "unpublish", b"unpublish", "video_id", b"video_id"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["action", b"action"]) -> typing.Literal["publish", "unpublish"] | None: ...

global___PerformVideoActionRequest = PerformVideoActionRequest

@typing.final
class PublishVideoAction(google.protobuf.message.Message):
    """Parameters for the publish action."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___PublishVideoAction = PublishVideoAction

@typing.final
class UnpublishVideoAction(google.protobuf.message.Message):
    """Parameters for the unpublish action."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___UnpublishVideoAction = UnpublishVideoAction

@typing.final
class PerformVideoActionMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    VIDEO_ID_FIELD_NUMBER: builtins.int
    video_id: builtins.str
    """ID of the video on which the action is being performed.
    This identifier can be used to track the action operation
    and to verify that the action is being applied to the correct video.
    """
    def __init__(
        self,
        *,
        video_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["video_id", b"video_id"]) -> None: ...

global___PerformVideoActionMetadata = PerformVideoActionMetadata

@typing.final
class GetVideoPlayerURLRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    VIDEO_ID_FIELD_NUMBER: builtins.int
    PARAMS_FIELD_NUMBER: builtins.int
    SIGNED_URL_EXPIRATION_DURATION_FIELD_NUMBER: builtins.int
    video_id: builtins.str
    """ID of the video for which to generate a player URL."""
    @property
    def params(self) -> global___VideoPlayerParams:
        """Optional player parameters to customize the playback experience.
        These parameters control initial player state such as mute, autoplay, and visibility of interface controls.
        """

    @property
    def signed_url_expiration_duration(self) -> google.protobuf.duration_pb2.Duration:
        """For episodes with signed URL access, specifies how long the generated URL will be valid.
        If not provided, a default expiration duration will be used.
        """

    def __init__(
        self,
        *,
        video_id: builtins.str = ...,
        params: global___VideoPlayerParams | None = ...,
        signed_url_expiration_duration: google.protobuf.duration_pb2.Duration | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["params", b"params", "signed_url_expiration_duration", b"signed_url_expiration_duration"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["params", b"params", "signed_url_expiration_duration", b"signed_url_expiration_duration", "video_id", b"video_id"]) -> None: ...

global___GetVideoPlayerURLRequest = GetVideoPlayerURLRequest

@typing.final
class VideoPlayerParams(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MUTE_FIELD_NUMBER: builtins.int
    AUTOPLAY_FIELD_NUMBER: builtins.int
    HIDDEN_FIELD_NUMBER: builtins.int
    mute: builtins.bool
    """If true, the player will start with audio muted.
    Users can unmute the audio manually after playback starts.
    """
    autoplay: builtins.bool
    """If true, the video will start playing automatically when the player loads.
    This may be subject to browser autoplay policies that restrict autoplay with sound.
    """
    hidden: builtins.bool
    """If true, the player interface controls will be hidden initially.
    Users can typically reveal the controls by moving the mouse over the player.
    """
    def __init__(
        self,
        *,
        mute: builtins.bool = ...,
        autoplay: builtins.bool = ...,
        hidden: builtins.bool = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["autoplay", b"autoplay", "hidden", b"hidden", "mute", b"mute"]) -> None: ...

global___VideoPlayerParams = VideoPlayerParams

@typing.final
class GetVideoPlayerURLResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PLAYER_URL_FIELD_NUMBER: builtins.int
    HTML_FIELD_NUMBER: builtins.int
    player_url: builtins.str
    """Direct URL to the video player.
    This URL can be used to access the video in a web browser
    or shared with users who have appropriate permissions.
    """
    html: builtins.str
    """HTML embed code in iframe format that can be inserted into web pages.
    This code allows the video to be embedded directly in third-party websites.
    """
    def __init__(
        self,
        *,
        player_url: builtins.str = ...,
        html: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["html", b"html", "player_url", b"player_url"]) -> None: ...

global___GetVideoPlayerURLResponse = GetVideoPlayerURLResponse

@typing.final
class BatchGetVideoPlayerURLsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CHANNEL_ID_FIELD_NUMBER: builtins.int
    VIDEO_IDS_FIELD_NUMBER: builtins.int
    PARAMS_FIELD_NUMBER: builtins.int
    SIGNED_URL_EXPIRATION_DURATION_FIELD_NUMBER: builtins.int
    channel_id: builtins.str
    """ID of the channel containing the videos for which to generate player URLs."""
    @property
    def video_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """List of video IDs for which to generate player URLs."""

    @property
    def params(self) -> global___VideoPlayerParams:
        """Optional player parameters to customize the playback experience.
        These parameters control initial player state such as mute, autoplay, and visibility of interface controls.
        These parameters will be applied to all generated player URLs.
        """

    @property
    def signed_url_expiration_duration(self) -> google.protobuf.duration_pb2.Duration:
        """For episodes with signed URL access, specifies how long the generated URL will be valid.
        If not provided, a default expiration duration will be used.
        This setting applies to all videos in the batch that use sign_url_access.
        """

    def __init__(
        self,
        *,
        channel_id: builtins.str = ...,
        video_ids: collections.abc.Iterable[builtins.str] | None = ...,
        params: global___VideoPlayerParams | None = ...,
        signed_url_expiration_duration: google.protobuf.duration_pb2.Duration | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["params", b"params", "signed_url_expiration_duration", b"signed_url_expiration_duration"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["channel_id", b"channel_id", "params", b"params", "signed_url_expiration_duration", b"signed_url_expiration_duration", "video_ids", b"video_ids"]) -> None: ...

global___BatchGetVideoPlayerURLsRequest = BatchGetVideoPlayerURLsRequest

@typing.final
class BatchGetVideoPlayerURLsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PLAYER_URLS_FIELD_NUMBER: builtins.int
    @property
    def player_urls(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """List of player URLs corresponding to the requested video IDs.
        The order of URLs matches the order of video IDs in the request.
        """

    def __init__(
        self,
        *,
        player_urls: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["player_urls", b"player_urls"]) -> None: ...

global___BatchGetVideoPlayerURLsResponse = BatchGetVideoPlayerURLsResponse

@typing.final
class GetVideoManifestsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    VIDEO_ID_FIELD_NUMBER: builtins.int
    video_id: builtins.str
    """ID of the video for which to retrieve manifest URLs."""
    def __init__(
        self,
        *,
        video_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["video_id", b"video_id"]) -> None: ...

global___GetVideoManifestsRequest = GetVideoManifestsRequest

@typing.final
class GetVideoManifestsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MANIFESTS_FIELD_NUMBER: builtins.int
    @property
    def manifests(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.video.v1.manifest_pb2.Manifest]:
        """List of manifests available for the video.
        Different manifests may represent different streaming formats (e.g., HLS, DASH)
        """

    def __init__(
        self,
        *,
        manifests: collections.abc.Iterable[yandex.cloud.video.v1.manifest_pb2.Manifest] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["manifests", b"manifests"]) -> None: ...

global___GetVideoManifestsResponse = GetVideoManifestsResponse
