"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.field_mask_pb2
import google.protobuf.internal.containers
import google.protobuf.message
import typing
import yandex.cloud.operation.operation_pb2
import yandex.cloud.vpc.v1.route_table_pb2

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class GetRouteTableRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ROUTE_TABLE_ID_FIELD_NUMBER: builtins.int
    route_table_id: builtins.str
    """ID of the RouteTable resource to return.
    To get the route table ID use a [RouteTableService.List] request.
    """
    def __init__(
        self,
        *,
        route_table_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["route_table_id", b"route_table_id"]) -> None: ...

global___GetRouteTableRequest = GetRouteTableRequest

@typing.final
class ListRouteTablesRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FOLDER_ID_FIELD_NUMBER: builtins.int
    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    FILTER_FIELD_NUMBER: builtins.int
    folder_id: builtins.str
    """ID of the folder that the route table belongs to.
    To get the folder ID use a [yandex.cloud.resourcemanager.v1.FolderService.List] request.
    """
    page_size: builtins.int
    """The maximum number of results per page to return. If the number of available
    results is larger than [page_size],
    the service returns a [ListRouteTablesResponse.next_page_token]
    that can be used to get the next page of results in subsequent list requests. Default value: 100.
    """
    page_token: builtins.str
    """Page token. To get the next page of results, set [page_token] to the
    [ListRouteTablesResponse.next_page_token] returned by a previous list request.
    """
    filter: builtins.str
    """A filter expression that filters resources listed in the response.
    The expression must specify:
    1. The field name. Currently you can use filtering only on [RouteTable.name] field.
    2. An `=` operator.
    3. The value in double quotes (`"`). Must be 3-63 characters long and match the regular expression `[a-z][-a-z0-9]{1,61}[a-z0-9]`.
    """
    def __init__(
        self,
        *,
        folder_id: builtins.str = ...,
        page_size: builtins.int = ...,
        page_token: builtins.str = ...,
        filter: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["filter", b"filter", "folder_id", b"folder_id", "page_size", b"page_size", "page_token", b"page_token"]) -> None: ...

global___ListRouteTablesRequest = ListRouteTablesRequest

@typing.final
class ListRouteTablesResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ROUTE_TABLES_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    next_page_token: builtins.str
    """This token allows you to get the next page of results for list requests. If the number of results
    is larger than [ListRouteTablesRequest.page_size], use
    the [next_page_token] as the value
    for the [ListRouteTablesRequest.page_token] query parameter
    in the next list request. Subsequent list requests will have their own
    [next_page_token] to continue paging through the results.
    """
    @property
    def route_tables(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.vpc.v1.route_table_pb2.RouteTable]:
        """List of RouteTable resources."""

    def __init__(
        self,
        *,
        route_tables: collections.abc.Iterable[yandex.cloud.vpc.v1.route_table_pb2.RouteTable] | None = ...,
        next_page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["next_page_token", b"next_page_token", "route_tables", b"route_tables"]) -> None: ...

global___ListRouteTablesResponse = ListRouteTablesResponse

@typing.final
class CreateRouteTableRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class LabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    FOLDER_ID_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    NETWORK_ID_FIELD_NUMBER: builtins.int
    STATIC_ROUTES_FIELD_NUMBER: builtins.int
    folder_id: builtins.str
    """ID of the folder that the route table belongs to.
    To get the folder ID use a [yandex.cloud.resourcemanager.v1.FolderService.List] request.
    """
    name: builtins.str
    """Name of the route table.
    The name must be unique within the folder.
    """
    description: builtins.str
    """Description of the route table."""
    network_id: builtins.str
    """ID of the network the route table belongs to."""
    @property
    def labels(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Resource labels, `` key:value `` pairs."""

    @property
    def static_routes(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.vpc.v1.route_table_pb2.StaticRoute]:
        """List of static routes."""

    def __init__(
        self,
        *,
        folder_id: builtins.str = ...,
        name: builtins.str = ...,
        description: builtins.str = ...,
        labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        network_id: builtins.str = ...,
        static_routes: collections.abc.Iterable[yandex.cloud.vpc.v1.route_table_pb2.StaticRoute] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["description", b"description", "folder_id", b"folder_id", "labels", b"labels", "name", b"name", "network_id", b"network_id", "static_routes", b"static_routes"]) -> None: ...

global___CreateRouteTableRequest = CreateRouteTableRequest

@typing.final
class CreateRouteTableMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ROUTE_TABLE_ID_FIELD_NUMBER: builtins.int
    route_table_id: builtins.str
    """ID of the route table that is being created."""
    def __init__(
        self,
        *,
        route_table_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["route_table_id", b"route_table_id"]) -> None: ...

global___CreateRouteTableMetadata = CreateRouteTableMetadata

@typing.final
class UpdateRouteTableRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class LabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    ROUTE_TABLE_ID_FIELD_NUMBER: builtins.int
    UPDATE_MASK_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    STATIC_ROUTES_FIELD_NUMBER: builtins.int
    route_table_id: builtins.str
    """ID of the RouteTable resource to update."""
    name: builtins.str
    """Name of the route table.
    The name must be unique within the folder.
    """
    description: builtins.str
    """Description of the route table."""
    @property
    def update_mask(self) -> google.protobuf.field_mask_pb2.FieldMask:
        """Field mask that specifies which fields of the RouteTable resource are going to be updated."""

    @property
    def labels(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Resource labels as `` key:value `` pairs."""

    @property
    def static_routes(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.vpc.v1.route_table_pb2.StaticRoute]:
        """List of static routes."""

    def __init__(
        self,
        *,
        route_table_id: builtins.str = ...,
        update_mask: google.protobuf.field_mask_pb2.FieldMask | None = ...,
        name: builtins.str = ...,
        description: builtins.str = ...,
        labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        static_routes: collections.abc.Iterable[yandex.cloud.vpc.v1.route_table_pb2.StaticRoute] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["update_mask", b"update_mask"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["description", b"description", "labels", b"labels", "name", b"name", "route_table_id", b"route_table_id", "static_routes", b"static_routes", "update_mask", b"update_mask"]) -> None: ...

global___UpdateRouteTableRequest = UpdateRouteTableRequest

@typing.final
class UpdateRouteTableMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ROUTE_TABLE_ID_FIELD_NUMBER: builtins.int
    route_table_id: builtins.str
    """ID of the RouteTable resource that is being updated."""
    def __init__(
        self,
        *,
        route_table_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["route_table_id", b"route_table_id"]) -> None: ...

global___UpdateRouteTableMetadata = UpdateRouteTableMetadata

@typing.final
class DeleteRouteTableRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ROUTE_TABLE_ID_FIELD_NUMBER: builtins.int
    route_table_id: builtins.str
    """ID of the route table to delete.
    To get the route table ID use a [RouteTableService.List] request.
    """
    def __init__(
        self,
        *,
        route_table_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["route_table_id", b"route_table_id"]) -> None: ...

global___DeleteRouteTableRequest = DeleteRouteTableRequest

@typing.final
class DeleteRouteTableMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ROUTE_TABLE_ID_FIELD_NUMBER: builtins.int
    route_table_id: builtins.str
    """ID of the RouteTable resource that is being deleted."""
    def __init__(
        self,
        *,
        route_table_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["route_table_id", b"route_table_id"]) -> None: ...

global___DeleteRouteTableMetadata = DeleteRouteTableMetadata

@typing.final
class ListRouteTableOperationsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ROUTE_TABLE_ID_FIELD_NUMBER: builtins.int
    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    route_table_id: builtins.str
    """ID of the RouteTable resource to list operations for."""
    page_size: builtins.int
    """The maximum number of results per page that should be returned. If the number of available
    results is larger than [page_size], the service returns a [ListRouteTableOperationsResponse.next_page_token]
    that can be used to get the next page of results in subsequent list requests. Default value: 100.
    """
    page_token: builtins.str
    """Page token. To get the next page of results, set [page_token] to the
    [ListRouteTableOperationsResponse.next_page_token] returned by a previous list request.
    """
    def __init__(
        self,
        *,
        route_table_id: builtins.str = ...,
        page_size: builtins.int = ...,
        page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["page_size", b"page_size", "page_token", b"page_token", "route_table_id", b"route_table_id"]) -> None: ...

global___ListRouteTableOperationsRequest = ListRouteTableOperationsRequest

@typing.final
class ListRouteTableOperationsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    OPERATIONS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    next_page_token: builtins.str
    """This token allows you to get the next page of results for list requests. If the number of results
    is larger than [ListRouteTableOperationsRequest.page_size], use the [next_page_token] as the value
    for the [ListRouteTableOperationsRequest.page_token] query parameter in the next list request.
    Each subsequent list request will have its own [next_page_token] to continue paging through the results.
    """
    @property
    def operations(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.operation.operation_pb2.Operation]:
        """List of operations for the specified RouteTable resource."""

    def __init__(
        self,
        *,
        operations: collections.abc.Iterable[yandex.cloud.operation.operation_pb2.Operation] | None = ...,
        next_page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["next_page_token", b"next_page_token", "operations", b"operations"]) -> None: ...

global___ListRouteTableOperationsResponse = ListRouteTableOperationsResponse

@typing.final
class MoveRouteTableRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ROUTE_TABLE_ID_FIELD_NUMBER: builtins.int
    DESTINATION_FOLDER_ID_FIELD_NUMBER: builtins.int
    route_table_id: builtins.str
    """ID of the RouteTable resource to move."""
    destination_folder_id: builtins.str
    """ID of the destination folder."""
    def __init__(
        self,
        *,
        route_table_id: builtins.str = ...,
        destination_folder_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["destination_folder_id", b"destination_folder_id", "route_table_id", b"route_table_id"]) -> None: ...

global___MoveRouteTableRequest = MoveRouteTableRequest

@typing.final
class MoveRouteTableMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ROUTE_TABLE_ID_FIELD_NUMBER: builtins.int
    route_table_id: builtins.str
    """ID of the RouteTable resource that is being moved."""
    def __init__(
        self,
        *,
        route_table_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["route_table_id", b"route_table_id"]) -> None: ...

global___MoveRouteTableMetadata = MoveRouteTableMetadata
