"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.field_mask_pb2
import google.protobuf.internal.containers
import google.protobuf.message
import typing
import yandex.cloud.operation.operation_pb2
import yandex.cloud.vpc.v1.security_group_pb2

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class GetSecurityGroupRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SECURITY_GROUP_ID_FIELD_NUMBER: builtins.int
    security_group_id: builtins.str
    """ID of the Security Group resource to return.
    To get the security group ID, use a [SecurityGroup.List] request.
    """
    def __init__(
        self,
        *,
        security_group_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["security_group_id", b"security_group_id"]) -> None: ...

global___GetSecurityGroupRequest = GetSecurityGroupRequest

@typing.final
class ListSecurityGroupsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FOLDER_ID_FIELD_NUMBER: builtins.int
    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    FILTER_FIELD_NUMBER: builtins.int
    folder_id: builtins.str
    """ID of the folder to list security groups in.
    To get the folder ID, use a [yandex.cloud.resourcemanager.v1.FolderService.List] request.
    """
    page_size: builtins.int
    """The maximum number of results per page to return. If the number of available
    results is larger than [page_size],
    the service returns a [ListSecurityGroupsResponse.next_page_token]
    that can be used to get the next page of results in subsequent list requests. Default value: 100.
    """
    page_token: builtins.str
    """Page token. To get the next page of results, set [page_token] to the
    [ListSecurityGroupsResponse.next_page_token] returned by a previous list request.
    """
    filter: builtins.str
    """A filter expression that filters resources listed in the response.
    The expression must specify:
    1. The field name. Currently you can use filtering only on the [SecurityGroup.name] field.
    2. An `=` operator.
    3. The value in double quotes (`"`). Must be 3-63 characters long and match the regular expression `[a-z][-a-z0-9]{1,61}[a-z0-9]`.
    filter by network_id is here
    """
    def __init__(
        self,
        *,
        folder_id: builtins.str = ...,
        page_size: builtins.int = ...,
        page_token: builtins.str = ...,
        filter: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["filter", b"filter", "folder_id", b"folder_id", "page_size", b"page_size", "page_token", b"page_token"]) -> None: ...

global___ListSecurityGroupsRequest = ListSecurityGroupsRequest

@typing.final
class ListSecurityGroupsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SECURITY_GROUPS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    next_page_token: builtins.str
    """This token allows you to get the next page of results for list requests. If the number of results
    is larger than [ListNetworksRequest.page_size], use
    the [next_page_token] as the value
    for the [ListNetworksRequest.page_token] query parameter
    in the next list request. Subsequent list requests will have their own
    [next_page_token] to continue paging through the results.
    """
    @property
    def security_groups(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.vpc.v1.security_group_pb2.SecurityGroup]:
        """List of SecurityGroup resources."""

    def __init__(
        self,
        *,
        security_groups: collections.abc.Iterable[yandex.cloud.vpc.v1.security_group_pb2.SecurityGroup] | None = ...,
        next_page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["next_page_token", b"next_page_token", "security_groups", b"security_groups"]) -> None: ...

global___ListSecurityGroupsResponse = ListSecurityGroupsResponse

@typing.final
class CreateSecurityGroupRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class LabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    FOLDER_ID_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    NETWORK_ID_FIELD_NUMBER: builtins.int
    RULE_SPECS_FIELD_NUMBER: builtins.int
    folder_id: builtins.str
    """ID of the folder for this request to create a security group in.
    To get the folder ID, use a [yandex.cloud.resourcemanager.v1.FolderService.List] request.
    """
    name: builtins.str
    """Name of the security group.
    The name must be unique within the folder.
    """
    description: builtins.str
    """Description of the security group."""
    network_id: builtins.str
    """ID of the Network to create security group for."""
    @property
    def labels(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Resource labels as `` key:value `` pairs."""

    @property
    def rule_specs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___SecurityGroupRuleSpec]:
        """Security rules specifications."""

    def __init__(
        self,
        *,
        folder_id: builtins.str = ...,
        name: builtins.str = ...,
        description: builtins.str = ...,
        labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        network_id: builtins.str = ...,
        rule_specs: collections.abc.Iterable[global___SecurityGroupRuleSpec] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["description", b"description", "folder_id", b"folder_id", "labels", b"labels", "name", b"name", "network_id", b"network_id", "rule_specs", b"rule_specs"]) -> None: ...

global___CreateSecurityGroupRequest = CreateSecurityGroupRequest

@typing.final
class SecurityGroupRuleSpec(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class LabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    DESCRIPTION_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    DIRECTION_FIELD_NUMBER: builtins.int
    PORTS_FIELD_NUMBER: builtins.int
    PROTOCOL_NAME_FIELD_NUMBER: builtins.int
    PROTOCOL_NUMBER_FIELD_NUMBER: builtins.int
    CIDR_BLOCKS_FIELD_NUMBER: builtins.int
    SECURITY_GROUP_ID_FIELD_NUMBER: builtins.int
    PREDEFINED_TARGET_FIELD_NUMBER: builtins.int
    description: builtins.str
    """Description of the security rule."""
    direction: yandex.cloud.vpc.v1.security_group_pb2.SecurityGroupRule.Direction.ValueType
    """The direction of network traffic allowed by this rule."""
    protocol_name: builtins.str
    """Protocol name."""
    protocol_number: builtins.int
    """Protocol number from [IANA protocol numbers](https://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml)."""
    security_group_id: builtins.str
    """ID of the security group to add rule to."""
    predefined_target: builtins.str
    """Predefined target. See [security groups rules](/docs/vpc/concepts/security-groups#security-groups-rules) for more information.
    string subnet_id = .. ;
    """
    @property
    def labels(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Rule labels as `` key:value `` pairs."""

    @property
    def ports(self) -> yandex.cloud.vpc.v1.security_group_pb2.PortRange:
        """The range of ports that allow traffic to pass through. Null value means any port.
        null value means any port
        """

    @property
    def cidr_blocks(self) -> yandex.cloud.vpc.v1.security_group_pb2.CidrBlocks:
        """CIDR blocks to allow to recieve or send traffic."""

    def __init__(
        self,
        *,
        description: builtins.str = ...,
        labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        direction: yandex.cloud.vpc.v1.security_group_pb2.SecurityGroupRule.Direction.ValueType = ...,
        ports: yandex.cloud.vpc.v1.security_group_pb2.PortRange | None = ...,
        protocol_name: builtins.str = ...,
        protocol_number: builtins.int = ...,
        cidr_blocks: yandex.cloud.vpc.v1.security_group_pb2.CidrBlocks | None = ...,
        security_group_id: builtins.str = ...,
        predefined_target: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["cidr_blocks", b"cidr_blocks", "ports", b"ports", "predefined_target", b"predefined_target", "protocol", b"protocol", "protocol_name", b"protocol_name", "protocol_number", b"protocol_number", "security_group_id", b"security_group_id", "target", b"target"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["cidr_blocks", b"cidr_blocks", "description", b"description", "direction", b"direction", "labels", b"labels", "ports", b"ports", "predefined_target", b"predefined_target", "protocol", b"protocol", "protocol_name", b"protocol_name", "protocol_number", b"protocol_number", "security_group_id", b"security_group_id", "target", b"target"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["protocol", b"protocol"]) -> typing.Literal["protocol_name", "protocol_number"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["target", b"target"]) -> typing.Literal["cidr_blocks", "security_group_id", "predefined_target"] | None: ...

global___SecurityGroupRuleSpec = SecurityGroupRuleSpec

@typing.final
class CreateSecurityGroupMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SECURITY_GROUP_ID_FIELD_NUMBER: builtins.int
    security_group_id: builtins.str
    """ID of the security group that is being created."""
    def __init__(
        self,
        *,
        security_group_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["security_group_id", b"security_group_id"]) -> None: ...

global___CreateSecurityGroupMetadata = CreateSecurityGroupMetadata

@typing.final
class UpdateSecurityGroupRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class LabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    SECURITY_GROUP_ID_FIELD_NUMBER: builtins.int
    UPDATE_MASK_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    RULE_SPECS_FIELD_NUMBER: builtins.int
    security_group_id: builtins.str
    """ID of the security group to update.

    To get the security group ID make a [SecurityGroupService.List] request.
    """
    name: builtins.str
    """New name for the security group.
    The name must be unique within the folder.
    """
    description: builtins.str
    """New description of the security group."""
    @property
    def update_mask(self) -> google.protobuf.field_mask_pb2.FieldMask:
        """Field mask that specifies which attributes of the Address should be updated."""

    @property
    def labels(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Security group labels as `key:value` pairs.

        Existing set of labels is completely replaced by the provided set, so if you just want
        to add or remove a label:
        1. Get the current set of labels with a [SecurityGroupService.Get] request.
        2. Add or remove a label in this set.
        3. Send the new set in this field.
        """

    @property
    def rule_specs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___SecurityGroupRuleSpec]:
        """Updated rule list. All existing rules will be replaced with given list."""

    def __init__(
        self,
        *,
        security_group_id: builtins.str = ...,
        update_mask: google.protobuf.field_mask_pb2.FieldMask | None = ...,
        name: builtins.str = ...,
        description: builtins.str = ...,
        labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        rule_specs: collections.abc.Iterable[global___SecurityGroupRuleSpec] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["update_mask", b"update_mask"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["description", b"description", "labels", b"labels", "name", b"name", "rule_specs", b"rule_specs", "security_group_id", b"security_group_id", "update_mask", b"update_mask"]) -> None: ...

global___UpdateSecurityGroupRequest = UpdateSecurityGroupRequest

@typing.final
class UpdateSecurityGroupMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SECURITY_GROUP_ID_FIELD_NUMBER: builtins.int
    ADDED_RULE_IDS_FIELD_NUMBER: builtins.int
    security_group_id: builtins.str
    """ID of the SecurityGroup that is being updated."""
    @property
    def added_rule_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """List of added security rules IDs."""

    def __init__(
        self,
        *,
        security_group_id: builtins.str = ...,
        added_rule_ids: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["added_rule_ids", b"added_rule_ids", "security_group_id", b"security_group_id"]) -> None: ...

global___UpdateSecurityGroupMetadata = UpdateSecurityGroupMetadata

@typing.final
class UpdateSecurityGroupRulesRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SECURITY_GROUP_ID_FIELD_NUMBER: builtins.int
    DELETION_RULE_IDS_FIELD_NUMBER: builtins.int
    ADDITION_RULE_SPECS_FIELD_NUMBER: builtins.int
    security_group_id: builtins.str
    """ID of the SecurityGroup that is being updated with new rules."""
    @property
    def deletion_rule_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """List of rules IDs to delete."""

    @property
    def addition_rule_specs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___SecurityGroupRuleSpec]:
        """Security rules specifications."""

    def __init__(
        self,
        *,
        security_group_id: builtins.str = ...,
        deletion_rule_ids: collections.abc.Iterable[builtins.str] | None = ...,
        addition_rule_specs: collections.abc.Iterable[global___SecurityGroupRuleSpec] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["addition_rule_specs", b"addition_rule_specs", "deletion_rule_ids", b"deletion_rule_ids", "security_group_id", b"security_group_id"]) -> None: ...

global___UpdateSecurityGroupRulesRequest = UpdateSecurityGroupRulesRequest

@typing.final
class UpdateSecurityGroupRuleRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class LabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    SECURITY_GROUP_ID_FIELD_NUMBER: builtins.int
    RULE_ID_FIELD_NUMBER: builtins.int
    UPDATE_MASK_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    security_group_id: builtins.str
    """ID of the SecurityGroup to update rule in."""
    rule_id: builtins.str
    """ID of the rule to update."""
    description: builtins.str
    """New description of the rule."""
    @property
    def update_mask(self) -> google.protobuf.field_mask_pb2.FieldMask:
        """Field mask that specifies which attributes of the Address should be updated."""

    @property
    def labels(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Rule labels as `key:value` pairs.

        Existing set of labels is completely replaced by the provided set, so if you just want
        to add or remove a label:
        1. Get the current set of labels with a [AddressService.Get] request.
        2. Add or remove a label in this set.
        3. Send the new set in this field.
        """

    def __init__(
        self,
        *,
        security_group_id: builtins.str = ...,
        rule_id: builtins.str = ...,
        update_mask: google.protobuf.field_mask_pb2.FieldMask | None = ...,
        description: builtins.str = ...,
        labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["update_mask", b"update_mask"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["description", b"description", "labels", b"labels", "rule_id", b"rule_id", "security_group_id", b"security_group_id", "update_mask", b"update_mask"]) -> None: ...

global___UpdateSecurityGroupRuleRequest = UpdateSecurityGroupRuleRequest

@typing.final
class UpdateSecurityGroupRuleMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SECURITY_GROUP_ID_FIELD_NUMBER: builtins.int
    RULE_ID_FIELD_NUMBER: builtins.int
    security_group_id: builtins.str
    """ID of the SecurityGroup that is being updated with new rules."""
    rule_id: builtins.str
    """ID of the rule that is being updated."""
    def __init__(
        self,
        *,
        security_group_id: builtins.str = ...,
        rule_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["rule_id", b"rule_id", "security_group_id", b"security_group_id"]) -> None: ...

global___UpdateSecurityGroupRuleMetadata = UpdateSecurityGroupRuleMetadata

@typing.final
class DeleteSecurityGroupRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SECURITY_GROUP_ID_FIELD_NUMBER: builtins.int
    security_group_id: builtins.str
    """ID of the security group to delete.

    To get a address ID make a [SecurityGroup.List] request.
    """
    def __init__(
        self,
        *,
        security_group_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["security_group_id", b"security_group_id"]) -> None: ...

global___DeleteSecurityGroupRequest = DeleteSecurityGroupRequest

@typing.final
class DeleteSecurityGroupMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SECURITY_GROUP_ID_FIELD_NUMBER: builtins.int
    security_group_id: builtins.str
    """ID of the SecurityGroup that is being deleted."""
    def __init__(
        self,
        *,
        security_group_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["security_group_id", b"security_group_id"]) -> None: ...

global___DeleteSecurityGroupMetadata = DeleteSecurityGroupMetadata

@typing.final
class ListSecurityGroupOperationsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SECURITY_GROUP_ID_FIELD_NUMBER: builtins.int
    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    security_group_id: builtins.str
    """ID of the address to list operations for.

    To get a address ID make a [SecurityGroup.List] request.
    """
    page_size: builtins.int
    """The maximum number of results per page to return. If the number of available
    results is larger than [page_size], the service returns a [ListSecurityGroupOperationsResponse.next_page_token]
    that can be used to get the next page of results in subsequent list requests.
    Default value: 100.
    """
    page_token: builtins.str
    """Page token. To get the next page of results, set [page_token] to the
    [ListSecurityGroupOperationsResponse.next_page_token] returned by a previous list request.
    """
    def __init__(
        self,
        *,
        security_group_id: builtins.str = ...,
        page_size: builtins.int = ...,
        page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["page_size", b"page_size", "page_token", b"page_token", "security_group_id", b"security_group_id"]) -> None: ...

global___ListSecurityGroupOperationsRequest = ListSecurityGroupOperationsRequest

@typing.final
class ListSecurityGroupOperationsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    OPERATIONS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    next_page_token: builtins.str
    """Token for getting the next page of the list. If the number of results is greater than
    the specified [ListSecurityGroupOperationsRequest.page_size], use `next_page_token` as the value
    for the [ListSecurityGroupOperationsRequest.page_token] parameter in the next list request.

    Each subsequent page will have its own `next_page_token` to continue paging through the results.
    """
    @property
    def operations(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.operation.operation_pb2.Operation]:
        """List of operations for the specified security group."""

    def __init__(
        self,
        *,
        operations: collections.abc.Iterable[yandex.cloud.operation.operation_pb2.Operation] | None = ...,
        next_page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["next_page_token", b"next_page_token", "operations", b"operations"]) -> None: ...

global___ListSecurityGroupOperationsResponse = ListSecurityGroupOperationsResponse

@typing.final
class MoveSecurityGroupRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SECURITY_GROUP_ID_FIELD_NUMBER: builtins.int
    DESTINATION_FOLDER_ID_FIELD_NUMBER: builtins.int
    security_group_id: builtins.str
    """ID of the security group to move."""
    destination_folder_id: builtins.str
    """ID of the folder to move security group to."""
    def __init__(
        self,
        *,
        security_group_id: builtins.str = ...,
        destination_folder_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["destination_folder_id", b"destination_folder_id", "security_group_id", b"security_group_id"]) -> None: ...

global___MoveSecurityGroupRequest = MoveSecurityGroupRequest

@typing.final
class MoveSecurityGroupMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SECURITY_GROUP_ID_FIELD_NUMBER: builtins.int
    security_group_id: builtins.str
    """ID of the security group that is being moved."""
    def __init__(
        self,
        *,
        security_group_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["security_group_id", b"security_group_id"]) -> None: ...

global___MoveSecurityGroupMetadata = MoveSecurityGroupMetadata
