"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.duration_pb2
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.timestamp_pb2
import google.type.dayofweek_pb2
import google.type.timeofday_pb2
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class BackupSchedule(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DAILY_BACKUP_SCHEDULE_FIELD_NUMBER: builtins.int
    WEEKLY_BACKUP_SCHEDULE_FIELD_NUMBER: builtins.int
    RECURRING_BACKUP_SCHEDULE_FIELD_NUMBER: builtins.int
    NEXT_EXECUTE_TIME_FIELD_NUMBER: builtins.int
    @property
    def daily_backup_schedule(self) -> global___DailyBackupSchedule: ...
    @property
    def weekly_backup_schedule(self) -> global___WeeklyBackupSchedule: ...
    @property
    def recurring_backup_schedule(self) -> global___RecurringBackupSchedule: ...
    @property
    def next_execute_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """output only field: when next backup will be executed
        using provided schedule.
        """

    def __init__(
        self,
        *,
        daily_backup_schedule: global___DailyBackupSchedule | None = ...,
        weekly_backup_schedule: global___WeeklyBackupSchedule | None = ...,
        recurring_backup_schedule: global___RecurringBackupSchedule | None = ...,
        next_execute_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["daily_backup_schedule", b"daily_backup_schedule", "next_execute_time", b"next_execute_time", "policy", b"policy", "recurring_backup_schedule", b"recurring_backup_schedule", "weekly_backup_schedule", b"weekly_backup_schedule"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["daily_backup_schedule", b"daily_backup_schedule", "next_execute_time", b"next_execute_time", "policy", b"policy", "recurring_backup_schedule", b"recurring_backup_schedule", "weekly_backup_schedule", b"weekly_backup_schedule"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["policy", b"policy"]) -> typing.Literal["daily_backup_schedule", "weekly_backup_schedule", "recurring_backup_schedule"] | None: ...

global___BackupSchedule = BackupSchedule

@typing.final
class RecurringBackupSchedule(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    START_TIME_FIELD_NUMBER: builtins.int
    RECURRENCE_FIELD_NUMBER: builtins.int
    recurrence: builtins.str
    """An RRULE (https://tools.ietf.org/html/rfc5545#section-3.8.5.3) for how
    this backup reccurs.
    The FREQ values of MINUTELY, and SECONDLY are not supported.
    """
    @property
    def start_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Timestamp of the first recurrence."""

    def __init__(
        self,
        *,
        start_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        recurrence: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["start_time", b"start_time"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["recurrence", b"recurrence", "start_time", b"start_time"]) -> None: ...

global___RecurringBackupSchedule = RecurringBackupSchedule

@typing.final
class DaysOfWeekBackupSchedule(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DAYS_FIELD_NUMBER: builtins.int
    EXECUTE_TIME_FIELD_NUMBER: builtins.int
    @property
    def days(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[google.type.dayofweek_pb2.DayOfWeek.ValueType]: ...
    @property
    def execute_time(self) -> google.type.timeofday_pb2.TimeOfDay: ...
    def __init__(
        self,
        *,
        days: collections.abc.Iterable[google.type.dayofweek_pb2.DayOfWeek.ValueType] | None = ...,
        execute_time: google.type.timeofday_pb2.TimeOfDay | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["execute_time", b"execute_time"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["days", b"days", "execute_time", b"execute_time"]) -> None: ...

global___DaysOfWeekBackupSchedule = DaysOfWeekBackupSchedule

@typing.final
class WeeklyBackupSchedule(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DAYS_OF_WEEK_FIELD_NUMBER: builtins.int
    @property
    def days_of_week(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___DaysOfWeekBackupSchedule]: ...
    def __init__(
        self,
        *,
        days_of_week: collections.abc.Iterable[global___DaysOfWeekBackupSchedule] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["days_of_week", b"days_of_week"]) -> None: ...

global___WeeklyBackupSchedule = WeeklyBackupSchedule

@typing.final
class DailyBackupSchedule(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    EXECUTE_TIME_FIELD_NUMBER: builtins.int
    @property
    def execute_time(self) -> google.type.timeofday_pb2.TimeOfDay: ...
    def __init__(
        self,
        *,
        execute_time: google.type.timeofday_pb2.TimeOfDay | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["execute_time", b"execute_time"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["execute_time", b"execute_time"]) -> None: ...

global___DailyBackupSchedule = DailyBackupSchedule

@typing.final
class BackupSettings(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Type:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _TypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[BackupSettings._Type.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        TYPE_UNSPECIFIED: BackupSettings._Type.ValueType  # 0
        SYSTEM: BackupSettings._Type.ValueType  # 1
        USER: BackupSettings._Type.ValueType  # 2

    class Type(_Type, metaclass=_TypeEnumTypeWrapper): ...
    TYPE_UNSPECIFIED: BackupSettings.Type.ValueType  # 0
    SYSTEM: BackupSettings.Type.ValueType  # 1
    USER: BackupSettings.Type.ValueType  # 2

    class _StorageClass:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _StorageClassEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[BackupSettings._StorageClass.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        STORAGE_CLASS_UNSPECIFIED: BackupSettings._StorageClass.ValueType  # 0
        STANDARD: BackupSettings._StorageClass.ValueType  # 1
        REDUCED_REDUNDANCY: BackupSettings._StorageClass.ValueType  # 2
        STANDARD_IA: BackupSettings._StorageClass.ValueType  # 3
        ONEZONE_IA: BackupSettings._StorageClass.ValueType  # 4
        INTELLIGENT_TIERING: BackupSettings._StorageClass.ValueType  # 5
        GLACIER: BackupSettings._StorageClass.ValueType  # 6
        DEEP_ARCHIVE: BackupSettings._StorageClass.ValueType  # 7
        OUTPOSTS: BackupSettings._StorageClass.ValueType  # 8

    class StorageClass(_StorageClass, metaclass=_StorageClassEnumTypeWrapper): ...
    STORAGE_CLASS_UNSPECIFIED: BackupSettings.StorageClass.ValueType  # 0
    STANDARD: BackupSettings.StorageClass.ValueType  # 1
    REDUCED_REDUNDANCY: BackupSettings.StorageClass.ValueType  # 2
    STANDARD_IA: BackupSettings.StorageClass.ValueType  # 3
    ONEZONE_IA: BackupSettings.StorageClass.ValueType  # 4
    INTELLIGENT_TIERING: BackupSettings.StorageClass.ValueType  # 5
    GLACIER: BackupSettings.StorageClass.ValueType  # 6
    DEEP_ARCHIVE: BackupSettings.StorageClass.ValueType  # 7
    OUTPOSTS: BackupSettings.StorageClass.ValueType  # 8

    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    BACKUP_SCHEDULE_FIELD_NUMBER: builtins.int
    BACKUP_TIME_TO_LIVE_FIELD_NUMBER: builtins.int
    SOURCE_PATHS_FIELD_NUMBER: builtins.int
    SOURCE_PATHS_TO_EXCLUDE_FIELD_NUMBER: builtins.int
    TYPE_FIELD_NUMBER: builtins.int
    STORAGE_CLASS_FIELD_NUMBER: builtins.int
    name: builtins.str
    """name of backup settings"""
    description: builtins.str
    """human readable description."""
    type: global___BackupSettings.Type.ValueType
    storage_class: global___BackupSettings.StorageClass.ValueType
    @property
    def backup_schedule(self) -> global___BackupSchedule:
        """provide schedule. if empty, backup will be disabled."""

    @property
    def backup_time_to_live(self) -> google.protobuf.duration_pb2.Duration:
        """provide time to live of backup."""

    @property
    def source_paths(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """provide a list of source paths. Each path can be directory, table or even database itself.
        Each directory (or database) will be traversed recursively and all childs of directory will be included to backup.
        By default, backup will be created for full database.
        """

    @property
    def source_paths_to_exclude(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """provide a list of paths to exclude from backup.
        Each path is a directory, table, or database.
        Each directory (or database) will be traversed recursively and all childs of directory will be excluded.
        """

    def __init__(
        self,
        *,
        name: builtins.str = ...,
        description: builtins.str = ...,
        backup_schedule: global___BackupSchedule | None = ...,
        backup_time_to_live: google.protobuf.duration_pb2.Duration | None = ...,
        source_paths: collections.abc.Iterable[builtins.str] | None = ...,
        source_paths_to_exclude: collections.abc.Iterable[builtins.str] | None = ...,
        type: global___BackupSettings.Type.ValueType = ...,
        storage_class: global___BackupSettings.StorageClass.ValueType = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["backup_schedule", b"backup_schedule", "backup_time_to_live", b"backup_time_to_live"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["backup_schedule", b"backup_schedule", "backup_time_to_live", b"backup_time_to_live", "description", b"description", "name", b"name", "source_paths", b"source_paths", "source_paths_to_exclude", b"source_paths_to_exclude", "storage_class", b"storage_class", "type", b"type"]) -> None: ...

global___BackupSettings = BackupSettings

@typing.final
class BackupConfig(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    BACKUP_SETTINGS_FIELD_NUMBER: builtins.int
    @property
    def backup_settings(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___BackupSettings]: ...
    def __init__(
        self,
        *,
        backup_settings: collections.abc.Iterable[global___BackupSettings] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["backup_settings", b"backup_settings"]) -> None: ...

global___BackupConfig = BackupConfig

@typing.final
class Backup(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Status:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _StatusEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Backup._Status.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        STATUS_UNSPECIFIED: Backup._Status.ValueType  # 0
        CREATING: Backup._Status.ValueType  # 1
        READY: Backup._Status.ValueType  # 2
        ERROR: Backup._Status.ValueType  # 3
        CANCELLED: Backup._Status.ValueType  # 4

    class Status(_Status, metaclass=_StatusEnumTypeWrapper):
        """id of backup"""

    STATUS_UNSPECIFIED: Backup.Status.ValueType  # 0
    CREATING: Backup.Status.ValueType  # 1
    READY: Backup.Status.ValueType  # 2
    ERROR: Backup.Status.ValueType  # 3
    CANCELLED: Backup.Status.ValueType  # 4

    class _Type:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _TypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Backup._Type.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        TYPE_UNSPECIFIED: Backup._Type.ValueType  # 0
        SYSTEM: Backup._Type.ValueType  # 1
        """indicates that backup started by the system."""
        USER: Backup._Type.ValueType  # 2

    class Type(_Type, metaclass=_TypeEnumTypeWrapper): ...
    TYPE_UNSPECIFIED: Backup.Type.ValueType  # 0
    SYSTEM: Backup.Type.ValueType  # 1
    """indicates that backup started by the system."""
    USER: Backup.Type.ValueType  # 2

    ID_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    FOLDER_ID_FIELD_NUMBER: builtins.int
    DATABASE_ID_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    CREATED_AT_FIELD_NUMBER: builtins.int
    STARTED_AT_FIELD_NUMBER: builtins.int
    COMPLETED_AT_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    BACKUP_SETTINGS_FIELD_NUMBER: builtins.int
    TYPE_FIELD_NUMBER: builtins.int
    SIZE_FIELD_NUMBER: builtins.int
    id: builtins.str
    name: builtins.str
    """human readable backup name."""
    folder_id: builtins.str
    database_id: builtins.str
    description: builtins.str
    """description of backup."""
    status: global___Backup.Status.ValueType
    type: global___Backup.Type.ValueType
    size: builtins.int
    """size of backup in bytes."""
    @property
    def created_at(self) -> google.protobuf.timestamp_pb2.Timestamp: ...
    @property
    def started_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """indicates when backup started."""

    @property
    def completed_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """indicates when backup completed."""

    @property
    def backup_settings(self) -> global___BackupSettings:
        """settings used to make backup."""

    def __init__(
        self,
        *,
        id: builtins.str = ...,
        name: builtins.str = ...,
        folder_id: builtins.str = ...,
        database_id: builtins.str = ...,
        description: builtins.str = ...,
        created_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        started_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        completed_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        status: global___Backup.Status.ValueType = ...,
        backup_settings: global___BackupSettings | None = ...,
        type: global___Backup.Type.ValueType = ...,
        size: builtins.int = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["backup_settings", b"backup_settings", "completed_at", b"completed_at", "created_at", b"created_at", "started_at", b"started_at"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["backup_settings", b"backup_settings", "completed_at", b"completed_at", "created_at", b"created_at", "database_id", b"database_id", "description", b"description", "folder_id", b"folder_id", "id", b"id", "name", b"name", "size", b"size", "started_at", b"started_at", "status", b"status", "type", b"type"]) -> None: ...

global___Backup = Backup
