"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.duration_pb2
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.timestamp_pb2
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class Cluster(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Status:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _StatusEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Cluster._Status.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        STATUS_UNKNOWN: Cluster._Status.ValueType  # 0
        CREATING: Cluster._Status.ValueType  # 1
        """Cluster is being created."""
        RUNNING: Cluster._Status.ValueType  # 2
        """Cluster is running."""
        ERROR: Cluster._Status.ValueType  # 3
        """Cluster encountered a problem and cannot operate."""
        STOPPING: Cluster._Status.ValueType  # 4
        """Cluster is being stopped."""
        STOPPED: Cluster._Status.ValueType  # 5
        """Cluster stopped."""
        STARTING: Cluster._Status.ValueType  # 6
        """Cluster is being started."""
        UPDATING: Cluster._Status.ValueType  # 7
        """Cluster is being updated."""
        DELETING: Cluster._Status.ValueType  # 8
        """Cluster is being deleted."""

    class Status(_Status, metaclass=_StatusEnumTypeWrapper): ...
    STATUS_UNKNOWN: Cluster.Status.ValueType  # 0
    CREATING: Cluster.Status.ValueType  # 1
    """Cluster is being created."""
    RUNNING: Cluster.Status.ValueType  # 2
    """Cluster is running."""
    ERROR: Cluster.Status.ValueType  # 3
    """Cluster encountered a problem and cannot operate."""
    STOPPING: Cluster.Status.ValueType  # 4
    """Cluster is being stopped."""
    STOPPED: Cluster.Status.ValueType  # 5
    """Cluster stopped."""
    STARTING: Cluster.Status.ValueType  # 6
    """Cluster is being started."""
    UPDATING: Cluster.Status.ValueType  # 7
    """Cluster is being updated."""
    DELETING: Cluster.Status.ValueType  # 8
    """Cluster is being deleted."""

    class _Health:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _HealthEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Cluster._Health.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        HEALTH_UNKNOWN: Cluster._Health.ValueType  # 0
        ALIVE: Cluster._Health.ValueType  # 1
        """Cluster is alive."""
        DEAD: Cluster._Health.ValueType  # 2
        """Cluster is dead."""
        DEGRADED: Cluster._Health.ValueType  # 3
        """Cluster is degraded."""

    class Health(_Health, metaclass=_HealthEnumTypeWrapper): ...
    HEALTH_UNKNOWN: Cluster.Health.ValueType  # 0
    ALIVE: Cluster.Health.ValueType  # 1
    """Cluster is alive."""
    DEAD: Cluster.Health.ValueType  # 2
    """Cluster is dead."""
    DEGRADED: Cluster.Health.ValueType  # 3
    """Cluster is degraded."""

    @typing.final
    class LabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    @typing.final
    class Endpoints(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        UI_FIELD_NUMBER: builtins.int
        EXTERNAL_HTTP_PROXY_BALANCER_FIELD_NUMBER: builtins.int
        INTERNAL_HTTP_PROXY_ALIAS_FIELD_NUMBER: builtins.int
        INTERNAL_RPC_PROXY_ALIAS_FIELD_NUMBER: builtins.int
        ui: builtins.str
        """https://CID.ui.ytsaurus.yandexcloud.net"""
        external_http_proxy_balancer: builtins.str
        """https://CID.proxy.ytsaurus.yandexcloud.net"""
        internal_http_proxy_alias: builtins.str
        """https://hp.CID.ytsaurus.mdb.yandexcloud.net:PORT"""
        internal_rpc_proxy_alias: builtins.str
        """rp.CID.ytsaurus.mdb.yandexcloud.net:PORT"""
        def __init__(
            self,
            *,
            ui: builtins.str = ...,
            external_http_proxy_balancer: builtins.str = ...,
            internal_http_proxy_alias: builtins.str = ...,
            internal_rpc_proxy_alias: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["external_http_proxy_balancer", b"external_http_proxy_balancer", "internal_http_proxy_alias", b"internal_http_proxy_alias", "internal_rpc_proxy_alias", b"internal_rpc_proxy_alias", "ui", b"ui"]) -> None: ...

    ID_FIELD_NUMBER: builtins.int
    FOLDER_ID_FIELD_NUMBER: builtins.int
    ZONE_ID_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    SUBNET_ID_FIELD_NUMBER: builtins.int
    SECURITY_GROUP_IDS_FIELD_NUMBER: builtins.int
    SPEC_FIELD_NUMBER: builtins.int
    CREATED_AT_FIELD_NUMBER: builtins.int
    CREATED_BY_FIELD_NUMBER: builtins.int
    UPDATED_AT_FIELD_NUMBER: builtins.int
    UPDATED_BY_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    HEALTH_FIELD_NUMBER: builtins.int
    ENDPOINTS_FIELD_NUMBER: builtins.int
    id: builtins.str
    """ID of the cluster. Generated at creation time."""
    folder_id: builtins.str
    """ID of the folder that the cluster belongs to."""
    zone_id: builtins.str
    """ID of the availability zone where the cluster resides."""
    name: builtins.str
    """Name of the cluster.
    The name is unique within the folder.
    """
    description: builtins.str
    """Description of the cluster."""
    subnet_id: builtins.str
    """ID of the subnet where the cluster resides."""
    created_by: builtins.str
    """User who created the cluster."""
    updated_by: builtins.str
    """User who last updated the cluster."""
    status: global___Cluster.Status.ValueType
    """Status of the cluster."""
    health: global___Cluster.Health.ValueType
    """Health of the cluster."""
    @property
    def labels(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Cluster labels as `key:value` pairs."""

    @property
    def security_group_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Network interfaces security groups."""

    @property
    def spec(self) -> global___ClusterSpec:
        """Cluster specification."""

    @property
    def created_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Time when the cluster was created."""

    @property
    def updated_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Time when the cluster was last updated."""

    @property
    def endpoints(self) -> global___Cluster.Endpoints:
        """Endpoints of the cluster."""

    def __init__(
        self,
        *,
        id: builtins.str = ...,
        folder_id: builtins.str = ...,
        zone_id: builtins.str = ...,
        name: builtins.str = ...,
        description: builtins.str = ...,
        labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        subnet_id: builtins.str = ...,
        security_group_ids: collections.abc.Iterable[builtins.str] | None = ...,
        spec: global___ClusterSpec | None = ...,
        created_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        created_by: builtins.str = ...,
        updated_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        updated_by: builtins.str = ...,
        status: global___Cluster.Status.ValueType = ...,
        health: global___Cluster.Health.ValueType = ...,
        endpoints: global___Cluster.Endpoints | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["created_at", b"created_at", "endpoints", b"endpoints", "spec", b"spec", "updated_at", b"updated_at"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["created_at", b"created_at", "created_by", b"created_by", "description", b"description", "endpoints", b"endpoints", "folder_id", b"folder_id", "health", b"health", "id", b"id", "labels", b"labels", "name", b"name", "security_group_ids", b"security_group_ids", "spec", b"spec", "status", b"status", "subnet_id", b"subnet_id", "updated_at", b"updated_at", "updated_by", b"updated_by", "zone_id", b"zone_id"]) -> None: ...

global___Cluster = Cluster

@typing.final
class StorageSpec(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class HddSpec(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        SIZE_GB_FIELD_NUMBER: builtins.int
        COUNT_FIELD_NUMBER: builtins.int
        size_gb: builtins.int
        count: builtins.int
        def __init__(
            self,
            *,
            size_gb: builtins.int = ...,
            count: builtins.int = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["count", b"count", "size_gb", b"size_gb"]) -> None: ...

    @typing.final
    class SsdSpec(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        SIZE_GB_FIELD_NUMBER: builtins.int
        TYPE_FIELD_NUMBER: builtins.int
        COUNT_FIELD_NUMBER: builtins.int
        size_gb: builtins.int
        type: builtins.str
        count: builtins.int
        def __init__(
            self,
            *,
            size_gb: builtins.int = ...,
            type: builtins.str = ...,
            count: builtins.int = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["count", b"count", "size_gb", b"size_gb", "type", b"type"]) -> None: ...

    HDD_FIELD_NUMBER: builtins.int
    SSD_FIELD_NUMBER: builtins.int
    @property
    def hdd(self) -> global___StorageSpec.HddSpec: ...
    @property
    def ssd(self) -> global___StorageSpec.SsdSpec: ...
    def __init__(
        self,
        *,
        hdd: global___StorageSpec.HddSpec | None = ...,
        ssd: global___StorageSpec.SsdSpec | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["hdd", b"hdd", "ssd", b"ssd"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["hdd", b"hdd", "ssd", b"ssd"]) -> None: ...

global___StorageSpec = StorageSpec

@typing.final
class ComputeSpec(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class DiskSpec(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        TYPE_FIELD_NUMBER: builtins.int
        SIZE_GB_FIELD_NUMBER: builtins.int
        LOCATIONS_FIELD_NUMBER: builtins.int
        type: builtins.str
        size_gb: builtins.int
        @property
        def locations(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]: ...
        def __init__(
            self,
            *,
            type: builtins.str = ...,
            size_gb: builtins.int = ...,
            locations: collections.abc.Iterable[builtins.str] | None = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["locations", b"locations", "size_gb", b"size_gb", "type", b"type"]) -> None: ...

    @typing.final
    class ScalePolicy(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        @typing.final
        class FixedScale(google.protobuf.message.Message):
            DESCRIPTOR: google.protobuf.descriptor.Descriptor

            SIZE_FIELD_NUMBER: builtins.int
            size: builtins.int
            def __init__(
                self,
                *,
                size: builtins.int = ...,
            ) -> None: ...
            def ClearField(self, field_name: typing.Literal["size", b"size"]) -> None: ...

        @typing.final
        class AutoScale(google.protobuf.message.Message):
            DESCRIPTOR: google.protobuf.descriptor.Descriptor

            MIN_SIZE_FIELD_NUMBER: builtins.int
            MAX_SIZE_FIELD_NUMBER: builtins.int
            min_size: builtins.int
            max_size: builtins.int
            def __init__(
                self,
                *,
                min_size: builtins.int = ...,
                max_size: builtins.int = ...,
            ) -> None: ...
            def ClearField(self, field_name: typing.Literal["max_size", b"max_size", "min_size", b"min_size"]) -> None: ...

        FIXED_FIELD_NUMBER: builtins.int
        AUTO_FIELD_NUMBER: builtins.int
        @property
        def fixed(self) -> global___ComputeSpec.ScalePolicy.FixedScale: ...
        @property
        def auto(self) -> global___ComputeSpec.ScalePolicy.AutoScale: ...
        def __init__(
            self,
            *,
            fixed: global___ComputeSpec.ScalePolicy.FixedScale | None = ...,
            auto: global___ComputeSpec.ScalePolicy.AutoScale | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["auto", b"auto", "fixed", b"fixed", "policy", b"policy"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["auto", b"auto", "fixed", b"fixed", "policy", b"policy"]) -> None: ...
        def WhichOneof(self, oneof_group: typing.Literal["policy", b"policy"]) -> typing.Literal["fixed", "auto"] | None: ...

    PRESET_FIELD_NUMBER: builtins.int
    DISKS_FIELD_NUMBER: builtins.int
    SCALE_POLICY_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    preset: builtins.str
    name: builtins.str
    """Name for exec pool."""
    @property
    def disks(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ComputeSpec.DiskSpec]: ...
    @property
    def scale_policy(self) -> global___ComputeSpec.ScalePolicy: ...
    def __init__(
        self,
        *,
        preset: builtins.str = ...,
        disks: collections.abc.Iterable[global___ComputeSpec.DiskSpec] | None = ...,
        scale_policy: global___ComputeSpec.ScalePolicy | None = ...,
        name: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["scale_policy", b"scale_policy"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["disks", b"disks", "name", b"name", "preset", b"preset", "scale_policy", b"scale_policy"]) -> None: ...

global___ComputeSpec = ComputeSpec

@typing.final
class HttpProxySpec(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    COUNT_FIELD_NUMBER: builtins.int
    count: builtins.int
    def __init__(
        self,
        *,
        count: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["count", b"count"]) -> None: ...

global___HttpProxySpec = HttpProxySpec

@typing.final
class RpcProxySpec(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    COUNT_FIELD_NUMBER: builtins.int
    count: builtins.int
    def __init__(
        self,
        *,
        count: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["count", b"count"]) -> None: ...

global___RpcProxySpec = RpcProxySpec

@typing.final
class TabletSpec(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PRESET_FIELD_NUMBER: builtins.int
    COUNT_FIELD_NUMBER: builtins.int
    preset: builtins.str
    count: builtins.int
    def __init__(
        self,
        *,
        preset: builtins.str = ...,
        count: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["count", b"count", "preset", b"preset"]) -> None: ...

global___TabletSpec = TabletSpec

@typing.final
class ProxySpec(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    HTTP_FIELD_NUMBER: builtins.int
    RPC_FIELD_NUMBER: builtins.int
    @property
    def http(self) -> global___HttpProxySpec: ...
    @property
    def rpc(self) -> global___RpcProxySpec: ...
    def __init__(
        self,
        *,
        http: global___HttpProxySpec | None = ...,
        rpc: global___RpcProxySpec | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["http", b"http", "rpc", b"rpc"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["http", b"http", "rpc", b"rpc"]) -> None: ...

global___ProxySpec = ProxySpec

@typing.final
class OdinSpec(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CHECKS_TTL_FIELD_NUMBER: builtins.int
    @property
    def checks_ttl(self) -> google.protobuf.duration_pb2.Duration: ...
    def __init__(
        self,
        *,
        checks_ttl: google.protobuf.duration_pb2.Duration | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["checks_ttl", b"checks_ttl"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["checks_ttl", b"checks_ttl"]) -> None: ...

global___OdinSpec = OdinSpec

@typing.final
class ClusterSpec(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Flavor:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _FlavorEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[ClusterSpec._Flavor.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        FLAVOR_UNSPECIFIED: ClusterSpec._Flavor.ValueType  # 0
        DEMO: ClusterSpec._Flavor.ValueType  # 1
        """Demo cluster configuration with minimal system resources. Not fault-tolerant, not for production use."""

    class Flavor(_Flavor, metaclass=_FlavorEnumTypeWrapper): ...
    FLAVOR_UNSPECIFIED: ClusterSpec.Flavor.ValueType  # 0
    DEMO: ClusterSpec.Flavor.ValueType  # 1
    """Demo cluster configuration with minimal system resources. Not fault-tolerant, not for production use."""

    STORAGE_FIELD_NUMBER: builtins.int
    COMPUTE_FIELD_NUMBER: builtins.int
    TABLET_FIELD_NUMBER: builtins.int
    PROXY_FIELD_NUMBER: builtins.int
    ODIN_FIELD_NUMBER: builtins.int
    FLAVOR_FIELD_NUMBER: builtins.int
    flavor: global___ClusterSpec.Flavor.ValueType
    @property
    def storage(self) -> global___StorageSpec: ...
    @property
    def compute(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ComputeSpec]: ...
    @property
    def tablet(self) -> global___TabletSpec: ...
    @property
    def proxy(self) -> global___ProxySpec: ...
    @property
    def odin(self) -> global___OdinSpec: ...
    def __init__(
        self,
        *,
        storage: global___StorageSpec | None = ...,
        compute: collections.abc.Iterable[global___ComputeSpec] | None = ...,
        tablet: global___TabletSpec | None = ...,
        proxy: global___ProxySpec | None = ...,
        odin: global___OdinSpec | None = ...,
        flavor: global___ClusterSpec.Flavor.ValueType = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["odin", b"odin", "proxy", b"proxy", "storage", b"storage", "tablet", b"tablet"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["compute", b"compute", "flavor", b"flavor", "odin", b"odin", "proxy", b"proxy", "storage", b"storage", "tablet", b"tablet"]) -> None: ...

global___ClusterSpec = ClusterSpec
