"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ConsumerGroup = exports.ConsumerGroupProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const dts_generated_1 = require("./dts.generated");
Object.defineProperty(exports, "ConsumerGroupProperty", { enumerable: true, get: function () { return dts_generated_1.RosConsumerGroup; } });
/**
 * This class encapsulates and extends the ROS resource type `ALIYUN::DTS::ConsumerGroup`, which is used to create a consumer group for a change tracking instance.
 * @Note This class may have some new functions to facilitate development, so it is recommended to use this class instead of `RosConsumerGroup`for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/aliyun-dts-consumergroup
 */
class ConsumerGroup extends ros.Resource {
    /**
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        this.scope = scope;
        this.id = id;
        this.props = props;
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        const rosConsumerGroup = new dts_generated_1.RosConsumerGroup(this, id, {
            consumerGroupPassword: props.consumerGroupPassword,
            consumerGroupUserName: props.consumerGroupUserName,
            consumerGroupName: props.consumerGroupName,
            subscriptionInstanceId: props.subscriptionInstanceId,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosConsumerGroup;
        this.attrConsumerGroupId = rosConsumerGroup.attrConsumerGroupId;
        this.attrConsumerGroupName = rosConsumerGroup.attrConsumerGroupName;
        this.attrSubscriptionInstanceId = rosConsumerGroup.attrSubscriptionInstanceId;
    }
}
exports.ConsumerGroup = ConsumerGroup;
//# sourceMappingURL=data:application/json;base64,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