"use strict";
// Generated from the AliCloud ROS Resource Specification
Object.defineProperty(exports, "__esModule", { value: true });
exports.RosSynchronizationJob2 = exports.RosSubscriptionJob2 = exports.RosMigrationJob2 = exports.RosInstance = exports.RosConsumerGroup = void 0;
const ros = require("@alicloud/ros-cdk-core");
/**
 * Determine whether the given properties match those of a `RosConsumerGroupProps`
 *
 * @param properties - the TypeScript properties of a `RosConsumerGroupProps`
 *
 * @returns the result of the validation.
 */
function RosConsumerGroupPropsValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('consumerGroupPassword', ros.requiredValidator)(properties.consumerGroupPassword));
    errors.collect(ros.propertyValidator('consumerGroupPassword', ros.validateString)(properties.consumerGroupPassword));
    errors.collect(ros.propertyValidator('consumerGroupUserName', ros.requiredValidator)(properties.consumerGroupUserName));
    errors.collect(ros.propertyValidator('consumerGroupUserName', ros.validateString)(properties.consumerGroupUserName));
    errors.collect(ros.propertyValidator('consumerGroupName', ros.requiredValidator)(properties.consumerGroupName));
    errors.collect(ros.propertyValidator('consumerGroupName', ros.validateString)(properties.consumerGroupName));
    errors.collect(ros.propertyValidator('subscriptionInstanceId', ros.requiredValidator)(properties.subscriptionInstanceId));
    errors.collect(ros.propertyValidator('subscriptionInstanceId', ros.validateString)(properties.subscriptionInstanceId));
    return errors.wrap('supplied properties not correct for "RosConsumerGroupProps"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::DTS::ConsumerGroup` resource
 *
 * @param properties - the TypeScript properties of a `RosConsumerGroupProps`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::DTS::ConsumerGroup` resource.
 */
// @ts-ignore TS6133
function rosConsumerGroupPropsToRosTemplate(properties, enableResourcePropertyConstraint) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    if (enableResourcePropertyConstraint) {
        RosConsumerGroupPropsValidator(properties).assertSuccess();
    }
    return {
        ConsumerGroupName: ros.stringToRosTemplate(properties.consumerGroupName),
        ConsumerGroupPassword: ros.stringToRosTemplate(properties.consumerGroupPassword),
        ConsumerGroupUserName: ros.stringToRosTemplate(properties.consumerGroupUserName),
        SubscriptionInstanceId: ros.stringToRosTemplate(properties.subscriptionInstanceId),
    };
}
/**
 * This class is a base encapsulation around the ROS resource type `ALIYUN::DTS::ConsumerGroup`, which is used to create a consumer group for a change tracking instance.
 * @Note This class does not contain additional functions, so it is recommended to use the `ConsumerGroup` class instead of this class for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/aliyun-dts-consumergroup
 */
class RosConsumerGroup extends ros.RosResource {
    /**
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint) {
        super(scope, id, { type: RosConsumerGroup.ROS_RESOURCE_TYPE_NAME, properties: props });
        this.attrConsumerGroupId = this.getAtt('ConsumerGroupID');
        this.attrConsumerGroupName = this.getAtt('ConsumerGroupName');
        this.attrSubscriptionInstanceId = this.getAtt('SubscriptionInstanceId');
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        this.consumerGroupName = props.consumerGroupName;
        this.consumerGroupPassword = props.consumerGroupPassword;
        this.consumerGroupUserName = props.consumerGroupUserName;
        this.subscriptionInstanceId = props.subscriptionInstanceId;
    }
    get rosProperties() {
        return {
            consumerGroupName: this.consumerGroupName,
            consumerGroupPassword: this.consumerGroupPassword,
            consumerGroupUserName: this.consumerGroupUserName,
            subscriptionInstanceId: this.subscriptionInstanceId,
        };
    }
    renderProperties(props) {
        return rosConsumerGroupPropsToRosTemplate(props, this.enableResourcePropertyConstraint);
    }
}
exports.RosConsumerGroup = RosConsumerGroup;
/**
 * The resource type name for this resource class.
 */
RosConsumerGroup.ROS_RESOURCE_TYPE_NAME = "ALIYUN::DTS::ConsumerGroup";
/**
 * Determine whether the given properties match those of a `RosInstanceProps`
 *
 * @param properties - the TypeScript properties of a `RosInstanceProps`
 *
 * @returns the result of the validation.
 */
function RosInstancePropsValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('resourceGroupId', ros.validateString)(properties.resourceGroupId));
    errors.collect(ros.propertyValidator('feeType', ros.validateString)(properties.feeType));
    errors.collect(ros.propertyValidator('computeUnit', ros.validateNumber)(properties.computeUnit));
    if (properties.period && (typeof properties.period) !== 'object') {
        errors.collect(ros.propertyValidator('period', ros.validateAllowedValues)({
            data: properties.period,
            allowedValues: ["Month", "Year"],
        }));
    }
    errors.collect(ros.propertyValidator('period', ros.validateString)(properties.period));
    errors.collect(ros.propertyValidator('destinationRegion', ros.validateString)(properties.destinationRegion));
    errors.collect(ros.propertyValidator('instanceClass', ros.requiredValidator)(properties.instanceClass));
    if (properties.instanceClass && (typeof properties.instanceClass) !== 'object') {
        errors.collect(ros.propertyValidator('instanceClass', ros.validateAllowedValues)({
            data: properties.instanceClass,
            allowedValues: ["xxlarge", "xlarge", "large", "medium", "small", "micro"],
        }));
    }
    errors.collect(ros.propertyValidator('instanceClass', ros.validateString)(properties.instanceClass));
    errors.collect(ros.propertyValidator('sourceEndpointEngineName', ros.validateString)(properties.sourceEndpointEngineName));
    errors.collect(ros.propertyValidator('payType', ros.requiredValidator)(properties.payType));
    if (properties.payType && (typeof properties.payType) !== 'object') {
        errors.collect(ros.propertyValidator('payType', ros.validateAllowedValues)({
            data: properties.payType,
            allowedValues: ["PayAsYouGo", "PostPaid", "PayOnDemand", "Postpaid", "PostPay", "Postpay", "POSTPAY", "POST", "Subscription", "PrePaid", "Prepaid", "PrePay", "Prepay", "PREPAY", "PRE"],
        }));
    }
    errors.collect(ros.propertyValidator('payType', ros.validateString)(properties.payType));
    errors.collect(ros.propertyValidator('autoPay', ros.validateBoolean)(properties.autoPay));
    errors.collect(ros.propertyValidator('destinationEndpointEngineName', ros.validateString)(properties.destinationEndpointEngineName));
    errors.collect(ros.propertyValidator('sourceRegion', ros.validateString)(properties.sourceRegion));
    if (properties.du && (typeof properties.du) !== 'object') {
        errors.collect(ros.propertyValidator('du', ros.validateRange)({
            data: properties.du,
            min: 1,
            max: 100,
        }));
    }
    errors.collect(ros.propertyValidator('du', ros.validateNumber)(properties.du));
    errors.collect(ros.propertyValidator('type', ros.requiredValidator)(properties.type));
    if (properties.type && (typeof properties.type) !== 'object') {
        errors.collect(ros.propertyValidator('type', ros.validateAllowedValues)({
            data: properties.type,
            allowedValues: ["MIGRATION", "SYNC", "SUBSCRIBE"],
        }));
    }
    errors.collect(ros.propertyValidator('type', ros.validateString)(properties.type));
    errors.collect(ros.propertyValidator('databaseCount', ros.validateNumber)(properties.databaseCount));
    if (properties.usedTime && (typeof properties.usedTime) !== 'object') {
        errors.collect(ros.propertyValidator('usedTime', ros.validateAllowedValues)({
            data: properties.usedTime,
            allowedValues: [1, 2, 3, 4, 5, 6, 7, 8, 9],
        }));
    }
    errors.collect(ros.propertyValidator('usedTime', ros.validateNumber)(properties.usedTime));
    errors.collect(ros.propertyValidator('autoStart', ros.validateBoolean)(properties.autoStart));
    errors.collect(ros.propertyValidator('jobId', ros.validateString)(properties.jobId));
    if (properties.syncArchitecture && (typeof properties.syncArchitecture) !== 'object') {
        errors.collect(ros.propertyValidator('syncArchitecture', ros.validateAllowedValues)({
            data: properties.syncArchitecture,
            allowedValues: ["oneway", "bidirectional"],
        }));
    }
    errors.collect(ros.propertyValidator('syncArchitecture', ros.validateString)(properties.syncArchitecture));
    return errors.wrap('supplied properties not correct for "RosInstanceProps"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::DTS::Instance` resource
 *
 * @param properties - the TypeScript properties of a `RosInstanceProps`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::DTS::Instance` resource.
 */
// @ts-ignore TS6133
function rosInstancePropsToRosTemplate(properties, enableResourcePropertyConstraint) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    if (enableResourcePropertyConstraint) {
        RosInstancePropsValidator(properties).assertSuccess();
    }
    return {
        InstanceClass: ros.stringToRosTemplate(properties.instanceClass),
        PayType: ros.stringToRosTemplate(properties.payType),
        Type: ros.stringToRosTemplate(properties.type),
        AutoPay: ros.booleanToRosTemplate(properties.autoPay),
        AutoStart: ros.booleanToRosTemplate(properties.autoStart),
        ComputeUnit: ros.numberToRosTemplate(properties.computeUnit),
        DatabaseCount: ros.numberToRosTemplate(properties.databaseCount),
        DestinationEndpointEngineName: ros.stringToRosTemplate(properties.destinationEndpointEngineName),
        DestinationRegion: ros.stringToRosTemplate(properties.destinationRegion),
        Du: ros.numberToRosTemplate(properties.du),
        FeeType: ros.stringToRosTemplate(properties.feeType),
        JobId: ros.stringToRosTemplate(properties.jobId),
        Period: ros.stringToRosTemplate(properties.period),
        ResourceGroupId: ros.stringToRosTemplate(properties.resourceGroupId),
        SourceEndpointEngineName: ros.stringToRosTemplate(properties.sourceEndpointEngineName),
        SourceRegion: ros.stringToRosTemplate(properties.sourceRegion),
        SyncArchitecture: ros.stringToRosTemplate(properties.syncArchitecture),
        UsedTime: ros.numberToRosTemplate(properties.usedTime),
    };
}
/**
 * This class is a base encapsulation around the ROS resource type `ALIYUN::DTS::Instance`, which is a new resource type that is used to create a Data Transmission Service (DTS) instance.
 * @Note This class does not contain additional functions, so it is recommended to use the `Instance` class instead of this class for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/aliyun-dts-instance
 */
class RosInstance extends ros.RosResource {
    /**
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint) {
        super(scope, id, { type: RosInstance.ROS_RESOURCE_TYPE_NAME, properties: props });
        this.attrInstanceId = this.getAtt('InstanceId');
        this.attrJobId = this.getAtt('JobId');
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        this.instanceClass = props.instanceClass;
        this.payType = props.payType;
        this.type = props.type;
        this.autoPay = props.autoPay;
        this.autoStart = props.autoStart;
        this.computeUnit = props.computeUnit;
        this.databaseCount = props.databaseCount;
        this.destinationEndpointEngineName = props.destinationEndpointEngineName;
        this.destinationRegion = props.destinationRegion;
        this.du = props.du;
        this.feeType = props.feeType;
        this.jobId = props.jobId;
        this.period = props.period;
        this.resourceGroupId = props.resourceGroupId;
        this.sourceEndpointEngineName = props.sourceEndpointEngineName;
        this.sourceRegion = props.sourceRegion;
        this.syncArchitecture = props.syncArchitecture;
        this.usedTime = props.usedTime;
    }
    get rosProperties() {
        return {
            instanceClass: this.instanceClass,
            payType: this.payType,
            type: this.type,
            autoPay: this.autoPay,
            autoStart: this.autoStart,
            computeUnit: this.computeUnit,
            databaseCount: this.databaseCount,
            destinationEndpointEngineName: this.destinationEndpointEngineName,
            destinationRegion: this.destinationRegion,
            du: this.du,
            feeType: this.feeType,
            jobId: this.jobId,
            period: this.period,
            resourceGroupId: this.resourceGroupId,
            sourceEndpointEngineName: this.sourceEndpointEngineName,
            sourceRegion: this.sourceRegion,
            syncArchitecture: this.syncArchitecture,
            usedTime: this.usedTime,
        };
    }
    renderProperties(props) {
        return rosInstancePropsToRosTemplate(props, this.enableResourcePropertyConstraint);
    }
}
exports.RosInstance = RosInstance;
/**
 * The resource type name for this resource class.
 */
RosInstance.ROS_RESOURCE_TYPE_NAME = "ALIYUN::DTS::Instance";
/**
 * Determine whether the given properties match those of a `RosMigrationJob2Props`
 *
 * @param properties - the TypeScript properties of a `RosMigrationJob2Props`
 *
 * @returns the result of the validation.
 */
function RosMigrationJob2PropsValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    if (properties.status && (typeof properties.status) !== 'object') {
        errors.collect(ros.propertyValidator('status', ros.validateAllowedValues)({
            data: properties.status,
            allowedValues: ["Migrating", "Suspending", "Stopping"],
        }));
    }
    errors.collect(ros.propertyValidator('status', ros.validateString)(properties.status));
    errors.collect(ros.propertyValidator('reserve', ros.hashValidator(ros.validateAny))(properties.reserve));
    errors.collect(ros.propertyValidator('dataSynchronization', ros.requiredValidator)(properties.dataSynchronization));
    errors.collect(ros.propertyValidator('dataSynchronization', ros.validateBoolean)(properties.dataSynchronization));
    errors.collect(ros.propertyValidator('dedicatedClusterId', ros.validateString)(properties.dedicatedClusterId));
    errors.collect(ros.propertyValidator('delayPhone', ros.validateString)(properties.delayPhone));
    errors.collect(ros.propertyValidator('errorNotice', ros.validateBoolean)(properties.errorNotice));
    errors.collect(ros.propertyValidator('dtsJobName', ros.requiredValidator)(properties.dtsJobName));
    errors.collect(ros.propertyValidator('dtsJobName', ros.validateString)(properties.dtsJobName));
    errors.collect(ros.propertyValidator('delayRuleTime', ros.validateNumber)(properties.delayRuleTime));
    errors.collect(ros.propertyValidator('dtsInstanceId', ros.validateString)(properties.dtsInstanceId));
    errors.collect(ros.propertyValidator('dbList', ros.requiredValidator)(properties.dbList));
    errors.collect(ros.propertyValidator('dbList', ros.hashValidator(ros.validateAny))(properties.dbList));
    errors.collect(ros.propertyValidator('fileOssUrl', ros.validateString)(properties.fileOssUrl));
    errors.collect(ros.propertyValidator('dataCheckConfigure', RosMigrationJob2_DataCheckConfigurePropertyValidator)(properties.dataCheckConfigure));
    errors.collect(ros.propertyValidator('dtsBisLabel', ros.validateString)(properties.dtsBisLabel));
    errors.collect(ros.propertyValidator('checkpoint', ros.validateString)(properties.checkpoint));
    errors.collect(ros.propertyValidator('disasterRecoveryJob', ros.validateBoolean)(properties.disasterRecoveryJob));
    errors.collect(ros.propertyValidator('dtsJobId', ros.validateString)(properties.dtsJobId));
    errors.collect(ros.propertyValidator('delayNotice', ros.validateBoolean)(properties.delayNotice));
    errors.collect(ros.propertyValidator('dataInitialization', ros.requiredValidator)(properties.dataInitialization));
    errors.collect(ros.propertyValidator('dataInitialization', ros.validateBoolean)(properties.dataInitialization));
    errors.collect(ros.propertyValidator('destinationEndpoint', ros.requiredValidator)(properties.destinationEndpoint));
    errors.collect(ros.propertyValidator('destinationEndpoint', RosMigrationJob2_DestinationEndpointPropertyValidator)(properties.destinationEndpoint));
    errors.collect(ros.propertyValidator('sourceEndpoint', ros.requiredValidator)(properties.sourceEndpoint));
    errors.collect(ros.propertyValidator('sourceEndpoint', RosMigrationJob2_SourceEndpointPropertyValidator)(properties.sourceEndpoint));
    errors.collect(ros.propertyValidator('errorPhone', ros.validateString)(properties.errorPhone));
    errors.collect(ros.propertyValidator('structureInitialization', ros.requiredValidator)(properties.structureInitialization));
    errors.collect(ros.propertyValidator('structureInitialization', ros.validateBoolean)(properties.structureInitialization));
    return errors.wrap('supplied properties not correct for "RosMigrationJob2Props"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::DTS::MigrationJob2` resource
 *
 * @param properties - the TypeScript properties of a `RosMigrationJob2Props`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::DTS::MigrationJob2` resource.
 */
// @ts-ignore TS6133
function rosMigrationJob2PropsToRosTemplate(properties, enableResourcePropertyConstraint) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    if (enableResourcePropertyConstraint) {
        RosMigrationJob2PropsValidator(properties).assertSuccess();
    }
    return {
        DataInitialization: ros.booleanToRosTemplate(properties.dataInitialization),
        DataSynchronization: ros.booleanToRosTemplate(properties.dataSynchronization),
        DbList: ros.hashMapper(ros.objectToRosTemplate)(properties.dbList),
        DestinationEndpoint: rosMigrationJob2DestinationEndpointPropertyToRosTemplate(properties.destinationEndpoint),
        DtsJobName: ros.stringToRosTemplate(properties.dtsJobName),
        SourceEndpoint: rosMigrationJob2SourceEndpointPropertyToRosTemplate(properties.sourceEndpoint),
        StructureInitialization: ros.booleanToRosTemplate(properties.structureInitialization),
        Checkpoint: ros.stringToRosTemplate(properties.checkpoint),
        DataCheckConfigure: rosMigrationJob2DataCheckConfigurePropertyToRosTemplate(properties.dataCheckConfigure),
        DedicatedClusterId: ros.stringToRosTemplate(properties.dedicatedClusterId),
        DelayNotice: ros.booleanToRosTemplate(properties.delayNotice),
        DelayPhone: ros.stringToRosTemplate(properties.delayPhone),
        DelayRuleTime: ros.numberToRosTemplate(properties.delayRuleTime),
        DisasterRecoveryJob: ros.booleanToRosTemplate(properties.disasterRecoveryJob),
        DtsBisLabel: ros.stringToRosTemplate(properties.dtsBisLabel),
        DtsInstanceId: ros.stringToRosTemplate(properties.dtsInstanceId),
        DtsJobId: ros.stringToRosTemplate(properties.dtsJobId),
        ErrorNotice: ros.booleanToRosTemplate(properties.errorNotice),
        ErrorPhone: ros.stringToRosTemplate(properties.errorPhone),
        FileOssUrl: ros.stringToRosTemplate(properties.fileOssUrl),
        Reserve: ros.hashMapper(ros.objectToRosTemplate)(properties.reserve),
        Status: ros.stringToRosTemplate(properties.status),
    };
}
/**
 * This class is a base encapsulation around the ROS resource type `ALIYUN::DTS::MigrationJob2`, which is used to purchase a data migration instance and configure a data migration task of the new version.
 * @Note This class does not contain additional functions, so it is recommended to use the `MigrationJob2` class instead of this class for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/aliyun-dts-migrationjob2
 */
class RosMigrationJob2 extends ros.RosResource {
    /**
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint) {
        super(scope, id, { type: RosMigrationJob2.ROS_RESOURCE_TYPE_NAME, properties: props });
        this.attrDtsInstanceId = this.getAtt('DtsInstanceId');
        this.attrDtsJobId = this.getAtt('DtsJobId');
        this.attrDtsJobName = this.getAtt('DtsJobName');
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        this.dataInitialization = props.dataInitialization;
        this.dataSynchronization = props.dataSynchronization;
        this.dbList = props.dbList;
        this.destinationEndpoint = props.destinationEndpoint;
        this.dtsJobName = props.dtsJobName;
        this.sourceEndpoint = props.sourceEndpoint;
        this.structureInitialization = props.structureInitialization;
        this.checkpoint = props.checkpoint;
        this.dataCheckConfigure = props.dataCheckConfigure;
        this.dedicatedClusterId = props.dedicatedClusterId;
        this.delayNotice = props.delayNotice;
        this.delayPhone = props.delayPhone;
        this.delayRuleTime = props.delayRuleTime;
        this.disasterRecoveryJob = props.disasterRecoveryJob;
        this.dtsBisLabel = props.dtsBisLabel;
        this.dtsInstanceId = props.dtsInstanceId;
        this.dtsJobId = props.dtsJobId;
        this.errorNotice = props.errorNotice;
        this.errorPhone = props.errorPhone;
        this.fileOssUrl = props.fileOssUrl;
        this.reserve = props.reserve;
        this.status = props.status;
    }
    get rosProperties() {
        return {
            dataInitialization: this.dataInitialization,
            dataSynchronization: this.dataSynchronization,
            dbList: this.dbList,
            destinationEndpoint: this.destinationEndpoint,
            dtsJobName: this.dtsJobName,
            sourceEndpoint: this.sourceEndpoint,
            structureInitialization: this.structureInitialization,
            checkpoint: this.checkpoint,
            dataCheckConfigure: this.dataCheckConfigure,
            dedicatedClusterId: this.dedicatedClusterId,
            delayNotice: this.delayNotice,
            delayPhone: this.delayPhone,
            delayRuleTime: this.delayRuleTime,
            disasterRecoveryJob: this.disasterRecoveryJob,
            dtsBisLabel: this.dtsBisLabel,
            dtsInstanceId: this.dtsInstanceId,
            dtsJobId: this.dtsJobId,
            errorNotice: this.errorNotice,
            errorPhone: this.errorPhone,
            fileOssUrl: this.fileOssUrl,
            reserve: this.reserve,
            status: this.status,
        };
    }
    renderProperties(props) {
        return rosMigrationJob2PropsToRosTemplate(props, this.enableResourcePropertyConstraint);
    }
}
exports.RosMigrationJob2 = RosMigrationJob2;
/**
 * The resource type name for this resource class.
 */
RosMigrationJob2.ROS_RESOURCE_TYPE_NAME = "ALIYUN::DTS::MigrationJob2";
/**
 * Determine whether the given properties match those of a `DataCheckConfigureProperty`
 *
 * @param properties - the TypeScript properties of a `DataCheckConfigureProperty`
 *
 * @returns the result of the validation.
 */
function RosMigrationJob2_DataCheckConfigurePropertyValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    if (properties.fullCheckMaxReadRps && (typeof properties.fullCheckMaxReadRps) !== 'object') {
        errors.collect(ros.propertyValidator('fullCheckMaxReadRps', ros.validateRange)({
            data: properties.fullCheckMaxReadRps,
            min: 0,
            max: 9007199254740991,
        }));
    }
    errors.collect(ros.propertyValidator('fullCheckMaxReadRps', ros.validateNumber)(properties.fullCheckMaxReadRps));
    errors.collect(ros.propertyValidator('dataCheckNoticePhone', ros.validateString)(properties.dataCheckNoticePhone));
    errors.collect(ros.propertyValidator('incrementalCheckDelayNotice', ros.validateBoolean)(properties.incrementalCheckDelayNotice));
    errors.collect(ros.propertyValidator('incrementalCheckDelayNoticeValue', ros.validateNumber)(properties.incrementalCheckDelayNoticeValue));
    if (properties.incrementalCheckDelayNoticePeriod && (typeof properties.incrementalCheckDelayNoticePeriod) !== 'object') {
        errors.collect(ros.propertyValidator('incrementalCheckDelayNoticePeriod', ros.validateAllowedValues)({
            data: properties.incrementalCheckDelayNoticePeriod,
            allowedValues: [1, 2, 3, 4],
        }));
    }
    errors.collect(ros.propertyValidator('incrementalCheckDelayNoticePeriod', ros.validateNumber)(properties.incrementalCheckDelayNoticePeriod));
    errors.collect(ros.propertyValidator('dataCheckDbList', ros.validateString)(properties.dataCheckDbList));
    if (properties.checkMaximumHourEnable && (typeof properties.checkMaximumHourEnable) !== 'object') {
        errors.collect(ros.propertyValidator('checkMaximumHourEnable', ros.validateAllowedValues)({
            data: properties.checkMaximumHourEnable,
            allowedValues: [0, 1],
        }));
    }
    errors.collect(ros.propertyValidator('checkMaximumHourEnable', ros.validateNumber)(properties.checkMaximumHourEnable));
    if (properties.fullCheckRatio && (typeof properties.fullCheckRatio) !== 'object') {
        errors.collect(ros.propertyValidator('fullCheckRatio', ros.validateRange)({
            data: properties.fullCheckRatio,
            min: 10,
            max: 100,
        }));
    }
    errors.collect(ros.propertyValidator('fullCheckRatio', ros.validateNumber)(properties.fullCheckRatio));
    if (properties.checkMaximumHour && (typeof properties.checkMaximumHour) !== 'object') {
        errors.collect(ros.propertyValidator('checkMaximumHour', ros.validateRange)({
            data: properties.checkMaximumHour,
            min: 1,
            max: 72,
        }));
    }
    errors.collect(ros.propertyValidator('checkMaximumHour', ros.validateNumber)(properties.checkMaximumHour));
    errors.collect(ros.propertyValidator('fullCheckFixData', ros.validateBoolean)(properties.fullCheckFixData));
    if (properties.fullCheckModel && (typeof properties.fullCheckModel) !== 'object') {
        errors.collect(ros.propertyValidator('fullCheckModel', ros.validateAllowedValues)({
            data: properties.fullCheckModel,
            allowedValues: [1, 2],
        }));
    }
    errors.collect(ros.propertyValidator('fullCheckModel', ros.validateNumber)(properties.fullCheckModel));
    errors.collect(ros.propertyValidator('incrementalCheckValidFailNoticeValue', ros.validateNumber)(properties.incrementalCheckValidFailNoticeValue));
    errors.collect(ros.propertyValidator('incrementalDataCheck', ros.validateBoolean)(properties.incrementalDataCheck));
    errors.collect(ros.propertyValidator('incrementalCheckValidFailNoticeTimes', ros.validateNumber)(properties.incrementalCheckValidFailNoticeTimes));
    if (properties.fullCheckMaxReadBps && (typeof properties.fullCheckMaxReadBps) !== 'object') {
        errors.collect(ros.propertyValidator('fullCheckMaxReadBps', ros.validateRange)({
            data: properties.fullCheckMaxReadBps,
            min: 0,
            max: 9007199254740991,
        }));
    }
    errors.collect(ros.propertyValidator('fullCheckMaxReadBps', ros.validateNumber)(properties.fullCheckMaxReadBps));
    errors.collect(ros.propertyValidator('fullCheckValidFailNotice', ros.validateBoolean)(properties.fullCheckValidFailNotice));
    errors.collect(ros.propertyValidator('fullCheckErrorNotice', ros.validateBoolean)(properties.fullCheckErrorNotice));
    if (properties.incrementalCheckValidFailNoticePeriod && (typeof properties.incrementalCheckValidFailNoticePeriod) !== 'object') {
        errors.collect(ros.propertyValidator('incrementalCheckValidFailNoticePeriod', ros.validateAllowedValues)({
            data: properties.incrementalCheckValidFailNoticePeriod,
            allowedValues: [1, 2, 3, 4],
        }));
    }
    errors.collect(ros.propertyValidator('incrementalCheckValidFailNoticePeriod', ros.validateNumber)(properties.incrementalCheckValidFailNoticePeriod));
    errors.collect(ros.propertyValidator('incrementalCheckDelayNoticeTimes', ros.validateNumber)(properties.incrementalCheckDelayNoticeTimes));
    errors.collect(ros.propertyValidator('fullCheckReferEndpoint', ros.validateString)(properties.fullCheckReferEndpoint));
    errors.collect(ros.propertyValidator('fullDataCheck', ros.validateBoolean)(properties.fullDataCheck));
    errors.collect(ros.propertyValidator('incrementalCheckValidFailNotice', ros.validateBoolean)(properties.incrementalCheckValidFailNotice));
    errors.collect(ros.propertyValidator('fullCheckNoticeValue', ros.validateNumber)(properties.fullCheckNoticeValue));
    errors.collect(ros.propertyValidator('incrementalCheckErrorNotice', ros.validateBoolean)(properties.incrementalCheckErrorNotice));
    return errors.wrap('supplied properties not correct for "DataCheckConfigureProperty"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::DTS::MigrationJob2.DataCheckConfigure` resource
 *
 * @param properties - the TypeScript properties of a `DataCheckConfigureProperty`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::DTS::MigrationJob2.DataCheckConfigure` resource.
 */
// @ts-ignore TS6133
function rosMigrationJob2DataCheckConfigurePropertyToRosTemplate(properties) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    RosMigrationJob2_DataCheckConfigurePropertyValidator(properties).assertSuccess();
    return {
        fullCheckMaxReadRps: ros.numberToRosTemplate(properties.fullCheckMaxReadRps),
        dataCheckNoticePhone: ros.stringToRosTemplate(properties.dataCheckNoticePhone),
        incrementalCheckDelayNotice: ros.booleanToRosTemplate(properties.incrementalCheckDelayNotice),
        incrementalCheckDelayNoticeValue: ros.numberToRosTemplate(properties.incrementalCheckDelayNoticeValue),
        incrementalCheckDelayNoticePeriod: ros.numberToRosTemplate(properties.incrementalCheckDelayNoticePeriod),
        dataCheckDbList: ros.stringToRosTemplate(properties.dataCheckDbList),
        checkMaximumHourEnable: ros.numberToRosTemplate(properties.checkMaximumHourEnable),
        fullCheckRatio: ros.numberToRosTemplate(properties.fullCheckRatio),
        checkMaximumHour: ros.numberToRosTemplate(properties.checkMaximumHour),
        fullCheckFixData: ros.booleanToRosTemplate(properties.fullCheckFixData),
        fullCheckModel: ros.numberToRosTemplate(properties.fullCheckModel),
        incrementalCheckValidFailNoticeValue: ros.numberToRosTemplate(properties.incrementalCheckValidFailNoticeValue),
        incrementalDataCheck: ros.booleanToRosTemplate(properties.incrementalDataCheck),
        incrementalCheckValidFailNoticeTimes: ros.numberToRosTemplate(properties.incrementalCheckValidFailNoticeTimes),
        fullCheckMaxReadBps: ros.numberToRosTemplate(properties.fullCheckMaxReadBps),
        fullCheckValidFailNotice: ros.booleanToRosTemplate(properties.fullCheckValidFailNotice),
        fullCheckErrorNotice: ros.booleanToRosTemplate(properties.fullCheckErrorNotice),
        incrementalCheckValidFailNoticePeriod: ros.numberToRosTemplate(properties.incrementalCheckValidFailNoticePeriod),
        incrementalCheckDelayNoticeTimes: ros.numberToRosTemplate(properties.incrementalCheckDelayNoticeTimes),
        fullCheckReferEndpoint: ros.stringToRosTemplate(properties.fullCheckReferEndpoint),
        fullDataCheck: ros.booleanToRosTemplate(properties.fullDataCheck),
        incrementalCheckValidFailNotice: ros.booleanToRosTemplate(properties.incrementalCheckValidFailNotice),
        fullCheckNoticeValue: ros.numberToRosTemplate(properties.fullCheckNoticeValue),
        incrementalCheckErrorNotice: ros.booleanToRosTemplate(properties.incrementalCheckErrorNotice),
    };
}
/**
 * Determine whether the given properties match those of a `DestinationEndpointProperty`
 *
 * @param properties - the TypeScript properties of a `DestinationEndpointProperty`
 *
 * @returns the result of the validation.
 */
function RosMigrationJob2_DestinationEndpointPropertyValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('role', ros.validateString)(properties.role));
    errors.collect(ros.propertyValidator('oracleSid', ros.validateString)(properties.oracleSid));
    errors.collect(ros.propertyValidator('userName', ros.validateString)(properties.userName));
    errors.collect(ros.propertyValidator('ownerId', ros.validateString)(properties.ownerId));
    errors.collect(ros.propertyValidator('instanceId', ros.validateString)(properties.instanceId));
    errors.collect(ros.propertyValidator('ip', ros.validateString)(properties.ip));
    errors.collect(ros.propertyValidator('port', ros.validateString)(properties.port));
    errors.collect(ros.propertyValidator('databaseName', ros.validateString)(properties.databaseName));
    errors.collect(ros.propertyValidator('region', ros.validateString)(properties.region));
    errors.collect(ros.propertyValidator('instanceType', ros.requiredValidator)(properties.instanceType));
    errors.collect(ros.propertyValidator('instanceType', ros.validateString)(properties.instanceType));
    errors.collect(ros.propertyValidator('engineName', ros.validateString)(properties.engineName));
    errors.collect(ros.propertyValidator('password', ros.validateString)(properties.password));
    return errors.wrap('supplied properties not correct for "DestinationEndpointProperty"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::DTS::MigrationJob2.DestinationEndpoint` resource
 *
 * @param properties - the TypeScript properties of a `DestinationEndpointProperty`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::DTS::MigrationJob2.DestinationEndpoint` resource.
 */
// @ts-ignore TS6133
function rosMigrationJob2DestinationEndpointPropertyToRosTemplate(properties) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    RosMigrationJob2_DestinationEndpointPropertyValidator(properties).assertSuccess();
    return {
        Role: ros.stringToRosTemplate(properties.role),
        OracleSID: ros.stringToRosTemplate(properties.oracleSid),
        UserName: ros.stringToRosTemplate(properties.userName),
        OwnerID: ros.stringToRosTemplate(properties.ownerId),
        InstanceID: ros.stringToRosTemplate(properties.instanceId),
        IP: ros.stringToRosTemplate(properties.ip),
        Port: ros.stringToRosTemplate(properties.port),
        DatabaseName: ros.stringToRosTemplate(properties.databaseName),
        Region: ros.stringToRosTemplate(properties.region),
        InstanceType: ros.stringToRosTemplate(properties.instanceType),
        EngineName: ros.stringToRosTemplate(properties.engineName),
        Password: ros.stringToRosTemplate(properties.password),
    };
}
/**
 * Determine whether the given properties match those of a `SourceEndpointProperty`
 *
 * @param properties - the TypeScript properties of a `SourceEndpointProperty`
 *
 * @returns the result of the validation.
 */
function RosMigrationJob2_SourceEndpointPropertyValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('oracleSid', ros.validateString)(properties.oracleSid));
    errors.collect(ros.propertyValidator('userName', ros.validateString)(properties.userName));
    errors.collect(ros.propertyValidator('instanceId', ros.validateString)(properties.instanceId));
    errors.collect(ros.propertyValidator('ip', ros.validateString)(properties.ip));
    errors.collect(ros.propertyValidator('port', ros.validateString)(properties.port));
    errors.collect(ros.propertyValidator('vSwitchId', ros.validateString)(properties.vSwitchId));
    errors.collect(ros.propertyValidator('databaseName', ros.validateString)(properties.databaseName));
    errors.collect(ros.propertyValidator('engineName', ros.validateString)(properties.engineName));
    errors.collect(ros.propertyValidator('role', ros.validateString)(properties.role));
    errors.collect(ros.propertyValidator('ownerId', ros.validateString)(properties.ownerId));
    errors.collect(ros.propertyValidator('region', ros.validateString)(properties.region));
    errors.collect(ros.propertyValidator('instanceType', ros.requiredValidator)(properties.instanceType));
    errors.collect(ros.propertyValidator('instanceType', ros.validateString)(properties.instanceType));
    errors.collect(ros.propertyValidator('password', ros.validateString)(properties.password));
    return errors.wrap('supplied properties not correct for "SourceEndpointProperty"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::DTS::MigrationJob2.SourceEndpoint` resource
 *
 * @param properties - the TypeScript properties of a `SourceEndpointProperty`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::DTS::MigrationJob2.SourceEndpoint` resource.
 */
// @ts-ignore TS6133
function rosMigrationJob2SourceEndpointPropertyToRosTemplate(properties) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    RosMigrationJob2_SourceEndpointPropertyValidator(properties).assertSuccess();
    return {
        OracleSID: ros.stringToRosTemplate(properties.oracleSid),
        UserName: ros.stringToRosTemplate(properties.userName),
        InstanceID: ros.stringToRosTemplate(properties.instanceId),
        IP: ros.stringToRosTemplate(properties.ip),
        Port: ros.stringToRosTemplate(properties.port),
        VSwitchID: ros.stringToRosTemplate(properties.vSwitchId),
        DatabaseName: ros.stringToRosTemplate(properties.databaseName),
        EngineName: ros.stringToRosTemplate(properties.engineName),
        Role: ros.stringToRosTemplate(properties.role),
        OwnerID: ros.stringToRosTemplate(properties.ownerId),
        Region: ros.stringToRosTemplate(properties.region),
        InstanceType: ros.stringToRosTemplate(properties.instanceType),
        Password: ros.stringToRosTemplate(properties.password),
    };
}
/**
 * Determine whether the given properties match those of a `RosSubscriptionJob2Props`
 *
 * @param properties - the TypeScript properties of a `RosSubscriptionJob2Props`
 *
 * @returns the result of the validation.
 */
function RosSubscriptionJob2PropsValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    if (properties.status && (typeof properties.status) !== 'object') {
        errors.collect(ros.propertyValidator('status', ros.validateAllowedValues)({
            data: properties.status,
            allowedValues: ["Subscribing", "Suspending", "Stopping"],
        }));
    }
    errors.collect(ros.propertyValidator('status', ros.validateString)(properties.status));
    errors.collect(ros.propertyValidator('reserve', ros.hashValidator(ros.validateAny))(properties.reserve));
    errors.collect(ros.propertyValidator('delayPhone', ros.validateString)(properties.delayPhone));
    errors.collect(ros.propertyValidator('dedicatedClusterId', ros.validateString)(properties.dedicatedClusterId));
    errors.collect(ros.propertyValidator('errorNotice', ros.validateBoolean)(properties.errorNotice));
    errors.collect(ros.propertyValidator('dtsJobName', ros.requiredValidator)(properties.dtsJobName));
    errors.collect(ros.propertyValidator('dtsJobName', ros.validateString)(properties.dtsJobName));
    errors.collect(ros.propertyValidator('delayRuleTime', ros.validateNumber)(properties.delayRuleTime));
    errors.collect(ros.propertyValidator('dtsInstanceId', ros.validateString)(properties.dtsInstanceId));
    errors.collect(ros.propertyValidator('dbList', ros.requiredValidator)(properties.dbList));
    errors.collect(ros.propertyValidator('dbList', ros.hashValidator(ros.validateAny))(properties.dbList));
    errors.collect(ros.propertyValidator('dtsBisLabel', ros.validateString)(properties.dtsBisLabel));
    errors.collect(ros.propertyValidator('subscriptionDataType', RosSubscriptionJob2_SubscriptionDataTypePropertyValidator)(properties.subscriptionDataType));
    errors.collect(ros.propertyValidator('checkpoint', ros.validateString)(properties.checkpoint));
    errors.collect(ros.propertyValidator('delayNotice', ros.validateBoolean)(properties.delayNotice));
    errors.collect(ros.propertyValidator('dtsJobId', ros.validateString)(properties.dtsJobId));
    errors.collect(ros.propertyValidator('subscriptionInstance', ros.requiredValidator)(properties.subscriptionInstance));
    errors.collect(ros.propertyValidator('subscriptionInstance', RosSubscriptionJob2_SubscriptionInstancePropertyValidator)(properties.subscriptionInstance));
    errors.collect(ros.propertyValidator('sourceEndpoint', ros.requiredValidator)(properties.sourceEndpoint));
    errors.collect(ros.propertyValidator('sourceEndpoint', RosSubscriptionJob2_SourceEndpointPropertyValidator)(properties.sourceEndpoint));
    errors.collect(ros.propertyValidator('errorPhone', ros.validateString)(properties.errorPhone));
    return errors.wrap('supplied properties not correct for "RosSubscriptionJob2Props"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::DTS::SubscriptionJob2` resource
 *
 * @param properties - the TypeScript properties of a `RosSubscriptionJob2Props`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::DTS::SubscriptionJob2` resource.
 */
// @ts-ignore TS6133
function rosSubscriptionJob2PropsToRosTemplate(properties, enableResourcePropertyConstraint) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    if (enableResourcePropertyConstraint) {
        RosSubscriptionJob2PropsValidator(properties).assertSuccess();
    }
    return {
        DbList: ros.hashMapper(ros.objectToRosTemplate)(properties.dbList),
        DtsJobName: ros.stringToRosTemplate(properties.dtsJobName),
        SourceEndpoint: rosSubscriptionJob2SourceEndpointPropertyToRosTemplate(properties.sourceEndpoint),
        SubscriptionInstance: rosSubscriptionJob2SubscriptionInstancePropertyToRosTemplate(properties.subscriptionInstance),
        Checkpoint: ros.stringToRosTemplate(properties.checkpoint),
        DedicatedClusterId: ros.stringToRosTemplate(properties.dedicatedClusterId),
        DelayNotice: ros.booleanToRosTemplate(properties.delayNotice),
        DelayPhone: ros.stringToRosTemplate(properties.delayPhone),
        DelayRuleTime: ros.numberToRosTemplate(properties.delayRuleTime),
        DtsBisLabel: ros.stringToRosTemplate(properties.dtsBisLabel),
        DtsInstanceId: ros.stringToRosTemplate(properties.dtsInstanceId),
        DtsJobId: ros.stringToRosTemplate(properties.dtsJobId),
        ErrorNotice: ros.booleanToRosTemplate(properties.errorNotice),
        ErrorPhone: ros.stringToRosTemplate(properties.errorPhone),
        Reserve: ros.hashMapper(ros.objectToRosTemplate)(properties.reserve),
        Status: ros.stringToRosTemplate(properties.status),
        SubscriptionDataType: rosSubscriptionJob2SubscriptionDataTypePropertyToRosTemplate(properties.subscriptionDataType),
    };
}
/**
 * This class is a base encapsulation around the ROS resource type `ALIYUN::DTS::SubscriptionJob2`, which is used to configure a change tracking task.
 * @Note This class does not contain additional functions, so it is recommended to use the `SubscriptionJob2` class instead of this class for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/aliyun-dts-subscriptionjob2
 */
class RosSubscriptionJob2 extends ros.RosResource {
    /**
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint) {
        super(scope, id, { type: RosSubscriptionJob2.ROS_RESOURCE_TYPE_NAME, properties: props });
        this.attrDtsInstanceId = this.getAtt('DtsInstanceId');
        this.attrDtsJobId = this.getAtt('DtsJobId');
        this.attrDtsJobName = this.getAtt('DtsJobName');
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        this.dbList = props.dbList;
        this.dtsJobName = props.dtsJobName;
        this.sourceEndpoint = props.sourceEndpoint;
        this.subscriptionInstance = props.subscriptionInstance;
        this.checkpoint = props.checkpoint;
        this.dedicatedClusterId = props.dedicatedClusterId;
        this.delayNotice = props.delayNotice;
        this.delayPhone = props.delayPhone;
        this.delayRuleTime = props.delayRuleTime;
        this.dtsBisLabel = props.dtsBisLabel;
        this.dtsInstanceId = props.dtsInstanceId;
        this.dtsJobId = props.dtsJobId;
        this.errorNotice = props.errorNotice;
        this.errorPhone = props.errorPhone;
        this.reserve = props.reserve;
        this.status = props.status;
        this.subscriptionDataType = props.subscriptionDataType;
    }
    get rosProperties() {
        return {
            dbList: this.dbList,
            dtsJobName: this.dtsJobName,
            sourceEndpoint: this.sourceEndpoint,
            subscriptionInstance: this.subscriptionInstance,
            checkpoint: this.checkpoint,
            dedicatedClusterId: this.dedicatedClusterId,
            delayNotice: this.delayNotice,
            delayPhone: this.delayPhone,
            delayRuleTime: this.delayRuleTime,
            dtsBisLabel: this.dtsBisLabel,
            dtsInstanceId: this.dtsInstanceId,
            dtsJobId: this.dtsJobId,
            errorNotice: this.errorNotice,
            errorPhone: this.errorPhone,
            reserve: this.reserve,
            status: this.status,
            subscriptionDataType: this.subscriptionDataType,
        };
    }
    renderProperties(props) {
        return rosSubscriptionJob2PropsToRosTemplate(props, this.enableResourcePropertyConstraint);
    }
}
exports.RosSubscriptionJob2 = RosSubscriptionJob2;
/**
 * The resource type name for this resource class.
 */
RosSubscriptionJob2.ROS_RESOURCE_TYPE_NAME = "ALIYUN::DTS::SubscriptionJob2";
/**
 * Determine whether the given properties match those of a `SourceEndpointProperty`
 *
 * @param properties - the TypeScript properties of a `SourceEndpointProperty`
 *
 * @returns the result of the validation.
 */
function RosSubscriptionJob2_SourceEndpointPropertyValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('oracleSid', ros.validateString)(properties.oracleSid));
    errors.collect(ros.propertyValidator('userName', ros.validateString)(properties.userName));
    errors.collect(ros.propertyValidator('instanceId', ros.validateString)(properties.instanceId));
    errors.collect(ros.propertyValidator('ip', ros.validateString)(properties.ip));
    errors.collect(ros.propertyValidator('port', ros.validateString)(properties.port));
    errors.collect(ros.propertyValidator('vSwitchId', ros.validateString)(properties.vSwitchId));
    errors.collect(ros.propertyValidator('databaseName', ros.validateString)(properties.databaseName));
    errors.collect(ros.propertyValidator('engineName', ros.validateString)(properties.engineName));
    errors.collect(ros.propertyValidator('role', ros.validateString)(properties.role));
    errors.collect(ros.propertyValidator('ownerId', ros.validateString)(properties.ownerId));
    errors.collect(ros.propertyValidator('region', ros.validateString)(properties.region));
    errors.collect(ros.propertyValidator('instanceType', ros.validateString)(properties.instanceType));
    errors.collect(ros.propertyValidator('password', ros.validateString)(properties.password));
    return errors.wrap('supplied properties not correct for "SourceEndpointProperty"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::DTS::SubscriptionJob2.SourceEndpoint` resource
 *
 * @param properties - the TypeScript properties of a `SourceEndpointProperty`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::DTS::SubscriptionJob2.SourceEndpoint` resource.
 */
// @ts-ignore TS6133
function rosSubscriptionJob2SourceEndpointPropertyToRosTemplate(properties) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    RosSubscriptionJob2_SourceEndpointPropertyValidator(properties).assertSuccess();
    return {
        OracleSID: ros.stringToRosTemplate(properties.oracleSid),
        UserName: ros.stringToRosTemplate(properties.userName),
        InstanceID: ros.stringToRosTemplate(properties.instanceId),
        IP: ros.stringToRosTemplate(properties.ip),
        Port: ros.stringToRosTemplate(properties.port),
        VSwitchID: ros.stringToRosTemplate(properties.vSwitchId),
        DatabaseName: ros.stringToRosTemplate(properties.databaseName),
        EngineName: ros.stringToRosTemplate(properties.engineName),
        Role: ros.stringToRosTemplate(properties.role),
        OwnerID: ros.stringToRosTemplate(properties.ownerId),
        Region: ros.stringToRosTemplate(properties.region),
        InstanceType: ros.stringToRosTemplate(properties.instanceType),
        Password: ros.stringToRosTemplate(properties.password),
    };
}
/**
 * Determine whether the given properties match those of a `SubscriptionDataTypeProperty`
 *
 * @param properties - the TypeScript properties of a `SubscriptionDataTypeProperty`
 *
 * @returns the result of the validation.
 */
function RosSubscriptionJob2_SubscriptionDataTypePropertyValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('dml', ros.validateBoolean)(properties.dml));
    errors.collect(ros.propertyValidator('ddl', ros.validateBoolean)(properties.ddl));
    return errors.wrap('supplied properties not correct for "SubscriptionDataTypeProperty"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::DTS::SubscriptionJob2.SubscriptionDataType` resource
 *
 * @param properties - the TypeScript properties of a `SubscriptionDataTypeProperty`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::DTS::SubscriptionJob2.SubscriptionDataType` resource.
 */
// @ts-ignore TS6133
function rosSubscriptionJob2SubscriptionDataTypePropertyToRosTemplate(properties) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    RosSubscriptionJob2_SubscriptionDataTypePropertyValidator(properties).assertSuccess();
    return {
        DML: ros.booleanToRosTemplate(properties.dml),
        DDL: ros.booleanToRosTemplate(properties.ddl),
    };
}
/**
 * Determine whether the given properties match those of a `SubscriptionInstanceProperty`
 *
 * @param properties - the TypeScript properties of a `SubscriptionInstanceProperty`
 *
 * @returns the result of the validation.
 */
function RosSubscriptionJob2_SubscriptionInstancePropertyValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('vpcId', ros.validateString)(properties.vpcId));
    errors.collect(ros.propertyValidator('networkType', ros.requiredValidator)(properties.networkType));
    errors.collect(ros.propertyValidator('networkType', ros.validateString)(properties.networkType));
    errors.collect(ros.propertyValidator('vSwitchId', ros.validateString)(properties.vSwitchId));
    return errors.wrap('supplied properties not correct for "SubscriptionInstanceProperty"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::DTS::SubscriptionJob2.SubscriptionInstance` resource
 *
 * @param properties - the TypeScript properties of a `SubscriptionInstanceProperty`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::DTS::SubscriptionJob2.SubscriptionInstance` resource.
 */
// @ts-ignore TS6133
function rosSubscriptionJob2SubscriptionInstancePropertyToRosTemplate(properties) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    RosSubscriptionJob2_SubscriptionInstancePropertyValidator(properties).assertSuccess();
    return {
        VPCId: ros.stringToRosTemplate(properties.vpcId),
        NetworkType: ros.stringToRosTemplate(properties.networkType),
        VSwitchId: ros.stringToRosTemplate(properties.vSwitchId),
    };
}
/**
 * Determine whether the given properties match those of a `RosSynchronizationJob2Props`
 *
 * @param properties - the TypeScript properties of a `RosSynchronizationJob2Props`
 *
 * @returns the result of the validation.
 */
function RosSynchronizationJob2PropsValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    if (properties.status && (typeof properties.status) !== 'object') {
        errors.collect(ros.propertyValidator('status', ros.validateAllowedValues)({
            data: properties.status,
            allowedValues: ["Synchronizing", "Suspending", "Stopping"],
        }));
    }
    errors.collect(ros.propertyValidator('status', ros.validateString)(properties.status));
    errors.collect(ros.propertyValidator('reserve', ros.hashValidator(ros.validateAny))(properties.reserve));
    errors.collect(ros.propertyValidator('dataSynchronization', ros.requiredValidator)(properties.dataSynchronization));
    errors.collect(ros.propertyValidator('dataSynchronization', ros.validateBoolean)(properties.dataSynchronization));
    errors.collect(ros.propertyValidator('delayPhone', ros.validateString)(properties.delayPhone));
    errors.collect(ros.propertyValidator('dedicatedClusterId', ros.validateString)(properties.dedicatedClusterId));
    errors.collect(ros.propertyValidator('errorNotice', ros.validateBoolean)(properties.errorNotice));
    errors.collect(ros.propertyValidator('dtsJobName', ros.requiredValidator)(properties.dtsJobName));
    errors.collect(ros.propertyValidator('dtsJobName', ros.validateString)(properties.dtsJobName));
    errors.collect(ros.propertyValidator('delayRuleTime', ros.validateNumber)(properties.delayRuleTime));
    errors.collect(ros.propertyValidator('dtsInstanceId', ros.validateString)(properties.dtsInstanceId));
    errors.collect(ros.propertyValidator('dbList', ros.requiredValidator)(properties.dbList));
    errors.collect(ros.propertyValidator('dbList', ros.hashValidator(ros.validateAny))(properties.dbList));
    errors.collect(ros.propertyValidator('fileOssUrl', ros.validateString)(properties.fileOssUrl));
    errors.collect(ros.propertyValidator('dataCheckConfigure', RosSynchronizationJob2_DataCheckConfigurePropertyValidator)(properties.dataCheckConfigure));
    errors.collect(ros.propertyValidator('dtsBisLabel', ros.validateString)(properties.dtsBisLabel));
    errors.collect(ros.propertyValidator('checkpoint', ros.validateString)(properties.checkpoint));
    errors.collect(ros.propertyValidator('disasterRecoveryJob', ros.validateBoolean)(properties.disasterRecoveryJob));
    errors.collect(ros.propertyValidator('dtsJobId', ros.validateString)(properties.dtsJobId));
    errors.collect(ros.propertyValidator('delayNotice', ros.validateBoolean)(properties.delayNotice));
    errors.collect(ros.propertyValidator('dataInitialization', ros.requiredValidator)(properties.dataInitialization));
    errors.collect(ros.propertyValidator('dataInitialization', ros.validateBoolean)(properties.dataInitialization));
    errors.collect(ros.propertyValidator('destinationEndpoint', ros.requiredValidator)(properties.destinationEndpoint));
    errors.collect(ros.propertyValidator('destinationEndpoint', RosSynchronizationJob2_DestinationEndpointPropertyValidator)(properties.destinationEndpoint));
    errors.collect(ros.propertyValidator('sourceEndpoint', ros.requiredValidator)(properties.sourceEndpoint));
    errors.collect(ros.propertyValidator('sourceEndpoint', RosSynchronizationJob2_SourceEndpointPropertyValidator)(properties.sourceEndpoint));
    errors.collect(ros.propertyValidator('errorPhone', ros.validateString)(properties.errorPhone));
    errors.collect(ros.propertyValidator('structureInitialization', ros.requiredValidator)(properties.structureInitialization));
    errors.collect(ros.propertyValidator('structureInitialization', ros.validateBoolean)(properties.structureInitialization));
    errors.collect(ros.propertyValidator('synchronizationDirection', ros.validateString)(properties.synchronizationDirection));
    return errors.wrap('supplied properties not correct for "RosSynchronizationJob2Props"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::DTS::SynchronizationJob2` resource
 *
 * @param properties - the TypeScript properties of a `RosSynchronizationJob2Props`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::DTS::SynchronizationJob2` resource.
 */
// @ts-ignore TS6133
function rosSynchronizationJob2PropsToRosTemplate(properties, enableResourcePropertyConstraint) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    if (enableResourcePropertyConstraint) {
        RosSynchronizationJob2PropsValidator(properties).assertSuccess();
    }
    return {
        DataInitialization: ros.booleanToRosTemplate(properties.dataInitialization),
        DataSynchronization: ros.booleanToRosTemplate(properties.dataSynchronization),
        DbList: ros.hashMapper(ros.objectToRosTemplate)(properties.dbList),
        DestinationEndpoint: rosSynchronizationJob2DestinationEndpointPropertyToRosTemplate(properties.destinationEndpoint),
        DtsJobName: ros.stringToRosTemplate(properties.dtsJobName),
        SourceEndpoint: rosSynchronizationJob2SourceEndpointPropertyToRosTemplate(properties.sourceEndpoint),
        StructureInitialization: ros.booleanToRosTemplate(properties.structureInitialization),
        Checkpoint: ros.stringToRosTemplate(properties.checkpoint),
        DataCheckConfigure: rosSynchronizationJob2DataCheckConfigurePropertyToRosTemplate(properties.dataCheckConfigure),
        DedicatedClusterId: ros.stringToRosTemplate(properties.dedicatedClusterId),
        DelayNotice: ros.booleanToRosTemplate(properties.delayNotice),
        DelayPhone: ros.stringToRosTemplate(properties.delayPhone),
        DelayRuleTime: ros.numberToRosTemplate(properties.delayRuleTime),
        DisasterRecoveryJob: ros.booleanToRosTemplate(properties.disasterRecoveryJob),
        DtsBisLabel: ros.stringToRosTemplate(properties.dtsBisLabel),
        DtsInstanceId: ros.stringToRosTemplate(properties.dtsInstanceId),
        DtsJobId: ros.stringToRosTemplate(properties.dtsJobId),
        ErrorNotice: ros.booleanToRosTemplate(properties.errorNotice),
        ErrorPhone: ros.stringToRosTemplate(properties.errorPhone),
        FileOssUrl: ros.stringToRosTemplate(properties.fileOssUrl),
        Reserve: ros.hashMapper(ros.objectToRosTemplate)(properties.reserve),
        Status: ros.stringToRosTemplate(properties.status),
        SynchronizationDirection: ros.stringToRosTemplate(properties.synchronizationDirection),
    };
}
/**
 * This class is a base encapsulation around the ROS resource type `ALIYUN::DTS::SynchronizationJob2`, which is used to configure a data synchronization task.
 * @Note This class does not contain additional functions, so it is recommended to use the `SynchronizationJob2` class instead of this class for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/aliyun-dts-synchronizationjob2
 */
class RosSynchronizationJob2 extends ros.RosResource {
    /**
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint) {
        super(scope, id, { type: RosSynchronizationJob2.ROS_RESOURCE_TYPE_NAME, properties: props });
        this.attrDtsInstanceId = this.getAtt('DtsInstanceId');
        this.attrDtsJobId = this.getAtt('DtsJobId');
        this.attrDtsJobName = this.getAtt('DtsJobName');
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        this.dataInitialization = props.dataInitialization;
        this.dataSynchronization = props.dataSynchronization;
        this.dbList = props.dbList;
        this.destinationEndpoint = props.destinationEndpoint;
        this.dtsJobName = props.dtsJobName;
        this.sourceEndpoint = props.sourceEndpoint;
        this.structureInitialization = props.structureInitialization;
        this.checkpoint = props.checkpoint;
        this.dataCheckConfigure = props.dataCheckConfigure;
        this.dedicatedClusterId = props.dedicatedClusterId;
        this.delayNotice = props.delayNotice;
        this.delayPhone = props.delayPhone;
        this.delayRuleTime = props.delayRuleTime;
        this.disasterRecoveryJob = props.disasterRecoveryJob;
        this.dtsBisLabel = props.dtsBisLabel;
        this.dtsInstanceId = props.dtsInstanceId;
        this.dtsJobId = props.dtsJobId;
        this.errorNotice = props.errorNotice;
        this.errorPhone = props.errorPhone;
        this.fileOssUrl = props.fileOssUrl;
        this.reserve = props.reserve;
        this.status = props.status;
        this.synchronizationDirection = props.synchronizationDirection;
    }
    get rosProperties() {
        return {
            dataInitialization: this.dataInitialization,
            dataSynchronization: this.dataSynchronization,
            dbList: this.dbList,
            destinationEndpoint: this.destinationEndpoint,
            dtsJobName: this.dtsJobName,
            sourceEndpoint: this.sourceEndpoint,
            structureInitialization: this.structureInitialization,
            checkpoint: this.checkpoint,
            dataCheckConfigure: this.dataCheckConfigure,
            dedicatedClusterId: this.dedicatedClusterId,
            delayNotice: this.delayNotice,
            delayPhone: this.delayPhone,
            delayRuleTime: this.delayRuleTime,
            disasterRecoveryJob: this.disasterRecoveryJob,
            dtsBisLabel: this.dtsBisLabel,
            dtsInstanceId: this.dtsInstanceId,
            dtsJobId: this.dtsJobId,
            errorNotice: this.errorNotice,
            errorPhone: this.errorPhone,
            fileOssUrl: this.fileOssUrl,
            reserve: this.reserve,
            status: this.status,
            synchronizationDirection: this.synchronizationDirection,
        };
    }
    renderProperties(props) {
        return rosSynchronizationJob2PropsToRosTemplate(props, this.enableResourcePropertyConstraint);
    }
}
exports.RosSynchronizationJob2 = RosSynchronizationJob2;
/**
 * The resource type name for this resource class.
 */
RosSynchronizationJob2.ROS_RESOURCE_TYPE_NAME = "ALIYUN::DTS::SynchronizationJob2";
/**
 * Determine whether the given properties match those of a `DataCheckConfigureProperty`
 *
 * @param properties - the TypeScript properties of a `DataCheckConfigureProperty`
 *
 * @returns the result of the validation.
 */
function RosSynchronizationJob2_DataCheckConfigurePropertyValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    if (properties.fullCheckMaxReadRps && (typeof properties.fullCheckMaxReadRps) !== 'object') {
        errors.collect(ros.propertyValidator('fullCheckMaxReadRps', ros.validateRange)({
            data: properties.fullCheckMaxReadRps,
            min: 0,
            max: 9007199254740991,
        }));
    }
    errors.collect(ros.propertyValidator('fullCheckMaxReadRps', ros.validateNumber)(properties.fullCheckMaxReadRps));
    errors.collect(ros.propertyValidator('dataCheckNoticePhone', ros.validateString)(properties.dataCheckNoticePhone));
    errors.collect(ros.propertyValidator('incrementalCheckDelayNotice', ros.validateBoolean)(properties.incrementalCheckDelayNotice));
    errors.collect(ros.propertyValidator('incrementalCheckDelayNoticeValue', ros.validateNumber)(properties.incrementalCheckDelayNoticeValue));
    if (properties.incrementalCheckDelayNoticePeriod && (typeof properties.incrementalCheckDelayNoticePeriod) !== 'object') {
        errors.collect(ros.propertyValidator('incrementalCheckDelayNoticePeriod', ros.validateAllowedValues)({
            data: properties.incrementalCheckDelayNoticePeriod,
            allowedValues: [1, 2, 3, 4],
        }));
    }
    errors.collect(ros.propertyValidator('incrementalCheckDelayNoticePeriod', ros.validateNumber)(properties.incrementalCheckDelayNoticePeriod));
    errors.collect(ros.propertyValidator('dataCheckDbList', ros.validateString)(properties.dataCheckDbList));
    if (properties.checkMaximumHourEnable && (typeof properties.checkMaximumHourEnable) !== 'object') {
        errors.collect(ros.propertyValidator('checkMaximumHourEnable', ros.validateAllowedValues)({
            data: properties.checkMaximumHourEnable,
            allowedValues: [0, 1],
        }));
    }
    errors.collect(ros.propertyValidator('checkMaximumHourEnable', ros.validateNumber)(properties.checkMaximumHourEnable));
    if (properties.fullCheckRatio && (typeof properties.fullCheckRatio) !== 'object') {
        errors.collect(ros.propertyValidator('fullCheckRatio', ros.validateRange)({
            data: properties.fullCheckRatio,
            min: 10,
            max: 100,
        }));
    }
    errors.collect(ros.propertyValidator('fullCheckRatio', ros.validateNumber)(properties.fullCheckRatio));
    if (properties.checkMaximumHour && (typeof properties.checkMaximumHour) !== 'object') {
        errors.collect(ros.propertyValidator('checkMaximumHour', ros.validateRange)({
            data: properties.checkMaximumHour,
            min: 1,
            max: 72,
        }));
    }
    errors.collect(ros.propertyValidator('checkMaximumHour', ros.validateNumber)(properties.checkMaximumHour));
    errors.collect(ros.propertyValidator('fullCheckFixData', ros.validateBoolean)(properties.fullCheckFixData));
    if (properties.fullCheckModel && (typeof properties.fullCheckModel) !== 'object') {
        errors.collect(ros.propertyValidator('fullCheckModel', ros.validateAllowedValues)({
            data: properties.fullCheckModel,
            allowedValues: [1, 2],
        }));
    }
    errors.collect(ros.propertyValidator('fullCheckModel', ros.validateNumber)(properties.fullCheckModel));
    errors.collect(ros.propertyValidator('incrementalCheckValidFailNoticeValue', ros.validateNumber)(properties.incrementalCheckValidFailNoticeValue));
    errors.collect(ros.propertyValidator('incrementalDataCheck', ros.validateBoolean)(properties.incrementalDataCheck));
    errors.collect(ros.propertyValidator('incrementalCheckValidFailNoticeTimes', ros.validateNumber)(properties.incrementalCheckValidFailNoticeTimes));
    if (properties.fullCheckMaxReadBps && (typeof properties.fullCheckMaxReadBps) !== 'object') {
        errors.collect(ros.propertyValidator('fullCheckMaxReadBps', ros.validateRange)({
            data: properties.fullCheckMaxReadBps,
            min: 0,
            max: 9007199254740991,
        }));
    }
    errors.collect(ros.propertyValidator('fullCheckMaxReadBps', ros.validateNumber)(properties.fullCheckMaxReadBps));
    errors.collect(ros.propertyValidator('fullCheckValidFailNotice', ros.validateBoolean)(properties.fullCheckValidFailNotice));
    errors.collect(ros.propertyValidator('fullCheckErrorNotice', ros.validateBoolean)(properties.fullCheckErrorNotice));
    if (properties.incrementalCheckValidFailNoticePeriod && (typeof properties.incrementalCheckValidFailNoticePeriod) !== 'object') {
        errors.collect(ros.propertyValidator('incrementalCheckValidFailNoticePeriod', ros.validateAllowedValues)({
            data: properties.incrementalCheckValidFailNoticePeriod,
            allowedValues: [1, 2, 3, 4],
        }));
    }
    errors.collect(ros.propertyValidator('incrementalCheckValidFailNoticePeriod', ros.validateNumber)(properties.incrementalCheckValidFailNoticePeriod));
    errors.collect(ros.propertyValidator('incrementalCheckDelayNoticeTimes', ros.validateNumber)(properties.incrementalCheckDelayNoticeTimes));
    errors.collect(ros.propertyValidator('fullCheckReferEndpoint', ros.validateString)(properties.fullCheckReferEndpoint));
    errors.collect(ros.propertyValidator('fullDataCheck', ros.validateBoolean)(properties.fullDataCheck));
    errors.collect(ros.propertyValidator('incrementalCheckValidFailNotice', ros.validateBoolean)(properties.incrementalCheckValidFailNotice));
    errors.collect(ros.propertyValidator('fullCheckNoticeValue', ros.validateNumber)(properties.fullCheckNoticeValue));
    errors.collect(ros.propertyValidator('incrementalCheckErrorNotice', ros.validateBoolean)(properties.incrementalCheckErrorNotice));
    return errors.wrap('supplied properties not correct for "DataCheckConfigureProperty"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::DTS::SynchronizationJob2.DataCheckConfigure` resource
 *
 * @param properties - the TypeScript properties of a `DataCheckConfigureProperty`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::DTS::SynchronizationJob2.DataCheckConfigure` resource.
 */
// @ts-ignore TS6133
function rosSynchronizationJob2DataCheckConfigurePropertyToRosTemplate(properties) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    RosSynchronizationJob2_DataCheckConfigurePropertyValidator(properties).assertSuccess();
    return {
        fullCheckMaxReadRps: ros.numberToRosTemplate(properties.fullCheckMaxReadRps),
        dataCheckNoticePhone: ros.stringToRosTemplate(properties.dataCheckNoticePhone),
        incrementalCheckDelayNotice: ros.booleanToRosTemplate(properties.incrementalCheckDelayNotice),
        incrementalCheckDelayNoticeValue: ros.numberToRosTemplate(properties.incrementalCheckDelayNoticeValue),
        incrementalCheckDelayNoticePeriod: ros.numberToRosTemplate(properties.incrementalCheckDelayNoticePeriod),
        dataCheckDbList: ros.stringToRosTemplate(properties.dataCheckDbList),
        checkMaximumHourEnable: ros.numberToRosTemplate(properties.checkMaximumHourEnable),
        fullCheckRatio: ros.numberToRosTemplate(properties.fullCheckRatio),
        checkMaximumHour: ros.numberToRosTemplate(properties.checkMaximumHour),
        fullCheckFixData: ros.booleanToRosTemplate(properties.fullCheckFixData),
        fullCheckModel: ros.numberToRosTemplate(properties.fullCheckModel),
        incrementalCheckValidFailNoticeValue: ros.numberToRosTemplate(properties.incrementalCheckValidFailNoticeValue),
        incrementalDataCheck: ros.booleanToRosTemplate(properties.incrementalDataCheck),
        incrementalCheckValidFailNoticeTimes: ros.numberToRosTemplate(properties.incrementalCheckValidFailNoticeTimes),
        fullCheckMaxReadBps: ros.numberToRosTemplate(properties.fullCheckMaxReadBps),
        fullCheckValidFailNotice: ros.booleanToRosTemplate(properties.fullCheckValidFailNotice),
        fullCheckErrorNotice: ros.booleanToRosTemplate(properties.fullCheckErrorNotice),
        incrementalCheckValidFailNoticePeriod: ros.numberToRosTemplate(properties.incrementalCheckValidFailNoticePeriod),
        incrementalCheckDelayNoticeTimes: ros.numberToRosTemplate(properties.incrementalCheckDelayNoticeTimes),
        fullCheckReferEndpoint: ros.stringToRosTemplate(properties.fullCheckReferEndpoint),
        fullDataCheck: ros.booleanToRosTemplate(properties.fullDataCheck),
        incrementalCheckValidFailNotice: ros.booleanToRosTemplate(properties.incrementalCheckValidFailNotice),
        fullCheckNoticeValue: ros.numberToRosTemplate(properties.fullCheckNoticeValue),
        incrementalCheckErrorNotice: ros.booleanToRosTemplate(properties.incrementalCheckErrorNotice),
    };
}
/**
 * Determine whether the given properties match those of a `DestinationEndpointProperty`
 *
 * @param properties - the TypeScript properties of a `DestinationEndpointProperty`
 *
 * @returns the result of the validation.
 */
function RosSynchronizationJob2_DestinationEndpointPropertyValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('role', ros.validateString)(properties.role));
    errors.collect(ros.propertyValidator('oracleSid', ros.validateString)(properties.oracleSid));
    errors.collect(ros.propertyValidator('userName', ros.validateString)(properties.userName));
    errors.collect(ros.propertyValidator('ownerId', ros.validateString)(properties.ownerId));
    errors.collect(ros.propertyValidator('instanceId', ros.validateString)(properties.instanceId));
    errors.collect(ros.propertyValidator('ip', ros.validateString)(properties.ip));
    errors.collect(ros.propertyValidator('port', ros.validateString)(properties.port));
    errors.collect(ros.propertyValidator('databaseName', ros.validateString)(properties.databaseName));
    errors.collect(ros.propertyValidator('region', ros.validateString)(properties.region));
    errors.collect(ros.propertyValidator('instanceType', ros.requiredValidator)(properties.instanceType));
    errors.collect(ros.propertyValidator('instanceType', ros.validateString)(properties.instanceType));
    errors.collect(ros.propertyValidator('engineName', ros.validateString)(properties.engineName));
    errors.collect(ros.propertyValidator('password', ros.validateString)(properties.password));
    return errors.wrap('supplied properties not correct for "DestinationEndpointProperty"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::DTS::SynchronizationJob2.DestinationEndpoint` resource
 *
 * @param properties - the TypeScript properties of a `DestinationEndpointProperty`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::DTS::SynchronizationJob2.DestinationEndpoint` resource.
 */
// @ts-ignore TS6133
function rosSynchronizationJob2DestinationEndpointPropertyToRosTemplate(properties) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    RosSynchronizationJob2_DestinationEndpointPropertyValidator(properties).assertSuccess();
    return {
        Role: ros.stringToRosTemplate(properties.role),
        OracleSID: ros.stringToRosTemplate(properties.oracleSid),
        UserName: ros.stringToRosTemplate(properties.userName),
        OwnerID: ros.stringToRosTemplate(properties.ownerId),
        InstanceID: ros.stringToRosTemplate(properties.instanceId),
        IP: ros.stringToRosTemplate(properties.ip),
        Port: ros.stringToRosTemplate(properties.port),
        DatabaseName: ros.stringToRosTemplate(properties.databaseName),
        Region: ros.stringToRosTemplate(properties.region),
        InstanceType: ros.stringToRosTemplate(properties.instanceType),
        EngineName: ros.stringToRosTemplate(properties.engineName),
        Password: ros.stringToRosTemplate(properties.password),
    };
}
/**
 * Determine whether the given properties match those of a `SourceEndpointProperty`
 *
 * @param properties - the TypeScript properties of a `SourceEndpointProperty`
 *
 * @returns the result of the validation.
 */
function RosSynchronizationJob2_SourceEndpointPropertyValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('oracleSid', ros.validateString)(properties.oracleSid));
    errors.collect(ros.propertyValidator('userName', ros.validateString)(properties.userName));
    errors.collect(ros.propertyValidator('instanceId', ros.validateString)(properties.instanceId));
    errors.collect(ros.propertyValidator('ip', ros.validateString)(properties.ip));
    errors.collect(ros.propertyValidator('port', ros.validateString)(properties.port));
    errors.collect(ros.propertyValidator('vSwitchId', ros.validateString)(properties.vSwitchId));
    errors.collect(ros.propertyValidator('databaseName', ros.validateString)(properties.databaseName));
    errors.collect(ros.propertyValidator('engineName', ros.validateString)(properties.engineName));
    errors.collect(ros.propertyValidator('role', ros.validateString)(properties.role));
    errors.collect(ros.propertyValidator('ownerId', ros.validateString)(properties.ownerId));
    errors.collect(ros.propertyValidator('region', ros.validateString)(properties.region));
    errors.collect(ros.propertyValidator('instanceType', ros.requiredValidator)(properties.instanceType));
    errors.collect(ros.propertyValidator('instanceType', ros.validateString)(properties.instanceType));
    errors.collect(ros.propertyValidator('password', ros.validateString)(properties.password));
    return errors.wrap('supplied properties not correct for "SourceEndpointProperty"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::DTS::SynchronizationJob2.SourceEndpoint` resource
 *
 * @param properties - the TypeScript properties of a `SourceEndpointProperty`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::DTS::SynchronizationJob2.SourceEndpoint` resource.
 */
// @ts-ignore TS6133
function rosSynchronizationJob2SourceEndpointPropertyToRosTemplate(properties) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    RosSynchronizationJob2_SourceEndpointPropertyValidator(properties).assertSuccess();
    return {
        OracleSID: ros.stringToRosTemplate(properties.oracleSid),
        UserName: ros.stringToRosTemplate(properties.userName),
        InstanceID: ros.stringToRosTemplate(properties.instanceId),
        IP: ros.stringToRosTemplate(properties.ip),
        Port: ros.stringToRosTemplate(properties.port),
        VSwitchID: ros.stringToRosTemplate(properties.vSwitchId),
        DatabaseName: ros.stringToRosTemplate(properties.databaseName),
        EngineName: ros.stringToRosTemplate(properties.engineName),
        Role: ros.stringToRosTemplate(properties.role),
        OwnerID: ros.stringToRosTemplate(properties.ownerId),
        Region: ros.stringToRosTemplate(properties.region),
        InstanceType: ros.stringToRosTemplate(properties.instanceType),
        Password: ros.stringToRosTemplate(properties.password),
    };
}
//# sourceMappingURL=data:application/json;base64,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