"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Instance = exports.InstanceProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const dts_generated_1 = require("./dts.generated");
Object.defineProperty(exports, "InstanceProperty", { enumerable: true, get: function () { return dts_generated_1.RosInstance; } });
/**
 * This class encapsulates and extends the ROS resource type `ALIYUN::DTS::Instance`, which is a new resource type that is used to create a Data Transmission Service (DTS) instance.
 * @Note This class may have some new functions to facilitate development, so it is recommended to use this class instead of `RosInstance`for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/aliyun-dts-instance
 */
class Instance extends ros.Resource {
    /**
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        this.scope = scope;
        this.id = id;
        this.props = props;
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        const rosInstance = new dts_generated_1.RosInstance(this, id, {
            resourceGroupId: props.resourceGroupId,
            feeType: props.feeType,
            computeUnit: props.computeUnit,
            period: props.period,
            destinationRegion: props.destinationRegion,
            instanceClass: props.instanceClass,
            sourceEndpointEngineName: props.sourceEndpointEngineName,
            payType: props.payType,
            autoPay: props.autoPay,
            destinationEndpointEngineName: props.destinationEndpointEngineName,
            sourceRegion: props.sourceRegion,
            du: props.du,
            type: props.type,
            databaseCount: props.databaseCount,
            usedTime: props.usedTime,
            autoStart: props.autoStart,
            jobId: props.jobId,
            syncArchitecture: props.syncArchitecture,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosInstance;
        this.attrInstanceId = rosInstance.attrInstanceId;
        this.attrJobId = rosInstance.attrJobId;
    }
}
exports.Instance = Instance;
//# sourceMappingURL=data:application/json;base64,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