"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SubscriptionJob2 = exports.SubscriptionJob2Property = void 0;
const ros = require("@alicloud/ros-cdk-core");
const dts_generated_1 = require("./dts.generated");
Object.defineProperty(exports, "SubscriptionJob2Property", { enumerable: true, get: function () { return dts_generated_1.RosSubscriptionJob2; } });
/**
 * This class encapsulates and extends the ROS resource type `ALIYUN::DTS::SubscriptionJob2`, which is used to configure a change tracking task.
 * @Note This class may have some new functions to facilitate development, so it is recommended to use this class instead of `RosSubscriptionJob2`for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/aliyun-dts-subscriptionjob2
 */
class SubscriptionJob2 extends ros.Resource {
    /**
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        this.scope = scope;
        this.id = id;
        this.props = props;
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        const rosSubscriptionJob2 = new dts_generated_1.RosSubscriptionJob2(this, id, {
            status: props.status,
            reserve: props.reserve,
            delayPhone: props.delayPhone,
            dedicatedClusterId: props.dedicatedClusterId,
            errorNotice: props.errorNotice,
            dtsJobName: props.dtsJobName,
            delayRuleTime: props.delayRuleTime,
            dtsInstanceId: props.dtsInstanceId,
            dbList: props.dbList,
            dtsBisLabel: props.dtsBisLabel,
            subscriptionDataType: props.subscriptionDataType,
            checkpoint: props.checkpoint,
            delayNotice: props.delayNotice,
            dtsJobId: props.dtsJobId,
            subscriptionInstance: props.subscriptionInstance,
            sourceEndpoint: props.sourceEndpoint,
            errorPhone: props.errorPhone,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosSubscriptionJob2;
        this.attrDtsInstanceId = rosSubscriptionJob2.attrDtsInstanceId;
        this.attrDtsJobId = rosSubscriptionJob2.attrDtsJobId;
        this.attrDtsJobName = rosSubscriptionJob2.attrDtsJobName;
    }
}
exports.SubscriptionJob2 = SubscriptionJob2;
//# sourceMappingURL=data:application/json;base64,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