"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SynchronizationJob2 = exports.SynchronizationJob2Property = void 0;
const ros = require("@alicloud/ros-cdk-core");
const dts_generated_1 = require("./dts.generated");
Object.defineProperty(exports, "SynchronizationJob2Property", { enumerable: true, get: function () { return dts_generated_1.RosSynchronizationJob2; } });
/**
 * This class encapsulates and extends the ROS resource type `ALIYUN::DTS::SynchronizationJob2`, which is used to configure a data synchronization task.
 * @Note This class may have some new functions to facilitate development, so it is recommended to use this class instead of `RosSynchronizationJob2`for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/aliyun-dts-synchronizationjob2
 */
class SynchronizationJob2 extends ros.Resource {
    /**
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        this.scope = scope;
        this.id = id;
        this.props = props;
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        const rosSynchronizationJob2 = new dts_generated_1.RosSynchronizationJob2(this, id, {
            status: props.status,
            reserve: props.reserve,
            dataSynchronization: props.dataSynchronization,
            delayPhone: props.delayPhone,
            dedicatedClusterId: props.dedicatedClusterId,
            errorNotice: props.errorNotice,
            dtsJobName: props.dtsJobName,
            delayRuleTime: props.delayRuleTime,
            dtsInstanceId: props.dtsInstanceId,
            dbList: props.dbList,
            fileOssUrl: props.fileOssUrl,
            dataCheckConfigure: props.dataCheckConfigure,
            dtsBisLabel: props.dtsBisLabel,
            checkpoint: props.checkpoint,
            disasterRecoveryJob: props.disasterRecoveryJob,
            dtsJobId: props.dtsJobId,
            delayNotice: props.delayNotice,
            dataInitialization: props.dataInitialization,
            destinationEndpoint: props.destinationEndpoint,
            sourceEndpoint: props.sourceEndpoint,
            errorPhone: props.errorPhone,
            structureInitialization: props.structureInitialization,
            synchronizationDirection: props.synchronizationDirection,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosSynchronizationJob2;
        this.attrDtsInstanceId = rosSynchronizationJob2.attrDtsInstanceId;
        this.attrDtsJobId = rosSynchronizationJob2.attrDtsJobId;
        this.attrDtsJobName = rosSynchronizationJob2.attrDtsJobName;
    }
}
exports.SynchronizationJob2 = SynchronizationJob2;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic3luY2hyb25pemF0aW9uam9iMi5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbInN5bmNocm9uaXphdGlvbmpvYjIudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7O0FBQUEsOENBQThDO0FBQzlDLG1EQUF5RDtBQUV0Qiw0R0FGMUIsc0NBQXNCLE9BRStCO0FBcUk5RDs7OztHQUlHO0FBQ0gsTUFBYSxtQkFBb0IsU0FBUSxHQUFHLENBQUMsUUFBUTtJQXFCakQ7Ozs7T0FJRztJQUNILFlBQVksS0FBb0IsRUFBRSxFQUFVLEVBQUUsS0FBK0IsRUFBRSxtQ0FBMkMsSUFBSTtRQUMxSCxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsQ0FBQyxDQUFDO1FBQ2pCLElBQUksQ0FBQyxLQUFLLEdBQUcsS0FBSyxDQUFDO1FBQ25CLElBQUksQ0FBQyxFQUFFLEdBQUcsRUFBRSxDQUFDO1FBQ2IsSUFBSSxDQUFDLEtBQUssR0FBRyxLQUFLLENBQUM7UUFDbkIsSUFBSSxDQUFDLGdDQUFnQyxHQUFHLGdDQUFnQyxDQUFDO1FBRXpFLE1BQU0sc0JBQXNCLEdBQUcsSUFBSSxzQ0FBc0IsQ0FBQyxJQUFJLEVBQUUsRUFBRSxFQUFHO1lBQ2pFLE1BQU0sRUFBRSxLQUFLLENBQUMsTUFBTTtZQUNwQixPQUFPLEVBQUUsS0FBSyxDQUFDLE9BQU87WUFDdEIsbUJBQW1CLEVBQUUsS0FBSyxDQUFDLG1CQUFtQjtZQUM5QyxVQUFVLEVBQUUsS0FBSyxDQUFDLFVBQVU7WUFDNUIsa0JBQWtCLEVBQUUsS0FBSyxDQUFDLGtCQUFrQjtZQUM1QyxXQUFXLEVBQUUsS0FBSyxDQUFDLFdBQVc7WUFDOUIsVUFBVSxFQUFFLEtBQUssQ0FBQyxVQUFVO1lBQzVCLGFBQWEsRUFBRSxLQUFLLENBQUMsYUFBYTtZQUNsQyxhQUFhLEVBQUUsS0FBSyxDQUFDLGFBQWE7WUFDbEMsTUFBTSxFQUFFLEtBQUssQ0FBQyxNQUFNO1lBQ3BCLFVBQVUsRUFBRSxLQUFLLENBQUMsVUFBVTtZQUM1QixrQkFBa0IsRUFBRSxLQUFLLENBQUMsa0JBQWtCO1lBQzVDLFdBQVcsRUFBRSxLQUFLLENBQUMsV0FBVztZQUM5QixVQUFVLEVBQUUsS0FBSyxDQUFDLFVBQVU7WUFDNUIsbUJBQW1CLEVBQUUsS0FBSyxDQUFDLG1CQUFtQjtZQUM5QyxRQUFRLEVBQUUsS0FBSyxDQUFDLFFBQVE7WUFDeEIsV0FBVyxFQUFFLEtBQUssQ0FBQyxXQUFXO1lBQzlCLGtCQUFrQixFQUFFLEtBQUssQ0FBQyxrQkFBa0I7WUFDNUMsbUJBQW1CLEVBQUUsS0FBSyxDQUFDLG1CQUFtQjtZQUM5QyxjQUFjLEVBQUUsS0FBSyxDQUFDLGNBQWM7WUFDcEMsVUFBVSxFQUFFLEtBQUssQ0FBQyxVQUFVO1lBQzVCLHVCQUF1QixFQUFFLEtBQUssQ0FBQyx1QkFBdUI7WUFDdEQsd0JBQXdCLEVBQUUsS0FBSyxDQUFDLHdCQUF3QjtTQUMzRCxFQUFFLGdDQUFnQyxJQUFJLElBQUksQ0FBQyxLQUFLLENBQUMsZ0NBQWdDLENBQUMsQ0FBQztRQUNwRixJQUFJLENBQUMsUUFBUSxHQUFHLHNCQUFzQixDQUFDO1FBQ3ZDLElBQUksQ0FBQyxpQkFBaUIsR0FBRyxzQkFBc0IsQ0FBQyxpQkFBaUIsQ0FBQztRQUNsRSxJQUFJLENBQUMsWUFBWSxHQUFHLHNCQUFzQixDQUFDLFlBQVksQ0FBQztRQUN4RCxJQUFJLENBQUMsY0FBYyxHQUFHLHNCQUFzQixDQUFDLGNBQWMsQ0FBQztJQUNoRSxDQUFDO0NBQ0o7QUEvREQsa0RBK0RDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0ICogYXMgcm9zIGZyb20gJ0BhbGljbG91ZC9yb3MtY2RrLWNvcmUnO1xuaW1wb3J0IHsgUm9zU3luY2hyb25pemF0aW9uSm9iMiB9IGZyb20gJy4vZHRzLmdlbmVyYXRlZCc7XG4vLyBHZW5lcmF0ZWQgZnJvbSB0aGUgQWxpQ2xvdWQgUk9TIFJlc291cmNlIFNwZWNpZmljYXRpb25cbmV4cG9ydCB7IFJvc1N5bmNocm9uaXphdGlvbkpvYjIgYXMgU3luY2hyb25pemF0aW9uSm9iMlByb3BlcnR5IH07XG5cbi8qKlxuICogUHJvcGVydGllcyBmb3IgZGVmaW5pbmcgYSBgU3luY2hyb25pemF0aW9uSm9iMmAuXG4gKiBTZWUgaHR0cHM6Ly93d3cuYWxpYmFiYWNsb3VkLmNvbS9oZWxwL3Jvcy9kZXZlbG9wZXItcmVmZXJlbmNlL2FsaXl1bi1kdHMtc3luY2hyb25pemF0aW9uam9iMlxuICovXG5leHBvcnQgaW50ZXJmYWNlIFN5bmNocm9uaXphdGlvbkpvYjJQcm9wcyB7XG5cbiAgICAvKipcbiAgICAgKiBQcm9wZXJ0eSBkYXRhSW5pdGlhbGl6YXRpb246IFNwZWNpZmllcyB3aGV0aGVyIHRvIHBlcmZvcm0gZnVsbCBkYXRhIG1pZ3JhdGlvbiBvciBmdWxsIGRhdGEgc3luY2hyb25pemF0aW9uLiBEZWZhdWx0IHZhbHVlOiAqKnRydWUqKi4gVmFsaWQgdmFsdWVzOiAqKnRydWUqKiBhbmQgKipmYWxzZSoqLlxuICAgICAqL1xuICAgIHJlYWRvbmx5IGRhdGFJbml0aWFsaXphdGlvbjogYm9vbGVhbiB8IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIFByb3BlcnR5IGRhdGFTeW5jaHJvbml6YXRpb246IFNwZWNpZmllcyB3aGV0aGVyIHRvIHBlcmZvcm0gaW5jcmVtZW50YWwgZGF0YSBtaWdyYXRpb24gb3IgaW5jcmVtZW50YWwgZGF0YSBzeW5jaHJvbml6YXRpb24uIERlZmF1bHQgdmFsdWU6ICoqZmFsc2UqKi4gVmFsaWQgdmFsdWVzOiAqKnRydWUqKiBhbmQgKipmYWxzZSoqLlxuICAgICAqL1xuICAgIHJlYWRvbmx5IGRhdGFTeW5jaHJvbml6YXRpb246IGJvb2xlYW4gfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBQcm9wZXJ0eSBkYkxpc3Q6IFRoZSBvYmplY3RzIHRoYXQgeW91IHdhbnQgdG8gbWlncmF0ZSBvciBzeW5jaHJvbml6ZS5cbiAgICAgKi9cbiAgICByZWFkb25seSBkYkxpc3Q6IHsgW2tleTogc3RyaW5nXTogKGFueSB8IHJvcy5JUmVzb2x2YWJsZSkgfSB8IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIFByb3BlcnR5IGRlc3RpbmF0aW9uRW5kcG9pbnQ6IERlc3RpbmF0aW9uIGluc3RhbmNlIGNvbmZpZ3VyYXRpb24uXG4gICAgICovXG4gICAgcmVhZG9ubHkgZGVzdGluYXRpb25FbmRwb2ludDogUm9zU3luY2hyb25pemF0aW9uSm9iMi5EZXN0aW5hdGlvbkVuZHBvaW50UHJvcGVydHkgfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBQcm9wZXJ0eSBkdHNKb2JOYW1lOiBUaGUgbmFtZSBvZiB0aGUgRFRTIGluc3RhbmNlLlxuICAgICAqL1xuICAgIHJlYWRvbmx5IGR0c0pvYk5hbWU6IHN0cmluZyB8IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIFByb3BlcnR5IHNvdXJjZUVuZHBvaW50OiBTb3VyY2UgaW5zdGFuY2UgY29uZmlndXJhdGlvbi5cbiAgICAgKi9cbiAgICByZWFkb25seSBzb3VyY2VFbmRwb2ludDogUm9zU3luY2hyb25pemF0aW9uSm9iMi5Tb3VyY2VFbmRwb2ludFByb3BlcnR5IHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogUHJvcGVydHkgc3RydWN0dXJlSW5pdGlhbGl6YXRpb246IFNwZWNpZmllcyB3aGV0aGVyIHRvIHBlcmZvcm0gc2NoZW1hIG1pZ3JhdGlvbiBvciBzY2hlbWEgc3luY2hyb25pemF0aW9uLiBEZWZhdWx0IHZhbHVlOiB0cnVlLiBWYWxpZCB2YWx1ZXM6ICoqdHJ1ZSoqIGFuZCAqKmZhbHNlKiouXG4gICAgICovXG4gICAgcmVhZG9ubHkgc3RydWN0dXJlSW5pdGlhbGl6YXRpb246IGJvb2xlYW4gfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBQcm9wZXJ0eSBjaGVja3BvaW50OiBUaGUgc3RhcnQgb2Zmc2V0IG9mIGluY3JlbWVudGFsIGRhdGEgbWlncmF0aW9uIG9yIHN5bmNocm9uaXphdGlvbi4gVGhpcyB2YWx1ZSBpcyBhIFVOSVggdGltZXN0YW1wIHJlcHJlc2VudGluZyB0aGUgbnVtYmVyIG9mIHNlY29uZHMgdGhhdCBoYXZlIGVsYXBzZWQgc2luY2UgSmFudWFyeSAxLCAxOTcwLCAwMDowMDowMCBVVEMuXG4gICAgICovXG4gICAgcmVhZG9ubHkgY2hlY2twb2ludD86IHN0cmluZyB8IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIFByb3BlcnR5IGRhdGFDaGVja0NvbmZpZ3VyZTogVGhlIGRhdGEgdmVyaWZpY2F0aW9uIHRhc2sgZm9yIGEgZGF0YSBtaWdyYXRpb24gb3Igc3luY2hyb25pemF0aW9uIGluc3RhbmNlLlxuICAgICAqL1xuICAgIHJlYWRvbmx5IGRhdGFDaGVja0NvbmZpZ3VyZT86IFJvc1N5bmNocm9uaXphdGlvbkpvYjIuRGF0YUNoZWNrQ29uZmlndXJlUHJvcGVydHkgfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBQcm9wZXJ0eSBkZWRpY2F0ZWRDbHVzdGVySWQ6IFRoZSBJRCBvZiB0aGUgRFRTIGRlZGljYXRlZCBjbHVzdGVyIG9uIHdoaWNoIHRoZSB0YXNrIHJ1bnMuXG4gICAgICovXG4gICAgcmVhZG9ubHkgZGVkaWNhdGVkQ2x1c3RlcklkPzogc3RyaW5nIHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogUHJvcGVydHkgZGVsYXlOb3RpY2U6IFNwZWNpZmllcyB3aGV0aGVyIHRvIG1vbml0b3IgdGhlIHRhc2sgbGF0ZW5jeS4gVmFsaWQgdmFsdWVzOiAqKnRydWUqKiBhbmQgKipmYWxzZSoqXG4gICAgICovXG4gICAgcmVhZG9ubHkgZGVsYXlOb3RpY2U/OiBib29sZWFuIHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogUHJvcGVydHkgZGVsYXlQaG9uZTogVGhlIG1vYmlsZSBudW1iZXJzIHRoYXQgcmVjZWl2ZSBsYXRlbmN5LXJlbGF0ZWQgYWxlcnRzLiBTZXBhcmF0ZSBtdWx0aXBsZSBtb2JpbGUgbnVtYmVycyB3aXRoIGNvbW1hcyAoLCkuXG4gICAgICogKipOb3RlKio6IFRoaXMgcGFyYW1ldGVyIGlzIGF2YWlsYWJsZSBvbmx5IGZvciB1c2VycyBvZiB0aGUgQ2hpbmEgc2l0ZSAoYWxpeXVuLmNvbSkuIE9ubHkgbW9iaWxlIG51bWJlcnMgaW4gdGhlIENoaW5lc2UgbWFpbmxhbmQgYXJlIHN1cHBvcnRlZC4gWW91IGNhbiBzcGVjaWZ5IHVwIHRvIDEwIG1vYmlsZSBudW1iZXJzLiBVc2VycyBvZiB0aGUgaW50ZXJuYXRpb25hbCBzaXRlIChhbGliYWJhY2xvdWQuY29tKSBjYW5ub3QgcmVjZWl2ZSBhbGVydHMgYnkgdXNpbmcgbW9iaWxlIG51bWJlcnMsIGJ1dCBjYW4gY29uZmlndXJlIGFsZXJ0IHJ1bGVzIGZvciBEVFMgdGFza3MgaW4gdGhlIENsb3VkTW9uaXRvciBjb25zb2xlLlxuICAgICAqL1xuICAgIHJlYWRvbmx5IGRlbGF5UGhvbmU/OiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBQcm9wZXJ0eSBkZWxheVJ1bGVUaW1lOiBUaGUgdGhyZXNob2xkIGZvciBsYXRlbmN5IGFsZXJ0cy4gVW5pdDogc2Vjb25kcy4gWW91IGNhbiBzZXQgdGhlIHRocmVzaG9sZCBiYXNlZCBvbiB5b3VyIGJ1c2luZXNzIHJlcXVpcmVtZW50cy4gVG8gcHJldmVudCBqaXR0ZXJzIGNhdXNlZCBieSBuZXR3b3JrIGFuZCBkYXRhYmFzZSBvdmVybG9hZHMsIHdlIHJlY29tbWVuZCB0aGF0IHlvdSBzZXQgdGhlIHRocmVzaG9sZCB0byBtb3JlIHRoYW4gMTAgc2Vjb25kcy5cbiAgICAgKi9cbiAgICByZWFkb25seSBkZWxheVJ1bGVUaW1lPzogbnVtYmVyIHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogUHJvcGVydHkgZGlzYXN0ZXJSZWNvdmVyeUpvYjogU3BlY2lmaWVzIHdoZXRoZXIgdGhlIGluc3RhbmNlIGlzIGEgZGlzYXN0ZXIgcmVjb3ZlcnkgaW5zdGFuY2UuIFZhbGlkIHZhbHVlczogKip0cnVlKiogYW5kICoqZmFsc2UqKlxuICAgICAqL1xuICAgIHJlYWRvbmx5IGRpc2FzdGVyUmVjb3ZlcnlKb2I/OiBib29sZWFuIHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogUHJvcGVydHkgZHRzQmlzTGFiZWw6IFRoZSBlbnZpcm9ubWVudCB0YWcgb2YgdGhlIERUUyBpbnN0YW5jZS4gVmFsaWQgdmFsdWVzOiAqKm5vcm1hbCoqIGFuZCAqKm9ubGluZSoqLlxuICAgICAqL1xuICAgIHJlYWRvbmx5IGR0c0Jpc0xhYmVsPzogc3RyaW5nIHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogUHJvcGVydHkgZHRzSW5zdGFuY2VJZDogVGhlIElEIG9mIHRoZSBEVFMgaW5zdGFuY2UuXG4gICAgICovXG4gICAgcmVhZG9ubHkgZHRzSW5zdGFuY2VJZD86IHN0cmluZyB8IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIFByb3BlcnR5IGR0c0pvYklkOiBUaGUgSUQgb2YgdGhlIERUUyB0YXNrLlxuICAgICAqL1xuICAgIHJlYWRvbmx5IGR0c0pvYklkPzogc3RyaW5nIHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogUHJvcGVydHkgZXJyb3JOb3RpY2U6IFNwZWNpZmllcyB3aGV0aGVyIHRvIG1vbml0b3IgdGhlIHRhc2sgc3RhdHVzLiBWYWxpZCB2YWx1ZXM6ICoqdHJ1ZSoqIGFuZCAqKmZhbHNlKiouXG4gICAgICovXG4gICAgcmVhZG9ubHkgZXJyb3JOb3RpY2U/OiBib29sZWFuIHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogUHJvcGVydHkgZXJyb3JQaG9uZTogVGhlIG1vYmlsZSBudW1iZXJzIHRoYXQgcmVjZWl2ZSBzdGF0dXMtcmVsYXRlZCBhbGVydHMuIFNlcGFyYXRlIG11bHRpcGxlIG1vYmlsZSBudW1iZXJzIHdpdGggY29tbWFzICgsKS5cbiAgICAgKiAqKk5vdGUqKjogVGhpcyBwYXJhbWV0ZXIgaXMgYXZhaWxhYmxlIG9ubHkgZm9yIHVzZXJzIG9mIHRoZSBDaGluYSBzaXRlIChhbGl5dW4uY29tKS4gT25seSBtb2JpbGUgbnVtYmVycyBpbiB0aGUgQ2hpbmVzZSBtYWlubGFuZCBhcmUgc3VwcG9ydGVkLiBZb3UgY2FuIHNwZWNpZnkgdXAgdG8gMTAgbW9iaWxlIG51bWJlcnMuIFVzZXJzIG9mIHRoZSBpbnRlcm5hdGlvbmFsIHNpdGUgKGFsaWJhYmFjbG91ZC5jb20pIGNhbm5vdCByZWNlaXZlIGFsZXJ0cyBieSB1c2luZyBtb2JpbGUgbnVtYmVycywgYnV0IGNhbiBjb25maWd1cmUgYWxlcnQgcnVsZXMgZm9yIERUUyB0YXNrcyBpbiB0aGUgQ2xvdWRNb25pdG9yIGNvbnNvbGUuXG4gICAgICovXG4gICAgcmVhZG9ubHkgZXJyb3JQaG9uZT86IHN0cmluZyB8IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIFByb3BlcnR5IGZpbGVPc3NVcmw6IFRoZSBVUkwgb2YgdGhlIE9iamVjdCBTdG9yYWdlIFNlcnZpY2UgKE9TUykgYnVja2V0IHRoYXQgc3RvcmVzIHRoZSBmaWxlcyByZWxhdGVkIHRvIHRoZSBEVFMgdGFzay5cbiAgICAgKi9cbiAgICByZWFkb25seSBmaWxlT3NzVXJsPzogc3RyaW5nIHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogUHJvcGVydHkgcmVzZXJ2ZTogVGhlIHJlc2VydmVkIHBhcmFtZXRlciBvZiBEVFMuIFlvdSBjYW4gc3BlY2lmeSB0aGlzIHBhcmFtZXRlciB0byBhZGQgbW9yZSBjb25maWd1cmF0aW9ucyBvZiB0aGUgc291cmNlIG9yIGRlc3RpbmF0aW9uIGluc3RhbmNlIHRvIHRoZSBEVFMgdGFzay4gRm9yIGV4YW1wbGUsIHlvdSBjYW4gc3BlY2lmeSB0aGUgZGF0YSBzdG9yYWdlIGZvcm1hdCBvZiB0aGUgZGVzdGluYXRpb24gS2Fma2EgZGF0YWJhc2UgYW5kIHRoZSBJRCBvZiB0aGUgQ0VOIGluc3RhbmNlLlxuICAgICAqL1xuICAgIHJlYWRvbmx5IHJlc2VydmU/OiB7IFtrZXk6IHN0cmluZ106IChhbnkgfCByb3MuSVJlc29sdmFibGUpIH0gfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBQcm9wZXJ0eSBzdGF0dXM6IFRoZSBzdGF0dXMgb2YgdGhlIHJlc291cmNlLiBWYWxpZCB2YWx1ZXM6XG4gICAgICogLSAqKlN5bmNocm9uaXppbmcqKjogU3RhcnQgdGhlIHRhc2suXG4gICAgICogLSAqKlN1c3BlbmRpbmcqKjogU3VzcGVuZCB0aGUgdGFzay5cbiAgICAgKiAtICoqU3RvcHBpbmcqKjogU3RvcCB0aGUgdGFzay5cbiAgICAgKi9cbiAgICByZWFkb25seSBzdGF0dXM/OiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBQcm9wZXJ0eSBzeW5jaHJvbml6YXRpb25EaXJlY3Rpb246IFRoZSBzeW5jaHJvbml6YXRpb24gZGlyZWN0aW9uLiBEZWZhdWx0IHZhbHVlOiBGb3J3YXJkLiBWYWxpZCB2YWx1ZXM6XG4gICAgICogLSAqKkZvcndhcmQqKjogRGF0YSBpcyBzeW5jaHJvbml6ZWQgZnJvbSB0aGUgc291cmNlIGRhdGFiYXNlIHRvIHRoZSBkZXN0aW5hdGlvbiBkYXRhYmFzZS5cbiAgICAgKiAtICoqUmV2ZXJzZSoqOiBEYXRhIGlzIHN5bmNocm9uaXplZCBmcm9tIHRoZSBkZXN0aW5hdGlvbiBkYXRhYmFzZSB0byB0aGUgc291cmNlIGRhdGFiYXNlLlxuICAgICAqICoqTm90ZSoqOiBUaGUgZGVmYXVsdCB2YWx1ZSBpcyAqKkZvcndhcmQqKi5cbiAgICAgKiBUaGUgdmFsdWUgUmV2ZXJzZSB0YWtlcyBlZmZlY3Qgb25seSBpZiB0aGUgdG9wb2xvZ3kgb2YgdGhlIGRhdGEgc3luY2hyb25pemF0aW9uIHRhc2sgaXMgdHdvLXdheSBzeW5jaHJvbml6YXRpb24uXG4gICAgICovXG4gICAgcmVhZG9ubHkgc3luY2hyb25pemF0aW9uRGlyZWN0aW9uPzogc3RyaW5nIHwgcm9zLklSZXNvbHZhYmxlO1xufVxuXG4vKipcbiAqIFRoaXMgY2xhc3MgZW5jYXBzdWxhdGVzIGFuZCBleHRlbmRzIHRoZSBST1MgcmVzb3VyY2UgdHlwZSBgQUxJWVVOOjpEVFM6OlN5bmNocm9uaXphdGlvbkpvYjJgLCB3aGljaCBpcyB1c2VkIHRvIGNvbmZpZ3VyZSBhIGRhdGEgc3luY2hyb25pemF0aW9uIHRhc2suXG4gKiBATm90ZSBUaGlzIGNsYXNzIG1heSBoYXZlIHNvbWUgbmV3IGZ1bmN0aW9ucyB0byBmYWNpbGl0YXRlIGRldmVsb3BtZW50LCBzbyBpdCBpcyByZWNvbW1lbmRlZCB0byB1c2UgdGhpcyBjbGFzcyBpbnN0ZWFkIG9mIGBSb3NTeW5jaHJvbml6YXRpb25Kb2IyYGZvciBhIG1vcmUgY29udmVuaWVudCBkZXZlbG9wbWVudCBleHBlcmllbmNlLlxuICogU2VlIGh0dHBzOi8vd3d3LmFsaWJhYmFjbG91ZC5jb20vaGVscC9yb3MvZGV2ZWxvcGVyLXJlZmVyZW5jZS9hbGl5dW4tZHRzLXN5bmNocm9uaXphdGlvbmpvYjJcbiAqL1xuZXhwb3J0IGNsYXNzIFN5bmNocm9uaXphdGlvbkpvYjIgZXh0ZW5kcyByb3MuUmVzb3VyY2Uge1xuICAgIHByb3RlY3RlZCBzY29wZTogcm9zLkNvbnN0cnVjdDtcbiAgICBwcm90ZWN0ZWQgaWQ6IHN0cmluZztcbiAgICBwcm90ZWN0ZWQgcHJvcHM6IFN5bmNocm9uaXphdGlvbkpvYjJQcm9wcztcbiAgICBwcm90ZWN0ZWQgZW5hYmxlUmVzb3VyY2VQcm9wZXJ0eUNvbnN0cmFpbnQ6IGJvb2xlYW47XG5cbiAgICAvKipcbiAgICAgKiBBdHRyaWJ1dGUgRHRzSW5zdGFuY2VJZDogVGhlIElEIG9mIHRoZSBEVFMgaW5zdGFuY2UuXG4gICAgICovXG4gICAgcHVibGljIHJlYWRvbmx5IGF0dHJEdHNJbnN0YW5jZUlkOiByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBBdHRyaWJ1dGUgRHRzSm9iSWQ6IFRoZSBJRCBvZiB0aGUgdGFzay5cbiAgICAgKi9cbiAgICBwdWJsaWMgcmVhZG9ubHkgYXR0ckR0c0pvYklkOiByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBBdHRyaWJ1dGUgRHRzSm9iTmFtZTogVGhlIG5hbWUgb2YgdGhlIERUUyBqb2IuXG4gICAgICovXG4gICAgcHVibGljIHJlYWRvbmx5IGF0dHJEdHNKb2JOYW1lOiByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBQYXJhbSBzY29wZSAtIHNjb3BlIGluIHdoaWNoIHRoaXMgcmVzb3VyY2UgaXMgZGVmaW5lZFxuICAgICAqIFBhcmFtIGlkICAgIC0gc2NvcGVkIGlkIG9mIHRoZSByZXNvdXJjZVxuICAgICAqIFBhcmFtIHByb3BzIC0gcmVzb3VyY2UgcHJvcGVydGllc1xuICAgICAqL1xuICAgIGNvbnN0cnVjdG9yKHNjb3BlOiByb3MuQ29uc3RydWN0LCBpZDogc3RyaW5nLCBwcm9wczogU3luY2hyb25pemF0aW9uSm9iMlByb3BzLCBlbmFibGVSZXNvdXJjZVByb3BlcnR5Q29uc3RyYWludDpib29sZWFuID0gdHJ1ZSkge1xuICAgICAgICBzdXBlcihzY29wZSwgaWQpO1xuICAgICAgICB0aGlzLnNjb3BlID0gc2NvcGU7XG4gICAgICAgIHRoaXMuaWQgPSBpZDtcbiAgICAgICAgdGhpcy5wcm9wcyA9IHByb3BzO1xuICAgICAgICB0aGlzLmVuYWJsZVJlc291cmNlUHJvcGVydHlDb25zdHJhaW50ID0gZW5hYmxlUmVzb3VyY2VQcm9wZXJ0eUNvbnN0cmFpbnQ7XG5cbiAgICAgICAgY29uc3Qgcm9zU3luY2hyb25pemF0aW9uSm9iMiA9IG5ldyBSb3NTeW5jaHJvbml6YXRpb25Kb2IyKHRoaXMsIGlkLCAge1xuICAgICAgICAgICAgc3RhdHVzOiBwcm9wcy5zdGF0dXMsXG4gICAgICAgICAgICByZXNlcnZlOiBwcm9wcy5yZXNlcnZlLFxuICAgICAgICAgICAgZGF0YVN5bmNocm9uaXphdGlvbjogcHJvcHMuZGF0YVN5bmNocm9uaXphdGlvbixcbiAgICAgICAgICAgIGRlbGF5UGhvbmU6IHByb3BzLmRlbGF5UGhvbmUsXG4gICAgICAgICAgICBkZWRpY2F0ZWRDbHVzdGVySWQ6IHByb3BzLmRlZGljYXRlZENsdXN0ZXJJZCxcbiAgICAgICAgICAgIGVycm9yTm90aWNlOiBwcm9wcy5lcnJvck5vdGljZSxcbiAgICAgICAgICAgIGR0c0pvYk5hbWU6IHByb3BzLmR0c0pvYk5hbWUsXG4gICAgICAgICAgICBkZWxheVJ1bGVUaW1lOiBwcm9wcy5kZWxheVJ1bGVUaW1lLFxuICAgICAgICAgICAgZHRzSW5zdGFuY2VJZDogcHJvcHMuZHRzSW5zdGFuY2VJZCxcbiAgICAgICAgICAgIGRiTGlzdDogcHJvcHMuZGJMaXN0LFxuICAgICAgICAgICAgZmlsZU9zc1VybDogcHJvcHMuZmlsZU9zc1VybCxcbiAgICAgICAgICAgIGRhdGFDaGVja0NvbmZpZ3VyZTogcHJvcHMuZGF0YUNoZWNrQ29uZmlndXJlLFxuICAgICAgICAgICAgZHRzQmlzTGFiZWw6IHByb3BzLmR0c0Jpc0xhYmVsLFxuICAgICAgICAgICAgY2hlY2twb2ludDogcHJvcHMuY2hlY2twb2ludCxcbiAgICAgICAgICAgIGRpc2FzdGVyUmVjb3ZlcnlKb2I6IHByb3BzLmRpc2FzdGVyUmVjb3ZlcnlKb2IsXG4gICAgICAgICAgICBkdHNKb2JJZDogcHJvcHMuZHRzSm9iSWQsXG4gICAgICAgICAgICBkZWxheU5vdGljZTogcHJvcHMuZGVsYXlOb3RpY2UsXG4gICAgICAgICAgICBkYXRhSW5pdGlhbGl6YXRpb246IHByb3BzLmRhdGFJbml0aWFsaXphdGlvbixcbiAgICAgICAgICAgIGRlc3RpbmF0aW9uRW5kcG9pbnQ6IHByb3BzLmRlc3RpbmF0aW9uRW5kcG9pbnQsXG4gICAgICAgICAgICBzb3VyY2VFbmRwb2ludDogcHJvcHMuc291cmNlRW5kcG9pbnQsXG4gICAgICAgICAgICBlcnJvclBob25lOiBwcm9wcy5lcnJvclBob25lLFxuICAgICAgICAgICAgc3RydWN0dXJlSW5pdGlhbGl6YXRpb246IHByb3BzLnN0cnVjdHVyZUluaXRpYWxpemF0aW9uLFxuICAgICAgICAgICAgc3luY2hyb25pemF0aW9uRGlyZWN0aW9uOiBwcm9wcy5zeW5jaHJvbml6YXRpb25EaXJlY3Rpb24sXG4gICAgICAgIH0sIGVuYWJsZVJlc291cmNlUHJvcGVydHlDb25zdHJhaW50ICYmIHRoaXMuc3RhY2suZW5hYmxlUmVzb3VyY2VQcm9wZXJ0eUNvbnN0cmFpbnQpO1xuICAgICAgICB0aGlzLnJlc291cmNlID0gcm9zU3luY2hyb25pemF0aW9uSm9iMjtcbiAgICAgICAgdGhpcy5hdHRyRHRzSW5zdGFuY2VJZCA9IHJvc1N5bmNocm9uaXphdGlvbkpvYjIuYXR0ckR0c0luc3RhbmNlSWQ7XG4gICAgICAgIHRoaXMuYXR0ckR0c0pvYklkID0gcm9zU3luY2hyb25pemF0aW9uSm9iMi5hdHRyRHRzSm9iSWQ7XG4gICAgICAgIHRoaXMuYXR0ckR0c0pvYk5hbWUgPSByb3NTeW5jaHJvbml6YXRpb25Kb2IyLmF0dHJEdHNKb2JOYW1lO1xuICAgIH1cbn1cbiJdfQ==