"""adding foreign key on fides key for taxonomy

Revision ID: 10c6b7709be3
Revises: b63ecb007556
Create Date: 2024-12-17 14:54:02.325442

"""

import sqlalchemy as sa
from alembic import op

# revision identifiers, used by Alembic.
revision = "10c6b7709be3"
down_revision = "b63ecb007556"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_foreign_key(
        "ctl_data_categories_parent_key_fkey",
        "ctl_data_categories",
        "ctl_data_categories",
        ["parent_key"],
        ["fides_key"],
        ondelete="RESTRICT",
    )
    op.create_foreign_key(
        "ctl_data_uses_parent_key_fkey",
        "ctl_data_uses",
        "ctl_data_uses",
        ["parent_key"],
        ["fides_key"],
        ondelete="RESTRICT",
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_constraint(
        "ctl_data_categories_parent_key_fkey", "ctl_data_categories", type_="foreignkey"
    )
    op.drop_constraint(
        "ctl_data_uses_parent_key_fkey", "ctl_data_uses", type_="foreignkey"
    )
    # ### end Alembic commands ###
