"""classification management

Revision ID: 3d9c476d7cea
Revises: 6bd93cb0603d
Create Date: 2022-09-14 02:21:37.828382

"""

import sqlalchemy as sa
from alembic import op

# revision identifiers, used by Alembic.
revision = "3d9c476d7cea"
down_revision = "6bd93cb0603d"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "cls_classification_detail",
        sa.Column("id", sa.String(length=255), nullable=False),
        sa.Column("instance_id", sa.String(length=255), nullable=True),
        sa.Column("status", sa.Text(), nullable=True),
        sa.Column("dataset", sa.Text(), nullable=True),
        sa.Column("collection", sa.Text(), nullable=True),
        sa.Column("field", sa.Text(), nullable=True),
        sa.Column("labels", sa.JSON(), nullable=True),
        sa.Column(
            "created_at",
            sa.DateTime(timezone=True),
            server_default=sa.text("now()"),
            nullable=True,
        ),
        sa.Column(
            "updated_at",
            sa.DateTime(timezone=True),
            server_default=sa.text("now()"),
            nullable=True,
        ),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_index(
        op.f("ix_cls_classification_detail_id"),
        "cls_classification_detail",
        ["id"],
        unique=False,
    )
    op.create_table(
        "cls_classification_instance",
        sa.Column("id", sa.String(length=255), nullable=False),
        sa.Column("status", sa.Text(), nullable=True),
        sa.Column("organization_key", sa.Text(), nullable=True),
        sa.Column("dataset_key", sa.Text(), nullable=True),
        sa.Column("dataset_name", sa.Text(), nullable=True),
        sa.Column("target", sa.Text(), nullable=True),
        sa.Column("type", sa.Text(), nullable=True),
        sa.Column(
            "created_at",
            sa.DateTime(timezone=True),
            server_default=sa.text("now()"),
            nullable=True,
        ),
        sa.Column(
            "updated_at",
            sa.DateTime(timezone=True),
            server_default=sa.text("now()"),
            nullable=True,
        ),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_index(
        op.f("ix_cls_classification_instance_id"),
        "cls_classification_instance",
        ["id"],
        unique=False,
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index(
        op.f("ix_cls_classification_instance_id"),
        table_name="cls_classification_instance",
    )
    op.drop_table("cls_classification_instance")
    op.drop_index(
        op.f("ix_cls_classification_detail_id"), table_name="cls_classification_detail"
    )
    op.drop_table("cls_classification_detail")
    # ### end Alembic commands ###
