"""add application config table

Revision ID: 5d62bab40b71
Revises: 7fd4601ef88b
Create Date: 2023-01-27 22:56:33.367379

"""

import sqlalchemy as sa
import sqlalchemy_utils
from alembic import op

# revision identifiers, used by Alembic.
revision = "5d62bab40b71"
down_revision = "7fd4601ef88b"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "applicationconfig",
        sa.Column("id", sa.String(length=255), nullable=False),
        sa.Column(
            "created_at",
            sa.DateTime(timezone=True),
            server_default=sa.text("now()"),
            nullable=True,
        ),
        sa.Column(
            "updated_at",
            sa.DateTime(timezone=True),
            server_default=sa.text("now()"),
            nullable=True,
        ),
        sa.Column(
            "api_set",
            sqlalchemy_utils.types.encrypted.encrypted_type.StringEncryptedType(),
            nullable=True,
        ),
        sa.Column("single_row", sa.Boolean(), nullable=False),
        sa.PrimaryKeyConstraint("id"),
        sa.CheckConstraint("single_row", name="single_row_check"),
    )
    op.create_index(
        op.f("ix_applicationconfig_id"), "applicationconfig", ["id"], unique=False
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index(op.f("ix_applicationconfig_id"), table_name="applicationconfig")
    op.drop_table("applicationconfig")
    # ### end Alembic commands ###
