# coding: utf-8

"""
    OpenAPI

    OpenAPI

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from hubsante_model.cisu.models.contact import Contact
from typing import Optional, Set
from typing_extensions import Self

class CallTaker(BaseModel):
    """
    CallTaker
    """ # noqa: E501
    organization: StrictStr = Field(description="Décrit la structure ou le service à laquelle est rattachée l'agent (en fonction du niveau de précision disponible). Se référer au DSF pour la structure normée des organisations. Le format est le suivant {pays}.{domaine}.{organisation}.{structure interne}*.{unité fonctionnelle}*.")
    control_room: StrictStr = Field(description="Décrit le centre d'appel auquel est rattaché l'agent", alias="controlRoom")
    role: Optional[StrictStr] = Field(default=None, description="Décrit le rôle de l'agent au sein du service selon la nomenclature PERSO (nomenclature SI-SAMU)")
    calltaker_contact: Optional[Contact] = Field(default=None, alias="calltakerContact")
    calltaker_id: Optional[StrictStr] = Field(default=None, description="Identifiant unique de l'opérateur ayant traité l'alerte (peut être un identifiant technique, un numéro de carte CPS etc)", alias="calltakerId")
    __properties: ClassVar[List[str]] = ["organization", "controlRoom", "role", "calltakerContact", "calltakerId"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CallTaker from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of calltaker_contact
        if self.calltaker_contact:
            _dict['calltakerContact'] = self.calltaker_contact.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CallTaker from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "organization": obj.get("organization"),
            "controlRoom": obj.get("controlRoom"),
            "role": obj.get("role"),
            "calltakerContact": Contact.from_dict(obj["calltakerContact"]) if obj.get("calltakerContact") is not None else None,
            "calltakerId": obj.get("calltakerId")
        })
        return _obj


