# coding: utf-8

"""
    OpenAPI

    OpenAPI

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from hubsante_model.emsi.models.context import Context
from hubsante_model.emsi.models.event import Event
from hubsante_model.emsi.models.mission import Mission
from hubsante_model.emsi.models.resource import Resource
from typing import Optional, Set
from typing_extensions import Self

class Emsi(BaseModel):
    """
    Emsi
    """ # noqa: E501
    context: Context = Field(alias="CONTEXT")
    event: Event = Field(alias="EVENT")
    mission: Optional[List[Mission]] = Field(default=None, alias="MISSION")
    resource: Optional[List[Resource]] = Field(default=None, alias="RESOURCE")
    __properties: ClassVar[List[str]] = ["CONTEXT", "EVENT", "MISSION", "RESOURCE"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Emsi from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of context
        if self.context:
            _dict['CONTEXT'] = self.context.to_dict()
        # override the default output from pydantic by calling `to_dict()` of event
        if self.event:
            _dict['EVENT'] = self.event.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in mission (list)
        _items = []
        if self.mission:
            for _item_mission in self.mission:
                if _item_mission:
                    _items.append(_item_mission.to_dict())
            _dict['MISSION'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in resource (list)
        _items = []
        if self.resource:
            for _item_resource in self.resource:
                if _item_resource:
                    _items.append(_item_resource.to_dict())
            _dict['RESOURCE'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Emsi from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "CONTEXT": Context.from_dict(obj["CONTEXT"]) if obj.get("CONTEXT") is not None else None,
            "EVENT": Event.from_dict(obj["EVENT"]) if obj.get("EVENT") is not None else None,
            "MISSION": [Mission.from_dict(_item) for _item in obj["MISSION"]] if obj.get("MISSION") is not None else None,
            "RESOURCE": [Resource.from_dict(_item) for _item in obj["RESOURCE"]] if obj.get("RESOURCE") is not None else None
        })
        return _obj


