# coding: utf-8

"""
    OpenAPI

    OpenAPI

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from hubsante_model.emsi.models.position import Position
from typing import Optional, Set
from typing_extensions import Self

class Mission(BaseModel):
    """
    Mission
    """ # noqa: E501
    type: StrictStr = Field(description="Le champ MISSION TYPE permet d'identifier l'effet à obtenir souhaité à partir de la combinaison du code ACTOR et du code TYPE. => La table de transcodage permettant d'identifier les concourants et les effets à obtenir à partir d'un code EMSI est fournie en annexe \"Référentiel Effets à Obtenir - correspondance EMSI\". Dans le cadre d'une réponse à DC : - reprendre le type de la DC si le code réponse choisi est vien \"VALIDE\" Dans le cadre d'une mission décrivant les opérations en cours : - reprendre la nomenclature EMSI pour caractériser la mission en cours.", alias="TYPE")
    freetext: Optional[StrictStr] = Field(default=None, description="Contient des commentaires relatifs aux objectifs et  moyens sollicités dans le cadre de la demande de concours. Les équipements supplémentaires souhaités ou le nom/ prénom des patients à prendre en charge peuvent être explicitement indiqués ici.", alias="FREETEXT")
    id: StrictStr = Field(description="Contient un identifiant de demande de concours unique. Cet identifiant sera réutilisable par le partenaire pour répondre à cette demande. Identifiant unique de la mission dans le système du partenaire la conduisant.", alias="ID")
    org_id: Optional[StrictStr] = Field(default=None, description="Indique l'organisation du partenaire concerné par la Demande de Concours (voir DSF). Le code CRRA ou le code du SIS peut être utilisé. Indique l'organisation du service réalisant la mission.  Dans le cas d'une réponse, c'est l'organisation du concourant qui doit être indiquée. Se référer au DSF pour la structure normée des organisations Le format est le suivant {pays}.{domaine}.{organisation}.{structure interne}*.{unité fonctionnelle}*.", alias="ORG_ID")
    name: StrictStr = Field(description="Le nom de la mission est construit à partir de l'expression régulière suivante : \"#DEMANDE_CONCOURS#\"{libelle_cadre_conventionnel}\"#\"{code_cadre_conventionnel}\"#\" où le code_cadre_conventionnel est issue d'une nomenclature CISU-Cadre Conventionnel (A Venir) NB : ce champ est détourné par rapport au standard EMSI pour permettre l'expression d'une demande de concours et indiquer le cadre conventionnel dans lequel elle est effectuée. Pour une réponse à demande de concours : - Le nom de la mission est construit à partir de l'expression régulière suivante : \"#REPONSE_DEMANDE_CONCOURS#\"{code_reponse}\"#\" où le code_reponse peut prendre les valeurs ACCEPTE, REFUS, PARTIELLE, DIVERGENTE - sinon libre", alias="NAME")
    status: StrictStr = Field(description="Les valeurs possibles avec lesquelles valoriser ce champ sont détaillées au sein d'une nomenclature EMSI - ABO : mission refusée (ABOrted) - CANCLD : mission annulée (CANCeLeD)** - NST : mission non débuté pour le métier (Not STarted) - IPR :  mission débuté pour le métier (In PRogress). la valeur IPR peut être suivi d'une valeur numérique de 00 à 100 (IPRnn) spécifiant le degré d'avancement de la mission. Ce principe n'est pas retenu au sein de NexSIS qui ne transmettra pas d'indication sur le degré d'avancement de la mission via ce champ. - PAU : événement arrêté, en pause pour métier, pas de besoin supplémentaire - COM : événement terminé pour le métier (COMplete) Le status de la mission et celui des RESSOURCE associées doit être cohérent et transcodable avec un status ANTARES (voir DSF)  Dans le cas d'un objet MISSION générique de réponse à demande de concours, le champ doit être valorisé à \"NST\"", alias="STATUS")
    start_time: Optional[str] = Field(default=None, description="- Dans le cadre d'une réponse à Demande de Concours Horraire cible pour l'arrivée sur les lieux décrites (peut diverger de l'horaire demandé) - Dans le cadre d'une mission décrivant les opérations en cours : Horaire effectif de début de la mission", alias="START_TIME")
    end_time: Optional[str] = Field(default=None, description="A valoriser selon la catégorie de mission : - Dans le cadre d'une mission de réponse à demande de concours : ne pas renseigner - Dans le cadre d'une mission décrivant les opérations en cours :  Si c'est un déplacement, l'heure d'arrivée, si c'est une prise en charge patient/victime, la fin de la prise en charge.", alias="END_TIME")
    resource_id: Optional[List[StrictStr]] = Field(default=None, alias="RESOURCE_ID")
    parent_mission_id: Optional[List[StrictStr]] = Field(default=None, alias="PARENT_MISSION_ID")
    child_mission_id: Optional[List[StrictStr]] = Field(default=None, alias="CHILD_MISSION_ID")
    main_mission_id: Optional[StrictStr] = Field(default=None, description="- Dans le cas d'une mission générique de réponse à demande de concours, indiquer l'ID de la mission générique utilisée pour modéliser la demande de concours - Dans le cas d'une mission déclenchée dans le cadre d'une réponse à demande de concours, l'ID de la mission générique de réponse peut être utilisée dans ce champ pour indiquer qu'elle est liée à une réponse", alias="MAIN_MISSION_ID")
    position: Optional[Position] = Field(default=None, alias="POSITION")
    priority: Optional[StrictStr] = Field(default=None, description="Indique une échelle de priorité pour la demande de concours. Dans le cadre du standard EMSI, cette échelle doit être comprise entre 0 et 5. Ce champ peut ne pas être interprété ni alimenté par les LRMs. Dans le cadre d'un échange des opérations, optionnel. Le champ peut ne pas être émis ni interprété.", alias="PRIORITY")
    __properties: ClassVar[List[str]] = ["TYPE", "FREETEXT", "ID", "ORG_ID", "NAME", "STATUS", "START_TIME", "END_TIME", "RESOURCE_ID", "PARENT_MISSION_ID", "CHILD_MISSION_ID", "MAIN_MISSION_ID", "POSITION", "PRIORITY"]

    @field_validator('type')
    def type_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['SAV/ASC', 'FR_MED/REGLTN', 'GEN/SUPRTN', 'SAV/AR/FR_MED', 'SAV/AR/FR_PARAMD', 'SAV', 'GEN/TRNSPN', 'SAV/SARCSL', 'SAV/ASC/FR_PPL/LIFT', 'GEN/RECVRY', 'SAV/RHD', 'FFST/FR_FIRE', 'FSTT/RRHAZ/FR_CO', 'CBRN/TSA', 'INT/RECCE/FR_SMLL', 'FSTT/TA', 'SAV/AR/FR_PPL/GRP', 'INT/RECCE', 'GEN/TRNSPN/FR_SECNDRY', 'OPR/LOG', 'SAV/AR/FR_PPL/OBS', 'FSTT/TA/FR_CLRACCSS']):
            raise ValueError("must be one of enum values ('SAV/ASC', 'FR_MED/REGLTN', 'GEN/SUPRTN', 'SAV/AR/FR_MED', 'SAV/AR/FR_PARAMD', 'SAV', 'GEN/TRNSPN', 'SAV/SARCSL', 'SAV/ASC/FR_PPL/LIFT', 'GEN/RECVRY', 'SAV/RHD', 'FFST/FR_FIRE', 'FSTT/RRHAZ/FR_CO', 'CBRN/TSA', 'INT/RECCE/FR_SMLL', 'FSTT/TA', 'SAV/AR/FR_PPL/GRP', 'INT/RECCE', 'GEN/TRNSPN/FR_SECNDRY', 'OPR/LOG', 'SAV/AR/FR_PPL/OBS', 'FSTT/TA/FR_CLRACCSS')")
        return value

    @field_validator('status')
    def status_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['ABO', 'NST', 'CANCLD', 'COM', 'IPR', 'PAU']):
            raise ValueError("must be one of enum values ('ABO', 'NST', 'CANCLD', 'COM', 'IPR', 'PAU')")
        return value

    @field_validator('start_time')
    def start_time_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^\d{4}-\d{2}-\d{2}T\d{2}:\d{2}:\d{2}[\-+]\d{2}:\d{2}$", value):
            raise ValueError(r"must validate the regular expression /^\d{4}-\d{2}-\d{2}T\d{2}:\d{2}:\d{2}[\-+]\d{2}:\d{2}$/")
        return value

    @field_validator('end_time')
    def end_time_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^\d{4}-\d{2}-\d{2}T\d{2}:\d{2}:\d{2}[\-+]\d{2}:\d{2}$", value):
            raise ValueError(r"must validate the regular expression /^\d{4}-\d{2}-\d{2}T\d{2}:\d{2}:\d{2}[\-+]\d{2}:\d{2}$/")
        return value

    @field_validator('priority')
    def priority_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['0', '1', '2', '3', '4', '5']):
            raise ValueError("must be one of enum values ('0', '1', '2', '3', '4', '5')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Mission from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of position
        if self.position:
            _dict['POSITION'] = self.position.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Mission from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "TYPE": obj.get("TYPE"),
            "FREETEXT": obj.get("FREETEXT"),
            "ID": obj.get("ID"),
            "ORG_ID": obj.get("ORG_ID"),
            "NAME": obj.get("NAME"),
            "STATUS": obj.get("STATUS"),
            "START_TIME": obj.get("START_TIME"),
            "END_TIME": obj.get("END_TIME"),
            "RESOURCE_ID": obj.get("RESOURCE_ID"),
            "PARENT_MISSION_ID": obj.get("PARENT_MISSION_ID"),
            "CHILD_MISSION_ID": obj.get("CHILD_MISSION_ID"),
            "MAIN_MISSION_ID": obj.get("MAIN_MISSION_ID"),
            "POSITION": Position.from_dict(obj["POSITION"]) if obj.get("POSITION") is not None else None,
            "PRIORITY": obj.get("PRIORITY")
        })
        return _obj


