# coding: utf-8

"""
    OpenAPI

    OpenAPI

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from hubsante_model.emsi.models.coord import Coord
from typing import Optional, Set
from typing_extensions import Self

class Position(BaseModel):
    """
    Position
    """ # noqa: E501
    loc_id: Optional[StrictStr] = Field(default=None, description="Optionnel La localisation de l'affaire est transmise en amont dans un message RC-EDA et le lieu souhaité pour l'intervention est systématiquement reprécisé dans un objet MISSION.  Lorsque le lieu d'intervention est identique à celle d'une position de l'affaire partagée dans le message RC-EDA, le champ MISSION.RGEO.POSITION.LOC_ID doit être alimenté valorisé comme le champ eventLocation.locId du message RC-EDA envoyé en amont. ", alias="LOC_ID")
    name: Optional[StrictStr] = Field(default=None, description="Optionnel, non utilisé par NexSIS nom de lieu", alias="NAME")
    type: Optional[StrictStr] = Field(default=None, description="Optionnel Dans le cadre de l'interface LRM NexSIS, seul le libellé POINT doit obligatoirement être interprétable par les deux partenaires. Cf. Nomenclature EMSI - POSITION pour plus de détails", alias="TYPE")
    height_role: Optional[StrictStr] = Field(default=None, description="Optionnel", alias="HEIGHT_ROLE")
    coordsys: Optional[StrictStr] = Field(default=None, description="Optionnel", alias="COORDSYS")
    coord: Optional[List[Coord]] = Field(default=None, alias="COORD")
    address: Optional[List[StrictStr]] = Field(default=None, alias="ADDRESS")
    __properties: ClassVar[List[str]] = ["LOC_ID", "NAME", "TYPE", "HEIGHT_ROLE", "COORDSYS", "COORD", "ADDRESS"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Position from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in coord (list)
        _items = []
        if self.coord:
            for _item_coord in self.coord:
                if _item_coord:
                    _items.append(_item_coord.to_dict())
            _dict['COORD'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Position from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "LOC_ID": obj.get("LOC_ID"),
            "NAME": obj.get("NAME"),
            "TYPE": obj.get("TYPE"),
            "HEIGHT_ROLE": obj.get("HEIGHT_ROLE"),
            "COORDSYS": obj.get("COORDSYS"),
            "COORD": [Coord.from_dict(_item) for _item in obj["COORD"]] if obj.get("COORD") is not None else None,
            "ADDRESS": obj.get("ADDRESS")
        })
        return _obj


