# coding: utf-8

"""
    OpenAPI

    OpenAPI

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from hubsante_model.emsi.models.contact import Contact
from hubsante_model.emsi.models.rgeo import Rgeo
from hubsante_model.emsi.models.rtype import Rtype
from typing import Optional, Set
from typing_extensions import Self

class Resource(BaseModel):
    """
    Resource
    """ # noqa: E501
    rtype: Rtype = Field(alias="RTYPE")
    id: StrictStr = Field(description="Identifiant unique de la ressource  dans le système du partenaire propriétaire. Les systèmes sont garants de l'unicité et de l'invariablité des ids de véhicule dans le temps. Ils peuvent se servir des ids dans les référentiels existants si ils sont uniques et stables. Dans le cas d'un véhicule agrégé par un LRM (comme un SMUR), l'ID doit être valorisé avec son immatriculation. Dans le cas d'un véhicule agrégé par NexSIS, l'ID fournit peut ne pas correspondre à une immatriculation.", alias="ID")
    org_id: Optional[StrictStr] = Field(default=None, description="Identifiant de l'organisation à laquelle la ressource est rattachée (caserne, SAMU etc). Se référer au DSF pour la structure normée des organisations. Le format est le suivant {pays}.{domaine}.{organisation}.{structure interne}*.{unité fonctionnelle}*. Dans le cas où le LRM/NexSIS sert d'aggrégateur pour des véhicules appartenant à un partenaire tiers (type ambulance privée), l'identifiant d'organisation permet d'identifier ce tiers. A constituer par le rédacteur du présent EMSI pour être unique.", alias="ORG_ID")
    name: StrictStr = Field(description="Nom donné à la ressource par le partenaire. L'immatriculation peut être utilisée dans le nom courant des véhicules. Dans le cas pompier, les véhicules sont nommés Dans le cas d'équipier, cela peut être leur nom", alias="NAME")
    freetext: Optional[StrictStr] = Field(default=None, description="Texte libre permettant de décrire la ressource où d'ajouter des précisions sur son engagement. Permet aussi notamment de décrire des attributs librement pour la ressource. Par exemple, pour un véhicule, sa plaque d'immatriculation.", alias="FREETEXT")
    rgeo: Optional[List[Rgeo]] = Field(default=None, alias="RGEO")
    quantity: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Dans le cadre d'un échange d'opération, optionnel. Permet de quantifier une ressource : - à ne pas utiliser pour les véhicules ni le personnel - utilisable pour du matériel - utilisable pour des consommables (dans le cas de consommable, à compléter avec le champ UM)", alias="QUANTITY")
    um: Optional[StrictStr] = Field(default=None, description="Dans le cadre d'un échange d'opération, optionnel. Unité de mesure pour des ressources consommables", alias="UM")
    status: StrictStr = Field(description="Définit le statut de disponibilité d'une ressource. - AVAILB : Lorsqu'une mission est terminée, une ressource redevient disponible - RESRVD : Lorsque la ressource est réservée pour intervenir sur l'affaire mais pas encore engagée dans l'opération. Par exemple : un SMUR termine un autre transfert patient/victime avant de rejoindre une autre intervention : il est alors RESRVD - IN_USE/MOBILE : à utiliser pour les véhicules et le personnel lorsqu'ils se déplaces - IN_USE/ON_SCENE : à utiliser pour les véhicules et le personnel lorsqu'ils sont sur les lieux de l'affaire", alias="STATUS")
    nationality: Optional[StrictStr] = Field(default=None, description="Nationalité d'une ressource, réemployer ISO 3166-1-alpha-2 code elements.", alias="NATIONALITY")
    contacts: Optional[List[Contact]] = Field(default=None, alias="CONTACTS")
    __properties: ClassVar[List[str]] = ["RTYPE", "ID", "ORG_ID", "NAME", "FREETEXT", "RGEO", "QUANTITY", "UM", "STATUS", "NATIONALITY", "CONTACTS"]

    @field_validator('um')
    def um_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['LSV', 'OTH', 'PKG', 'TIM', 'WGT', 'LSV/CM', 'LSV/CMH', 'LSV/CNTLTR', 'LSV/DEG', 'LSV/HCTLTR', 'LSV/HCTMTR', 'LSV/KM', 'LSV/KPH', 'LSV/LI', 'LSV/LTPRHR', 'LSV/LTPRMN', 'LSV/METRE', 'LSV/MILLTR', 'LSV/MILMTR', 'LSV/SMH', 'LSV/SQM', 'OTH/COIL', 'OTH/DOZEN', 'OTH/EA', 'OTH/GROSS', 'OTH/MANHUR', 'OTH/MHPRHR', 'PKG/BALE', 'PKG/BARREL', 'PKG/BLK', 'PKG/BOX', 'PKG/CASE', 'PKG/CONTNR', 'PKG/CRATE', 'PKG/DRM', 'PKG/JERCAN', 'PKG/PAK', 'PKG/PAL', 'PKG/RATION', 'TIM/DAY', 'TIM/HR', 'TIM/MINUTE', 'TIM/MON', 'TIM/SECOND', 'TIM/WEK', 'TIM/YEA', 'WGT/CNTGRM', 'WGT/GRAM', 'WGT/KG', 'WGT/KGH']):
            raise ValueError("must be one of enum values ('LSV', 'OTH', 'PKG', 'TIM', 'WGT', 'LSV/CM', 'LSV/CMH', 'LSV/CNTLTR', 'LSV/DEG', 'LSV/HCTLTR', 'LSV/HCTMTR', 'LSV/KM', 'LSV/KPH', 'LSV/LI', 'LSV/LTPRHR', 'LSV/LTPRMN', 'LSV/METRE', 'LSV/MILLTR', 'LSV/MILMTR', 'LSV/SMH', 'LSV/SQM', 'OTH/COIL', 'OTH/DOZEN', 'OTH/EA', 'OTH/GROSS', 'OTH/MANHUR', 'OTH/MHPRHR', 'PKG/BALE', 'PKG/BARREL', 'PKG/BLK', 'PKG/BOX', 'PKG/CASE', 'PKG/CONTNR', 'PKG/CRATE', 'PKG/DRM', 'PKG/JERCAN', 'PKG/PAK', 'PKG/PAL', 'PKG/RATION', 'TIM/DAY', 'TIM/HR', 'TIM/MINUTE', 'TIM/MON', 'TIM/SECOND', 'TIM/WEK', 'TIM/YEA', 'WGT/CNTGRM', 'WGT/GRAM', 'WGT/KG', 'WGT/KGH')")
        return value

    @field_validator('status')
    def status_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['AVAILB', 'UNAV', 'MAINTC', 'RESRVD', 'VIRTUAL', 'IN_USE/MOBILE', 'IN_USE/ON_SCENE']):
            raise ValueError("must be one of enum values ('AVAILB', 'UNAV', 'MAINTC', 'RESRVD', 'VIRTUAL', 'IN_USE/MOBILE', 'IN_USE/ON_SCENE')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Resource from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of rtype
        if self.rtype:
            _dict['RTYPE'] = self.rtype.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in rgeo (list)
        _items = []
        if self.rgeo:
            for _item_rgeo in self.rgeo:
                if _item_rgeo:
                    _items.append(_item_rgeo.to_dict())
            _dict['RGEO'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in contacts (list)
        _items = []
        if self.contacts:
            for _item_contacts in self.contacts:
                if _item_contacts:
                    _items.append(_item_contacts.to_dict())
            _dict['CONTACTS'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Resource from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "RTYPE": Rtype.from_dict(obj["RTYPE"]) if obj.get("RTYPE") is not None else None,
            "ID": obj.get("ID"),
            "ORG_ID": obj.get("ORG_ID"),
            "NAME": obj.get("NAME"),
            "FREETEXT": obj.get("FREETEXT"),
            "RGEO": [Rgeo.from_dict(_item) for _item in obj["RGEO"]] if obj.get("RGEO") is not None else None,
            "QUANTITY": obj.get("QUANTITY"),
            "UM": obj.get("UM"),
            "STATUS": obj.get("STATUS"),
            "NATIONALITY": obj.get("NATIONALITY"),
            "CONTACTS": [Contact.from_dict(_item) for _item in obj["CONTACTS"]] if obj.get("CONTACTS") is not None else None
        })
        return _obj


