# coding: utf-8

"""
    OpenAPI

    OpenAPI

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from hubsante_model.geolocation.models.contact import Contact
from typing import Optional, Set
from typing_extensions import Self

class Resource(BaseModel):
    """
    Resource
    """ # noqa: E501
    resource_id: Annotated[str, Field(strict=True)] = Field(description="A valoriser avec l'identifiant partagé unique de la ressource engagée, normé comme suit : {orgID}.resource.{ID unique de la ressource partagée} OU - uniquement dans le cas où un ID unique de ressource ne peut pas être garanti par l'organisation propriétaire : {orgID}.resource.{sendercaseId}.{n° d’ordre chronologique de la ressource}", alias="resourceId")
    org_id: StrictStr = Field(description="Identifiant unique de l'organisme :  {pays}.{domaine}.{organisation}.{structure interne}*.{unité fonctionnelle}* *données facultatives", alias="orgId")
    name: Optional[StrictStr] = Field(default=None, description="Nom donné à la ressource par l'organisme propriétaire.  L'immatriculation peut être utilisée dans le nom courant des véhicules.")
    resource_type: StrictStr = Field(description="Catégorie de la ressource (SMUR, SDIS, TSU, SNP, MSPE, navire)", alias="resourceType")
    nature: Optional[StrictStr] = Field(default=None, description="Nature de la ressource (effecteur, base)")
    mobility: Optional[StrictStr] = Field(default=None, description="Mobilité de la ressource (fixe, vehicule, heliporté, navire)")
    capacity: Optional[StrictStr] = Field(default=None, description="Capacité de transport d'un patient")
    contacts: Optional[List[Contact]] = None
    __properties: ClassVar[List[str]] = ["resourceId", "orgId", "name", "resourceType", "nature", "mobility", "capacity", "contacts"]

    @field_validator('resource_id')
    def resource_id_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^([\w-]+\.){3,8}resource(\.[\w-]+){1,2}$", value):
            raise ValueError(r"must validate the regular expression /^([\w-]+\.){3,8}resource(\.[\w-]+){1,2}$/")
        return value

    @field_validator('resource_type')
    def resource_type_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['SMUR', 'SDIS', 'TSU', 'SNP', 'MSPE', 'SHIP']):
            raise ValueError("must be one of enum values ('SMUR', 'SDIS', 'TSU', 'SNP', 'MSPE', 'SHIP')")
        return value

    @field_validator('nature')
    def nature_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['EFFECTEUR', 'BASE']):
            raise ValueError("must be one of enum values ('EFFECTEUR', 'BASE')")
        return value

    @field_validator('mobility')
    def mobility_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['FIXE', 'VEHICULE', 'HELICOPTERE', 'SHIP']):
            raise ValueError("must be one of enum values ('FIXE', 'VEHICULE', 'HELICOPTERE', 'SHIP')")
        return value

    @field_validator('capacity')
    def capacity_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['URGENCE', 'MEDICALE', 'PARAMEDICALE', 'INCONNUE']):
            raise ValueError("must be one of enum values ('URGENCE', 'MEDICALE', 'PARAMEDICALE', 'INCONNUE')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Resource from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in contacts (list)
        _items = []
        if self.contacts:
            for _item_contacts in self.contacts:
                if _item_contacts:
                    _items.append(_item_contacts.to_dict())
            _dict['contacts'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Resource from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "resourceId": obj.get("resourceId"),
            "orgId": obj.get("orgId"),
            "name": obj.get("name"),
            "resourceType": obj.get("resourceType"),
            "nature": obj.get("nature"),
            "mobility": obj.get("mobility"),
            "capacity": obj.get("capacity"),
            "contacts": [Contact.from_dict(_item) for _item in obj["contacts"]] if obj.get("contacts") is not None else None
        })
        return _obj


