# coding: utf-8

"""
    OpenAPI

    OpenAPI

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from hubsante_model.health.models.destination import Destination
from hubsante_model.health.models.operator import Operator
from typing import Optional, Set
from typing_extensions import Self

class Decision(BaseModel):
    """
    Decision
    """ # noqa: E501
    patient_id: Optional[StrictStr] = Field(default=None, description="A valoriser avec l'ID partagé du patient concerné par la décision, à chaque fois que la décision est liée à un patient dans le système émetteur", alias="patientId")
    creation: str = Field(description="A valoriser avec le groupe date heure de création de la décision.  L'indicateur de fuseau horaire Z ne doit pas être utilisé.")
    operator: Operator
    decision_type: StrictStr = Field(description="A valoriser avec le type de décision prise (cf.nomenclature associée)", alias="decisionType")
    resource_type: Optional[StrictStr] = Field(default=None, description="A valoriser avec le type de ressource souhaitée ou engagée (cf.nomenclature associée) - en fonction du type de décision. A fournir obligatoirement pour une décision d'intervention ou de transport/orientation.", alias="resourceType")
    medical_transport: Optional[StrictBool] = Field(default=None, description="A valoriser obligatoirement en cas de décision de transport, pour indiquer si ce dernier est médicalisé. True = transport médicalisé False = transport non médicalisé", alias="medicalTransport")
    orientation_type: Optional[StrictStr] = Field(default=None, description="Indique le type de destination en cas de décision d'orientation (cf. nomenclature associée)", alias="orientationType")
    destination: Optional[Destination] = None
    __properties: ClassVar[List[str]] = ["patientId", "creation", "operator", "decisionType", "resourceType", "medicalTransport", "orientationType", "destination"]

    @field_validator('creation')
    def creation_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^\d{4}-\d{2}-\d{2}T\d{2}:\d{2}:\d{2}[\-+]\d{2}:\d{2}$", value):
            raise ValueError(r"must validate the regular expression /^\d{4}-\d{2}-\d{2}T\d{2}:\d{2}:\d{2}[\-+]\d{2}:\d{2}$/")
        return value

    @field_validator('decision_type')
    def decision_type_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['CONSEIL', 'PMT', 'INTER', 'ORIENT', 'PASPLUS']):
            raise ValueError("must be one of enum values ('CONSEIL', 'PMT', 'INTER', 'ORIENT', 'PASPLUS')")
        return value

    @field_validator('resource_type')
    def resource_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['SMUR', 'SMUR.ADULT', 'SMUR.PED', 'SMUR.UMH-S', 'SMUR.CUMP', 'HOSPIT', 'LIBERAL', 'LIBERAL.MG', 'LIBERAL.PHARM', 'LIBERAL.INF', 'LIBERAL.KINE', 'LIBERAL.SOS', 'LIBERAL.MMG', 'LIBERAL.MSPD', 'LIBERAL.MCS', 'LIBERAL.SPEMED', 'LIBERAL.DENT', 'LIBERAL.LABO', 'LIBERAL.AUTREPRO', 'TSU', 'SIS', 'SIS.MEDSP', 'SIS.ISP', 'SIS.SP', 'AASC', 'FDO', 'FDO.PN', 'FDO.GEND', 'FDO.PM', 'FDO.DOUANES', 'AUTRE', 'AUTRE.ADM', 'AUTRE.DAE', 'AUTRE.AUTRE']):
            raise ValueError("must be one of enum values ('SMUR', 'SMUR.ADULT', 'SMUR.PED', 'SMUR.UMH-S', 'SMUR.CUMP', 'HOSPIT', 'LIBERAL', 'LIBERAL.MG', 'LIBERAL.PHARM', 'LIBERAL.INF', 'LIBERAL.KINE', 'LIBERAL.SOS', 'LIBERAL.MMG', 'LIBERAL.MSPD', 'LIBERAL.MCS', 'LIBERAL.SPEMED', 'LIBERAL.DENT', 'LIBERAL.LABO', 'LIBERAL.AUTREPRO', 'TSU', 'SIS', 'SIS.MEDSP', 'SIS.ISP', 'SIS.SP', 'AASC', 'FDO', 'FDO.PN', 'FDO.GEND', 'FDO.PM', 'FDO.DOUANES', 'AUTRE', 'AUTRE.ADM', 'AUTRE.DAE', 'AUTRE.AUTRE')")
        return value

    @field_validator('orientation_type')
    def orientation_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['URGENCES', 'REA-USI', 'SANTE', 'CABINET', 'DOMICILE', 'EPHAD', 'AUTRE']):
            raise ValueError("must be one of enum values ('URGENCES', 'REA-USI', 'SANTE', 'CABINET', 'DOMICILE', 'EPHAD', 'AUTRE')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Decision from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of operator
        if self.operator:
            _dict['operator'] = self.operator.to_dict()
        # override the default output from pydantic by calling `to_dict()` of destination
        if self.destination:
            _dict['destination'] = self.destination.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Decision from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "patientId": obj.get("patientId"),
            "creation": obj.get("creation"),
            "operator": Operator.from_dict(obj["operator"]) if obj.get("operator") is not None else None,
            "decisionType": obj.get("decisionType"),
            "resourceType": obj.get("resourceType"),
            "medicalTransport": obj.get("medicalTransport"),
            "orientationType": obj.get("orientationType"),
            "destination": Destination.from_dict(obj["destination"]) if obj.get("destination") is not None else None
        })
        return _obj


