# coding: utf-8

"""
    OpenAPI

    OpenAPI

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing_extensions import Annotated
from typing import Optional, Set
from typing_extensions import Self

class PatientDetail(BaseModel):
    """
    PatientDetail
    """ # noqa: E501
    weight: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="A valoriser avec le poids en kilogrammes")
    height: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="A valoriser avec la taille en centimètres du patient")
    age: Optional[Annotated[str, Field(strict=True)]] = Field(default=None, description="A valoriser avec l'age du patient. Au format \"Durée\" de la norme ISO 8601 (https://fr.wikipedia.org/wiki/ISO_8601#Dur%C3%A9e) et en n'utilisant qu'une seule unité de durée (années, mois, semaines ou jours)")
    care_level: Optional[StrictStr] = Field(default=None, description="A valoriser avec le niveau de soins spécifique au patient", alias="careLevel")
    medical_history: Optional[StrictStr] = Field(default=None, description="Texte libre  pour décrire les antécédents du patient.  Si ce n'est pas géré de manière structurés : à afficher dans une note liée au patient en réception. ", alias="medicalHistory")
    treatment: Optional[StrictStr] = Field(default=None, description="Texte libre  pour décrire les traitements du patient. Si ce n'est pas géré de manière structurés : à afficher dans une note liée au patient en réception. ")
    __properties: ClassVar[List[str]] = ["weight", "height", "age", "careLevel", "medicalHistory", "treatment"]

    @field_validator('age')
    def age_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^P[0-9]{1,3}[YMWD]$", value):
            raise ValueError(r"must validate the regular expression /^P[0-9]{1,3}[YMWD]$/")
        return value

    @field_validator('care_level')
    def care_level_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['R1', 'R2', 'R3', 'R4']):
            raise ValueError("must be one of enum values ('R1', 'R2', 'R3', 'R4')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PatientDetail from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PatientDetail from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "weight": obj.get("weight"),
            "height": obj.get("height"),
            "age": obj.get("age"),
            "careLevel": obj.get("careLevel"),
            "medicalHistory": obj.get("medicalHistory"),
            "treatment": obj.get("treatment")
        })
        return _obj


