# coding: utf-8

"""
    OpenAPI

    OpenAPI

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from hubsante_model.interventionreport.models.external_id import ExternalId
from typing import Optional, Set
from typing_extensions import Self

class Patient(BaseModel):
    """
    Patient
    """ # noqa: E501
    patient_id: Annotated[str, Field(strict=True)] = Field(description="Identifiant unique du patient.  A valoriser par {ID du SAMU qui engage le SMUR}.{ID du DRM}.P{numéro d’ordre chronologique} : fr.health.samu690.DRFR15DDXAAJJJ00001.P01", alias="patientId")
    birth_name: Optional[StrictStr] = Field(default=None, description="Nom de naissance du patient", alias="birthName")
    last_name: StrictStr = Field(description="Nom usuel du patient", alias="lastName")
    first_name: StrictStr = Field(description="Prénom du patient", alias="firstName")
    birth_date: Optional[StrictStr] = Field(default=None, description="Date de naissance du patient", alias="birthDate")
    age: Optional[StrictStr] = Field(default=None, description="La date de naissance n'est pas tout le temps connu, cette donnée permet d'indiquer un âge entier. ")
    sex: Optional[StrictStr] = Field(default=None, description="Sexe du patient, suivant le libellé court de la nomenclature SI-SAMU-NOMENC_SEXE")
    external_id: Optional[List[ExternalId]] = Field(default=None, alias="externalId")
    height: Optional[StrictInt] = Field(default=None, description="A valoriser avec le poids en kilogrammes")
    weight: Optional[StrictInt] = Field(default=None, description="A valoriser avec la taille en centimètres du patient")
    __properties: ClassVar[List[str]] = ["patientId", "birthName", "lastName", "firstName", "birthDate", "age", "sex", "externalId", "height", "weight"]

    @field_validator('patient_id')
    def patient_id_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^([\w-]+\.){3,8}patient(\.[\w-]+){1,2}$", value):
            raise ValueError(r"must validate the regular expression /^([\w-]+\.){3,8}patient(\.[\w-]+){1,2}$/")
        return value

    @field_validator('sex')
    def sex_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['M', 'F', 'O', 'UN']):
            raise ValueError("must be one of enum values ('M', 'F', 'O', 'UN')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Patient from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in external_id (list)
        _items = []
        if self.external_id:
            for _item_external_id in self.external_id:
                if _item_external_id:
                    _items.append(_item_external_id.to_dict())
            _dict['externalId'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Patient from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "patientId": obj.get("patientId"),
            "birthName": obj.get("birthName"),
            "lastName": obj.get("lastName"),
            "firstName": obj.get("firstName"),
            "birthDate": obj.get("birthDate"),
            "age": obj.get("age"),
            "sex": obj.get("sex"),
            "externalId": [ExternalId.from_dict(_item) for _item in obj["externalId"]] if obj.get("externalId") is not None else None,
            "height": obj.get("height"),
            "weight": obj.get("weight")
        })
        return _obj


