# coding: utf-8

"""
    OpenAPI

    OpenAPI

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class State(BaseModel):
    """
    State
    """ # noqa: E501
    datetime: str = Field(description="A valoriser avec la date et heure d'engagement de changement vers le nouveau statut")
    status: StrictStr = Field(description="A valoriser avec le statut du vecteur. Cf nomenclature associée.")
    availability: Optional[StrictBool] = Field(default=None, description="A valoriser de manière à indiquer la disponibilité du vecteur. TRUE = DISPONIBLE FALSE = INDISPONIBLE VIDE = INCONNU")
    __properties: ClassVar[List[str]] = ["datetime", "status", "availability"]

    @field_validator('datetime')
    def datetime_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^\d{4}-\d{2}-\d{2}T\d{2}:\d{2}:\d{2}[\-+]\d{2}:\d{2}$", value):
            raise ValueError(r"must validate the regular expression /^\d{4}-\d{2}-\d{2}T\d{2}:\d{2}:\d{2}[\-+]\d{2}:\d{2}$/")
        return value

    @field_validator('status')
    def status_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['DECISION', 'DECLENCHE', 'DEPART', 'ANNULE', 'ARRIVEE', 'PEC', 'BILAN', 'ORIENTAT', 'TRANSP', 'ETAPE1', 'TRANSP2', 'ETAPE2', 'TRANSP3', 'DESTIN', 'FINPEC', 'RETOUR', 'RET-BASE', 'REN-BASE']):
            raise ValueError("must be one of enum values ('DECISION', 'DECLENCHE', 'DEPART', 'ANNULE', 'ARRIVEE', 'PEC', 'BILAN', 'ORIENTAT', 'TRANSP', 'ETAPE1', 'TRANSP2', 'ETAPE2', 'TRANSP3', 'DESTIN', 'FINPEC', 'RETOUR', 'RET-BASE', 'REN-BASE')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of State from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of State from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "datetime": obj.get("datetime"),
            "status": obj.get("status"),
            "availability": obj.get("availability")
        })
        return _obj


