# coding: utf-8

"""
    OpenAPI

    OpenAPI

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from hubsante_model.rpis.models.location import Location
from hubsante_model.rpis.models.resource_status import ResourceStatus
from hubsante_model.rpis.models.team import Team
from typing import Optional, Set
from typing_extensions import Self

class Intervention(BaseModel):
    """
    Intervention
    """ # noqa: E501
    location: Location
    team: Team
    smur_status: Optional[ResourceStatus] = Field(default=None, alias="smurStatus")
    procedure: Optional[List[StrictStr]] = None
    main_diagnosis: StrictStr = Field(description="Thésaurus SFMU-FEDORU. A valoriser par un code de la nomenclature Diagnostic SMUR(à venir).", alias="mainDiagnosis")
    associated_diagnosis: Optional[StrictStr] = Field(default=None, description="Thésaurus SFMU-FEDORU. A valoriser par un code de la nomenclature Diagnostic SMUR (à venir).", alias="associatedDiagnosis")
    __properties: ClassVar[List[str]] = ["location", "team", "smurStatus", "procedure", "mainDiagnosis", "associatedDiagnosis"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Intervention from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of location
        if self.location:
            _dict['location'] = self.location.to_dict()
        # override the default output from pydantic by calling `to_dict()` of team
        if self.team:
            _dict['team'] = self.team.to_dict()
        # override the default output from pydantic by calling `to_dict()` of smur_status
        if self.smur_status:
            _dict['smurStatus'] = self.smur_status.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Intervention from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "location": Location.from_dict(obj["location"]) if obj.get("location") is not None else None,
            "team": Team.from_dict(obj["team"]) if obj.get("team") is not None else None,
            "smurStatus": ResourceStatus.from_dict(obj["smurStatus"]) if obj.get("smurStatus") is not None else None,
            "procedure": obj.get("procedure"),
            "mainDiagnosis": obj.get("mainDiagnosis"),
            "associatedDiagnosis": obj.get("associatedDiagnosis")
        })
        return _obj


