# coding: utf-8

"""
    OpenAPI

    OpenAPI

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing_extensions import Annotated
from hubsante_model.technical.noreq.models.level_one_data import LevelOneData
from hubsante_model.technical.noreq.models.technical_object import TechnicalObject
from typing import Optional, Set
from typing_extensions import Self

class TechnicalNoreq(BaseModel):
    """
    TechnicalNoreq
    """ # noqa: E501
    optional_string_field: Optional[StrictStr] = Field(default=None, description="This field is optional", alias="optionalStringField")
    enumeration_field: Optional[StrictStr] = Field(default=None, description="This is an enumeration", alias="enumerationField")
    integer_field: Optional[StrictInt] = Field(default=None, description="This is an integer", alias="integerField")
    number_field: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="This is a number", alias="numberField")
    boolean_field: Optional[StrictBool] = Field(default=None, description="This is a boolean", alias="booleanField")
    object_field: Optional[TechnicalObject] = Field(default=None, alias="objectField")
    array_field: Optional[List[StrictStr]] = Field(default=None, alias="arrayField")
    enum_array_field: Optional[List[StrictStr]] = Field(default=None, alias="enumArrayField")
    array_with_max_length: Optional[Annotated[List[StrictStr], Field(max_length=5)]] = Field(default=None, alias="arrayWithMaxLength")
    phone_number_field: Optional[Annotated[str, Field(strict=True)]] = Field(default=None, description="Phone number with regex", alias="phoneNumberField")
    date_field: Optional[Annotated[str, Field(strict=True)]] = Field(default=None, description="Date", alias="dateField")
    email_field: Optional[Annotated[str, Field(strict=True)]] = Field(default=None, description="Email with regex", alias="emailField")
    datetime_field: Optional[str] = Field(default=None, description="Datetime", alias="datetimeField")
    object_level1: Optional[LevelOneData] = Field(default=None, alias="objectLevel1")
    nomenclature_field: Optional[StrictStr] = Field(default=None, description="Enum from extenal nomenclature file", alias="nomenclatureField")
    __properties: ClassVar[List[str]] = ["optionalStringField", "enumerationField", "integerField", "numberField", "booleanField", "objectField", "arrayField", "enumArrayField", "arrayWithMaxLength", "phoneNumberField", "dateField", "emailField", "datetimeField", "objectLevel1", "nomenclatureField"]

    @field_validator('enumeration_field')
    def enumeration_field_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['ENUM_VALUE_1', 'ENUM_VALUE_2', 'ENUM_VALUE_3', 'ENUM_VALUE_4', 'ENUM_VALUE_5']):
            raise ValueError("must be one of enum values ('ENUM_VALUE_1', 'ENUM_VALUE_2', 'ENUM_VALUE_3', 'ENUM_VALUE_4', 'ENUM_VALUE_5')")
        return value

    @field_validator('enum_array_field')
    def enum_array_field_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        for i in value:
            if i not in set(['ENUM_VALUE_10', 'ENUM_VALUE_20', 'ENUM_VALUE_30', 'ENUM_VALUE_40', 'ENUM_VALUE_50']):
                raise ValueError("each list item must be one of ('ENUM_VALUE_10', 'ENUM_VALUE_20', 'ENUM_VALUE_30', 'ENUM_VALUE_40', 'ENUM_VALUE_50')")
        return value

    @field_validator('phone_number_field')
    def phone_number_field_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^\+?[0-9]{2,14}$", value):
            raise ValueError(r"must validate the regular expression /^\+?[0-9]{2,14}$/")
        return value

    @field_validator('date_field')
    def date_field_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^\d{4}-\d{2}-\d{2}$", value):
            raise ValueError(r"must validate the regular expression /^\d{4}-\d{2}-\d{2}$/")
        return value

    @field_validator('email_field')
    def email_field_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^[\w\-\.]+@([\w\-]+\.)+[\w\-]{2,4}$", value):
            raise ValueError(r"must validate the regular expression /^[\w\-\.]+@([\w\-]+\.)+[\w\-]{2,4}$/")
        return value

    @field_validator('datetime_field')
    def datetime_field_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^\d{4}-\d{2}-\d{2}T\d{2}:\d{2}:\d{2}[\-+]\d{2}:\d{2}$", value):
            raise ValueError(r"must validate the regular expression /^\d{4}-\d{2}-\d{2}T\d{2}:\d{2}:\d{2}[\-+]\d{2}:\d{2}$/")
        return value

    @field_validator('nomenclature_field')
    def nomenclature_field_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['M', 'F', 'O', 'UN']):
            raise ValueError("must be one of enum values ('M', 'F', 'O', 'UN')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of TechnicalNoreq from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of object_field
        if self.object_field:
            _dict['objectField'] = self.object_field.to_dict()
        # override the default output from pydantic by calling `to_dict()` of object_level1
        if self.object_level1:
            _dict['objectLevel1'] = self.object_level1.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of TechnicalNoreq from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "optionalStringField": obj.get("optionalStringField"),
            "enumerationField": obj.get("enumerationField"),
            "integerField": obj.get("integerField"),
            "numberField": obj.get("numberField"),
            "booleanField": obj.get("booleanField"),
            "objectField": TechnicalObject.from_dict(obj["objectField"]) if obj.get("objectField") is not None else None,
            "arrayField": obj.get("arrayField"),
            "enumArrayField": obj.get("enumArrayField"),
            "arrayWithMaxLength": obj.get("arrayWithMaxLength"),
            "phoneNumberField": obj.get("phoneNumberField"),
            "dateField": obj.get("dateField"),
            "emailField": obj.get("emailField"),
            "datetimeField": obj.get("datetimeField"),
            "objectLevel1": LevelOneData.from_dict(obj["objectLevel1"]) if obj.get("objectLevel1") is not None else None,
            "nomenclatureField": obj.get("nomenclatureField")
        })
        return _obj


