"""
OpenLIT ChromaDB Instrumentation
"""

from typing import Collection
import importlib.metadata
from opentelemetry.instrumentation.instrumentor import BaseInstrumentor
from wrapt import wrap_function_wrapper

from openlit.instrumentation.chroma.chroma import general_wrap

_instruments = ("chromadb >= 0.4.0",)

class ChromaInstrumentor(BaseInstrumentor):
    """
    An instrumentor for ChromaDB client library.
    """

    def instrumentation_dependencies(self) -> Collection[str]:
        return _instruments

    def _instrument(self, **kwargs):
        version = importlib.metadata.version("chromadb")
        environment = kwargs.get("environment", "default")
        application_name = kwargs.get("application_name", "default")
        tracer = kwargs.get("tracer")
        pricing_info = kwargs.get("pricing_info", {})
        capture_message_content = kwargs.get("capture_message_content", False)
        metrics = kwargs.get("metrics_dict")
        disable_metrics = kwargs.get("disable_metrics")

        # Sync operations
        wrap_function_wrapper(
            "chromadb.db",
            "DB.create_collection",
            general_wrap("chroma.create_collection", version, environment, application_name,
                tracer, pricing_info, capture_message_content, metrics, disable_metrics),
        )

        wrap_function_wrapper(
            "chromadb",
            "Collection.add",
            general_wrap("chroma.add", version, environment, application_name,
                tracer, pricing_info, capture_message_content, metrics, disable_metrics),
        )

        wrap_function_wrapper(
            "chromadb",
            "Collection.get",
            general_wrap("chroma.get", version, environment, application_name,
                tracer, pricing_info, capture_message_content, metrics, disable_metrics),
        )

        wrap_function_wrapper(
            "chromadb",
            "Collection.peek",
            general_wrap("chroma.peek", version, environment, application_name,
                tracer, pricing_info, capture_message_content, metrics, disable_metrics),
        )

        wrap_function_wrapper(
            "chromadb",
            "Collection.query",
            general_wrap("chroma.query", version, environment, application_name,
                tracer, pricing_info, capture_message_content, metrics, disable_metrics),
        )

        wrap_function_wrapper(
            "chromadb",
            "Collection.update",
            general_wrap("chroma.update", version, environment, application_name,
                tracer, pricing_info, capture_message_content, metrics, disable_metrics),
        )

        wrap_function_wrapper(
            "chromadb",
            "Collection.upsert",
            general_wrap("chroma.upsert", version, environment, application_name,
                tracer, pricing_info, capture_message_content, metrics, disable_metrics),
        )

        wrap_function_wrapper(
            "chromadb",
            "Collection.delete",
            general_wrap("chroma.delete", version, environment, application_name,
                tracer, pricing_info, capture_message_content, metrics, disable_metrics),
        )

    def _uninstrument(self, **kwargs):
        pass
