# pylint: disable=useless-return, bad-staticmethod-argument, disable=duplicate-code
"""Initializer of Auto Instrumentation of Dynamiq Functions"""

from typing import Collection
import importlib.metadata
from opentelemetry.instrumentation.instrumentor import BaseInstrumentor
from wrapt import wrap_function_wrapper

from openlit.instrumentation.dynamiq.dynamiq import (
    dynamiq_wrap
)

_instruments = ("dynamiq >= 0.4.0",)

class DynamiqInstrumentor(BaseInstrumentor):
    """
    An instrumentor for dynamiq's client library.
    """

    def instrumentation_dependencies(self) -> Collection[str]:
        return _instruments

    def _instrument(self, **kwargs):
        application_name = kwargs.get("application_name", "default_application")
        environment = kwargs.get("environment", "default_environment")
        tracer = kwargs.get("tracer")
        metrics = kwargs.get("metrics_dict")
        pricing_info = kwargs.get("pricing_info", {})
        capture_message_content = kwargs.get("capture_message_content", False)
        disable_metrics = kwargs.get("disable_metrics")
        version = importlib.metadata.version("dynamiq")

        wrap_function_wrapper(
            "dynamiq.nodes.agents.base",
            "Agent.run",
            dynamiq_wrap("dynamiq.agent_run", version, environment, application_name,
                  tracer, pricing_info, capture_message_content, metrics, disable_metrics),
        )

        wrap_function_wrapper(
            "dynamiq",
            "Workflow.run",
            dynamiq_wrap("dynamiq.workflow_run", version, environment, application_name,
                  tracer, pricing_info, capture_message_content, metrics, disable_metrics),
        )

        wrap_function_wrapper(
            "dynamiq.memory",
            "Memory.add",
            dynamiq_wrap("dynamiq.memory_add", version, environment, application_name,
                  tracer, pricing_info, capture_message_content, metrics, disable_metrics),
        )

        wrap_function_wrapper(
            "dynamiq.memory",
            "Memory.search",
            dynamiq_wrap("dynamiq.memory_search", version, environment, application_name,
                  tracer, pricing_info, capture_message_content, metrics, disable_metrics),
        )


    def _uninstrument(self, **kwargs):
        # Proper uninstrumentation logic to revert patched methods
        pass
