# Bilibili 直播适配器

## 概述

Bilibili 直播适配器用于接收 Bilibili 直播间的实时弹幕消息、礼物信息和用户互动事件。

## 功能特性

### 消息接收

- ✅ 实时弹幕消息
- ✅ 礼物和打赏信息
- ✅ 用户进房提醒
- ✅ 新关注用户提醒

### 连接协议

- ✅ WebSocket 实时连接
- ✅ JSON 数据格式
- ✅ 毫秒级实时性
- ✅ 自动重连机制

### 直播间事件

- ✅ 弹幕消息解析
- ✅ 礼物信息统计
- ✅ 用户互动监控
- ✅ 直播间状态跟踪

## 配置说明

### 必需配置

- 直播间房间号
- 连接超时设置
- 事件过滤规则

### 可选配置

- 弹幕过滤关键词
- 礼物价值阈值
- 消息格式模板

## 聊天标识规则

Bilibili 直播适配器使用以下格式标识聊天频道：

- **直播间弹幕**: `bilibili_live-room_房间号`
- **私信频道**: `bilibili_live-dm_用户ID`

## 依赖要求

- 稳定的网络连接
- Bilibili 直播间访问权限
- WebSocket 客户端支持

## 支持的事件类型

### 弹幕事件

- **DANMU_MSG**: 普通弹幕消息
- **WELCOME**: 用户进房
- **SEND_GIFT**: 礼物赠送
- **COMBO_SEND**: 连击礼物

### 用户事件

- **USER_TOAST_MSG**: 续费舰长
- **GUARD_BUY**: 购买舰长
- **ROOM_REAL_TIME_MESSAGE_UPDATE**: 粉丝数更新

### 直播间事件

- **LIVE**: 开播
- **PREPARING**: 下播
- **ROOM_CHANGE**: 房间信息变更

## 常见问题

### Q: 无法接收弹幕？

A: 请检查：

1. 房间号是否正确
2. 直播间是否正在直播
3. 网络连接是否稳定
4. 是否被限制访问

### Q: 礼物信息缺失？

A: 确认：

1. 礼物阈值设置
2. 事件过滤配置
3. 直播间权限

### Q: 连接频繁断开？

A: 检查：

1. 网络稳定性
2. 连接超时设置
3. Bilibili 服务器状态
