# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetPlacementGroupResult',
    'AwaitableGetPlacementGroupResult',
    'get_placement_group',
    'get_placement_group_output',
]

@pulumi.output_type
class GetPlacementGroupResult:
    """
    A collection of values returned by getPlacementGroup.
    """
    def __init__(__self__, id=None, labels=None, most_recent=None, name=None, servers=None, type=None, with_selector=None):
        if id and not isinstance(id, int):
            raise TypeError("Expected argument 'id' to be a int")
        pulumi.set(__self__, "id", id)
        if labels and not isinstance(labels, dict):
            raise TypeError("Expected argument 'labels' to be a dict")
        pulumi.set(__self__, "labels", labels)
        if most_recent and not isinstance(most_recent, bool):
            raise TypeError("Expected argument 'most_recent' to be a bool")
        pulumi.set(__self__, "most_recent", most_recent)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if servers and not isinstance(servers, list):
            raise TypeError("Expected argument 'servers' to be a list")
        pulumi.set(__self__, "servers", servers)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)
        if with_selector and not isinstance(with_selector, str):
            raise TypeError("Expected argument 'with_selector' to be a str")
        pulumi.set(__self__, "with_selector", with_selector)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.int:
        """
        (int) Unique ID of the Placement Group.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Mapping[str, _builtins.str]:
        """
        (map) User-defined labels (key-value pairs)
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter(name="mostRecent")
    def most_recent(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "most_recent")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        (string) Name of the Placement Group.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def servers(self) -> Sequence[_builtins.int]:
        return pulumi.get(self, "servers")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        (string) Type of the Placement Group.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="withSelector")
    def with_selector(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "with_selector")


class AwaitableGetPlacementGroupResult(GetPlacementGroupResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetPlacementGroupResult(
            id=self.id,
            labels=self.labels,
            most_recent=self.most_recent,
            name=self.name,
            servers=self.servers,
            type=self.type,
            with_selector=self.with_selector)


def get_placement_group(id: Optional[_builtins.int] = None,
                        labels: Optional[Mapping[str, _builtins.str]] = None,
                        most_recent: Optional[_builtins.bool] = None,
                        name: Optional[_builtins.str] = None,
                        type: Optional[_builtins.str] = None,
                        with_selector: Optional[_builtins.str] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetPlacementGroupResult:
    """
    Provides details about a specific Hetzner Cloud Placement Group.

    ```python
    import pulumi
    import pulumi_hcloud as hcloud

    sample_placement_group1 = hcloud.get_placement_group(name="sample-placement-group-1")
    sample_placement_group2 = hcloud.get_placement_group(id=4711)
    ```


    :param _builtins.int id: ID of the placement group.
    :param Mapping[str, _builtins.str] labels: (map) User-defined labels (key-value pairs)
    :param _builtins.bool most_recent: Return most recent placement group if multiple are found.
    :param _builtins.str name: Name of the placement group.
    :param _builtins.str type: (string) Type of the Placement Group.
    :param _builtins.str with_selector: [Label selector](https://docs.hetzner.cloud/reference/cloud#label-selector)
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['labels'] = labels
    __args__['mostRecent'] = most_recent
    __args__['name'] = name
    __args__['type'] = type
    __args__['withSelector'] = with_selector
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('hcloud:index/getPlacementGroup:getPlacementGroup', __args__, opts=opts, typ=GetPlacementGroupResult).value

    return AwaitableGetPlacementGroupResult(
        id=pulumi.get(__ret__, 'id'),
        labels=pulumi.get(__ret__, 'labels'),
        most_recent=pulumi.get(__ret__, 'most_recent'),
        name=pulumi.get(__ret__, 'name'),
        servers=pulumi.get(__ret__, 'servers'),
        type=pulumi.get(__ret__, 'type'),
        with_selector=pulumi.get(__ret__, 'with_selector'))
def get_placement_group_output(id: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                               labels: Optional[pulumi.Input[Optional[Mapping[str, _builtins.str]]]] = None,
                               most_recent: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                               name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                               type: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                               with_selector: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                               opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetPlacementGroupResult]:
    """
    Provides details about a specific Hetzner Cloud Placement Group.

    ```python
    import pulumi
    import pulumi_hcloud as hcloud

    sample_placement_group1 = hcloud.get_placement_group(name="sample-placement-group-1")
    sample_placement_group2 = hcloud.get_placement_group(id=4711)
    ```


    :param _builtins.int id: ID of the placement group.
    :param Mapping[str, _builtins.str] labels: (map) User-defined labels (key-value pairs)
    :param _builtins.bool most_recent: Return most recent placement group if multiple are found.
    :param _builtins.str name: Name of the placement group.
    :param _builtins.str type: (string) Type of the Placement Group.
    :param _builtins.str with_selector: [Label selector](https://docs.hetzner.cloud/reference/cloud#label-selector)
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['labels'] = labels
    __args__['mostRecent'] = most_recent
    __args__['name'] = name
    __args__['type'] = type
    __args__['withSelector'] = with_selector
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('hcloud:index/getPlacementGroup:getPlacementGroup', __args__, opts=opts, typ=GetPlacementGroupResult)
    return __ret__.apply(lambda __response__: GetPlacementGroupResult(
        id=pulumi.get(__response__, 'id'),
        labels=pulumi.get(__response__, 'labels'),
        most_recent=pulumi.get(__response__, 'most_recent'),
        name=pulumi.get(__response__, 'name'),
        servers=pulumi.get(__response__, 'servers'),
        type=pulumi.get(__response__, 'type'),
        with_selector=pulumi.get(__response__, 'with_selector')))
