# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetZoneRrsetResult',
    'AwaitableGetZoneRrsetResult',
    'get_zone_rrset',
    'get_zone_rrset_output',
]

@pulumi.output_type
class GetZoneRrsetResult:
    """
    A collection of values returned by getZoneRrset.
    """
    def __init__(__self__, change_protection=None, id=None, labels=None, name=None, records=None, ttl=None, type=None, with_selector=None, zone=None):
        if change_protection and not isinstance(change_protection, bool):
            raise TypeError("Expected argument 'change_protection' to be a bool")
        pulumi.set(__self__, "change_protection", change_protection)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if labels and not isinstance(labels, dict):
            raise TypeError("Expected argument 'labels' to be a dict")
        pulumi.set(__self__, "labels", labels)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if records and not isinstance(records, list):
            raise TypeError("Expected argument 'records' to be a list")
        pulumi.set(__self__, "records", records)
        if ttl and not isinstance(ttl, int):
            raise TypeError("Expected argument 'ttl' to be a int")
        pulumi.set(__self__, "ttl", ttl)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)
        if with_selector and not isinstance(with_selector, str):
            raise TypeError("Expected argument 'with_selector' to be a str")
        pulumi.set(__self__, "with_selector", with_selector)
        if zone and not isinstance(zone, str):
            raise TypeError("Expected argument 'zone' to be a str")
        pulumi.set(__self__, "zone", zone)

    @_builtins.property
    @pulumi.getter(name="changeProtection")
    def change_protection(self) -> _builtins.bool:
        """
        Whether change protection is enabled.
        """
        return pulumi.get(self, "change_protection")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        ID of the Zone RRSet.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Mapping[str, _builtins.str]:
        """
        User-defined [labels](https://docs.hetzner.cloud/reference/cloud#labels) (key-value pairs) for the resource.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        Name of the Zone RRSet.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def records(self) -> Sequence['outputs.GetZoneRrsetRecordResult']:
        """
        Records of the Zone RRSet.
        """
        return pulumi.get(self, "records")

    @_builtins.property
    @pulumi.getter
    def ttl(self) -> _builtins.int:
        """
        Time To Live (TTL) of the Zone RRSet.
        """
        return pulumi.get(self, "ttl")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        Type of the Zone RRSet.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="withSelector")
    def with_selector(self) -> Optional[_builtins.str]:
        """
        Filter results using a [Label Selector](https://docs.hetzner.cloud/reference/cloud#label-selector).
        """
        return pulumi.get(self, "with_selector")

    @_builtins.property
    @pulumi.getter
    def zone(self) -> _builtins.str:
        """
        ID or Name of the parent Zone.
        """
        return pulumi.get(self, "zone")


class AwaitableGetZoneRrsetResult(GetZoneRrsetResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetZoneRrsetResult(
            change_protection=self.change_protection,
            id=self.id,
            labels=self.labels,
            name=self.name,
            records=self.records,
            ttl=self.ttl,
            type=self.type,
            with_selector=self.with_selector,
            zone=self.zone)


def get_zone_rrset(id: Optional[_builtins.str] = None,
                   name: Optional[_builtins.str] = None,
                   type: Optional[_builtins.str] = None,
                   with_selector: Optional[_builtins.str] = None,
                   zone: Optional[_builtins.str] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetZoneRrsetResult:
    """
    Provides details about a Hetzner Cloud Zone Resource Record Set (RRSet).

    See the [Zone RRSets API documentation](https://docs.hetzner.cloud/reference/cloud#zone-rrsets) for more details.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_hcloud as hcloud

    example = hcloud.get_zone(name="example.com")
    by_id = hcloud.get_zone_rrset(zone=example.name,
        id="www/A")
    by_name_and_type = hcloud.get_zone_rrset(zone=example.name,
        name="www",
        type="A")
    by_label = hcloud.get_zone_rrset(zone=example.name,
        with_selector="key=value")
    ```


    :param _builtins.str id: ID of the Zone RRSet.
    :param _builtins.str name: Name of the Zone RRSet.
    :param _builtins.str type: Type of the Zone RRSet.
    :param _builtins.str with_selector: Filter results using a [Label Selector](https://docs.hetzner.cloud/reference/cloud#label-selector).
    :param _builtins.str zone: ID or Name of the parent Zone.
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['name'] = name
    __args__['type'] = type
    __args__['withSelector'] = with_selector
    __args__['zone'] = zone
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('hcloud:index/getZoneRrset:getZoneRrset', __args__, opts=opts, typ=GetZoneRrsetResult).value

    return AwaitableGetZoneRrsetResult(
        change_protection=pulumi.get(__ret__, 'change_protection'),
        id=pulumi.get(__ret__, 'id'),
        labels=pulumi.get(__ret__, 'labels'),
        name=pulumi.get(__ret__, 'name'),
        records=pulumi.get(__ret__, 'records'),
        ttl=pulumi.get(__ret__, 'ttl'),
        type=pulumi.get(__ret__, 'type'),
        with_selector=pulumi.get(__ret__, 'with_selector'),
        zone=pulumi.get(__ret__, 'zone'))
def get_zone_rrset_output(id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                          name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                          type: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                          with_selector: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                          zone: Optional[pulumi.Input[_builtins.str]] = None,
                          opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetZoneRrsetResult]:
    """
    Provides details about a Hetzner Cloud Zone Resource Record Set (RRSet).

    See the [Zone RRSets API documentation](https://docs.hetzner.cloud/reference/cloud#zone-rrsets) for more details.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_hcloud as hcloud

    example = hcloud.get_zone(name="example.com")
    by_id = hcloud.get_zone_rrset(zone=example.name,
        id="www/A")
    by_name_and_type = hcloud.get_zone_rrset(zone=example.name,
        name="www",
        type="A")
    by_label = hcloud.get_zone_rrset(zone=example.name,
        with_selector="key=value")
    ```


    :param _builtins.str id: ID of the Zone RRSet.
    :param _builtins.str name: Name of the Zone RRSet.
    :param _builtins.str type: Type of the Zone RRSet.
    :param _builtins.str with_selector: Filter results using a [Label Selector](https://docs.hetzner.cloud/reference/cloud#label-selector).
    :param _builtins.str zone: ID or Name of the parent Zone.
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['name'] = name
    __args__['type'] = type
    __args__['withSelector'] = with_selector
    __args__['zone'] = zone
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('hcloud:index/getZoneRrset:getZoneRrset', __args__, opts=opts, typ=GetZoneRrsetResult)
    return __ret__.apply(lambda __response__: GetZoneRrsetResult(
        change_protection=pulumi.get(__response__, 'change_protection'),
        id=pulumi.get(__response__, 'id'),
        labels=pulumi.get(__response__, 'labels'),
        name=pulumi.get(__response__, 'name'),
        records=pulumi.get(__response__, 'records'),
        ttl=pulumi.get(__response__, 'ttl'),
        type=pulumi.get(__response__, 'type'),
        with_selector=pulumi.get(__response__, 'with_selector'),
        zone=pulumi.get(__response__, 'zone')))
