# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'FirewallApplyTo',
    'FirewallRule',
    'LoadBalancerAlgorithm',
    'LoadBalancerServiceHealthCheck',
    'LoadBalancerServiceHealthCheckHttp',
    'LoadBalancerServiceHttp',
    'LoadBalancerTarget',
    'ServerNetwork',
    'ServerPublicNet',
    'ZoneAuthoritativeNameservers',
    'ZonePrimaryNameserver',
    'ZoneRrsetRecord',
    'GetCertificatesCertificateResult',
    'GetDatacentersDatacenterResult',
    'GetFirewallApplyToResult',
    'GetFirewallRuleResult',
    'GetFirewallsFirewallResult',
    'GetFirewallsFirewallApplyToResult',
    'GetFirewallsFirewallRuleResult',
    'GetFloatingIpsFloatingIpResult',
    'GetImagesImageResult',
    'GetLoadBalancerAlgorithmResult',
    'GetLoadBalancerServiceResult',
    'GetLoadBalancerServiceHealthCheckResult',
    'GetLoadBalancerServiceHealthCheckHttpResult',
    'GetLoadBalancerServiceHttpResult',
    'GetLoadBalancerTargetResult',
    'GetLoadBalancerTypesLoadBalancerTypeResult',
    'GetLoadBalancersLoadBalancerResult',
    'GetLoadBalancersLoadBalancerAlgorithmResult',
    'GetLoadBalancersLoadBalancerServiceResult',
    'GetLoadBalancersLoadBalancerServiceHealthCheckResult',
    'GetLoadBalancersLoadBalancerServiceHealthCheckHttpResult',
    'GetLoadBalancersLoadBalancerServiceHttpResult',
    'GetLoadBalancersLoadBalancerTargetResult',
    'GetLocationsLocationResult',
    'GetNetworksNetworkResult',
    'GetPlacementGroupsPlacementGroupResult',
    'GetPrimaryIpsPrimaryIpResult',
    'GetServerNetworkResult',
    'GetServerTypeLocationResult',
    'GetServerTypesServerTypeResult',
    'GetServerTypesServerTypeLocationResult',
    'GetServersServerResult',
    'GetServersServerNetworkResult',
    'GetSshKeysSshKeyResult',
    'GetVolumesVolumeResult',
    'GetZoneAuthoritativeNameserversResult',
    'GetZonePrimaryNameserverResult',
    'GetZoneRrsetRecordResult',
    'GetZoneRrsetsRrsetResult',
    'GetZoneRrsetsRrsetRecordResult',
    'GetZonesZoneResult',
    'GetZonesZoneAuthoritativeNameserversResult',
    'GetZonesZonePrimaryNameserverResult',
]

@pulumi.output_type
class FirewallApplyTo(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "labelSelector":
            suggest = "label_selector"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FirewallApplyTo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FirewallApplyTo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FirewallApplyTo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 label_selector: Optional[_builtins.str] = None,
                 server: Optional[_builtins.int] = None):
        """
        :param _builtins.str label_selector: Label Selector to select servers the firewall should be applied to (only one
               of `server` and `label_selector`can be applied in one block)
        :param _builtins.int server: ID of the server you want to apply the firewall to (only one of `server`
               and `label_selector`can be applied in one block)
        """
        if label_selector is not None:
            pulumi.set(__self__, "label_selector", label_selector)
        if server is not None:
            pulumi.set(__self__, "server", server)

    @_builtins.property
    @pulumi.getter(name="labelSelector")
    def label_selector(self) -> Optional[_builtins.str]:
        """
        Label Selector to select servers the firewall should be applied to (only one
        of `server` and `label_selector`can be applied in one block)
        """
        return pulumi.get(self, "label_selector")

    @_builtins.property
    @pulumi.getter
    def server(self) -> Optional[_builtins.int]:
        """
        ID of the server you want to apply the firewall to (only one of `server`
        and `label_selector`can be applied in one block)
        """
        return pulumi.get(self, "server")


@pulumi.output_type
class FirewallRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "destinationIps":
            suggest = "destination_ips"
        elif key == "sourceIps":
            suggest = "source_ips"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FirewallRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FirewallRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FirewallRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 direction: _builtins.str,
                 protocol: _builtins.str,
                 description: Optional[_builtins.str] = None,
                 destination_ips: Optional[Sequence[_builtins.str]] = None,
                 port: Optional[_builtins.str] = None,
                 source_ips: Optional[Sequence[_builtins.str]] = None):
        """
        :param _builtins.str direction: Direction of the Firewall Rule. `in`
        :param _builtins.str protocol: Protocol of the Firewall Rule. `tcp`, `icmp`, `udp`, `gre`, `esp`
        :param _builtins.str description: Description of the firewall rule
        :param Sequence[_builtins.str] destination_ips: List of IPs or CIDRs that are allowed within this Firewall Rule (when `direction`
               is `out`)
        :param _builtins.str port: Port of the Firewall Rule. Required when `protocol` is `tcp` or `udp`. You can use `any`
               to allow all ports for the specific protocol. Port ranges are also possible: `80-85` allows all ports between 80 and 85.
        :param Sequence[_builtins.str] source_ips: List of IPs or CIDRs that are allowed within this Firewall Rule (when `direction`
               is `in`)
        """
        pulumi.set(__self__, "direction", direction)
        pulumi.set(__self__, "protocol", protocol)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if destination_ips is not None:
            pulumi.set(__self__, "destination_ips", destination_ips)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if source_ips is not None:
            pulumi.set(__self__, "source_ips", source_ips)

    @_builtins.property
    @pulumi.getter
    def direction(self) -> _builtins.str:
        """
        Direction of the Firewall Rule. `in`
        """
        return pulumi.get(self, "direction")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> _builtins.str:
        """
        Protocol of the Firewall Rule. `tcp`, `icmp`, `udp`, `gre`, `esp`
        """
        return pulumi.get(self, "protocol")

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        """
        Description of the firewall rule
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="destinationIps")
    def destination_ips(self) -> Optional[Sequence[_builtins.str]]:
        """
        List of IPs or CIDRs that are allowed within this Firewall Rule (when `direction`
        is `out`)
        """
        return pulumi.get(self, "destination_ips")

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[_builtins.str]:
        """
        Port of the Firewall Rule. Required when `protocol` is `tcp` or `udp`. You can use `any`
        to allow all ports for the specific protocol. Port ranges are also possible: `80-85` allows all ports between 80 and 85.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter(name="sourceIps")
    def source_ips(self) -> Optional[Sequence[_builtins.str]]:
        """
        List of IPs or CIDRs that are allowed within this Firewall Rule (when `direction`
        is `in`)
        """
        return pulumi.get(self, "source_ips")


@pulumi.output_type
class LoadBalancerAlgorithm(dict):
    def __init__(__self__, *,
                 type: Optional[_builtins.str] = None):
        """
        :param _builtins.str type: Type of the Load Balancer Algorithm. `round_robin` or `least_connections`
        """
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        Type of the Load Balancer Algorithm. `round_robin` or `least_connections`
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class LoadBalancerServiceHealthCheck(dict):
    def __init__(__self__, *,
                 interval: _builtins.int,
                 port: _builtins.int,
                 protocol: _builtins.str,
                 retries: _builtins.int,
                 timeout: _builtins.int,
                 http: Optional['outputs.LoadBalancerServiceHealthCheckHttp'] = None):
        """
        :param _builtins.int interval: Interval how often the health check will be performed, in seconds.
        :param _builtins.int port: Port the health check tries to connect to, required if protocol is `tcp`. Can be everything between `1` and `65535`. Must be unique per Load Balancer.
        :param _builtins.str protocol: Protocol the health check uses. `http` or `tcp`
        :param _builtins.int retries: Number of tries a health check will be performed until a target will be listed as `unhealthy`.
        :param _builtins.int timeout: Timeout when a health check try will be canceled if there is no response, in seconds.
        :param 'LoadBalancerServiceHealthCheckHttpArgs' http: HTTP configuration. Required if `protocol` is `http`.
        """
        pulumi.set(__self__, "interval", interval)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "protocol", protocol)
        pulumi.set(__self__, "retries", retries)
        pulumi.set(__self__, "timeout", timeout)
        if http is not None:
            pulumi.set(__self__, "http", http)

    @_builtins.property
    @pulumi.getter
    def interval(self) -> _builtins.int:
        """
        Interval how often the health check will be performed, in seconds.
        """
        return pulumi.get(self, "interval")

    @_builtins.property
    @pulumi.getter
    def port(self) -> _builtins.int:
        """
        Port the health check tries to connect to, required if protocol is `tcp`. Can be everything between `1` and `65535`. Must be unique per Load Balancer.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> _builtins.str:
        """
        Protocol the health check uses. `http` or `tcp`
        """
        return pulumi.get(self, "protocol")

    @_builtins.property
    @pulumi.getter
    def retries(self) -> _builtins.int:
        """
        Number of tries a health check will be performed until a target will be listed as `unhealthy`.
        """
        return pulumi.get(self, "retries")

    @_builtins.property
    @pulumi.getter
    def timeout(self) -> _builtins.int:
        """
        Timeout when a health check try will be canceled if there is no response, in seconds.
        """
        return pulumi.get(self, "timeout")

    @_builtins.property
    @pulumi.getter
    def http(self) -> Optional['outputs.LoadBalancerServiceHealthCheckHttp']:
        """
        HTTP configuration. Required if `protocol` is `http`.
        """
        return pulumi.get(self, "http")


@pulumi.output_type
class LoadBalancerServiceHealthCheckHttp(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "statusCodes":
            suggest = "status_codes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LoadBalancerServiceHealthCheckHttp. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LoadBalancerServiceHealthCheckHttp.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LoadBalancerServiceHealthCheckHttp.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 domain: Optional[_builtins.str] = None,
                 path: Optional[_builtins.str] = None,
                 response: Optional[_builtins.str] = None,
                 status_codes: Optional[Sequence[_builtins.str]] = None,
                 tls: Optional[_builtins.bool] = None):
        """
        :param _builtins.str domain: Domain we try to access when performing the Health Check.
        :param _builtins.str path: Path we try to access when performing the Health Check.
        :param _builtins.str response: Response we expect to be included in the Target response when a Health Check was performed.
        :param Sequence[_builtins.str] status_codes: We expect that the target answers with these status codes. If not the target is marked as `unhealthy`.
        :param _builtins.bool tls: Enable TLS certificate checking.
        """
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if response is not None:
            pulumi.set(__self__, "response", response)
        if status_codes is not None:
            pulumi.set(__self__, "status_codes", status_codes)
        if tls is not None:
            pulumi.set(__self__, "tls", tls)

    @_builtins.property
    @pulumi.getter
    def domain(self) -> Optional[_builtins.str]:
        """
        Domain we try to access when performing the Health Check.
        """
        return pulumi.get(self, "domain")

    @_builtins.property
    @pulumi.getter
    def path(self) -> Optional[_builtins.str]:
        """
        Path we try to access when performing the Health Check.
        """
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter
    def response(self) -> Optional[_builtins.str]:
        """
        Response we expect to be included in the Target response when a Health Check was performed.
        """
        return pulumi.get(self, "response")

    @_builtins.property
    @pulumi.getter(name="statusCodes")
    def status_codes(self) -> Optional[Sequence[_builtins.str]]:
        """
        We expect that the target answers with these status codes. If not the target is marked as `unhealthy`.
        """
        return pulumi.get(self, "status_codes")

    @_builtins.property
    @pulumi.getter
    def tls(self) -> Optional[_builtins.bool]:
        """
        Enable TLS certificate checking.
        """
        return pulumi.get(self, "tls")


@pulumi.output_type
class LoadBalancerServiceHttp(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cookieLifetime":
            suggest = "cookie_lifetime"
        elif key == "cookieName":
            suggest = "cookie_name"
        elif key == "redirectHttp":
            suggest = "redirect_http"
        elif key == "stickySessions":
            suggest = "sticky_sessions"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LoadBalancerServiceHttp. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LoadBalancerServiceHttp.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LoadBalancerServiceHttp.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 certificates: Optional[Sequence[_builtins.int]] = None,
                 cookie_lifetime: Optional[_builtins.int] = None,
                 cookie_name: Optional[_builtins.str] = None,
                 redirect_http: Optional[_builtins.bool] = None,
                 sticky_sessions: Optional[_builtins.bool] = None):
        """
        :param Sequence[_builtins.int] certificates: List of IDs from certificates which the Load Balancer has.
        :param _builtins.int cookie_lifetime: Lifetime of the cookie for sticky session (in seconds). Default: `300`
        :param _builtins.str cookie_name: Name of the cookie for sticky session. Default: `HCLBSTICKY`
        :param _builtins.bool redirect_http: Redirect HTTP to HTTPS traffic. Only supported for services with `protocol` `https` using the default HTTP port `80`.
        :param _builtins.bool sticky_sessions: Enable sticky sessions
        """
        if certificates is not None:
            pulumi.set(__self__, "certificates", certificates)
        if cookie_lifetime is not None:
            pulumi.set(__self__, "cookie_lifetime", cookie_lifetime)
        if cookie_name is not None:
            pulumi.set(__self__, "cookie_name", cookie_name)
        if redirect_http is not None:
            pulumi.set(__self__, "redirect_http", redirect_http)
        if sticky_sessions is not None:
            pulumi.set(__self__, "sticky_sessions", sticky_sessions)

    @_builtins.property
    @pulumi.getter
    def certificates(self) -> Optional[Sequence[_builtins.int]]:
        """
        List of IDs from certificates which the Load Balancer has.
        """
        return pulumi.get(self, "certificates")

    @_builtins.property
    @pulumi.getter(name="cookieLifetime")
    def cookie_lifetime(self) -> Optional[_builtins.int]:
        """
        Lifetime of the cookie for sticky session (in seconds). Default: `300`
        """
        return pulumi.get(self, "cookie_lifetime")

    @_builtins.property
    @pulumi.getter(name="cookieName")
    def cookie_name(self) -> Optional[_builtins.str]:
        """
        Name of the cookie for sticky session. Default: `HCLBSTICKY`
        """
        return pulumi.get(self, "cookie_name")

    @_builtins.property
    @pulumi.getter(name="redirectHttp")
    def redirect_http(self) -> Optional[_builtins.bool]:
        """
        Redirect HTTP to HTTPS traffic. Only supported for services with `protocol` `https` using the default HTTP port `80`.
        """
        return pulumi.get(self, "redirect_http")

    @_builtins.property
    @pulumi.getter(name="stickySessions")
    def sticky_sessions(self) -> Optional[_builtins.bool]:
        """
        Enable sticky sessions
        """
        return pulumi.get(self, "sticky_sessions")


@pulumi.output_type
class LoadBalancerTarget(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "serverId":
            suggest = "server_id"
        elif key == "usePrivateIp":
            suggest = "use_private_ip"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LoadBalancerTarget. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LoadBalancerTarget.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LoadBalancerTarget.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: _builtins.str,
                 server_id: Optional[_builtins.int] = None,
                 use_private_ip: Optional[_builtins.bool] = None):
        """
        :param _builtins.str type: (string) Type of the Load Balancer Algorithm. `round_robin` or `least_connections`
        """
        pulumi.set(__self__, "type", type)
        if server_id is not None:
            pulumi.set(__self__, "server_id", server_id)
        if use_private_ip is not None:
            pulumi.set(__self__, "use_private_ip", use_private_ip)

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        (string) Type of the Load Balancer Algorithm. `round_robin` or `least_connections`
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="serverId")
    def server_id(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "server_id")

    @_builtins.property
    @pulumi.getter(name="usePrivateIp")
    @_utilities.deprecated("""Does not work. Use the LoadBalancerTarget resource instead.""")
    def use_private_ip(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "use_private_ip")


@pulumi.output_type
class ServerNetwork(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "networkId":
            suggest = "network_id"
        elif key == "aliasIps":
            suggest = "alias_ips"
        elif key == "macAddress":
            suggest = "mac_address"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServerNetwork. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServerNetwork.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServerNetwork.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 network_id: _builtins.int,
                 alias_ips: Optional[Sequence[_builtins.str]] = None,
                 ip: Optional[_builtins.str] = None,
                 mac_address: Optional[_builtins.str] = None):
        """
        :param _builtins.int network_id: ID of the network
        :param _builtins.str ip: Specify the IP the server should get in the network
        :param _builtins.str mac_address: (Optional, string) The MAC address the private interface of the server has
        """
        pulumi.set(__self__, "network_id", network_id)
        if alias_ips is not None:
            pulumi.set(__self__, "alias_ips", alias_ips)
        if ip is not None:
            pulumi.set(__self__, "ip", ip)
        if mac_address is not None:
            pulumi.set(__self__, "mac_address", mac_address)

    @_builtins.property
    @pulumi.getter(name="networkId")
    def network_id(self) -> _builtins.int:
        """
        ID of the network
        """
        return pulumi.get(self, "network_id")

    @_builtins.property
    @pulumi.getter(name="aliasIps")
    def alias_ips(self) -> Optional[Sequence[_builtins.str]]:
        return pulumi.get(self, "alias_ips")

    @_builtins.property
    @pulumi.getter
    def ip(self) -> Optional[_builtins.str]:
        """
        Specify the IP the server should get in the network
        """
        return pulumi.get(self, "ip")

    @_builtins.property
    @pulumi.getter(name="macAddress")
    def mac_address(self) -> Optional[_builtins.str]:
        """
        (Optional, string) The MAC address the private interface of the server has
        """
        return pulumi.get(self, "mac_address")


@pulumi.output_type
class ServerPublicNet(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipv4Enabled":
            suggest = "ipv4_enabled"
        elif key == "ipv6Enabled":
            suggest = "ipv6_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServerPublicNet. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServerPublicNet.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServerPublicNet.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ipv4: Optional[_builtins.int] = None,
                 ipv4_enabled: Optional[_builtins.bool] = None,
                 ipv6: Optional[_builtins.int] = None,
                 ipv6_enabled: Optional[_builtins.bool] = None):
        if ipv4 is not None:
            pulumi.set(__self__, "ipv4", ipv4)
        if ipv4_enabled is not None:
            pulumi.set(__self__, "ipv4_enabled", ipv4_enabled)
        if ipv6 is not None:
            pulumi.set(__self__, "ipv6", ipv6)
        if ipv6_enabled is not None:
            pulumi.set(__self__, "ipv6_enabled", ipv6_enabled)

    @_builtins.property
    @pulumi.getter
    def ipv4(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "ipv4")

    @_builtins.property
    @pulumi.getter(name="ipv4Enabled")
    def ipv4_enabled(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "ipv4_enabled")

    @_builtins.property
    @pulumi.getter
    def ipv6(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "ipv6")

    @_builtins.property
    @pulumi.getter(name="ipv6Enabled")
    def ipv6_enabled(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "ipv6_enabled")


@pulumi.output_type
class ZoneAuthoritativeNameservers(dict):
    def __init__(__self__, *,
                 assigneds: Optional[Sequence[_builtins.str]] = None):
        """
        :param Sequence[_builtins.str] assigneds: Authoritative Hetzner nameservers assigned to the Zone.
        """
        if assigneds is not None:
            pulumi.set(__self__, "assigneds", assigneds)

    @_builtins.property
    @pulumi.getter
    def assigneds(self) -> Optional[Sequence[_builtins.str]]:
        """
        Authoritative Hetzner nameservers assigned to the Zone.
        """
        return pulumi.get(self, "assigneds")


@pulumi.output_type
class ZonePrimaryNameserver(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "tsigAlgorithm":
            suggest = "tsig_algorithm"
        elif key == "tsigKey":
            suggest = "tsig_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ZonePrimaryNameserver. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ZonePrimaryNameserver.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ZonePrimaryNameserver.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 address: _builtins.str,
                 port: Optional[_builtins.int] = None,
                 tsig_algorithm: Optional[_builtins.str] = None,
                 tsig_key: Optional[_builtins.str] = None):
        """
        :param _builtins.str address: Public IPv4 or IPv6 address of the primary nameserver.
        :param _builtins.int port: Port of the primary nameserver.
        :param _builtins.str tsig_algorithm: Transaction signature (TSIG) algorithm used to generate the TSIG key.
        :param _builtins.str tsig_key: Transaction signature (TSIG) key
        """
        pulumi.set(__self__, "address", address)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if tsig_algorithm is not None:
            pulumi.set(__self__, "tsig_algorithm", tsig_algorithm)
        if tsig_key is not None:
            pulumi.set(__self__, "tsig_key", tsig_key)

    @_builtins.property
    @pulumi.getter
    def address(self) -> _builtins.str:
        """
        Public IPv4 or IPv6 address of the primary nameserver.
        """
        return pulumi.get(self, "address")

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[_builtins.int]:
        """
        Port of the primary nameserver.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter(name="tsigAlgorithm")
    def tsig_algorithm(self) -> Optional[_builtins.str]:
        """
        Transaction signature (TSIG) algorithm used to generate the TSIG key.
        """
        return pulumi.get(self, "tsig_algorithm")

    @_builtins.property
    @pulumi.getter(name="tsigKey")
    def tsig_key(self) -> Optional[_builtins.str]:
        """
        Transaction signature (TSIG) key
        """
        return pulumi.get(self, "tsig_key")


@pulumi.output_type
class ZoneRrsetRecord(dict):
    def __init__(__self__, *,
                 value: _builtins.str,
                 comment: Optional[_builtins.str] = None):
        """
        :param _builtins.str value: Value of the record.
        :param _builtins.str comment: Comment of the record.
        """
        pulumi.set(__self__, "value", value)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        Value of the record.
        """
        return pulumi.get(self, "value")

    @_builtins.property
    @pulumi.getter
    def comment(self) -> Optional[_builtins.str]:
        """
        Comment of the record.
        """
        return pulumi.get(self, "comment")


@pulumi.output_type
class GetCertificatesCertificateResult(dict):
    def __init__(__self__, *,
                 certificate: _builtins.str,
                 created: _builtins.str,
                 domain_names: Sequence[_builtins.str],
                 fingerprint: _builtins.str,
                 id: _builtins.int,
                 labels: Mapping[str, _builtins.str],
                 not_valid_after: _builtins.str,
                 not_valid_before: _builtins.str,
                 type: _builtins.str,
                 name: Optional[_builtins.str] = None):
        pulumi.set(__self__, "certificate", certificate)
        pulumi.set(__self__, "created", created)
        pulumi.set(__self__, "domain_names", domain_names)
        pulumi.set(__self__, "fingerprint", fingerprint)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "labels", labels)
        pulumi.set(__self__, "not_valid_after", not_valid_after)
        pulumi.set(__self__, "not_valid_before", not_valid_before)
        pulumi.set(__self__, "type", type)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def certificate(self) -> _builtins.str:
        return pulumi.get(self, "certificate")

    @_builtins.property
    @pulumi.getter
    def created(self) -> _builtins.str:
        return pulumi.get(self, "created")

    @_builtins.property
    @pulumi.getter(name="domainNames")
    def domain_names(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "domain_names")

    @_builtins.property
    @pulumi.getter
    def fingerprint(self) -> _builtins.str:
        return pulumi.get(self, "fingerprint")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.int:
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Mapping[str, _builtins.str]:
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter(name="notValidAfter")
    def not_valid_after(self) -> _builtins.str:
        return pulumi.get(self, "not_valid_after")

    @_builtins.property
    @pulumi.getter(name="notValidBefore")
    def not_valid_before(self) -> _builtins.str:
        return pulumi.get(self, "not_valid_before")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "name")


@pulumi.output_type
class GetDatacentersDatacenterResult(dict):
    def __init__(__self__, *,
                 available_server_type_ids: Sequence[_builtins.int],
                 description: _builtins.str,
                 id: _builtins.int,
                 location: Mapping[str, _builtins.str],
                 name: _builtins.str,
                 supported_server_type_ids: Sequence[_builtins.int]):
        """
        :param Sequence[_builtins.int] available_server_type_ids: List of currently available Server Types in the Datacenter.
        :param _builtins.str description: Description of the Datacenter.
        :param _builtins.int id: ID of the Datacenter.
        :param Mapping[str, _builtins.str] location: Location of the Datacenter. See the [Hetzner Docs](https://docs.hetzner.com/cloud/general/locations/#what-locations-are-there) for more details about locations.
        :param _builtins.str name: Name of the Datacenter.
        :param Sequence[_builtins.int] supported_server_type_ids: List of supported Server Types in the Datacenter.
        """
        pulumi.set(__self__, "available_server_type_ids", available_server_type_ids)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "supported_server_type_ids", supported_server_type_ids)

    @_builtins.property
    @pulumi.getter(name="availableServerTypeIds")
    def available_server_type_ids(self) -> Sequence[_builtins.int]:
        """
        List of currently available Server Types in the Datacenter.
        """
        return pulumi.get(self, "available_server_type_ids")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        Description of the Datacenter.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.int:
        """
        ID of the Datacenter.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def location(self) -> Mapping[str, _builtins.str]:
        """
        Location of the Datacenter. See the [Hetzner Docs](https://docs.hetzner.com/cloud/general/locations/#what-locations-are-there) for more details about locations.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the Datacenter.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="supportedServerTypeIds")
    def supported_server_type_ids(self) -> Sequence[_builtins.int]:
        """
        List of supported Server Types in the Datacenter.
        """
        return pulumi.get(self, "supported_server_type_ids")


@pulumi.output_type
class GetFirewallApplyToResult(dict):
    def __init__(__self__, *,
                 label_selector: _builtins.str,
                 server: _builtins.int):
        """
        :param _builtins.str label_selector: (string) Label Selector to select servers the firewall is applied to. Empty if a server is directly
               referenced
        :param _builtins.int server: (int) ID of a server where the firewall is applied to. `0` if applied to a label_selector
        """
        pulumi.set(__self__, "label_selector", label_selector)
        pulumi.set(__self__, "server", server)

    @_builtins.property
    @pulumi.getter(name="labelSelector")
    def label_selector(self) -> _builtins.str:
        """
        (string) Label Selector to select servers the firewall is applied to. Empty if a server is directly
        referenced
        """
        return pulumi.get(self, "label_selector")

    @_builtins.property
    @pulumi.getter
    def server(self) -> _builtins.int:
        """
        (int) ID of a server where the firewall is applied to. `0` if applied to a label_selector
        """
        return pulumi.get(self, "server")


@pulumi.output_type
class GetFirewallRuleResult(dict):
    def __init__(__self__, *,
                 direction: _builtins.str,
                 description: Optional[_builtins.str] = None,
                 destination_ips: Optional[Sequence[_builtins.str]] = None,
                 port: Optional[_builtins.str] = None,
                 protocol: Optional[_builtins.str] = None,
                 source_ips: Optional[Sequence[_builtins.str]] = None):
        """
        :param _builtins.str direction: (Required, string) Direction of the Firewall Rule. `in`, `out`
        :param _builtins.str description: (Optional, string) Description of the firewall rule
        :param Sequence[_builtins.str] destination_ips: (Required, List) List of CIDRs that are allowed within this Firewall Rule (when `direction` is `out`)
        :param _builtins.str port: (Required, string) Port of the Firewall Rule. Required when `protocol` is `tcp` or `udp`
        :param _builtins.str protocol: (Required, string) Protocol of the Firewall Rule. `tcp`, `icmp`, `udp`, `gre`, `esp`
        :param Sequence[_builtins.str] source_ips: (Required, List) List of CIDRs that are allowed within this Firewall Rule (when `direction` is `in`)
        """
        pulumi.set(__self__, "direction", direction)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if destination_ips is not None:
            pulumi.set(__self__, "destination_ips", destination_ips)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if source_ips is not None:
            pulumi.set(__self__, "source_ips", source_ips)

    @_builtins.property
    @pulumi.getter
    def direction(self) -> _builtins.str:
        """
        (Required, string) Direction of the Firewall Rule. `in`, `out`
        """
        return pulumi.get(self, "direction")

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        """
        (Optional, string) Description of the firewall rule
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="destinationIps")
    def destination_ips(self) -> Optional[Sequence[_builtins.str]]:
        """
        (Required, List) List of CIDRs that are allowed within this Firewall Rule (when `direction` is `out`)
        """
        return pulumi.get(self, "destination_ips")

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[_builtins.str]:
        """
        (Required, string) Port of the Firewall Rule. Required when `protocol` is `tcp` or `udp`
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> Optional[_builtins.str]:
        """
        (Required, string) Protocol of the Firewall Rule. `tcp`, `icmp`, `udp`, `gre`, `esp`
        """
        return pulumi.get(self, "protocol")

    @_builtins.property
    @pulumi.getter(name="sourceIps")
    def source_ips(self) -> Optional[Sequence[_builtins.str]]:
        """
        (Required, List) List of CIDRs that are allowed within this Firewall Rule (when `direction` is `in`)
        """
        return pulumi.get(self, "source_ips")


@pulumi.output_type
class GetFirewallsFirewallResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 apply_tos: Optional[Sequence['outputs.GetFirewallsFirewallApplyToResult']] = None,
                 id: Optional[_builtins.int] = None,
                 labels: Optional[Mapping[str, _builtins.str]] = None,
                 rules: Optional[Sequence['outputs.GetFirewallsFirewallRuleResult']] = None):
        pulumi.set(__self__, "name", name)
        if apply_tos is not None:
            pulumi.set(__self__, "apply_tos", apply_tos)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="applyTos")
    def apply_tos(self) -> Optional[Sequence['outputs.GetFirewallsFirewallApplyToResult']]:
        return pulumi.get(self, "apply_tos")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[Mapping[str, _builtins.str]]:
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter
    def rules(self) -> Optional[Sequence['outputs.GetFirewallsFirewallRuleResult']]:
        return pulumi.get(self, "rules")


@pulumi.output_type
class GetFirewallsFirewallApplyToResult(dict):
    def __init__(__self__, *,
                 label_selector: _builtins.str,
                 server: _builtins.int):
        pulumi.set(__self__, "label_selector", label_selector)
        pulumi.set(__self__, "server", server)

    @_builtins.property
    @pulumi.getter(name="labelSelector")
    def label_selector(self) -> _builtins.str:
        return pulumi.get(self, "label_selector")

    @_builtins.property
    @pulumi.getter
    def server(self) -> _builtins.int:
        return pulumi.get(self, "server")


@pulumi.output_type
class GetFirewallsFirewallRuleResult(dict):
    def __init__(__self__, *,
                 direction: _builtins.str,
                 description: Optional[_builtins.str] = None,
                 destination_ips: Optional[Sequence[_builtins.str]] = None,
                 port: Optional[_builtins.str] = None,
                 protocol: Optional[_builtins.str] = None,
                 source_ips: Optional[Sequence[_builtins.str]] = None):
        pulumi.set(__self__, "direction", direction)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if destination_ips is not None:
            pulumi.set(__self__, "destination_ips", destination_ips)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if source_ips is not None:
            pulumi.set(__self__, "source_ips", source_ips)

    @_builtins.property
    @pulumi.getter
    def direction(self) -> _builtins.str:
        return pulumi.get(self, "direction")

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="destinationIps")
    def destination_ips(self) -> Optional[Sequence[_builtins.str]]:
        return pulumi.get(self, "destination_ips")

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "protocol")

    @_builtins.property
    @pulumi.getter(name="sourceIps")
    def source_ips(self) -> Optional[Sequence[_builtins.str]]:
        return pulumi.get(self, "source_ips")


@pulumi.output_type
class GetFloatingIpsFloatingIpResult(dict):
    def __init__(__self__, *,
                 delete_protection: _builtins.bool,
                 description: _builtins.str,
                 home_location: _builtins.str,
                 id: _builtins.int,
                 ip_address: _builtins.str,
                 ip_network: _builtins.str,
                 labels: Mapping[str, _builtins.str],
                 server_id: _builtins.int,
                 type: _builtins.str,
                 name: Optional[_builtins.str] = None):
        pulumi.set(__self__, "delete_protection", delete_protection)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "home_location", home_location)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "ip_address", ip_address)
        pulumi.set(__self__, "ip_network", ip_network)
        pulumi.set(__self__, "labels", labels)
        pulumi.set(__self__, "server_id", server_id)
        pulumi.set(__self__, "type", type)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="deleteProtection")
    def delete_protection(self) -> _builtins.bool:
        return pulumi.get(self, "delete_protection")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="homeLocation")
    def home_location(self) -> _builtins.str:
        return pulumi.get(self, "home_location")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.int:
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> _builtins.str:
        return pulumi.get(self, "ip_address")

    @_builtins.property
    @pulumi.getter(name="ipNetwork")
    def ip_network(self) -> _builtins.str:
        return pulumi.get(self, "ip_network")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Mapping[str, _builtins.str]:
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter(name="serverId")
    def server_id(self) -> _builtins.int:
        return pulumi.get(self, "server_id")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "name")


@pulumi.output_type
class GetImagesImageResult(dict):
    def __init__(__self__, *,
                 architecture: _builtins.str,
                 created: _builtins.str,
                 deprecated: _builtins.str,
                 description: _builtins.str,
                 id: _builtins.int,
                 labels: Mapping[str, _builtins.str],
                 name: _builtins.str,
                 os_flavor: _builtins.str,
                 os_version: _builtins.str,
                 rapid_deploy: _builtins.bool,
                 type: _builtins.str,
                 selector: Optional[_builtins.str] = None):
        pulumi.set(__self__, "architecture", architecture)
        pulumi.set(__self__, "created", created)
        pulumi.set(__self__, "deprecated", deprecated)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "labels", labels)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "os_flavor", os_flavor)
        pulumi.set(__self__, "os_version", os_version)
        pulumi.set(__self__, "rapid_deploy", rapid_deploy)
        pulumi.set(__self__, "type", type)
        if selector is not None:
            pulumi.set(__self__, "selector", selector)

    @_builtins.property
    @pulumi.getter
    def architecture(self) -> _builtins.str:
        return pulumi.get(self, "architecture")

    @_builtins.property
    @pulumi.getter
    def created(self) -> _builtins.str:
        return pulumi.get(self, "created")

    @_builtins.property
    @pulumi.getter
    def deprecated(self) -> _builtins.str:
        return pulumi.get(self, "deprecated")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.int:
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Mapping[str, _builtins.str]:
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="osFlavor")
    def os_flavor(self) -> _builtins.str:
        return pulumi.get(self, "os_flavor")

    @_builtins.property
    @pulumi.getter(name="osVersion")
    def os_version(self) -> _builtins.str:
        return pulumi.get(self, "os_version")

    @_builtins.property
    @pulumi.getter(name="rapidDeploy")
    def rapid_deploy(self) -> _builtins.bool:
        return pulumi.get(self, "rapid_deploy")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Please use the with_selector property instead.""")
    def selector(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "selector")


@pulumi.output_type
class GetLoadBalancerAlgorithmResult(dict):
    def __init__(__self__, *,
                 type: _builtins.str):
        """
        :param _builtins.str type: (string) Type of the target. `server` or `label_selector`
        """
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        (string) Type of the target. `server` or `label_selector`
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetLoadBalancerServiceResult(dict):
    def __init__(__self__, *,
                 destination_port: _builtins.int,
                 health_checks: Sequence['outputs.GetLoadBalancerServiceHealthCheckResult'],
                 https: Sequence['outputs.GetLoadBalancerServiceHttpResult'],
                 listen_port: _builtins.int,
                 protocol: _builtins.str,
                 proxyprotocol: _builtins.bool):
        """
        :param _builtins.int destination_port: (int) Port the service connects to the targets on. Can be everything between `1` and `65535`.
        :param Sequence['GetLoadBalancerServiceHealthCheckArgs'] health_checks: (list) List of http configurations when `protocol` is `http` or `https`.
        :param Sequence['GetLoadBalancerServiceHttpArgs'] https: (list) List of http configurations when `protocol` is `http` or `https`.
        :param _builtins.int listen_port: (int) Port the service listen on. Can be everything between `1` and `65535`. Must be unique per Load Balancer.
        :param _builtins.str protocol: (string) Protocol the health check uses. `http`, `https` or `tcp`
        :param _builtins.bool proxyprotocol: (bool) Enable proxyprotocol.
        """
        pulumi.set(__self__, "destination_port", destination_port)
        pulumi.set(__self__, "health_checks", health_checks)
        pulumi.set(__self__, "https", https)
        pulumi.set(__self__, "listen_port", listen_port)
        pulumi.set(__self__, "protocol", protocol)
        pulumi.set(__self__, "proxyprotocol", proxyprotocol)

    @_builtins.property
    @pulumi.getter(name="destinationPort")
    def destination_port(self) -> _builtins.int:
        """
        (int) Port the service connects to the targets on. Can be everything between `1` and `65535`.
        """
        return pulumi.get(self, "destination_port")

    @_builtins.property
    @pulumi.getter(name="healthChecks")
    def health_checks(self) -> Sequence['outputs.GetLoadBalancerServiceHealthCheckResult']:
        """
        (list) List of http configurations when `protocol` is `http` or `https`.
        """
        return pulumi.get(self, "health_checks")

    @_builtins.property
    @pulumi.getter
    def https(self) -> Sequence['outputs.GetLoadBalancerServiceHttpResult']:
        """
        (list) List of http configurations when `protocol` is `http` or `https`.
        """
        return pulumi.get(self, "https")

    @_builtins.property
    @pulumi.getter(name="listenPort")
    def listen_port(self) -> _builtins.int:
        """
        (int) Port the service listen on. Can be everything between `1` and `65535`. Must be unique per Load Balancer.
        """
        return pulumi.get(self, "listen_port")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> _builtins.str:
        """
        (string) Protocol the health check uses. `http`, `https` or `tcp`
        """
        return pulumi.get(self, "protocol")

    @_builtins.property
    @pulumi.getter
    def proxyprotocol(self) -> _builtins.bool:
        """
        (bool) Enable proxyprotocol.
        """
        return pulumi.get(self, "proxyprotocol")


@pulumi.output_type
class GetLoadBalancerServiceHealthCheckResult(dict):
    def __init__(__self__, *,
                 https: Sequence['outputs.GetLoadBalancerServiceHealthCheckHttpResult'],
                 interval: _builtins.int,
                 port: _builtins.int,
                 protocol: _builtins.str,
                 retries: _builtins.int,
                 timeout: _builtins.int):
        """
        :param Sequence['GetLoadBalancerServiceHealthCheckHttpArgs'] https: (list) List of http configurations when `protocol` is `http` or `https`.
        :param _builtins.int interval: (int) Interval how often the health check will be performed, in seconds.
        :param _builtins.int port: (int) Port the health check tries to connect to. Can be everything between `1` and `65535`.
        :param _builtins.str protocol: (string) Protocol the health check uses. `http`, `https` or `tcp`
        :param _builtins.int retries: (int) Number of tries a health check will be performed until a target will be listed as `unhealthy`.
        :param _builtins.int timeout: (int) Timeout when a health check try will be canceled if there is no response, in seconds.
        """
        pulumi.set(__self__, "https", https)
        pulumi.set(__self__, "interval", interval)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "protocol", protocol)
        pulumi.set(__self__, "retries", retries)
        pulumi.set(__self__, "timeout", timeout)

    @_builtins.property
    @pulumi.getter
    def https(self) -> Sequence['outputs.GetLoadBalancerServiceHealthCheckHttpResult']:
        """
        (list) List of http configurations when `protocol` is `http` or `https`.
        """
        return pulumi.get(self, "https")

    @_builtins.property
    @pulumi.getter
    def interval(self) -> _builtins.int:
        """
        (int) Interval how often the health check will be performed, in seconds.
        """
        return pulumi.get(self, "interval")

    @_builtins.property
    @pulumi.getter
    def port(self) -> _builtins.int:
        """
        (int) Port the health check tries to connect to. Can be everything between `1` and `65535`.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> _builtins.str:
        """
        (string) Protocol the health check uses. `http`, `https` or `tcp`
        """
        return pulumi.get(self, "protocol")

    @_builtins.property
    @pulumi.getter
    def retries(self) -> _builtins.int:
        """
        (int) Number of tries a health check will be performed until a target will be listed as `unhealthy`.
        """
        return pulumi.get(self, "retries")

    @_builtins.property
    @pulumi.getter
    def timeout(self) -> _builtins.int:
        """
        (int) Timeout when a health check try will be canceled if there is no response, in seconds.
        """
        return pulumi.get(self, "timeout")


@pulumi.output_type
class GetLoadBalancerServiceHealthCheckHttpResult(dict):
    def __init__(__self__, *,
                 domain: _builtins.str,
                 path: _builtins.str,
                 response: _builtins.str,
                 status_codes: Sequence[_builtins.int],
                 tls: _builtins.bool):
        """
        :param _builtins.str domain: string) Domain we try to access when performing the Health Check.
        :param _builtins.str path: (string) Path we try to access when performing the Health Check.
        :param _builtins.str response: (string) Response we expect to be included in the Target response when a Health Check was performed.
        :param Sequence[_builtins.int] status_codes: (list[int]) We expect that the target answers with these status codes. If not the target is marked as `unhealthy`.
        :param _builtins.bool tls: (bool) Enable TLS certificate checking.
        """
        pulumi.set(__self__, "domain", domain)
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "response", response)
        pulumi.set(__self__, "status_codes", status_codes)
        pulumi.set(__self__, "tls", tls)

    @_builtins.property
    @pulumi.getter
    def domain(self) -> _builtins.str:
        """
        string) Domain we try to access when performing the Health Check.
        """
        return pulumi.get(self, "domain")

    @_builtins.property
    @pulumi.getter
    def path(self) -> _builtins.str:
        """
        (string) Path we try to access when performing the Health Check.
        """
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter
    def response(self) -> _builtins.str:
        """
        (string) Response we expect to be included in the Target response when a Health Check was performed.
        """
        return pulumi.get(self, "response")

    @_builtins.property
    @pulumi.getter(name="statusCodes")
    def status_codes(self) -> Sequence[_builtins.int]:
        """
        (list[int]) We expect that the target answers with these status codes. If not the target is marked as `unhealthy`.
        """
        return pulumi.get(self, "status_codes")

    @_builtins.property
    @pulumi.getter
    def tls(self) -> _builtins.bool:
        """
        (bool) Enable TLS certificate checking.
        """
        return pulumi.get(self, "tls")


@pulumi.output_type
class GetLoadBalancerServiceHttpResult(dict):
    def __init__(__self__, *,
                 certificates: Sequence[_builtins.str],
                 cookie_lifetime: _builtins.int,
                 cookie_name: _builtins.str,
                 redirect_http: _builtins.bool,
                 sticky_sessions: _builtins.bool):
        """
        :param Sequence[_builtins.str] certificates: (list[int]) List of IDs from certificates which the Load Balancer has.
        :param _builtins.int cookie_lifetime: (int) Lifetime of the cookie for sticky session (in seconds).
        :param _builtins.str cookie_name: (string) Name of the cookie for sticky session.
        :param _builtins.bool redirect_http: (string) Determine if all requests from port 80 should be redirected to port 443.
        :param _builtins.bool sticky_sessions: (string) Determine if sticky sessions are enabled or not.
        """
        pulumi.set(__self__, "certificates", certificates)
        pulumi.set(__self__, "cookie_lifetime", cookie_lifetime)
        pulumi.set(__self__, "cookie_name", cookie_name)
        pulumi.set(__self__, "redirect_http", redirect_http)
        pulumi.set(__self__, "sticky_sessions", sticky_sessions)

    @_builtins.property
    @pulumi.getter
    def certificates(self) -> Sequence[_builtins.str]:
        """
        (list[int]) List of IDs from certificates which the Load Balancer has.
        """
        return pulumi.get(self, "certificates")

    @_builtins.property
    @pulumi.getter(name="cookieLifetime")
    def cookie_lifetime(self) -> _builtins.int:
        """
        (int) Lifetime of the cookie for sticky session (in seconds).
        """
        return pulumi.get(self, "cookie_lifetime")

    @_builtins.property
    @pulumi.getter(name="cookieName")
    def cookie_name(self) -> _builtins.str:
        """
        (string) Name of the cookie for sticky session.
        """
        return pulumi.get(self, "cookie_name")

    @_builtins.property
    @pulumi.getter(name="redirectHttp")
    def redirect_http(self) -> _builtins.bool:
        """
        (string) Determine if all requests from port 80 should be redirected to port 443.
        """
        return pulumi.get(self, "redirect_http")

    @_builtins.property
    @pulumi.getter(name="stickySessions")
    def sticky_sessions(self) -> _builtins.bool:
        """
        (string) Determine if sticky sessions are enabled or not.
        """
        return pulumi.get(self, "sticky_sessions")


@pulumi.output_type
class GetLoadBalancerTargetResult(dict):
    def __init__(__self__, *,
                 label_selector: _builtins.str,
                 server_id: _builtins.int,
                 type: _builtins.str):
        """
        :param _builtins.str label_selector: (string) Label Selector to add a group of resources based on the label.
        :param _builtins.int server_id: (int) ID of the server which should be a target for this Load Balancer.
        :param _builtins.str type: (string) Type of the target. `server` or `label_selector`
        """
        pulumi.set(__self__, "label_selector", label_selector)
        pulumi.set(__self__, "server_id", server_id)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="labelSelector")
    def label_selector(self) -> _builtins.str:
        """
        (string) Label Selector to add a group of resources based on the label.
        """
        return pulumi.get(self, "label_selector")

    @_builtins.property
    @pulumi.getter(name="serverId")
    def server_id(self) -> _builtins.int:
        """
        (int) ID of the server which should be a target for this Load Balancer.
        """
        return pulumi.get(self, "server_id")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        (string) Type of the target. `server` or `label_selector`
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetLoadBalancerTypesLoadBalancerTypeResult(dict):
    def __init__(__self__, *,
                 description: _builtins.str,
                 id: _builtins.int,
                 max_assigned_certificates: _builtins.int,
                 max_connections: _builtins.int,
                 max_services: _builtins.int,
                 max_targets: _builtins.int,
                 name: _builtins.str):
        """
        :param _builtins.str description: Description of the Load Balancer Type.
        :param _builtins.int id: ID of the Load Balancer Type.
        :param _builtins.int max_assigned_certificates: Maximum number of certificates that can be assigned for the Load Balancer of this type.
        :param _builtins.int max_connections: Maximum number of simultaneous open connections for the Load Balancer of this type.
        :param _builtins.int max_services: Maximum number of services for the Load Balancer of this type.
        :param _builtins.int max_targets: Maximum number of targets for the Load Balancer of this type.
        :param _builtins.str name: Name of the Load Balancer Type.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "max_assigned_certificates", max_assigned_certificates)
        pulumi.set(__self__, "max_connections", max_connections)
        pulumi.set(__self__, "max_services", max_services)
        pulumi.set(__self__, "max_targets", max_targets)
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        Description of the Load Balancer Type.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.int:
        """
        ID of the Load Balancer Type.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="maxAssignedCertificates")
    def max_assigned_certificates(self) -> _builtins.int:
        """
        Maximum number of certificates that can be assigned for the Load Balancer of this type.
        """
        return pulumi.get(self, "max_assigned_certificates")

    @_builtins.property
    @pulumi.getter(name="maxConnections")
    def max_connections(self) -> _builtins.int:
        """
        Maximum number of simultaneous open connections for the Load Balancer of this type.
        """
        return pulumi.get(self, "max_connections")

    @_builtins.property
    @pulumi.getter(name="maxServices")
    def max_services(self) -> _builtins.int:
        """
        Maximum number of services for the Load Balancer of this type.
        """
        return pulumi.get(self, "max_services")

    @_builtins.property
    @pulumi.getter(name="maxTargets")
    def max_targets(self) -> _builtins.int:
        """
        Maximum number of targets for the Load Balancer of this type.
        """
        return pulumi.get(self, "max_targets")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the Load Balancer Type.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetLoadBalancersLoadBalancerResult(dict):
    def __init__(__self__, *,
                 algorithms: Sequence['outputs.GetLoadBalancersLoadBalancerAlgorithmResult'],
                 delete_protection: _builtins.bool,
                 id: _builtins.int,
                 ipv4: _builtins.str,
                 ipv6: _builtins.str,
                 labels: Mapping[str, _builtins.str],
                 load_balancer_type: _builtins.str,
                 location: _builtins.str,
                 network_id: _builtins.int,
                 network_ip: _builtins.str,
                 network_zone: _builtins.str,
                 services: Sequence['outputs.GetLoadBalancersLoadBalancerServiceResult'],
                 targets: Sequence['outputs.GetLoadBalancersLoadBalancerTargetResult'],
                 name: Optional[_builtins.str] = None):
        pulumi.set(__self__, "algorithms", algorithms)
        pulumi.set(__self__, "delete_protection", delete_protection)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "ipv4", ipv4)
        pulumi.set(__self__, "ipv6", ipv6)
        pulumi.set(__self__, "labels", labels)
        pulumi.set(__self__, "load_balancer_type", load_balancer_type)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "network_id", network_id)
        pulumi.set(__self__, "network_ip", network_ip)
        pulumi.set(__self__, "network_zone", network_zone)
        pulumi.set(__self__, "services", services)
        pulumi.set(__self__, "targets", targets)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def algorithms(self) -> Sequence['outputs.GetLoadBalancersLoadBalancerAlgorithmResult']:
        return pulumi.get(self, "algorithms")

    @_builtins.property
    @pulumi.getter(name="deleteProtection")
    def delete_protection(self) -> _builtins.bool:
        return pulumi.get(self, "delete_protection")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.int:
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def ipv4(self) -> _builtins.str:
        return pulumi.get(self, "ipv4")

    @_builtins.property
    @pulumi.getter
    def ipv6(self) -> _builtins.str:
        return pulumi.get(self, "ipv6")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Mapping[str, _builtins.str]:
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter(name="loadBalancerType")
    def load_balancer_type(self) -> _builtins.str:
        return pulumi.get(self, "load_balancer_type")

    @_builtins.property
    @pulumi.getter
    def location(self) -> _builtins.str:
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter(name="networkId")
    def network_id(self) -> _builtins.int:
        return pulumi.get(self, "network_id")

    @_builtins.property
    @pulumi.getter(name="networkIp")
    def network_ip(self) -> _builtins.str:
        return pulumi.get(self, "network_ip")

    @_builtins.property
    @pulumi.getter(name="networkZone")
    def network_zone(self) -> _builtins.str:
        return pulumi.get(self, "network_zone")

    @_builtins.property
    @pulumi.getter
    def services(self) -> Sequence['outputs.GetLoadBalancersLoadBalancerServiceResult']:
        return pulumi.get(self, "services")

    @_builtins.property
    @pulumi.getter
    def targets(self) -> Sequence['outputs.GetLoadBalancersLoadBalancerTargetResult']:
        return pulumi.get(self, "targets")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "name")


@pulumi.output_type
class GetLoadBalancersLoadBalancerAlgorithmResult(dict):
    def __init__(__self__, *,
                 type: _builtins.str):
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        return pulumi.get(self, "type")


@pulumi.output_type
class GetLoadBalancersLoadBalancerServiceResult(dict):
    def __init__(__self__, *,
                 destination_port: _builtins.int,
                 health_checks: Sequence['outputs.GetLoadBalancersLoadBalancerServiceHealthCheckResult'],
                 https: Sequence['outputs.GetLoadBalancersLoadBalancerServiceHttpResult'],
                 listen_port: _builtins.int,
                 protocol: _builtins.str,
                 proxyprotocol: _builtins.bool):
        pulumi.set(__self__, "destination_port", destination_port)
        pulumi.set(__self__, "health_checks", health_checks)
        pulumi.set(__self__, "https", https)
        pulumi.set(__self__, "listen_port", listen_port)
        pulumi.set(__self__, "protocol", protocol)
        pulumi.set(__self__, "proxyprotocol", proxyprotocol)

    @_builtins.property
    @pulumi.getter(name="destinationPort")
    def destination_port(self) -> _builtins.int:
        return pulumi.get(self, "destination_port")

    @_builtins.property
    @pulumi.getter(name="healthChecks")
    def health_checks(self) -> Sequence['outputs.GetLoadBalancersLoadBalancerServiceHealthCheckResult']:
        return pulumi.get(self, "health_checks")

    @_builtins.property
    @pulumi.getter
    def https(self) -> Sequence['outputs.GetLoadBalancersLoadBalancerServiceHttpResult']:
        return pulumi.get(self, "https")

    @_builtins.property
    @pulumi.getter(name="listenPort")
    def listen_port(self) -> _builtins.int:
        return pulumi.get(self, "listen_port")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> _builtins.str:
        return pulumi.get(self, "protocol")

    @_builtins.property
    @pulumi.getter
    def proxyprotocol(self) -> _builtins.bool:
        return pulumi.get(self, "proxyprotocol")


@pulumi.output_type
class GetLoadBalancersLoadBalancerServiceHealthCheckResult(dict):
    def __init__(__self__, *,
                 https: Sequence['outputs.GetLoadBalancersLoadBalancerServiceHealthCheckHttpResult'],
                 interval: _builtins.int,
                 port: _builtins.int,
                 protocol: _builtins.str,
                 retries: _builtins.int,
                 timeout: _builtins.int):
        pulumi.set(__self__, "https", https)
        pulumi.set(__self__, "interval", interval)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "protocol", protocol)
        pulumi.set(__self__, "retries", retries)
        pulumi.set(__self__, "timeout", timeout)

    @_builtins.property
    @pulumi.getter
    def https(self) -> Sequence['outputs.GetLoadBalancersLoadBalancerServiceHealthCheckHttpResult']:
        return pulumi.get(self, "https")

    @_builtins.property
    @pulumi.getter
    def interval(self) -> _builtins.int:
        return pulumi.get(self, "interval")

    @_builtins.property
    @pulumi.getter
    def port(self) -> _builtins.int:
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> _builtins.str:
        return pulumi.get(self, "protocol")

    @_builtins.property
    @pulumi.getter
    def retries(self) -> _builtins.int:
        return pulumi.get(self, "retries")

    @_builtins.property
    @pulumi.getter
    def timeout(self) -> _builtins.int:
        return pulumi.get(self, "timeout")


@pulumi.output_type
class GetLoadBalancersLoadBalancerServiceHealthCheckHttpResult(dict):
    def __init__(__self__, *,
                 domain: _builtins.str,
                 path: _builtins.str,
                 response: _builtins.str,
                 status_codes: Sequence[_builtins.int],
                 tls: _builtins.bool):
        pulumi.set(__self__, "domain", domain)
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "response", response)
        pulumi.set(__self__, "status_codes", status_codes)
        pulumi.set(__self__, "tls", tls)

    @_builtins.property
    @pulumi.getter
    def domain(self) -> _builtins.str:
        return pulumi.get(self, "domain")

    @_builtins.property
    @pulumi.getter
    def path(self) -> _builtins.str:
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter
    def response(self) -> _builtins.str:
        return pulumi.get(self, "response")

    @_builtins.property
    @pulumi.getter(name="statusCodes")
    def status_codes(self) -> Sequence[_builtins.int]:
        return pulumi.get(self, "status_codes")

    @_builtins.property
    @pulumi.getter
    def tls(self) -> _builtins.bool:
        return pulumi.get(self, "tls")


@pulumi.output_type
class GetLoadBalancersLoadBalancerServiceHttpResult(dict):
    def __init__(__self__, *,
                 certificates: Sequence[_builtins.str],
                 cookie_lifetime: _builtins.int,
                 cookie_name: _builtins.str,
                 redirect_http: _builtins.bool,
                 sticky_sessions: _builtins.bool):
        pulumi.set(__self__, "certificates", certificates)
        pulumi.set(__self__, "cookie_lifetime", cookie_lifetime)
        pulumi.set(__self__, "cookie_name", cookie_name)
        pulumi.set(__self__, "redirect_http", redirect_http)
        pulumi.set(__self__, "sticky_sessions", sticky_sessions)

    @_builtins.property
    @pulumi.getter
    def certificates(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "certificates")

    @_builtins.property
    @pulumi.getter(name="cookieLifetime")
    def cookie_lifetime(self) -> _builtins.int:
        return pulumi.get(self, "cookie_lifetime")

    @_builtins.property
    @pulumi.getter(name="cookieName")
    def cookie_name(self) -> _builtins.str:
        return pulumi.get(self, "cookie_name")

    @_builtins.property
    @pulumi.getter(name="redirectHttp")
    def redirect_http(self) -> _builtins.bool:
        return pulumi.get(self, "redirect_http")

    @_builtins.property
    @pulumi.getter(name="stickySessions")
    def sticky_sessions(self) -> _builtins.bool:
        return pulumi.get(self, "sticky_sessions")


@pulumi.output_type
class GetLoadBalancersLoadBalancerTargetResult(dict):
    def __init__(__self__, *,
                 label_selector: _builtins.str,
                 server_id: _builtins.int,
                 type: _builtins.str):
        pulumi.set(__self__, "label_selector", label_selector)
        pulumi.set(__self__, "server_id", server_id)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="labelSelector")
    def label_selector(self) -> _builtins.str:
        return pulumi.get(self, "label_selector")

    @_builtins.property
    @pulumi.getter(name="serverId")
    def server_id(self) -> _builtins.int:
        return pulumi.get(self, "server_id")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        return pulumi.get(self, "type")


@pulumi.output_type
class GetLocationsLocationResult(dict):
    def __init__(__self__, *,
                 city: _builtins.str,
                 country: _builtins.str,
                 description: _builtins.str,
                 id: _builtins.int,
                 latitude: _builtins.float,
                 longitude: _builtins.float,
                 name: _builtins.str,
                 network_zone: _builtins.str):
        """
        :param _builtins.str city: Name of the closest city to the Location. City name and optionally state in short form.
        :param _builtins.str country: Country the Location resides in. ISO 3166-1 alpha-2 code of the country.
        :param _builtins.str description: Description of the Location.
        :param _builtins.int id: ID of the Location.
        :param _builtins.float latitude: Latitude of the city closest to the Location.
        :param _builtins.float longitude: Longitude of the city closest to the Location.
        :param _builtins.str name: Name of the Location.
        :param _builtins.str network_zone: Name of the Network Zone this Location resides in.
        """
        pulumi.set(__self__, "city", city)
        pulumi.set(__self__, "country", country)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "latitude", latitude)
        pulumi.set(__self__, "longitude", longitude)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "network_zone", network_zone)

    @_builtins.property
    @pulumi.getter
    def city(self) -> _builtins.str:
        """
        Name of the closest city to the Location. City name and optionally state in short form.
        """
        return pulumi.get(self, "city")

    @_builtins.property
    @pulumi.getter
    def country(self) -> _builtins.str:
        """
        Country the Location resides in. ISO 3166-1 alpha-2 code of the country.
        """
        return pulumi.get(self, "country")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        Description of the Location.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.int:
        """
        ID of the Location.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def latitude(self) -> _builtins.float:
        """
        Latitude of the city closest to the Location.
        """
        return pulumi.get(self, "latitude")

    @_builtins.property
    @pulumi.getter
    def longitude(self) -> _builtins.float:
        """
        Longitude of the city closest to the Location.
        """
        return pulumi.get(self, "longitude")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the Location.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="networkZone")
    def network_zone(self) -> _builtins.str:
        """
        Name of the Network Zone this Location resides in.
        """
        return pulumi.get(self, "network_zone")


@pulumi.output_type
class GetNetworksNetworkResult(dict):
    def __init__(__self__, *,
                 delete_protection: _builtins.bool,
                 expose_routes_to_vswitch: _builtins.bool,
                 id: _builtins.int,
                 ip_range: _builtins.str,
                 labels: Mapping[str, _builtins.str],
                 name: _builtins.str):
        """
        :param _builtins.bool expose_routes_to_vswitch: Indicates if the routes from this network should be exposed to the vSwitch connection. The exposing only takes effect if a vSwitch connection is active.
        """
        pulumi.set(__self__, "delete_protection", delete_protection)
        pulumi.set(__self__, "expose_routes_to_vswitch", expose_routes_to_vswitch)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "ip_range", ip_range)
        pulumi.set(__self__, "labels", labels)
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="deleteProtection")
    def delete_protection(self) -> _builtins.bool:
        return pulumi.get(self, "delete_protection")

    @_builtins.property
    @pulumi.getter(name="exposeRoutesToVswitch")
    def expose_routes_to_vswitch(self) -> _builtins.bool:
        """
        Indicates if the routes from this network should be exposed to the vSwitch connection. The exposing only takes effect if a vSwitch connection is active.
        """
        return pulumi.get(self, "expose_routes_to_vswitch")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.int:
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="ipRange")
    def ip_range(self) -> _builtins.str:
        return pulumi.get(self, "ip_range")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Mapping[str, _builtins.str]:
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")


@pulumi.output_type
class GetPlacementGroupsPlacementGroupResult(dict):
    def __init__(__self__, *,
                 id: _builtins.int,
                 labels: Mapping[str, _builtins.str],
                 name: _builtins.str,
                 servers: Sequence[_builtins.int],
                 type: _builtins.str):
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "labels", labels)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "servers", servers)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.int:
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Mapping[str, _builtins.str]:
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def servers(self) -> Sequence[_builtins.int]:
        return pulumi.get(self, "servers")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        return pulumi.get(self, "type")


@pulumi.output_type
class GetPrimaryIpsPrimaryIpResult(dict):
    def __init__(__self__, *,
                 assignee_id: _builtins.int,
                 assignee_type: _builtins.str,
                 auto_delete: _builtins.bool,
                 datacenter: _builtins.str,
                 delete_protection: _builtins.bool,
                 id: _builtins.int,
                 ip_address: _builtins.str,
                 ip_network: _builtins.str,
                 labels: Mapping[str, _builtins.str],
                 type: _builtins.str,
                 name: Optional[_builtins.str] = None):
        pulumi.set(__self__, "assignee_id", assignee_id)
        pulumi.set(__self__, "assignee_type", assignee_type)
        pulumi.set(__self__, "auto_delete", auto_delete)
        pulumi.set(__self__, "datacenter", datacenter)
        pulumi.set(__self__, "delete_protection", delete_protection)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "ip_address", ip_address)
        pulumi.set(__self__, "ip_network", ip_network)
        pulumi.set(__self__, "labels", labels)
        pulumi.set(__self__, "type", type)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="assigneeId")
    def assignee_id(self) -> _builtins.int:
        return pulumi.get(self, "assignee_id")

    @_builtins.property
    @pulumi.getter(name="assigneeType")
    def assignee_type(self) -> _builtins.str:
        return pulumi.get(self, "assignee_type")

    @_builtins.property
    @pulumi.getter(name="autoDelete")
    def auto_delete(self) -> _builtins.bool:
        return pulumi.get(self, "auto_delete")

    @_builtins.property
    @pulumi.getter
    def datacenter(self) -> _builtins.str:
        return pulumi.get(self, "datacenter")

    @_builtins.property
    @pulumi.getter(name="deleteProtection")
    def delete_protection(self) -> _builtins.bool:
        return pulumi.get(self, "delete_protection")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.int:
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> _builtins.str:
        return pulumi.get(self, "ip_address")

    @_builtins.property
    @pulumi.getter(name="ipNetwork")
    def ip_network(self) -> _builtins.str:
        return pulumi.get(self, "ip_network")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Mapping[str, _builtins.str]:
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "name")


@pulumi.output_type
class GetServerNetworkResult(dict):
    def __init__(__self__, *,
                 alias_ips: Sequence[_builtins.str],
                 ip: _builtins.str,
                 mac_address: _builtins.str,
                 network_id: _builtins.int):
        """
        :param Sequence[_builtins.str] alias_ips: (list) A list of alias IP addresses assigned to the server in the network.
        :param _builtins.str ip: (string) The server's IP address within the network.
        :param _builtins.str mac_address: (string) The MAC address associated with the server's private network interface.
        :param _builtins.int network_id: (int) The unique identifier for the network.
        """
        pulumi.set(__self__, "alias_ips", alias_ips)
        pulumi.set(__self__, "ip", ip)
        pulumi.set(__self__, "mac_address", mac_address)
        pulumi.set(__self__, "network_id", network_id)

    @_builtins.property
    @pulumi.getter(name="aliasIps")
    def alias_ips(self) -> Sequence[_builtins.str]:
        """
        (list) A list of alias IP addresses assigned to the server in the network.
        """
        return pulumi.get(self, "alias_ips")

    @_builtins.property
    @pulumi.getter
    def ip(self) -> _builtins.str:
        """
        (string) The server's IP address within the network.
        """
        return pulumi.get(self, "ip")

    @_builtins.property
    @pulumi.getter(name="macAddress")
    def mac_address(self) -> _builtins.str:
        """
        (string) The MAC address associated with the server's private network interface.
        """
        return pulumi.get(self, "mac_address")

    @_builtins.property
    @pulumi.getter(name="networkId")
    def network_id(self) -> _builtins.int:
        """
        (int) The unique identifier for the network.
        """
        return pulumi.get(self, "network_id")


@pulumi.output_type
class GetServerTypeLocationResult(dict):
    def __init__(__self__, *,
                 deprecation_announced: _builtins.str,
                 id: _builtins.int,
                 is_deprecated: _builtins.bool,
                 name: _builtins.str,
                 unavailable_after: _builtins.str):
        """
        :param _builtins.str deprecation_announced: Date of the Server Type deprecation announcement.
        :param _builtins.int id: ID of the Location.
        :param _builtins.bool is_deprecated: Whether the Server Type is deprecated.
        :param _builtins.str name: Name of the Location.
        :param _builtins.str unavailable_after: Date of the Server Type removal. After this date, the Server Type cannot be used anymore.
        """
        pulumi.set(__self__, "deprecation_announced", deprecation_announced)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "is_deprecated", is_deprecated)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "unavailable_after", unavailable_after)

    @_builtins.property
    @pulumi.getter(name="deprecationAnnounced")
    def deprecation_announced(self) -> _builtins.str:
        """
        Date of the Server Type deprecation announcement.
        """
        return pulumi.get(self, "deprecation_announced")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.int:
        """
        ID of the Location.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="isDeprecated")
    def is_deprecated(self) -> _builtins.bool:
        """
        Whether the Server Type is deprecated.
        """
        return pulumi.get(self, "is_deprecated")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the Location.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="unavailableAfter")
    def unavailable_after(self) -> _builtins.str:
        """
        Date of the Server Type removal. After this date, the Server Type cannot be used anymore.
        """
        return pulumi.get(self, "unavailable_after")


@pulumi.output_type
class GetServerTypesServerTypeResult(dict):
    def __init__(__self__, *,
                 architecture: _builtins.str,
                 category: _builtins.str,
                 cores: _builtins.int,
                 cpu_type: _builtins.str,
                 deprecation_announced: _builtins.str,
                 description: _builtins.str,
                 disk: _builtins.int,
                 id: _builtins.int,
                 included_traffic: _builtins.int,
                 is_deprecated: _builtins.bool,
                 locations: Sequence['outputs.GetServerTypesServerTypeLocationResult'],
                 memory: _builtins.int,
                 name: _builtins.str,
                 storage_type: _builtins.str,
                 unavailable_after: _builtins.str):
        """
        :param _builtins.str architecture: Architecture of the cpu for a Server of this type.
        :param _builtins.str category: Category of the Server Type.
        :param _builtins.int cores: Number of cpu cores for a Server of this type.
        :param _builtins.str cpu_type: Type of cpu for a Server of this type.
        :param _builtins.str deprecation_announced: Date of the Server Type deprecation announcement.
        :param _builtins.str description: Description of the Server Type.
        :param _builtins.int disk: Disk size in GB for a Server of this type.
        :param _builtins.int id: ID of the Server Type.
        :param _builtins.bool is_deprecated: Whether the Server Type is deprecated.
        :param Sequence['GetServerTypesServerTypeLocationArgs'] locations: List of supported Locations for this Server Type.
        :param _builtins.int memory: Memory in GB for a Server of this type.
        :param _builtins.str name: Name of the Server Type.
        :param _builtins.str storage_type: Type of boot drive for a Server of this type.
        :param _builtins.str unavailable_after: Date of the Server Type removal. After this date, the Server Type cannot be used anymore.
        """
        pulumi.set(__self__, "architecture", architecture)
        pulumi.set(__self__, "category", category)
        pulumi.set(__self__, "cores", cores)
        pulumi.set(__self__, "cpu_type", cpu_type)
        pulumi.set(__self__, "deprecation_announced", deprecation_announced)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "disk", disk)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "included_traffic", included_traffic)
        pulumi.set(__self__, "is_deprecated", is_deprecated)
        pulumi.set(__self__, "locations", locations)
        pulumi.set(__self__, "memory", memory)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "storage_type", storage_type)
        pulumi.set(__self__, "unavailable_after", unavailable_after)

    @_builtins.property
    @pulumi.getter
    def architecture(self) -> _builtins.str:
        """
        Architecture of the cpu for a Server of this type.
        """
        return pulumi.get(self, "architecture")

    @_builtins.property
    @pulumi.getter
    def category(self) -> _builtins.str:
        """
        Category of the Server Type.
        """
        return pulumi.get(self, "category")

    @_builtins.property
    @pulumi.getter
    def cores(self) -> _builtins.int:
        """
        Number of cpu cores for a Server of this type.
        """
        return pulumi.get(self, "cores")

    @_builtins.property
    @pulumi.getter(name="cpuType")
    def cpu_type(self) -> _builtins.str:
        """
        Type of cpu for a Server of this type.
        """
        return pulumi.get(self, "cpu_type")

    @_builtins.property
    @pulumi.getter(name="deprecationAnnounced")
    @_utilities.deprecated("""The field is deprecated and will gradually be phased out starting 2025-09-24. Use the deprecation in the locations list instead.""")
    def deprecation_announced(self) -> _builtins.str:
        """
        Date of the Server Type deprecation announcement.
        """
        return pulumi.get(self, "deprecation_announced")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        Description of the Server Type.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def disk(self) -> _builtins.int:
        """
        Disk size in GB for a Server of this type.
        """
        return pulumi.get(self, "disk")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.int:
        """
        ID of the Server Type.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="includedTraffic")
    @_utilities.deprecated("""The field is deprecated and will always report 0 after 2024-08-05.""")
    def included_traffic(self) -> _builtins.int:
        return pulumi.get(self, "included_traffic")

    @_builtins.property
    @pulumi.getter(name="isDeprecated")
    @_utilities.deprecated("""The field is deprecated and will gradually be phased out starting 2025-09-24. Use the deprecation in the locations list instead.""")
    def is_deprecated(self) -> _builtins.bool:
        """
        Whether the Server Type is deprecated.
        """
        return pulumi.get(self, "is_deprecated")

    @_builtins.property
    @pulumi.getter
    def locations(self) -> Sequence['outputs.GetServerTypesServerTypeLocationResult']:
        """
        List of supported Locations for this Server Type.
        """
        return pulumi.get(self, "locations")

    @_builtins.property
    @pulumi.getter
    def memory(self) -> _builtins.int:
        """
        Memory in GB for a Server of this type.
        """
        return pulumi.get(self, "memory")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the Server Type.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="storageType")
    def storage_type(self) -> _builtins.str:
        """
        Type of boot drive for a Server of this type.
        """
        return pulumi.get(self, "storage_type")

    @_builtins.property
    @pulumi.getter(name="unavailableAfter")
    @_utilities.deprecated("""The field is deprecated and will gradually be phased out starting 2025-09-24. Use the deprecation in the locations list instead.""")
    def unavailable_after(self) -> _builtins.str:
        """
        Date of the Server Type removal. After this date, the Server Type cannot be used anymore.
        """
        return pulumi.get(self, "unavailable_after")


@pulumi.output_type
class GetServerTypesServerTypeLocationResult(dict):
    def __init__(__self__, *,
                 deprecation_announced: _builtins.str,
                 id: _builtins.int,
                 is_deprecated: _builtins.bool,
                 name: _builtins.str,
                 unavailable_after: _builtins.str):
        """
        :param _builtins.str deprecation_announced: Date of the Server Type deprecation announcement.
        :param _builtins.int id: ID of the Location.
        :param _builtins.bool is_deprecated: Whether the Server Type is deprecated.
        :param _builtins.str name: Name of the Location.
        :param _builtins.str unavailable_after: Date of the Server Type removal. After this date, the Server Type cannot be used anymore.
        """
        pulumi.set(__self__, "deprecation_announced", deprecation_announced)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "is_deprecated", is_deprecated)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "unavailable_after", unavailable_after)

    @_builtins.property
    @pulumi.getter(name="deprecationAnnounced")
    def deprecation_announced(self) -> _builtins.str:
        """
        Date of the Server Type deprecation announcement.
        """
        return pulumi.get(self, "deprecation_announced")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.int:
        """
        ID of the Location.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="isDeprecated")
    def is_deprecated(self) -> _builtins.bool:
        """
        Whether the Server Type is deprecated.
        """
        return pulumi.get(self, "is_deprecated")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the Location.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="unavailableAfter")
    def unavailable_after(self) -> _builtins.str:
        """
        Date of the Server Type removal. After this date, the Server Type cannot be used anymore.
        """
        return pulumi.get(self, "unavailable_after")


@pulumi.output_type
class GetServersServerResult(dict):
    def __init__(__self__, *,
                 backup_window: _builtins.str,
                 backups: _builtins.bool,
                 datacenter: _builtins.str,
                 delete_protection: _builtins.bool,
                 firewall_ids: Sequence[_builtins.int],
                 id: _builtins.int,
                 image: _builtins.str,
                 ipv4_address: _builtins.str,
                 ipv6_address: _builtins.str,
                 ipv6_network: _builtins.str,
                 iso: _builtins.str,
                 labels: Mapping[str, _builtins.str],
                 location: _builtins.str,
                 name: _builtins.str,
                 primary_disk_size: _builtins.int,
                 rebuild_protection: _builtins.bool,
                 rescue: _builtins.str,
                 server_type: _builtins.str,
                 status: _builtins.str,
                 networks: Optional[Sequence['outputs.GetServersServerNetworkResult']] = None,
                 placement_group_id: Optional[_builtins.int] = None):
        pulumi.set(__self__, "backup_window", backup_window)
        pulumi.set(__self__, "backups", backups)
        pulumi.set(__self__, "datacenter", datacenter)
        pulumi.set(__self__, "delete_protection", delete_protection)
        pulumi.set(__self__, "firewall_ids", firewall_ids)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "image", image)
        pulumi.set(__self__, "ipv4_address", ipv4_address)
        pulumi.set(__self__, "ipv6_address", ipv6_address)
        pulumi.set(__self__, "ipv6_network", ipv6_network)
        pulumi.set(__self__, "iso", iso)
        pulumi.set(__self__, "labels", labels)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "primary_disk_size", primary_disk_size)
        pulumi.set(__self__, "rebuild_protection", rebuild_protection)
        pulumi.set(__self__, "rescue", rescue)
        pulumi.set(__self__, "server_type", server_type)
        pulumi.set(__self__, "status", status)
        if networks is not None:
            pulumi.set(__self__, "networks", networks)
        if placement_group_id is not None:
            pulumi.set(__self__, "placement_group_id", placement_group_id)

    @_builtins.property
    @pulumi.getter(name="backupWindow")
    def backup_window(self) -> _builtins.str:
        return pulumi.get(self, "backup_window")

    @_builtins.property
    @pulumi.getter
    def backups(self) -> _builtins.bool:
        return pulumi.get(self, "backups")

    @_builtins.property
    @pulumi.getter
    def datacenter(self) -> _builtins.str:
        return pulumi.get(self, "datacenter")

    @_builtins.property
    @pulumi.getter(name="deleteProtection")
    def delete_protection(self) -> _builtins.bool:
        return pulumi.get(self, "delete_protection")

    @_builtins.property
    @pulumi.getter(name="firewallIds")
    def firewall_ids(self) -> Sequence[_builtins.int]:
        return pulumi.get(self, "firewall_ids")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.int:
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def image(self) -> _builtins.str:
        return pulumi.get(self, "image")

    @_builtins.property
    @pulumi.getter(name="ipv4Address")
    def ipv4_address(self) -> _builtins.str:
        return pulumi.get(self, "ipv4_address")

    @_builtins.property
    @pulumi.getter(name="ipv6Address")
    def ipv6_address(self) -> _builtins.str:
        return pulumi.get(self, "ipv6_address")

    @_builtins.property
    @pulumi.getter(name="ipv6Network")
    def ipv6_network(self) -> _builtins.str:
        return pulumi.get(self, "ipv6_network")

    @_builtins.property
    @pulumi.getter
    def iso(self) -> _builtins.str:
        return pulumi.get(self, "iso")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Mapping[str, _builtins.str]:
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter
    def location(self) -> _builtins.str:
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="primaryDiskSize")
    def primary_disk_size(self) -> _builtins.int:
        return pulumi.get(self, "primary_disk_size")

    @_builtins.property
    @pulumi.getter(name="rebuildProtection")
    def rebuild_protection(self) -> _builtins.bool:
        return pulumi.get(self, "rebuild_protection")

    @_builtins.property
    @pulumi.getter
    def rescue(self) -> _builtins.str:
        return pulumi.get(self, "rescue")

    @_builtins.property
    @pulumi.getter(name="serverType")
    def server_type(self) -> _builtins.str:
        return pulumi.get(self, "server_type")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def networks(self) -> Optional[Sequence['outputs.GetServersServerNetworkResult']]:
        return pulumi.get(self, "networks")

    @_builtins.property
    @pulumi.getter(name="placementGroupId")
    def placement_group_id(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "placement_group_id")


@pulumi.output_type
class GetServersServerNetworkResult(dict):
    def __init__(__self__, *,
                 alias_ips: Sequence[_builtins.str],
                 ip: _builtins.str,
                 mac_address: _builtins.str,
                 network_id: _builtins.int):
        pulumi.set(__self__, "alias_ips", alias_ips)
        pulumi.set(__self__, "ip", ip)
        pulumi.set(__self__, "mac_address", mac_address)
        pulumi.set(__self__, "network_id", network_id)

    @_builtins.property
    @pulumi.getter(name="aliasIps")
    def alias_ips(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "alias_ips")

    @_builtins.property
    @pulumi.getter
    def ip(self) -> _builtins.str:
        return pulumi.get(self, "ip")

    @_builtins.property
    @pulumi.getter(name="macAddress")
    def mac_address(self) -> _builtins.str:
        return pulumi.get(self, "mac_address")

    @_builtins.property
    @pulumi.getter(name="networkId")
    def network_id(self) -> _builtins.int:
        return pulumi.get(self, "network_id")


@pulumi.output_type
class GetSshKeysSshKeyResult(dict):
    def __init__(__self__, *,
                 fingerprint: _builtins.str,
                 id: _builtins.int,
                 labels: Mapping[str, _builtins.str],
                 name: _builtins.str,
                 public_key: _builtins.str):
        """
        :param _builtins.str fingerprint: Fingerprint of the SSH Key.
        :param _builtins.int id: ID of the SSH Key.
        :param Mapping[str, _builtins.str] labels: User-defined [labels](https://docs.hetzner.cloud/reference/cloud#labels) (key-value pairs) for the resource.
        :param _builtins.str name: Name of the SSH Key.
        :param _builtins.str public_key: Public key of the SSH Key pair.
        """
        pulumi.set(__self__, "fingerprint", fingerprint)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "labels", labels)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "public_key", public_key)

    @_builtins.property
    @pulumi.getter
    def fingerprint(self) -> _builtins.str:
        """
        Fingerprint of the SSH Key.
        """
        return pulumi.get(self, "fingerprint")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.int:
        """
        ID of the SSH Key.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Mapping[str, _builtins.str]:
        """
        User-defined [labels](https://docs.hetzner.cloud/reference/cloud#labels) (key-value pairs) for the resource.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the SSH Key.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> _builtins.str:
        """
        Public key of the SSH Key pair.
        """
        return pulumi.get(self, "public_key")


@pulumi.output_type
class GetVolumesVolumeResult(dict):
    def __init__(__self__, *,
                 delete_protection: _builtins.bool,
                 id: _builtins.int,
                 labels: Mapping[str, _builtins.str],
                 linux_device: _builtins.str,
                 name: _builtins.str,
                 size: _builtins.int,
                 location: Optional[_builtins.str] = None,
                 server_id: Optional[_builtins.int] = None):
        pulumi.set(__self__, "delete_protection", delete_protection)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "labels", labels)
        pulumi.set(__self__, "linux_device", linux_device)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "size", size)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if server_id is not None:
            pulumi.set(__self__, "server_id", server_id)

    @_builtins.property
    @pulumi.getter(name="deleteProtection")
    def delete_protection(self) -> _builtins.bool:
        return pulumi.get(self, "delete_protection")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.int:
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Mapping[str, _builtins.str]:
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter(name="linuxDevice")
    def linux_device(self) -> _builtins.str:
        return pulumi.get(self, "linux_device")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def size(self) -> _builtins.int:
        return pulumi.get(self, "size")

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter(name="serverId")
    def server_id(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "server_id")


@pulumi.output_type
class GetZoneAuthoritativeNameserversResult(dict):
    def __init__(__self__, *,
                 assigneds: Sequence[_builtins.str]):
        """
        :param Sequence[_builtins.str] assigneds: Authoritative Hetzner nameservers assigned to the Zone.
        """
        pulumi.set(__self__, "assigneds", assigneds)

    @_builtins.property
    @pulumi.getter
    def assigneds(self) -> Sequence[_builtins.str]:
        """
        Authoritative Hetzner nameservers assigned to the Zone.
        """
        return pulumi.get(self, "assigneds")


@pulumi.output_type
class GetZonePrimaryNameserverResult(dict):
    def __init__(__self__, *,
                 address: _builtins.str,
                 port: _builtins.int,
                 tsig_algorithm: _builtins.str,
                 tsig_key: _builtins.str):
        """
        :param _builtins.str address: Public IPv4 or IPv6 address of the primary nameserver.
        :param _builtins.int port: Port of the primary nameserver.
        :param _builtins.str tsig_algorithm: Transaction signature (TSIG) algorithm used to generate the TSIG key.
        :param _builtins.str tsig_key: Transaction signature (TSIG) key
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "tsig_algorithm", tsig_algorithm)
        pulumi.set(__self__, "tsig_key", tsig_key)

    @_builtins.property
    @pulumi.getter
    def address(self) -> _builtins.str:
        """
        Public IPv4 or IPv6 address of the primary nameserver.
        """
        return pulumi.get(self, "address")

    @_builtins.property
    @pulumi.getter
    def port(self) -> _builtins.int:
        """
        Port of the primary nameserver.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter(name="tsigAlgorithm")
    def tsig_algorithm(self) -> _builtins.str:
        """
        Transaction signature (TSIG) algorithm used to generate the TSIG key.
        """
        return pulumi.get(self, "tsig_algorithm")

    @_builtins.property
    @pulumi.getter(name="tsigKey")
    def tsig_key(self) -> _builtins.str:
        """
        Transaction signature (TSIG) key
        """
        return pulumi.get(self, "tsig_key")


@pulumi.output_type
class GetZoneRrsetRecordResult(dict):
    def __init__(__self__, *,
                 comment: _builtins.str,
                 value: _builtins.str):
        """
        :param _builtins.str comment: Comment of the record.
        :param _builtins.str value: Value of the record.
        """
        pulumi.set(__self__, "comment", comment)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def comment(self) -> _builtins.str:
        """
        Comment of the record.
        """
        return pulumi.get(self, "comment")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        Value of the record.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetZoneRrsetsRrsetResult(dict):
    def __init__(__self__, *,
                 change_protection: _builtins.bool,
                 id: _builtins.str,
                 labels: Mapping[str, _builtins.str],
                 name: _builtins.str,
                 records: Sequence['outputs.GetZoneRrsetsRrsetRecordResult'],
                 ttl: _builtins.int,
                 type: _builtins.str,
                 zone: _builtins.str):
        """
        :param _builtins.bool change_protection: Whether change protection is enabled.
        :param _builtins.str id: ID of the Zone RRSet.
        :param Mapping[str, _builtins.str] labels: User-defined [labels](https://docs.hetzner.cloud/reference/cloud#labels) (key-value pairs) for the resource.
        :param _builtins.str name: Name of the Zone RRSet.
        :param Sequence['GetZoneRrsetsRrsetRecordArgs'] records: Records of the Zone RRSet.
        :param _builtins.int ttl: Time To Live (TTL) of the Zone RRSet.
        :param _builtins.str type: Type of the Zone RRSet.
        :param _builtins.str zone: ID or Name of the parent Zone.
        """
        pulumi.set(__self__, "change_protection", change_protection)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "labels", labels)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "records", records)
        pulumi.set(__self__, "ttl", ttl)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "zone", zone)

    @_builtins.property
    @pulumi.getter(name="changeProtection")
    def change_protection(self) -> _builtins.bool:
        """
        Whether change protection is enabled.
        """
        return pulumi.get(self, "change_protection")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        ID of the Zone RRSet.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Mapping[str, _builtins.str]:
        """
        User-defined [labels](https://docs.hetzner.cloud/reference/cloud#labels) (key-value pairs) for the resource.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the Zone RRSet.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def records(self) -> Sequence['outputs.GetZoneRrsetsRrsetRecordResult']:
        """
        Records of the Zone RRSet.
        """
        return pulumi.get(self, "records")

    @_builtins.property
    @pulumi.getter
    def ttl(self) -> _builtins.int:
        """
        Time To Live (TTL) of the Zone RRSet.
        """
        return pulumi.get(self, "ttl")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Type of the Zone RRSet.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def zone(self) -> _builtins.str:
        """
        ID or Name of the parent Zone.
        """
        return pulumi.get(self, "zone")


@pulumi.output_type
class GetZoneRrsetsRrsetRecordResult(dict):
    def __init__(__self__, *,
                 comment: _builtins.str,
                 value: _builtins.str):
        """
        :param _builtins.str comment: Comment of the record.
        :param _builtins.str value: Value of the record.
        """
        pulumi.set(__self__, "comment", comment)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def comment(self) -> _builtins.str:
        """
        Comment of the record.
        """
        return pulumi.get(self, "comment")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        Value of the record.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetZonesZoneResult(dict):
    def __init__(__self__, *,
                 authoritative_nameservers: 'outputs.GetZonesZoneAuthoritativeNameserversResult',
                 delete_protection: _builtins.bool,
                 id: _builtins.int,
                 labels: Mapping[str, _builtins.str],
                 mode: _builtins.str,
                 name: _builtins.str,
                 primary_nameservers: Sequence['outputs.GetZonesZonePrimaryNameserverResult'],
                 registrar: _builtins.str,
                 ttl: _builtins.int):
        """
        :param 'GetZonesZoneAuthoritativeNameserversArgs' authoritative_nameservers: Authoritative nameservers of the Zone.
        :param _builtins.bool delete_protection: Whether delete protection is enabled.
        :param _builtins.int id: ID of the Zone.
        :param Mapping[str, _builtins.str] labels: User-defined [labels](https://docs.hetzner.cloud/reference/cloud#labels) (key-value pairs) for the resource.
        :param _builtins.str mode: Mode of the Zone.
        :param _builtins.str name: Name of the Zone.
        :param Sequence['GetZonesZonePrimaryNameserverArgs'] primary_nameservers: Primary nameservers of the Zone.
        :param _builtins.str registrar: Registrar of the Zone.
        :param _builtins.int ttl: Default Time To Live (TTL) of the Zone.
        """
        pulumi.set(__self__, "authoritative_nameservers", authoritative_nameservers)
        pulumi.set(__self__, "delete_protection", delete_protection)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "labels", labels)
        pulumi.set(__self__, "mode", mode)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "primary_nameservers", primary_nameservers)
        pulumi.set(__self__, "registrar", registrar)
        pulumi.set(__self__, "ttl", ttl)

    @_builtins.property
    @pulumi.getter(name="authoritativeNameservers")
    def authoritative_nameservers(self) -> 'outputs.GetZonesZoneAuthoritativeNameserversResult':
        """
        Authoritative nameservers of the Zone.
        """
        return pulumi.get(self, "authoritative_nameservers")

    @_builtins.property
    @pulumi.getter(name="deleteProtection")
    def delete_protection(self) -> _builtins.bool:
        """
        Whether delete protection is enabled.
        """
        return pulumi.get(self, "delete_protection")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.int:
        """
        ID of the Zone.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Mapping[str, _builtins.str]:
        """
        User-defined [labels](https://docs.hetzner.cloud/reference/cloud#labels) (key-value pairs) for the resource.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter
    def mode(self) -> _builtins.str:
        """
        Mode of the Zone.
        """
        return pulumi.get(self, "mode")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the Zone.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="primaryNameservers")
    def primary_nameservers(self) -> Sequence['outputs.GetZonesZonePrimaryNameserverResult']:
        """
        Primary nameservers of the Zone.
        """
        return pulumi.get(self, "primary_nameservers")

    @_builtins.property
    @pulumi.getter
    def registrar(self) -> _builtins.str:
        """
        Registrar of the Zone.
        """
        return pulumi.get(self, "registrar")

    @_builtins.property
    @pulumi.getter
    def ttl(self) -> _builtins.int:
        """
        Default Time To Live (TTL) of the Zone.
        """
        return pulumi.get(self, "ttl")


@pulumi.output_type
class GetZonesZoneAuthoritativeNameserversResult(dict):
    def __init__(__self__, *,
                 assigneds: Sequence[_builtins.str]):
        """
        :param Sequence[_builtins.str] assigneds: Authoritative Hetzner nameservers assigned to the Zone.
        """
        pulumi.set(__self__, "assigneds", assigneds)

    @_builtins.property
    @pulumi.getter
    def assigneds(self) -> Sequence[_builtins.str]:
        """
        Authoritative Hetzner nameservers assigned to the Zone.
        """
        return pulumi.get(self, "assigneds")


@pulumi.output_type
class GetZonesZonePrimaryNameserverResult(dict):
    def __init__(__self__, *,
                 address: _builtins.str,
                 port: _builtins.int,
                 tsig_algorithm: _builtins.str,
                 tsig_key: _builtins.str):
        """
        :param _builtins.str address: Public IPv4 or IPv6 address of the primary nameserver.
        :param _builtins.int port: Port of the primary nameserver.
        :param _builtins.str tsig_algorithm: Transaction signature (TSIG) algorithm used to generate the TSIG key.
        :param _builtins.str tsig_key: Transaction signature (TSIG) key
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "tsig_algorithm", tsig_algorithm)
        pulumi.set(__self__, "tsig_key", tsig_key)

    @_builtins.property
    @pulumi.getter
    def address(self) -> _builtins.str:
        """
        Public IPv4 or IPv6 address of the primary nameserver.
        """
        return pulumi.get(self, "address")

    @_builtins.property
    @pulumi.getter
    def port(self) -> _builtins.int:
        """
        Port of the primary nameserver.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter(name="tsigAlgorithm")
    def tsig_algorithm(self) -> _builtins.str:
        """
        Transaction signature (TSIG) algorithm used to generate the TSIG key.
        """
        return pulumi.get(self, "tsig_algorithm")

    @_builtins.property
    @pulumi.getter(name="tsigKey")
    def tsig_key(self) -> _builtins.str:
        """
        Transaction signature (TSIG) key
        """
        return pulumi.get(self, "tsig_key")


