# -*- coding: utf-8 -*-
# Generated by HAND for Django 1.11.3 on 2017-07-05
# See https://stackoverflow.com/questions/44948775/django-migration-of-polymor

from django.db import migrations, models


def migrate_answers(apps, schema_editor):
    classes = []
    classes_str = ["AnswerText", "AnswerInteger", "AnswerRadio", "AnswerSelect", "AnswerSelectMultiple"]
    for class_name in classes_str:
        classes.append(apps.get_model("survey", class_name))
    for class_ in classes:
        for answer in class_.objects.all():
            answer.new_body = answer.body
            answer.save()


class Migration(migrations.Migration):

    dependencies = [("survey", "0003_auto_20170320_0337")]

    operations = [
        migrations.AddField(model_name="answerbase", name="new_body", field=models.TextField(blank=True, null=True)),
        migrations.RunPython(migrate_answers),
        migrations.DeleteModel(name="AnswerInteger"),
        migrations.DeleteModel(name="AnswerRadio"),
        migrations.DeleteModel(name="AnswerSelect"),
        migrations.DeleteModel(name="AnswerSelectMultiple"),
        migrations.DeleteModel(name="AnswerText"),
        migrations.RenameField("AnswerBase", "new_body", "body"),
        migrations.RenameModel("AnswerBase", "Answer"),
    ]
