#!/usr/bin/env python3
"""
Setup script for EchoGem library.
"""

from setuptools import setup, find_packages

# Read the README file from within the echogem folder
with open("echogem/README.md", "r", encoding="utf-8") as fh:
    long_description = fh.read()

# Read requirements from within the echogem folder
with open("echogem/requirements.txt", "r", encoding="utf-8") as fh:
    requirements = [line.strip() for line in fh if line.strip() and not line.startswith("#")]

setup(
    name="echogem",
    version="0.1.3",
    author="Your Name",
    author_email="your.email@example.com",
    description="Intelligent Transcript Processing and Question Answering Library",
    long_description=long_description,
    long_description_content_type="text/markdown",
    url="https://github.com/yourusername/echogem",
    packages=find_packages(),
    classifiers=[
        "Development Status :: 3 - Alpha",
        "Intended Audience :: Developers",
        "Intended Audience :: Science/Research",
        "License :: OSI Approved :: MIT License",
        "Operating System :: OS Independent",
        "Programming Language :: Python :: 3",
        "Programming Language :: Python :: 3.8",
        "Programming Language :: Python :: 3.9",
        "Programming Language :: Python :: 3.10",
        "Programming Language :: Python :: 3.11",
        "Programming Language :: Python :: 3.12",
        "Topic :: Scientific/Engineering :: Artificial Intelligence",
        "Topic :: Text Processing :: Linguistic",
        "Topic :: Software Development :: Libraries :: Python Modules",
    ],
    python_requires=">=3.8",
    install_requires=requirements,
    extras_require={
        "dev": [
            "pytest>=6.0",
            "pytest-cov>=2.0",
            "black>=21.0",
            "flake8>=3.8",
            "mypy>=0.800",
        ],
        "docs": [
            "sphinx>=4.0",
            "sphinx-rtd-theme>=1.0",
        ],
    },
    entry_points={
        "console_scripts": [
            "echogem=echogem.cli:main",
        ],
    },
    include_package_data=True,
    zip_safe=False,
)
