""""Module to hold constants."""
import numpy as np

# wavelength/energy = 12398.4 (A) / E(eV)
WAVELENGTH_TO_ENERGY_LAMBDA = 12398.4


# Material density in g/cm^3
density = {
    "H": 0.00008988,
    "He": 0.0001785,
    "Li": 0.543,
    "Be": 1.85,
    "B": 2.34,
    "C": 3.5,
    "N": 0.0012506,
    "O": 0.001429,
    "F": 0.001696,
    "Ne": 0.0008999,
    "Na": 0.971,
    "Mg": 1.738,
    "Al": 2.698,
    "Si": 2.3296,
    "P": 1.82,
    "S": 2.067,
    "Cl": 0.003214,
    "Ar": 0.0017837,
    "K": 0.862,
    "Ca": 1.54,
    "Sc": 2.989,
    "Ti": 4.54,
    "V": 6.11,
    "Cr": 7.15,
    "Mn": 7.44,
    "Fe": 7.874,
    "Co": 8.86,
    "Ni": 8.912,
    "Cu": 8.96,
    "Zn": 7.134,
    "Ga": 5.907,
    "Ge": 5.323,
    "As": 5.776,
    "Se": 4.809,
    "Br": 3.122,
    "Kr": 0.003733,
    "Rb": 1.532,
    "Sr": 2.64,
    "Y": 4.469,
    "Zr": 6.506,
    "Nb": 8.57,
    "Mo": 10.22,
    "Tc": 11.5,
    "Ru": 12.37,
    "Rh": 12.41,
    "Pd": 12.02,
    "Ag": 10.501,
    "Cd": 8.69,
    "In": 7.31,
    "Sn": 7.287,
    "Sb": 6.685,
    "Te": 6.232,
    "I": 4.93,
    "Xe": 0.005887,
    "Cs": 1.873,
    "Ba": 3.594,
    "La": 6.145,
    "Ce": 6.77,
    "Pr": 6.773,
    "Nd": 7.007,
    "Pm": 7.26,
    "Sm": 7.52,
    "Eu": 5.243,
    "Gd": 7.895,
    "Tb": 8.229,
    "Dy": 8.55,
    "Ho": 8.795,
    "Er": 9.066,
    "Tm": 9.321,
    "Yb": 6.965,
    "Lu": 9.84,
    "Hf": 13.31,
    "Ta": 16.654,
    "W": 19.25,
    "WC": 15.8,
    "Re": 21.02,
    "Os": 22.61,
    "Ir": 22.56,
    "Pt": 21.46,
    "Au": 19.282,
    "Hg": 13.5336,
    "Tl": 11.85,
    "Pb": 11.342,
    "Bi": 9.807,
    "Po": 9.32,
    "At": 7,
    "Rn": 0.00973,
    "Fr": 1.87,
    "Ra": 5.5,
    "Ac": 10.07,
    "Th": 11.72,
    "Pa": 15.37,
    "U": 18.95,
    "Np": 20.45,
    "Pu": 19.84,
    "H2O": 1.0,
    "B4C": 2.52,
    "SiC": 3.217,
    "SiO2": 2.2,
    "Al2O3": 3.97,
    "ZnSe": 5.42,
    "ZnTe": 6.34,
    "CdS": 6.749,
    "CdSe": 7.01,
    "CdTe": 7.47,
    "BN": 3.49,
    "GaSb": 5.619,
    "GaAs": 5.316,
    "GaMnAs": 5.316,
    "GaP": 4.13,
    "InP": 4.787,
    "InAs": 5.66,
    "InSb": 5.775,
    "TaC": 13.9,
    "TiB2": 4.52,
    "YAG": 4.55,
    "CuBe": 8.96,
    "ZnO": 5.606,
    "SiC2": 3.217,
    "AlN": 3.3,
    "Si3N4": 3.44,
    "CaF2": 3.18,
    "LiF": 2.635,
    "KF": 2.48,
    "PbF2": 8.24,
    "SrF2": 4.24,
    "KBr": 2.75,
    "ZrO2": 5.6,
    "Gd3Ga5O12": 7.08,
    "CaSiO5": 2.4,
    "LaMnO3": 5.7,
    "LaAlO3": 6.52,
    "La0.7Sr0.3MnO3": 6.17,
    "La0.5Ca0.5MnO3": 6.3,
    "Fe.68Cr.2Ni.1Mn.02": 8.03,
    "CaSO4H4O2": 2.32,
    "C10H8O4": 1.4,
    "C22H10N2O5": 1.43,
    "C3H6O": 0.79,
    "C5H8O2": 1.19,
    "C2F4": 2.2,
    "C7H8": 0.867,
    "Y3Al5O12": 4.56,
    "CHN.3O7.6": 1.06,
    "C1.5H0.3O4.3N0.4PCa2.2": 1.92,
    ("Be0.9983O0.0003Al0.0001Ca0.0002C0.0003Cr0.000035Co0.000005Cu0.00005Fe0."
     "0003Pb0.000005Mg0.00006Mn0.00003Mo0.00001Ni0.0002Si0.0001Ag0.000005Ti0."
     "00001Zn0.0001"): 1.85,
    ("Be.994O.004Al.0005B.000003Cd.0000002Ca.0001C.0006Cr.0001Co.00001Cu."
     "0001Fe.0008Pb.00002Li.000003Mg.00049Mn.0001Mo.00002Ni.0002N.0003Si."
     "0004Ag.00001"): 1.85,
}


# Chemical Formula Aliases
chemical_name_to_formula = {
    "Air": "N1.562O.42C.0003Ar.0094",
    "air": "N1.562O.42C.0003Ar.0094",
    "C*": "C",
    "mylar": "C10H8O4",
    "Mylar": "C10H8O4",
    "polyimide": "C22H10N2O5",
    "Polyimide": "C22H10N2O5",
    "kapton": "C22H10N2O5",
    "Kapton": "C22H10N2O5",
    "304SS": "Fe.68Cr.2Ni.1Mn.02",
    "Acetone": "C3H6O",
    "acetone": "C3H6O",
    "PMMA": "C5H8O2",
    "Teflon": "C2F4",
    "teflon": "C2F4",
    "Toluene": "C7H8",
    "toluene": "C7H8",
    "FS": "SiO2",
    "GGG": "Gd3Ga5O12",
    "quartz": "SiO2",
    "Quartz": "SiO2",
    "Silica": "SiO2",
    "silica": "SiO2",
    "water": "H2O",
    "Water": "H2O",
    "Calcite": "CaCO3",
    "calcite": "CaCO3",
    "YAG": "Y3Al5O12",
    "yag": "Y3Al5O12",
    "Sapphire": "Al2O3",
    "sapphire": "Al2O3",
    "Blood": "CHN.3O7.6",
    "LMSO": "La0.7Sr0.3MnO3",
    "blood": "CHN.3O7.6",
    "Bone": "C1.5H0.3O4.3N0.4PCa2.2",
    "bone": "C1.5H0.3O4.3N0.4PCa2.2",
    "IF1": ("Be0.9983O0.0003Al0.0001Ca0.0002C0.0003Cr0.000035Co0.000005Cu0."
            "00005Fe0.0003Pb0.000005Mg0.00006Mn0.00003Mo0.00001Ni0.0002Si0."
            "0001Ag0.000005Ti0.00001Zn0.0001"),
    "PF60": ("Be.994O.004Al.0005B.000003Cd.0000002Ca.0001C.0006Cr.0001Co."
             "00001Cu.0001Fe.0008Pb.00002Li.000003Mg.00049Mn.0001Mo.00002Ni."
             "0002N.0003Si.0004Ag.00001"),
}

# Crystal Lattice parameters (a, b, c, alpha, beta, gamma)
# a,b,c in angstroms
# alpha, beta, gamma in degrees
lattice_parameters = {
    "H": (3.75, 3.75, 6.12, 90, 90, 120),
    "He": (3.57, 3.57, 5.83, 90, 90, 120),
    "Li": (3.491, 3.491, 3.491, 90, 90, 90),
    "Be": (2.2866, 2.2866, 3.5833, 90, 90, 120),
    "B": (5.06, 5.06, 5.06, 58.06, 58.06, 58.06),
    "C": (3.567, 3.567, 3.567, 90, 90, 90),
    "N": (5.66, 5.66, 5.66, 90, 90, 90),
    "Ne": (4.66, 4.66, 4.66, 90, 90, 90),
    "Na": (4.225, 4.225, 4.225, 90, 90, 90),
    "Mg": (3.21, 3.21, 5.21, 90, 90, 120),
    "Al": (4.05, 4.05, 4.05, 90, 90, 90),
    "Si": (5.4310205, 5.4310205, 5.4310205, 90, 90, 90),
    "Ar": (5.31, 5.31, 5.31, 90, 90, 90),
    "K": (5.225, 5.225, 5.225, 90, 90, 90),
    "Ca": (5.58, 5.58, 5.58, 90, 90, 90),
    "Sc": (3.31, 3.31, 5.27, 90, 90, 120),
    "Ti": (2.95, 2.95, 4.68, 90, 90, 120),
    "V": (3.03, 3.03, 3.03, 90, 90, 90),
    "Cr": (2.88, 2.88, 2.88, 90, 90, 90),
    "Fe": (2.87, 2.87, 2.87, 90, 90, 90),
    "Co": (2.51, 2.51, 4.07, 90, 90, 120),
    "Ni": (3.52, 3.52, 3.52, 90, 90, 90),
    "Cu": (3.61, 3.61, 3.61, 90, 90, 90),
    "Zn": (2.66, 2.66, 4.95, 90, 90, 120),
    "Ge": (5.658, 5.658, 5.658, 90, 90, 90),
    "As": (4.1018, 4.1018, 4.1018, 54.554, 54.554, 54.554),
    "Kr": (5.64, 5.64, 5.64, 90, 90, 90),
    "Rb": (5.585, 5.585, 5.585, 90, 90, 90),
    "Sr": (6.08, 6.08, 6.08, 90, 90, 90),
    "Y": (3.65, 3.65, 5.73, 90, 90, 120),
    "Zr": (3.23, 3.23, 5.15, 90, 90, 120),
    "Nb": (3.3, 3.3, 3.3, 90, 90, 90),
    "Mo": (3.15, 3.15, 3.15, 90, 90, 90),
    "Tc": (2.74, 2.74, 4.4, 90, 90, 120),
    "Ru": (2.71, 2.71, 4.28, 90, 90, 120),
    "Rh": (3.8, 3.8, 3.8, 90, 90, 90),
    "Pd": (3.89, 3.89, 3.89, 90, 90, 90),
    "Ag": (4.09, 4.09, 4.09, 90, 90, 90),
    "Cd": (2.98, 2.98, 5.62, 90, 90, 120),
    "In": (3.25, 3.25, 4.95, 90, 90, 90),
    "Sn": (6.49, 6.49, 6.49, 90, 90, 90),
    "Sb": (4.4898, 4.4898, 4.4898, 57.233, 57.233, 57.233),
    "Xe": (6.13, 6.13, 6.13, 90, 90, 90),
    "Cs": (6.045, 6.045, 6.045, 90, 90, 90),
    "Ba": (5.02, 5.02, 5.02, 90, 90, 90),
    "Ce": (5.16, 5.16, 5.16, 90, 90, 90),
    "Eu": (4.58, 4.58, 4.58, 90, 90, 90),
    "Gd": (3.63, 3.63, 5.78, 90, 90, 120),
    "Tb": (3.6, 3.6, 5.7, 90, 90, 120),
    "Dy": (3.59, 3.59, 5.65, 90, 90, 120),
    "Ho": (3.58, 3.58, 5.62, 90, 90, 120),
    "Er": (3.56, 3.56, 5.59, 90, 90, 120),
    "Tm": (3.54, 3.54, 5.56, 90, 90, 120),
    "Yb": (5.45, 5.45, 5.45, 90, 90, 90),
    "Lu": (3.5, 3.5, 5.55, 90, 90, 120),
    "Hf": (3.19, 3.19, 5.05, 90, 90, 120),
    "Ta": (3.3, 3.3, 3.3, 90, 90, 90),
    "W": (3.16, 3.16, 3.16, 90, 90, 90),
    "Re": (2.76, 2.76, 4.46, 90, 90, 120),
    "Os": (2.74, 2.74, 4.32, 90, 90, 120),
    "Ir": (3.84, 3.84, 3.84, 90, 90, 90),
    "Pt": (3.92, 3.92, 3.92, 90, 90, 90),
    "Au": (4.08, 4.08, 4.08, 90, 90, 90),
    "Tl": (3.46, 3.46, 5.52, 90, 90, 120),
    "Pb": (4.95, 4.95, 4.95, 90, 90, 90),
    "Bi": (4.7236, 4.7236, 4.7236, 57.35, 57.35, 57.35),
    "Po": (3.34, 3.34, 3.34, 90, 90, 90),
    "Ac": (5.31, 5.31, 5.31, 90, 90, 90),
    "Th": (5.08, 5.08, 5.08, 90, 90, 90),
    "Pa": (3.92, 3.92, 3.24, 90, 90, 90),
    "ZnSe": (5.6676, 5.6676, 5.6676, 90, 90, 90),
    "ZnTe": (6.101, 6.101, 6.101, 90, 90, 90),
    "CdS": (5.832, 5.832, 5.832, 90, 90, 90),
    "CdSe": (6.05, 6.05, 6.05, 90, 90, 90),
    "CdTe": (6.477, 6.477, 6.477, 90, 90, 90),
    "BN": (3.615, 3.615, 3.615, 90, 90, 90),
    "GaSb": (6.0954, 6.0954, 6.0954, 90, 90, 90),
    "GaAs": (5.65315, 5.65315, 5.65315, 90, 90, 90),
    "GaMnAs": (5.65, 5.65, 5.65, 90, 90, 90),
    "GaP": (5.4505, 5.4505, 5.4505, 90, 90, 90),
    "InP": (5.86875, 5.86875, 5.86875, 90, 90, 90),
    "InAs": (6.05838, 6.05838, 6.05838, 90, 90, 90),
    "InSb": (6.47877, 6.47877, 6.47877, 90, 90, 90),
    "LaMnO3": (5.531, 5.602, 7.742, 90, 90, 90),
    "LaAlO3": (5.377, 5.377, 5.377, 60.13, 60.13, 60.13),
    "La0.7Sr0.3MnO3": (5.4738, 5.4738, 5.4738, 60.45, 60.45, 60.45),
    "Gd3Ga5O12": (12.383, 12.383, 12.383, 90, 90, 90),
}

# define units and constants
units = {
    "fm": 1e15,
    "pm": 1e12,
    "ang": 1e10,
    "nm": 1e9,
    "um": 1e6,
    "mm": 1e3,
    "cm": 1e2,
    "km": 1e-3,
    "kHz": 1e-3,
    "MHz": 1e-6,
    "GHz": 1e-9,
    "THz": 1e-12,
    "PHz": 1e-15,
    "inch": 39.370079,
    "mile": 0.000621,
    "ft": 3.28084,
    "yard": 1.093613,
    "mil": 39.370079 * 1000,
    "barn": 1e28,
    "fs": 1e15,
    "ps": 1e12,
    "ns": 1e9,
    "us": 1e6,
    "ms": 1e3,
    "min": 1 / 60.0,
    "hour": 1 / 3600.0,
    "day": 1 / (3600 * 24.0),
    "mdeg": 1e3,
    "udeg": 1e6,
    "ndeg": 1e9,
    "rad": np.pi / 180,
    "mrad": np.pi / 180 * 1e3,
    "urad": np.pi / 180 * 1e6,
    "nrad": np.pi / 180 * 1e9,
    "asec": 3600,
    "amin": 60,
    "g": 1e3,
    "eV": 6.2415e18,
    "erg": 1e7,
    "cal": 0.239,
    "mJ": 1e3,
    "uJ": 1e6,
    "nJ": 1e9,
    "pJ": 1e9,
    "Torr": 7.5006e-3,
}
