class BootstrapModal {
    static count = 0;

    constructor(options) {
        this.props = {
            title: "",
            body: "",
            footer: "",
            modalClass: "fade",
            modalDialogClass: "",
            onCreate: null,
            onDispose: null,
            onSubmit: null,
        };
        Object.assign(this.props, options);

        this.id = `bootstrap-modal-${BootstrapModal.count++}`;
        this.createContainerElement();
    }

    createContainerElement() {
        this.element = document.createElement("div");
        this.element.id = this.id;
        this.element.className = `modal ${this.props.modalClass}`;
        this.element.tabIndex = -1;
        this.element.setAttribute("role", "dialog");
        this.element.setAttribute("aria-labelledby", this.id);
        this.element.innerHTML = `
      <div class="modal-dialog ${this.props.modalDialogClass}" role="document">
        <div class="modal-content">
          <div class="modal-header">
            <h5 class="modal-title">${this.props.title}</h5>
            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
          </div>
          <div class="modal-body">${this.props.body}</div>
          <div class="modal-footer">${this.props.footer}</div>
        </div>
      </div>
    `;
        document.body.appendChild(this.element);

        this.modalInstance = bootstrap.Modal.getOrCreateInstance(this.element);
        this.element.addEventListener("hidden.bs.modal", () => this.dispose());

        if (this.props.onCreate) this.props.onCreate(this);
    }

    show() {
        this.modalInstance.show();
    }

    hide() {
        this.modalInstance.hide();
    }

    dispose() {
        this.modalInstance.dispose();
        document.body.removeChild(this.element);
        if (this.props.onDispose) this.props.onDispose(this);
    }
}

$.extend({
    showModal: (options) => new BootstrapModal(options).show(),
    showAlert: (options) => $.showModal({
        ...options,
        footer: '<button type="button" class="btn btn-primary" data-bs-dismiss="modal">OK</button>'
    }),
    showConfirm: (options) => {
        options.footer = `
      <button class="btn btn-secondary btn-false" data-bs-dismiss="modal">${options.textFalse}</button>
      <button class="btn btn-primary btn-true">${options.textTrue}</button>
    `;
        options.onCreate = (modal) => {
            modal.element.querySelector(".btn-true").addEventListener("click", () => {
                modal.hide();
                if (options.onSubmit) options.onSubmit(true, modal);
            });
            modal.element.querySelector(".btn-false").addEventListener("click", () => {
                modal.hide();
                if (options.onSubmit) options.onSubmit(false, modal);
            });
        };
        return $.showModal(options);
    }
});
