# This file was auto-generated by Fern from our API Definition.

from ..core.pydantic_utilities import UniversalBaseModel
import typing_extensions
from ..core.serialization import FieldMetadata
import pydantic
import typing
from .completed_achievement_response import CompletedAchievementResponse
from .metric_event_streak_response import MetricEventStreakResponse
from .metric_event_points_response import MetricEventPointsResponse
from ..core.pydantic_utilities import IS_PYDANTIC_V2


class EventResponse(UniversalBaseModel):
    event_id: typing_extensions.Annotated[str, FieldMetadata(alias="eventId")] = (
        pydantic.Field()
    )
    """
    The unique ID of the event.
    """

    metric_id: typing_extensions.Annotated[str, FieldMetadata(alias="metricId")] = (
        pydantic.Field()
    )
    """
    The unique ID of the metric that was updated.
    """

    total: float = pydantic.Field()
    """
    The user's new total progress against the metric.
    """

    achievements: typing.Optional[typing.List[CompletedAchievementResponse]] = (
        pydantic.Field(default=None)
    )
    """
    Achievements completed as a result of this event.
    """

    current_streak: typing_extensions.Annotated[
        typing.Optional[MetricEventStreakResponse], FieldMetadata(alias="currentStreak")
    ] = pydantic.Field(default=None)
    """
    The user's current streak for the metric, if the metric has streaks enabled.
    """

    points: typing.Optional[typing.Dict[str, MetricEventPointsResponse]] = (
        pydantic.Field(default=None)
    )
    """
    A map of points systems by key that were affected by this event.
    """

    idempotency_key: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="idempotencyKey")
    ] = pydantic.Field(default=None)
    """
    The idempotency key used for the event, if one was provided.
    """

    idempotent_replayed: typing_extensions.Annotated[
        typing.Optional[bool], FieldMetadata(alias="idempotentReplayed")
    ] = pydantic.Field(default=None)
    """
    Whether the event was replayed due to idempotency.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
