# This file was auto-generated by Fern from our API Definition.

from ..core.pydantic_utilities import UniversalBaseModel
import pydantic
import typing
import typing_extensions
from ..core.serialization import FieldMetadata
from .points_award import PointsAward
from ..core.pydantic_utilities import IS_PYDANTIC_V2


class GetUserPointsResponse(UniversalBaseModel):
    id: str = pydantic.Field()
    """
    The ID of the points system
    """

    name: str = pydantic.Field()
    """
    The name of the points system
    """

    description: typing.Optional[str] = pydantic.Field(default=None)
    """
    The description of the points system
    """

    badge_url: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="badgeUrl")
    ] = pydantic.Field(default=None)
    """
    The URL of the badge image for the points system
    """

    total: float = pydantic.Field()
    """
    The user's total points
    """

    awards: typing.List[PointsAward] = pydantic.Field()
    """
    Array of trigger awards that added points.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
