# This file was auto-generated by Fern from our API Definition.

from .upserted_user import UpsertedUser
import typing
import pydantic
import datetime as dt
from ..core.pydantic_utilities import IS_PYDANTIC_V2


class User(UpsertedUser):
    """
    A user of your application.
    """

    control: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Whether the user is in the control group, meaning they do not receive emails or other communications from Trophy.
    """

    created: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The date and time the user was created, in ISO 8601 format.
    """

    updated: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The date and time the user was last updated, in ISO 8601 format.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
